/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.EntityDimensionsDTO;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTODocsToPayFromPosEntry;
import com.namasoft.modules.namapos.contracts.common.DTODocToPayReq;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfiguration;
import com.namasoft.modules.namapos.contracts.common.IDTOPosSubsidType;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTextArea;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSAddCustomerDialog;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSGenericRefSearchBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.PosFileChooser;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPaymentToRegisterType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSReceiptCouponsDialog;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.domain.AbsPOSPayReceipt;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSGenReference;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.entities.PosNamaDocToPay;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSPaymentMethodsUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSWSClient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.util.StringConverter;

public class POSPaymentReciptScreen
implements IHasToolBar {
    private static Stage stage;
    private static PosScene scene;
    private boolean isPayment;
    private NamaButton noBtn;
    private NamaButton okBtn;
    private NamaTextField codeField;
    private NamaSearchBox docToPayCodeField;
    private AbsPOSPayReceipt payReceipt;
    private NamaBorderPane pane;
    private NamaSearchBox cancelReservationsField;
    private POSGenericRefSearchBox subsidiary;
    private NamaSearchBox currency;
    protected NamaSearchBox docCategory;
    private NamaTextField amountField;
    private NamaTextField totalField;
    private NamaTextField paidField;
    private NamaComboBox<POSPaymentToRegisterType> payTypeCombo;
    private NamaTextArea remarks;
    protected POSIdleMonitor idleMonitor;
    private String paymentType = "";
    private GridPane headerGrid;
    private CheckBox genCoupons;
    private final BorderPaneCreator borderPaneCreator = new BorderPaneCreator();
    private NamaSearchBox paymentMethod;
    protected NamaLabel attach1Label;
    protected NamaLabel attach2Label;
    protected PosFileChooser attach1;
    protected PosFileChooser attach2;
    public static String docsFromNama;
    private HashMap<String, IPOSFieldInfo> map = new HashMap();
    private NamaHBox paymentReceiptPane = new NamaHBox();
    private static HashMap<String, String> namaWithPosSubsidType;

    public POSPaymentReciptScreen() {
        PosEntryPoint.lastScreen = this;
    }

    public NamaSearchBox getCurrency() {
        return this.currency;
    }

    public void setCurrency(NamaSearchBox currency) {
        this.currency = currency;
    }

    public NamaTextField getAmountField() {
        return this.amountField;
    }

    public TextArea getRemarks() {
        return this.remarks;
    }

    public void setRemarks(NamaTextArea remarks) {
        this.remarks = remarks;
    }

    @Override
    public void defineControllers() {
        this.initHeaderGrid();
        this.payTypeCombo = new NamaComboBox(FXCollections.observableArrayList((Object[])new POSPaymentToRegisterType[]{new POSPaymentToRegisterType(POSResourcesUtil.id("FromRegister", new Object[0]), true)}), this, null);
        this.amountField = new NamaTextField();
        this.totalField = new NamaTextField();
        this.totalField.setEditable(false);
        this.paidField = new NamaTextField();
        this.paidField.setEditable(false);
        this.remarks = new NamaTextArea(this, "Remarks");
        this.paymentMethod = new NamaSearchBox(POSPaymentMethod.class, this, "paymentMethod", stage);
        this.subsidiary = new POSGenericRefSearchBox(this, (Callback<Observable>)((Callback)e -> this.chooseCreditNoteAction()), List.of("Register", "Employee", "Customer", "Vendor", "POSCreditNote"));
        this.subsidiary.setShowNameField(true);
        this.currency = new NamaSearchBox(POSCurrency.class, this, "money.currency", stage);
        NamaHBox.setHgrow((Node)this.currency, (Priority)Priority.ALWAYS);
        POSCurrency registerCurrency = POSResourcesUtil.fetchMainRegister().fetchCurrency();
        this.currency.getCodeBox().setText(registerCurrency.getCode());
        this.currency.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)registerCurrency.getId()));
        this.currency.getNameBox().setText(registerCurrency.nameByLanguage());
        this.cancelReservationsField = new NamaSearchBox(PosCancelReservation.class, this, "cancelReservation", stage);
        this.cancelReservationsField.getIdBox().textProperty().addListener(e -> this.selectCancelReservation());
        this.docCategory = new NamaSearchBox(PosDocCategory.class, this, "docCategory", stage);
        this.codeField = new NamaTextField(POSFieldType.Text);
        this.codeField.setEditable(false);
        this.codeField.setText(this.payReceipt.getCode());
        this.docToPayCodeField = new NamaSearchBox(PosNamaDocToPay.class, this, docsFromNama, this.fetchStage());
        this.docToPayCodeField.setId("doc-to-pay-code-field");
        this.docToPayCodeField.hideName();
        this.docToPayCodeField.getSearchBtn().setVisible(false);
        this.docToPayCodeField.getCodeBox().setOnAction(event -> this.fetchDocFromNama(this.docToPayCodeField.getCodeBox().getText()));
        this.attach1Label = new NamaLabel("Attachment1");
        this.attach2Label = new NamaLabel("Attachment2");
        this.attach1 = new PosFileChooser(stage, p -> this.payReceipt.setAttach1FilePath((String)p));
        this.attach2 = new PosFileChooser(stage, p -> this.payReceipt.setAttach2FilePath((String)p));
        this.attach1.reset();
        this.attach2.reset();
        this.amountField.lengthProperty().addListener((ChangeListener)new WeakChangeListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                char ch;
                if (newValue.intValue() > oldValue.intValue() && ((ch = POSPaymentReciptScreen.this.amountField.getText().charAt(oldValue.intValue())) < '0' || ch > '9') && ch != '.') {
                    POSPaymentReciptScreen.this.amountField.setText(POSPaymentReciptScreen.this.amountField.getText().substring(0, POSPaymentReciptScreen.this.amountField.getText().length() - 1));
                }
            }
        }));
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getAllowPaymentFromCurrEmp())) {
            this.payTypeCombo.getItems().add((Object)new POSPaymentToRegisterType(POSResourcesUtil.id("FromCurrentEmployee", new Object[0]), false));
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseReservationDoc())) {
            this.payTypeCombo.getItems().add((Object)new POSPaymentToRegisterType(POSResourcesUtil.id("FromCancelReservationDoc", new Object[0]), false));
        }
        this.payTypeCombo.getSelectionModel().selectFirst();
        this.payTypeCombo.setConverter((StringConverter)new StringConverter<POSPaymentToRegisterType>(){

            public String toString(POSPaymentToRegisterType object) {
                return object.getType();
            }

            public POSPaymentToRegisterType fromString(String string) {
                return POSPaymentReciptScreen.this.payTypeCombo.getItems().stream().filter(ap -> ap.getType().equals(string)).findFirst().orElse(null);
            }
        });
        this.map.put("subsidiary", new IPOSFieldInfo(){

            @Override
            public void update(AbsPOSSales posSales) {
            }

            @Override
            public String namaField() {
                return "subsidiary";
            }

            @Override
            public String posFieldValue() {
                return POSPaymentReciptScreen.this.subsidiary.getRefField().getIdBox().getText();
            }
        });
        this.map.put("docCategory", new IPOSFieldInfo(){

            @Override
            public void update(AbsPOSSales posSales) {
            }

            @Override
            public String namaField() {
                return "docCategory";
            }

            @Override
            public String posFieldValue() {
                return ServerStringUtils.strToUUID((String)POSPaymentReciptScreen.this.docCategory.getIdBox().getText()).toString();
            }
        });
        this.map.put("money.currency", new IPOSFieldInfo(){

            @Override
            public void update(AbsPOSSales posSales) {
            }

            @Override
            public String namaField() {
                return "money.currency";
            }

            @Override
            public String posFieldValue() {
                return POSPaymentReciptScreen.this.currency.getIdBox().getText();
            }
        });
        this.genCoupons = new CheckBox();
    }

    private void initHeaderGrid() {
        this.headerGrid = new GridPane();
        this.headerGrid.setId("container-grid-pane");
        ColumnConstraints labelColumnConstraints1 = new ColumnConstraints();
        labelColumnConstraints1.setPercentWidth(10.0);
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setPercentWidth(40.0);
        ColumnConstraints labelColumnConstraints2 = new ColumnConstraints();
        labelColumnConstraints2.setPercentWidth(15.0);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(30.0);
        this.headerGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{labelColumnConstraints1, columnConstraints1, labelColumnConstraints2, columnConstraints2});
    }

    public void draw(Stage primStage, boolean payment, String payType) {
        try {
            this.setPayment(payment);
            this.paymentType = payType;
            stage = primStage;
            this.payReceipt = this.isPayment ? new POSPaymentToRegistery(this) : new POSReceiptFromRegistery(this);
            this.pane = this.borderPaneCreator.createBorderPane(this);
            ((IPOSToolBar)this.pane.getTop()).updateInformation(null);
            this.pane.setPrefSize(stage.getWidth(), stage.getHeight());
            if (scene == null) {
                scene = new PosScene((Parent)this.pane, stage.getWidth(), stage.getHeight(), this, stage);
                POSSettingsUtil.addStyleSheetFor("css/allfiles.css", (Parent)this.pane);
                POSSettingsUtil.updateScreenColor((Parent)this.pane, this.documentType());
            } else {
                scene.setRoot((Parent)this.pane);
            }
            PosScene.monitorIdleness(this);
            stage.setScene((Scene)scene);
            stage.setOnCloseRequest(e -> PosScene.onCloseRequestEvent(event -> PosScene.terminateAction(this, primStage, event), e));
            scene.setNodeOrientation(POSResourcesUtil.getOrientation());
            this.pane.autosize();
        }
        catch (Exception es) {
            es.printStackTrace();
        }
    }

    public static Stage getStage() {
        return stage;
    }

    public static void setStage(Stage stage) {
        POSPaymentReciptScreen.stage = stage;
    }

    public static PosScene getScene() {
        return scene;
    }

    public static void setScene(PosScene scene) {
        POSPaymentReciptScreen.scene = scene;
    }

    @Override
    public Node fetchPaneCenter() {
        if (!this.isPayment()) {
            this.subsidiary.setAllowedValues(List.of("Register", "Employee", "Customer", "Vendor"));
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getHideDefaultTypesInPaymentsAndReceipts())) {
            this.subsidiary.setAllowedValues(new ArrayList<String>());
        }
        this.subsidiary.getTypeCombo().getItems().addAll(POSResourcesUtil.fetchPosGenRef().stream().filter(r -> !this.subsidiary.getTypeCombo().getItems().contains((Object)POSPaymentReciptScreen.namaWithPosSubsidType(r))).toList());
        if (ObjectChecker.isNotEmptyOrNull((Object)this.paymentType)) {
            this.subsidiary.getTypeCombo().getSelectionModel().select((Object)this.paymentType);
        }
        int row = 0;
        this.headerGrid.add((Node)new NamaLabel("code"), 0, row);
        this.headerGrid.add((Node)this.codeField, 1, row);
        this.headerGrid.add((Node)new NamaLabel("docToPay"), 2, row);
        this.headerGrid.add((Node)this.docToPayCodeField, 3, row++);
        if (this.isPayment) {
            this.headerGrid.add((Node)new NamaLabel("type"), 0, row);
            this.headerGrid.add(this.payTypeCombo, 1, row);
            this.headerGrid.add((Node)new NamaLabel("cancelReservation"), 2, row);
            this.headerGrid.add((Node)this.cancelReservationsField, 3, row++);
            this.cancelReservationsField.setEditable(false);
        }
        NamaLabel paymentReceiptLabel = this.isPayment() ? new NamaLabel("paidTo") : new NamaLabel("receiptFrom");
        this.headerGrid.add((Node)paymentReceiptLabel, 0, row);
        this.paymentReceiptPane.getChildren().addAll((Object[])new Node[]{this.subsidiary});
        this.paymentReceiptPane.setAlignment(Pos.CENTER_LEFT);
        if (POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanAddCustomer).isSucceeded().booleanValue()) {
            NamaButton addCustomerBtn = new NamaButton();
            addCustomerBtn.setTooltip(new POSTooltip("addCustomer"));
            addCustomerBtn.setSVGIcon("addCustomer.svg");
            addCustomerBtn.setOnAction(event -> new POSAddCustomerDialog().showDialog(this, ""));
            this.paymentReceiptPane.getChildren().add((Object)addCustomerBtn);
        }
        this.headerGrid.add((Node)this.paymentReceiptPane, 1, row);
        this.updatePayRecComboIfNeeded();
        this.updateComboFromConfig();
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getAddDocCategoryToPayReceipt())) {
            this.headerGrid.add((Node)new NamaLabel("DocCategory"), 2, row);
            this.headerGrid.add((Node)this.docCategory, 3, row++);
        } else {
            ++row;
        }
        this.headerGrid.add((Node)new NamaLabel("amount"), 0, row);
        this.headerGrid.add((Node)new NamaHBox(new Node[]{this.amountField, this.currency}), 1, row);
        this.headerGrid.add((Node)new NamaLabel("paymentMethod"), 2, row);
        this.headerGrid.add((Node)this.paymentMethod, 3, row++);
        this.headerGrid.add((Node)new NamaLabel("total"), 0, row);
        this.headerGrid.add((Node)this.totalField, 1, row);
        this.headerGrid.add((Node)new NamaLabel("paid"), 2, row);
        this.headerGrid.add((Node)this.paidField, 3, row++);
        int row5Cols = -1;
        if (this.mustAddAttach(true)) {
            this.headerGrid.add((Node)this.attach1Label, ++row5Cols, row);
            this.headerGrid.add((Node)this.attach1, ++row5Cols, row);
        }
        if (this.mustAddAttach(false)) {
            this.headerGrid.add((Node)this.attach2Label, ++row5Cols, row);
            this.headerGrid.add((Node)this.attach2, ++row5Cols, row);
        }
        this.headerGrid.add((Node)new NamaLabel("remarks"), 0, ++row);
        this.headerGrid.add(this.createRemarksPane(), 1, row++, Integer.MAX_VALUE, 1);
        if (!this.isPayment() && POSResourcesUtil.fetchPOSConfig().getUseCoupons().booleanValue()) {
            NamaHBox couponBox = new NamaHBox(new Node[]{this.genCoupons, new NamaLabel("genCouponsWithReceiptValue")});
            couponBox.setId("payment-receipt-coupon-box");
            this.headerGrid.add((Node)couponBox, 0, row++, Integer.MAX_VALUE, 1);
        }
        this.headerGrid.add((Node)this.createButtonPane(), 0, row, Integer.MAX_VALUE, 1);
        if (ObjectChecker.isNotEmptyOrNull((Object)this.paymentType)) {
            Platform.runLater(() -> {
                if (ObjectChecker.isNotEmptyOrNull((Object)this.subsidiary.getRefField().getCodeBox())) {
                    this.subsidiary.getRefField().getCodeBox().requestFocus();
                }
            });
        }
        this.payTypeCombo.setOnAction(e -> this.payTypeAction());
        this.paymentMethod.getIdBox().textProperty().addListener(e -> this.payReceipt.setPaymentMethod(POSPersister.findByID(POSPaymentMethod.class, this.paymentMethod.getIdBox().getText())));
        NamaVBox container = new NamaVBox();
        container.setId("payment-receipt-root");
        container.setPrefWidth(stage.getWidth());
        container.getChildren().addAll((Object[])new Node[]{this.headerGrid});
        return container;
    }

    private Node createRemarksPane() {
        this.remarks.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.TAB) {
                if (event.isControlDown()) {
                    this.remarks.replaceSelection("\t");
                } else {
                    boolean focusChanged;
                    boolean bl = focusChanged = !this.remarks.isFocused();
                    if (!focusChanged) {
                        for (Node child : this.remarks.getParent().getChildrenUnmodifiable()) {
                            if (child.isDisable() || !child.isFocusTraversable()) continue;
                            child.requestFocus();
                            break;
                        }
                    }
                }
                event.consume();
            }
        });
        this.remarks.textProperty().addListener(l -> this.payReceipt.setRemarks(this.remarks.getText()));
        return this.remarks;
    }

    private Pane createButtonPane() {
        this.okBtn = new NamaButton("Ok");
        this.okBtn.getStyleClass().add((Object)"apply-button");
        this.noBtn = new NamaButton("cancel");
        this.noBtn.setOnAction(event -> PosScene.drawSalesScreen(stage));
        this.okBtn.setOnAction(event -> {
            POSResult result = new POSResult();
            this.validPayReceipt(result);
            if (result.isFailed().booleanValue()) {
                POSErrorAndInfoMessagesUtil.showError(result, this.fetchStage());
                return;
            }
            this.payReceipt.updateCurrency(this.currency.getIdBox().getText());
            this.payReceipt.updateDocCategory((PosDocCategory)this.docCategory.fetchValue());
            this.payReceipt.setValue(new BigDecimal(this.amountField.getText()));
            this.payReceipt.setRegisterId(POSResourcesUtil.fetchRegisterId());
            this.payReceipt.setValueDate(new Date());
            this.payReceipt.setValueTime(new Date());
            POSShiftOpen posShiftOpen = POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister());
            if (posShiftOpen != null) {
                this.payReceipt.setShiftCode(posShiftOpen.getCode());
                this.payReceipt.setShiftOpenId(posShiftOpen.getId());
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)((Object)this.subsidiary))) {
                this.payReceipt.updateSubsidiary(this.subsidiary.getReference(), ObjectChecker.toBigDecimalIfNumber((Object)this.amountField.getText()), result);
            }
            this.payReceipt.setRemarks(this.remarks.getText());
            String value = ((POSPaymentToRegisterType)this.payTypeCombo.getValue()).getType();
            if (ObjectChecker.areEqual((Object)value, (Object)POSResourcesUtil.id("FromRegister", new Object[0]))) {
                this.payReceipt.setType("FromRegister");
            } else {
                this.payReceipt.setType("FromCurrentEmployee");
            }
            this.payReceipt.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
            POSResourcesUtil.updateDocDateAndTime(this.payReceipt);
            if (ObjectChecker.isEmptyOrNull((Object)this.payReceipt.getNamaDocToPayCode())) {
                POSResult posResult = POSPersister.saveAndCreateActionHistoryEntry(this.payReceipt);
                if (posResult.isFailed().booleanValue()) {
                    POSErrorAndInfoMessagesUtil.showError(posResult, stage);
                    return;
                }
                this.payReceipt.writeToServer(POSResourcesUtil.fetchMainRegister(), false, null);
            } else {
                this.payReceipt.writeToServer(POSResourcesUtil.fetchMainRegister(), true, r -> {
                    if (this.payReceipt.getSent().booleanValue()) {
                        POSResult posResult = POSPersister.saveAndCreateActionHistoryEntry(this.payReceipt);
                        if (posResult.isFailed().booleanValue()) {
                            POSErrorAndInfoMessagesUtil.showError(posResult, stage);
                            return;
                        }
                        this.afterSaveAction();
                    } else {
                        POSResult posResult = new POSResult();
                        posResult.failure("Cannot be saved, there is no connection", new Object[0]);
                        POSErrorAndInfoMessagesUtil.showError(posResult, this.fetchStage());
                    }
                });
                if (ObjectChecker.isFalse((Boolean)this.payReceipt.getSent())) {
                    return;
                }
            }
            this.afterSaveAction();
        });
        NamaHBox buttonPane = new NamaHBox(new Node[]{this.okBtn, this.noBtn});
        buttonPane.setId("payment-receipt-buttons-pane");
        return buttonPane;
    }

    public void selectCancelReservation() {
        PosCancelReservation reservation = (PosCancelReservation)this.cancelReservationsField.fetchValue();
        if (ObjectChecker.isEmptyOrNull((Object)reservation)) {
            return;
        }
        ((POSPaymentToRegistery)this.payReceipt).setCancelReservation(reservation);
        BigDecimal net = ObjectChecker.toZeroIfNull((BigDecimal)reservation.getNetValue());
        this.amountField.setText(String.valueOf(net));
        POSCustomer customer = reservation.getCustomer();
        if (ObjectChecker.isNotEmptyOrNull((Object)customer)) {
            this.subsidiary.setType("Customer");
            Platform.runLater(() -> this.subsidiary.updateFromRecord(customer));
        }
    }

    private void afterSaveAction() {
        if (this.genCoupons.isSelected() && POSResourcesUtil.fetchPOSConfig().getUseCoupons().booleanValue() && this.payReceipt.getSubsidiaryType().equals(POSCustomer.class.getSimpleName())) {
            POSReceiptCouponsDialog couponsDialog = new POSReceiptCouponsDialog();
            couponsDialog.showDialog(this);
        }
        POSReportDefinition.printForm(POSResourcesUtil.fetchMainRegister(), this.payReceipt, (Callback<Void>)((Callback)c -> this.doPostSaveAction()));
    }

    private void fetchDocFromNama(String code) {
        if (ObjectChecker.isEmptyOrNull((Object)code)) {
            return;
        }
        POSResult posResult = new POSResult();
        POSGenericDims genericDims = POSResourcesUtil.fetchMainRegister().getGenericDims();
        DTODocToPayReq req = new DTODocToPayReq();
        req.setDocCode(code);
        req.setPayment(this.isPayment());
        SendRequest request = new SendRequest((Object)req);
        request.setDoNotRememberLoginDimensions(Boolean.valueOf(true));
        EntityDimensionsDTO dimensionsIds = new EntityDimensionsDTO();
        dimensionsIds.setLegalEntity(new EntityReferenceData("LegalEntity", ServerStringUtils.toUUIDStr((Object)genericDims.getLegalEntity().getId())));
        dimensionsIds.setBranch(new EntityReferenceData("Branch", ServerStringUtils.toUUIDStr((Object)genericDims.getBranch().getId())));
        dimensionsIds.setSector(new EntityReferenceData("Sector", ServerStringUtils.toUUIDStr((Object)genericDims.getSector().getId())));
        dimensionsIds.setDepartment(new EntityReferenceData("Department", ServerStringUtils.toUUIDStr((Object)genericDims.getDepartment().getId())));
        dimensionsIds.setAnalysisSet(new EntityReferenceData("AnalysisSet", ServerStringUtils.toUUIDStr((Object)genericDims.getAnalysisSet().getId())));
        request.setDimensionsIds(dimensionsIds);
        GetResult<DTODocsToPayFromPosEntry> result = POSWSClient.instance.fetchDocToPayInfo((SendRequest<DTODocToPayReq>)request);
        DTODocsToPayFromPosEntry data = (DTODocsToPayFromPosEntry)result.getData();
        if (data == null) {
            posResult.failure("There is no document to pay with code " + code, new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(posResult, stage);
        } else {
            this.selectNamaDoc(code, data);
        }
    }

    public void selectNamaDoc(String code, DTODocsToPayFromPosEntry data) {
        BigDecimal total = ObjectChecker.toZeroIfNull((BigDecimal)data.getPaymentAmount());
        BigDecimal paid = ObjectChecker.toZeroIfNull((BigDecimal)data.getPaidAmount());
        BigDecimal amount = total.subtract(paid);
        this.docToPayCodeField.getCodeBox().setText(code);
        this.amountField.setText(ObjectChecker.toZeroIfNull((BigDecimal)amount).toString());
        this.totalField.setText(ObjectChecker.toZeroIfNull((BigDecimal)total).toString());
        this.paidField.setText(ObjectChecker.toZeroIfNull((BigDecimal)paid).toString());
        this.payReceipt.setNamaDocToPayCode(code);
    }

    private void updateComboFromConfig() {
        List list;
        Boolean hideDefaultsInPaysReceipts = POSResourcesUtil.fetchPOSConfig().getHideDefaultTypesInPaymentsAndReceipts();
        if (ObjectChecker.isTrue((Boolean)hideDefaultsInPaysReceipts)) {
            return;
        }
        List list2 = list = this.isPayment() ? POSResourcesUtil.fetchPOSConfig().getPaymentSubsidiaryTypes() : POSResourcesUtil.fetchPOSConfig().getReceiptSubsidiaryTypes();
        if (ObjectChecker.isEmptyOrNull((Object)list)) {
            return;
        }
        List<String> types = list.stream().map(IDTOPosSubsidType::getEntityTypeDF).toList();
        ObservableList items = this.subsidiary.getTypeCombo().getItems();
        types.forEach(type -> {
            if (ObjectChecker.isEmptyOrNull((Object)type) || items.stream().anyMatch(obj -> obj.equals(POSPaymentReciptScreen.namaWithPosSubsidType(type)))) {
                return;
            }
            items.add((Object)POSPaymentReciptScreen.namaWithPosSubsidType(type));
        });
        this.subsidiary.setAllowedValues((List<String>)items);
    }

    private boolean mustAddAttach(boolean isAttach1) {
        if (this.isPayment) {
            return isAttach1 && ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddAttach1InPayments()) || !isAttach1 && ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddAttach2InPayments());
        }
        return isAttach1 && ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddAttach1InReceipts()) || !isAttach1 && ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettings().getUiSettingsOptions().getAddAttach2InReceipts());
    }

    private void updatePayRecComboIfNeeded() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.subsidiary.getType())) {
            return;
        }
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        DTOPOSConfiguration config = POSResourcesUtil.fetchPOSConfig();
        String subsidiary = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{register.getDefaultRecSubsidiaryType(), config.getDefaultRecSubsidiaryType()});
        if (this.isPayment()) {
            subsidiary = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{register.getDefaultPaySubsidiaryType(), config.getDefaultPaySubsidiaryType()});
        }
        String fSubsid = subsidiary;
        if (ObjectChecker.isEmptyOrNull((Object)subsidiary) || this.subsidiary.getTypeCombo().getItems().stream().filter(obj -> obj.equals(POSPaymentReciptScreen.namaWithPosSubsidType(fSubsid))).count() < 0L) {
            return;
        }
        String posSubsidType = POSPaymentReciptScreen.namaWithPosSubsidType(subsidiary);
        this.subsidiary.setType(posSubsidType);
    }

    public void payTypeAction() {
        POSPaymentToRegisterType value = (POSPaymentToRegisterType)this.payTypeCombo.getValue();
        if (ObjectChecker.areNotEqual((Object)value.getType(), (Object)POSResourcesUtil.id("FromCancelReservationDoc", new Object[0]))) {
            this.cancelReservationsField.setEditable(false);
        } else {
            this.cancelReservationsField.setEditable(true);
        }
    }

    private String getPayRecType() {
        return this.subsidiary.getType();
    }

    public POSGenericRefSearchBox getSubsidiary() {
        return this.subsidiary;
    }

    public void chooseCreditNoteAction() {
        POSCreditNote creditNote;
        POSMasterFile pOSMasterFile;
        if (this.subsidiary != null && (pOSMasterFile = this.subsidiary.getReference()) instanceof POSCreditNote && ObjectChecker.isNotEmptyOrNull((Object)(creditNote = (POSCreditNote)pOSMasterFile))) {
            this.amountField.setText(String.valueOf(creditNote.calcUnPaidAmount()));
        }
    }

    private void validPayReceipt(POSResult result) {
        POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift();
        if (ObjectChecker.isEmptyOrNull((Object)lastShift)) {
            result.failure("Please open shift firstly", new Object[0]);
        } else if (ObjectChecker.areNotEqual((Object)lastShift.getPosUser().getId(), (Object)POSSettingsInfo.fetchConfiguration().getCurrentUser().getId()) && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseAnotherUserShift).isFailed().booleanValue()) {
            result.failure("Another user shift. User: {0} opened shift at: {1} {2}", lastShift.getPosUser().nameByLanguage(), lastShift.getTime(), LocalDateUtils.dateToLocalDate((Date)lastShift.getShiftDate()));
        }
        PosCancelReservation cancelReservation = (PosCancelReservation)this.cancelReservationsField.fetchValue();
        if (ObjectChecker.isNotEmptyOrNull((Object)cancelReservation) && ObjectChecker.isTrue((Boolean)cancelReservation.getPaid())) {
            result.failure("Cancel reservation document is already paid", new Object[0]);
        }
        String currencyCode = this.currency.getCodeBox().getText();
        String currencyID = this.currency.getIdBox().getText();
        POSCurrency currency = POSPersister.findByID(POSCurrency.class, currencyID);
        if (ObjectChecker.isNotEmptyOrNull((Object)currencyCode) && ObjectChecker.isEmptyOrNull((Object)currency)) {
            result.failure("Please enter valid currency", new Object[0]);
        }
        this.validateSubsidiary(result, currencyCode);
        this.validateAmount(result);
        this.payReceipt.hasEmptyReqFields(result);
    }

    private void validateSubsidiary(POSResult result, String currencyCode) {
        POSMasterFile entity = this.subsidiary.getReference();
        this.validateSubsidiary(result);
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{currencyCode})) {
            result.failure("Please enter currency", new Object[0]);
        }
        if (ObjectChecker.isEmptyOrNull((Object)entity)) {
            result.failure("Please enter valid  {0}", this.subsidiary.getType());
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.docCategory.getCodeBox().getText()) && this.requiersDocCategory(this.isPayment())) {
            result.failure("Please enter Document Category", new Object[0]);
        }
        if (entity instanceof POSCreditNote) {
            POSCreditNote creditNote = (POSCreditNote)entity;
            if (creditNote.getDeactivated().booleanValue()) {
                result.failure("Please enter valid credit note", new Object[0]);
            }
            if (new BigDecimal(this.amountField.getText()).compareTo(creditNote.calcUnPaidAmount()) > 0) {
                result.failure("Invalid amount", new Object[0]);
            }
        }
        if (ObjectChecker.areEqual((Object)entity, (Object)POSResourcesUtil.fetchMainRegister())) {
            result.failure("Invalid register", new Object[0]);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)this.paymentMethod.getCodeBox().getText())) {
            POSPaymentMethod method = POSPersister.findByID(POSPaymentMethod.class, this.paymentMethod.getIdBox().getText());
            if (ObjectChecker.isEmptyOrNull((Object)method)) {
                result.failure("Please enter valid payment method", new Object[0]);
            } else if (this.isPayment() && ObjectChecker.isTrue((Boolean)method.getDoNotUseInPosPayments()) || !this.isPayment() && ObjectChecker.isTrue((Boolean)method.getDoNotUseInPosReceipts())) {
                result.failure("Cannot use payment method {0}", method.nameByLanguage());
            }
        }
    }

    private boolean requiersDocCategory(boolean payment) {
        if (payment) {
            return ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getDocCategoryRequiredInPOSPayScreen());
        }
        return ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getDocCategoryRequiredInPOSReceiptScreen());
    }

    private void validateSubsidiary(POSResult result) {
        Boolean subsidiaryReq = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getSubsidiaryRequiredInPayments());
        if (this.isPayment() && !subsidiaryReq.booleanValue()) {
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.getPayRecType())) {
            result.failure("Please enter subsidiary type", new Object[0]);
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.subsidiary.getRefField().getCodeBox().getText())) {
            result.failure("Please enter subsidiary", new Object[0]);
        }
    }

    private void validateAmount(POSResult result) {
        if (ObjectChecker.isEmptyOrNull((Object)this.amountField.getText())) {
            result.failure("Please enter amount", new Object[0]);
            return;
        }
        BigDecimal amountVal = new BigDecimal(this.amountField.getText());
        try {
            boolean cash;
            if (amountVal.compareTo(BigDecimal.ZERO) < 0) {
                result.failure("Amount value cannot be negative", new Object[0]);
            }
            if (amountVal.compareTo(BigDecimal.ZERO) == 0) {
                result.failure("Amount value cannot be zero", new Object[0]);
            }
            UUID cashMethodID = MultiplePaymentDialog.cashMethodID();
            boolean bl = cash = ObjectChecker.isEmptyOrNull((Object)this.paymentMethod.getIdBox().getText()) || ObjectChecker.isNotEmptyOrNull((Object)cashMethodID) && ObjectChecker.areEqual((Object)this.paymentMethod.getIdBox().getText(), (Object)cashMethodID.toString());
            if (this.isPayment() && ((POSPaymentToRegisterType)this.payTypeCombo.getValue()).isFromRegister() && cash) {
                POSPaymentMethodsUtil.checkAvailableCash(POSResourcesUtil.fetchMainRegister(), result, amountVal);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            result.failure("An error occurred, please refer to log file for details", new Object[0]);
        }
    }

    @Override
    public PosScene fetchScene() {
        return scene;
    }

    public boolean isPayment() {
        return this.isPayment;
    }

    public void setPayment(boolean pay) {
        this.isPayment = pay;
    }

    @Override
    public Stage fetchStage() {
        return stage;
    }

    @Override
    public NamaBorderPane fetchPane() {
        return this.pane;
    }

    @Override
    public String screenTitle() {
        if (this.isPayment) {
            return "POSPayments";
        }
        return "Receipts";
    }

    public NamaButton getNoBtn() {
        return this.noBtn;
    }

    public NamaButton getOkBtn() {
        return this.okBtn;
    }

    @Override
    public POSIdleMonitor fetchMonitor() {
        return this.idleMonitor;
    }

    @Override
    public String fetchScreenEntityType() {
        if (this.isPayment) {
            return "POSPaymentToRegister";
        }
        return "POSReceiptFromRegister";
    }

    @Override
    public void doPostSaveAction() {
        Platform.runLater(() -> PosScene.drawSalesScreen(stage));
    }

    public void setPayReceipt(AbsPOSPayReceipt payReceipt) {
        this.payReceipt = payReceipt;
    }

    public AbsPOSPayReceipt getPayReceipt() {
        return this.payReceipt;
    }

    public void openPaymentOrReceipt(AbsPOSPayReceipt selectedItem) {
        POSMasterFile subsidiary;
        NamaSearchBox subsidField;
        block7: {
            this.payReceipt = selectedItem;
            this.codeField.setText(selectedItem.getCode());
            ((IPOSToolBar)this.pane.getTop()).updateInformation(selectedItem);
            this.amountField.setText(selectedItem.getValue().toString());
            this.subsidiary.getTypeCombo().setValue((Object)selectedItem.getSubsidiaryType());
            ((POSPaymentToRegisterType)this.payTypeCombo.getValue()).setType(POSResourcesUtil.id(selectedItem.getType(), new Object[0]));
            this.remarks.setText(selectedItem.getRemarks());
            subsidField = this.subsidiary.getRefField();
            subsidField.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)selectedItem.getSubsidiaryID()));
            subsidField.getCodeBox().setText(selectedItem.getSubsidiaryCode());
            if (ObjectChecker.isNotEmptyOrNull((Object)selectedItem.getPaymentMethod())) {
                this.paymentMethod.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)selectedItem.getPaymentMethod().getId()));
                this.paymentMethod.getCodeBox().setText(selectedItem.getPaymentMethod().getCode());
                this.paymentMethod.getNameBox().setText(selectedItem.getPaymentMethod().nameByLanguage());
            } else {
                this.paymentMethod.clear();
            }
            subsidiary = null;
            try {
                subsidiary = (POSMasterFile)POSPersister.findByCode(Class.forName("com.namasoft.pos.domain.entities." + selectedItem.getSubsidiaryType()), selectedItem.getSubsidiaryCode());
            }
            catch (ClassNotFoundException e) {
                subsidiary = (POSMasterFile)POSPersister.findByCode(POSGenReference.class, selectedItem.getSubsidiaryCode());
                if (subsidiary != null) break block7;
                NaMaLogger.error((Throwable)e);
            }
        }
        if (ObjectChecker.isNotEmptyOrNull(subsidiary)) {
            subsidField.getNameBox().setText(subsidiary.nameByLanguage());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)selectedItem.getAttach1FilePath())) {
            this.attach1.getFileNameField().setText(StringUtils.substringAfterLast((String)selectedItem.getAttach1FilePath(), (String)"_#_"));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)selectedItem.getAttach2FilePath())) {
            this.attach2.getFileNameField().setText(StringUtils.substringAfterLast((String)selectedItem.getAttach2FilePath(), (String)"_#_"));
        }
    }

    @Override
    public void fireOpenOldDocAction(POSMasterFile selectedItem, Event event) {
        this.openPaymentOrReceipt((AbsPOSPayReceipt)selectedItem);
    }

    @Override
    public void escapeAction() {
        this.getNoBtn().fire();
    }

    @Override
    public void terminateAction(Stage stage, Event e) {
        if (ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{this.subsidiary.getRefField(), this.getAmountField().getText(), this.getCurrency().getCodeBox().getText(), this.getCurrency().getNameBox().getText(), this.getRemarks().getText()})) {
            PosScene.continueOrCancelCheck(stage, e, this);
        }
    }

    public static String namaWithPosSubsidType(String namaType) {
        if (ObjectChecker.isNotEmptyOrNull(namaWithPosSubsidType)) {
            return (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{namaWithPosSubsidType.get(namaType), namaType});
        }
        namaWithPosSubsidType.put("Supplier", "Vendor");
        namaWithPosSubsidType.put("NamaPOSRegister", "Register");
        return (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{namaWithPosSubsidType.get(namaType), namaType});
    }

    @Override
    public void onCustomerAdded(POSCustomer customer) {
        this.payReceipt.setSubsidiaryType("Customer");
        this.payReceipt.setSubsidiaryID(customer.getId());
        this.payReceipt.setSubsidiaryCode(customer.getCode());
        this.subsidiary.getTypeCombo().setValue((Object)"Customer");
        this.subsidiary.getRefField().getCodeBox().setText(customer.getCode());
        this.subsidiary.getRefField().getIdBox().setText(ServerStringUtils.toUUIDStr((Object)customer.getId()));
        this.subsidiary.getRefField().getNameBox().setText(customer.nameByLanguage());
    }

    public POSMasterFile document() {
        return this.payReceipt;
    }

    @Override
    public BorderPaneCreator fetchPaneCreator() {
        return this.borderPaneCreator;
    }

    @Override
    public POSDocumentType documentType() {
        if (this.isPayment) {
            return POSDocumentType.Payment;
        }
        return POSDocumentType.Receipt;
    }

    @Override
    public <T extends POSMasterFile> void afterCachedScreenReDraw() {
        this.payReceipt = this.isPayment ? new POSPaymentToRegistery(this) : new POSReceiptFromRegistery(this);
        this.codeField.setText(this.payReceipt.getCode());
        ((IPOSToolBar)this.pane.getTop()).updateInformation(null);
        this.payTypeCombo.getSelectionModel().selectFirst();
        this.cancelReservationsField.clear();
        this.docToPayCodeField.clear();
        this.subsidiary.refresh();
        this.amountField.clear();
        this.paymentMethod.clear();
        this.totalField.clear();
        this.paidField.clear();
        this.docCategory.clear();
        this.attach1.reset();
        this.attach2.reset();
        this.remarks.clear();
        if (ObjectChecker.isNotEmptyOrNull((Object)this.paymentType)) {
            this.subsidiary.getTypeCombo().getSelectionModel().select((Object)this.paymentType);
        }
    }

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return this.map;
    }

    static {
        docsFromNama = "docsFromNama";
        namaWithPosSubsidType = new HashMap();
    }
}

