/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.Pair;
import com.namasoft.common.ResultDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.DTOPageData;
import com.namasoft.contracts.common.dtos.requests.FindByIDRequest;
import com.namasoft.contracts.common.services.base.EntityService;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.namapos.contracts.common.DTODataWriterResponse;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaPOSSearchDialog;
import com.namasoft.namacontrols.PosSettingValidation;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSSlideMenu;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSActionHistory;
import com.namasoft.pos.domain.entities.POSError;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSActionType;
import com.namasoft.pos.orm.NaMaSQLServerDialect;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import jakarta.persistence.FlushModeType;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class POSPersister {
    private static SessionFactory factory;

    public static Number count(Class klass, String sqlQuery, Map<String, Object> paramters) {
        return POSPersister.count(klass, sqlQuery, paramters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number count(Class klass, String sqlQuery, Map<String, Object> paramters, boolean filterOnDimensions) {
        try (Session session = POSPersister.openSession();){
            String queryStr = "select count(id) from " + klass.getSimpleName() + sqlQuery;
            if (filterOnDimensions) {
                queryStr = queryStr + NamaPOSSearchDialog.filterOnDimensionCriteria(klass, paramters);
            }
            Query query = session.createQuery(queryStr);
            POSPersister.updateParams(paramters, query);
            Number number = (Number)query.uniqueResult();
            return number;
        }
    }

    public static <T> T max(Class<?> klass, String field, Class<T> returnType) {
        return POSPersister.max(klass, field, "", new HashMap<String, Object>(), returnType);
    }

    public static <T> T max(Class<?> klass, String field, String whereClause, Map<String, Object> params, Class<T> returnType) {
        return returnType.cast(CollectionsUtility.getFirst(POSPersister.executeSelect("select max(".concat(field).concat(") from ").concat(klass.getSimpleName()), whereClause, params)));
    }

    public static List<Object[]> executeSelectAndDoNotFail(String queryStr, String whereClause, Map<String, Object> params) {
        try {
            return POSPersister.executeSelect(queryStr, whereClause, params);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return new ArrayList<Object[]>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> executeSelect(String queryStr, String whereClause, Map<String, Object> params) {
        try (Session session = POSPersister.openSession();){
            String whereKeyword = " where ";
            if (whereClause.startsWith("where ") || whereClause.startsWith(" where ")) {
                whereKeyword = "";
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)whereClause)) {
                queryStr = queryStr.concat(whereKeyword).concat(whereClause);
            }
            NativeQuery query = session.createNativeQuery(queryStr, Object[].class);
            POSPersister.updateParams(params, (Query)query);
            List list = query.list();
            return list;
        }
    }

    public static POSResult saveAndCreateActionHistoryEntry(POSMasterFile object) {
        POSResult posResult = POSPersister.saveOrUpdate(object);
        if (posResult.isSucceeded().booleanValue()) {
            posResult = POSPersister.saveOrUpdate(POSActionHistory.create(object, POSActionType.Inserted));
        }
        return posResult;
    }

    public static POSResult saveOrUpdateWithActionHistory(POSMasterFile object) {
        return POSPersister.saveOrUpdateWithActionHistory(object, null);
    }

    public static POSResult saveOrUpdateWithActionHistory(POSMasterFile object, Session session) {
        POSMasterFile existingRecord = (POSMasterFile)POSPersister.findByID(object.getClass(), object.getId());
        POSResult result = POSPersister.saveOrUpdate(object, session);
        if (result.isSucceeded().booleanValue()) {
            POSPersister.saveOrUpdate(POSActionHistory.create(object, existingRecord == null ? POSActionType.Inserted : POSActionType.Updated));
        }
        return result;
    }

    public static Session openSession() {
        Session session = factory.openSession();
        session.setFlushMode(FlushModeType.COMMIT);
        return session;
    }

    public static boolean isInitialized() {
        return factory != null;
    }

    public static POSResult saveOrUpdate(POSSavable object) {
        if (object == null) {
            return new POSResult();
        }
        try (Session session = null;){
            session = POSPersister.openSession();
            POSResult pOSResult = POSPersister.saveOrUpdate(object, session);
            return pOSResult;
        }
    }

    public static POSResult saveOrUpdate(POSSavable object, Session session) {
        POSSalesReturn returnDoc;
        if (object == null) {
            return new POSResult();
        }
        if (session == null) {
            return POSPersister.saveOrUpdate(object);
        }
        POSResult posResult = new POSResult();
        Transaction tx = null;
        if (object instanceof POSSalesInvoice && ObjectChecker.isEmptyOrNull(((POSSalesInvoice)object).getDetails())) {
            POSResult result = new POSResult();
            result.failure("Save failed. Invoice is empty {0}", object);
            posResult.accumulate(result);
            NaMaLogger.error((Throwable)new RuntimeException("******************Save failed. Invoice is empty*****"));
            return posResult;
        }
        if (object instanceof POSSalesReturn && POSPersister.verifySalesReturnFromInvoiceFieldNotChanged(returnDoc = (POSSalesReturn)object, posResult).isFailed().booleanValue()) {
            return posResult;
        }
        if (object.hasEmptyReqFields(posResult)) {
            return posResult;
        }
        boolean commit = false;
        try {
            Random x;
            int Result;
            tx = session.getTransaction();
            if (tx == null || !tx.isActive()) {
                tx = session.beginTransaction();
                commit = true;
            }
            object.assignIds();
            object.markAsCommit();
            if (object instanceof POSMasterFile && POSGeneralSettings.randomFailure() && (Result = (x = new Random()).nextInt(99) + 1) > 50) {
                Platform.runLater(() -> {
                    Notifications create = Notifications.create();
                    create.title("Notification").text("Random failure " + object.getClass().getSimpleName() + " " + ((POSMasterFile)object).getCode()).darkStyle().hideAfter(Duration.seconds((double)5.0)).showInformation();
                });
                throw new RuntimeException("Random Failure");
            }
            session.saveOrUpdate((Object)object);
            object.postCommitAction(session);
            if (commit) {
                tx.commit();
                object.afterCommitSuccessfully();
            }
        }
        catch (Throwable e) {
            NaMaLogger.error((Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            POSPersister.addErrorsEntry(object, e);
            Platform.runLater(() -> {
                Notifications create = Notifications.create();
                String notification = POSResourcesUtil.id("Previous document not saved", new Object[0]) + "\n " + e.getMessage() + "\n ";
                if (object instanceof POSMasterFile) {
                    notification = notification + object.getClass().getSimpleName() + " with code " + ((POSMasterFile)object).getCode();
                }
                create.title("Notification").text(notification).darkStyle().hideAfter(Duration.seconds((double)5.0)).showInformation();
            });
            posResult.failure(POSResourcesUtil.id("Save transaction failed", new Object[0]), new Object[0]);
            throw e;
        }
        return posResult;
    }

    private static POSResult verifySalesReturnFromInvoiceFieldNotChanged(POSSalesReturn returnDoc, POSResult result) {
        POSSalesReturn persistedSalesReturn = POSPersister.findByID(POSSalesReturn.class, returnDoc.getId());
        if (persistedSalesReturn == null) {
            persistedSalesReturn = (POSSalesReturn)POSPersister.findByCode(POSSalesReturn.class, returnDoc.getCode());
        }
        if (persistedSalesReturn == null) {
            return result;
        }
        if (ObjectChecker.isTrue((Boolean)persistedSalesReturn.getHold())) {
            return result;
        }
        if (ObjectChecker.areNotEqual((Object)persistedSalesReturn.getFromInvoiceId(), (Object)returnDoc.getFromInvoiceId())) {
            return result.accumulate("\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0627 \u0627\u0644\u0645\u0631\u062f\u0648\u062f \u064a\u0631\u062c\u0649 \u0625\u0646\u0634\u0627\u0621 \u0645\u0631\u062f\u0648\u062f \u062c\u062f\u064a\u062f", "Can not use this sales return please create new one", true);
        }
        return result;
    }

    private static void addErrorsEntry(POSSavable object, Throwable e) {
        boolean userWithErrorsCapability;
        if (ObjectChecker.isEmptyOrNull((Object)POSSettingsInfo.fetchConfiguration())) {
            return;
        }
        boolean bl = userWithErrorsCapability = ObjectChecker.isNotEmptyOrNull((Object)POSSettingsInfo.fetchConfiguration().getCurrentUser()) && POSSecurityUtil.userCan(POSSecurityCapability.CanShowDataTransferErrors).isSucceeded() != false;
        if (!(object instanceof POSError) && object instanceof POSMasterFile) {
            DTODataWriterResponse response = new DTODataWriterResponse();
            response.setCode(((POSMasterFile)object).getCode());
            response.setId(object.getId().toString());
            Throwable cause = e.getCause() == null ? e : e.getCause();
            response.setResult(ResultDTO.fail((String)cause.getMessage()));
            POSError error = new POSError();
            error.setCode(((POSMasterFile)object).getCode());
            error.setOnTime(new Date());
            error.setEntityType(((POSMasterFile)object).calcNamaEntityType());
            error.setRecordId(object.getId());
            error.setFailure(e.getMessage());
            error.setLog(response.getResult().getEnglishMessage());
            POSPersister.saveOrUpdate(error);
            if (userWithErrorsCapability) {
                POSDataWriterUtil.showNotificationWithFailure(error, "");
            }
        }
    }

    public static <PersistedType extends POSSavable> List<PersistedType> listAll(Class<PersistedType> klass) {
        return POSPersister.listAll(klass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <PersistedType extends POSSavable> List<PersistedType> listAll(Class<PersistedType> klass, boolean filterOnDims) {
        Session session = POSPersister.openSession();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object filterOnDimensionCriteria = "where 1=1 ";
        if (filterOnDims) {
            filterOnDimensionCriteria = (String)filterOnDimensionCriteria + NamaPOSSearchDialog.filterOnDimensionCriteria(klass, parameters);
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            Query query = session.createQuery("FROM " + klass.getSimpleName() + " " + (String)filterOnDimensionCriteria);
            POSPersister.updateParams(parameters, query);
            List objects = query.list();
            POSPersister.initializeLists(objects);
            tx.commit();
            List list = objects;
            return list;
        }
        catch (Throwable e) {
            if (tx != null) {
                tx.rollback();
            }
            NaMaLogger.error((Throwable)e);
        }
        finally {
            session.close();
        }
        return null;
    }

    public static List<?> listAll(Class<?> klass, String query, HashMap<String, Object> paramters, String orderByCol) {
        String criteria = "FROM " + klass.getSimpleName() + query;
        if (ObjectChecker.isNotEmptyOrNull((Object)orderByCol)) {
            criteria = criteria + " order by " + orderByCol;
        }
        return POSPersister.searchFor(criteria, paramters);
    }

    public static List<?> listAll(Class<?> klass, DTOPageData pageData) {
        return POSPersister.searchFor("FROM " + klass.getSimpleName(), pageData);
    }

    public static List<?> listAll(Class<?> klass, String query) {
        return POSPersister.searchFor("FROM " + klass.getSimpleName() + query);
    }

    public static List<?> listAll(Class<?> klass, String query, String orderByCol1) {
        return POSPersister.searchFor("FROM " + klass.getSimpleName() + query + " order by " + orderByCol1 + " desc");
    }

    public static List<?> listAll(Class<?> klass, String query, String orderByCol1, boolean desc) {
        if (desc) {
            return POSPersister.searchFor("FROM " + klass.getSimpleName() + query + " order by " + orderByCol1 + " desc");
        }
        return POSPersister.searchFor("FROM " + klass.getSimpleName() + query + " order by " + orderByCol1 + " asc");
    }

    public static List<?> listAll(Class<?> klass, String query, String orderByCol1, String orderByCol2) {
        return POSPersister.searchFor("FROM " + klass.getSimpleName() + query + " order by " + orderByCol1 + " desc, " + orderByCol2 + " desc");
    }

    public static List<?> selectTop(Class<?> klass, String condition, int number) {
        return POSPersister.selectTop(klass, condition, number, " asc", null, new String[0]);
    }

    public static List<?> selectTop(Class<?> klass, String condition, int number, Map<String, Object> parameters) {
        return POSPersister.selectTop(klass, condition, number, " asc", parameters, new String[0]);
    }

    public static List<?> selectTop(Class<?> klass, String condition, int number, String descOrAsc, Map<String, Object> parameters, String ... orderBy) {
        return POSPersister.selectTop(klass, condition, number, descOrAsc, parameters, false, orderBy);
    }

    public static List<?> selectTop(Class<?> klass, String condition, int number, String descOrAsc, Map<String, Object> parameters, boolean filterOnDimensions, List<String> columnsToGet, String ... orderBy) {
        return POSPersister.selectTop(klass, condition, number, descOrAsc, parameters, filterOnDimensions, null, columnsToGet, orderBy);
    }

    public static List<?> selectTop(Class<?> klass, String condition, int number, String descOrAsc, Map<String, Object> parameters, boolean filterOnDimensions, String ... orderBy) {
        return POSPersister.selectTop(klass, condition, number, descOrAsc, parameters, filterOnDimensions, null, null, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<?> selectTop(Class<?> klass, String condition, int number, String descOrAsc, Map<String, Object> parameters, boolean filterOnDimensions, DTOPageData pageData, List<String> columnsToGet, String ... orderBy) {
        Session session = POSPersister.openSession();
        boolean initializeLists = true;
        if (number == 0) {
            initializeLists = false;
            number = 10;
        }
        Transaction tx = null;
        try {
            ArrayList<POSMasterFile> objects;
            int i;
            tx = session.beginTransaction();
            String queryString = " FROM " + klass.getSimpleName() + " obj ";
            String fieldPrefix = "obj.";
            condition = POSPersister.adjustCondition(klass, condition, fieldPrefix).toString();
            if (ObjectChecker.isNotEmptyOrNull((Object)condition)) {
                queryString = queryString + condition;
            }
            if (filterOnDimensions) {
                queryString = queryString + NamaPOSSearchDialog.filterOnDimensionCriteria(klass, parameters);
            }
            ArrayList<String> orderByList = new ArrayList<String>(Arrays.asList(orderBy));
            orderByList.removeIf(ObjectChecker::isEmptyOrNull);
            for (i = orderByList.size() - 1; i > 0; --i) {
                if (orderByList.indexOf(orderByList.get(i)) == i) continue;
                orderByList.remove(i);
            }
            if (ObjectChecker.isNotEmptyOrNull(orderByList)) {
                for (i = 0; i < orderByList.size(); ++i) {
                    queryString = queryString.contains("order by") ? queryString + ", " + fieldPrefix + (String)orderByList.get(i) + " " + descOrAsc : queryString + " order by " + fieldPrefix + (String)orderByList.get(i) + " " + descOrAsc;
                }
            }
            if (ObjectChecker.isNotEmptyOrNull(columnsToGet)) {
                queryString = "select " + columnsToGet.stream().map(c -> fieldPrefix + c).collect(Collectors.joining(",")) + " " + queryString;
            }
            Query query = session.createQuery(queryString);
            if (pageData == null) {
                pageData = new DTOPageData();
            }
            if (ObjectChecker.isZero((Integer)pageData.getPageSize())) {
                pageData.setPageSize(number);
            }
            POSPersister.setPagingData(query, pageData);
            if (parameters != null) {
                POSPersister.updateParams(parameters, query);
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)(objects = query.list())) && !(objects.get(0) instanceof POSMasterFile)) {
                ArrayList<POSMasterFile> realObjs = new ArrayList<POSMasterFile>();
                for (Object e : objects) {
                    POSMasterFile object = (POSMasterFile)ObjectCreatorUtil.creator(klass).create();
                    int i2 = 0;
                    for (String colId : columnsToGet) {
                        ReflectionUtils.setProperty((Object)object, (String)colId, (Object)((Object[])e)[i2]);
                        ++i2;
                    }
                    realObjs.add(object);
                }
                objects = realObjs;
            }
            if (initializeLists) {
                POSPersister.initializeLists(objects);
            } else {
                for (Object e : objects) {
                    ((POSSavable)e).initializeSearchLevelLists();
                }
            }
            tx.commit();
            ArrayList<POSMasterFile> arrayList = objects;
            return arrayList;
        }
        catch (Throwable e) {
            if (tx != null) {
                tx.rollback();
            }
            NaMaLogger.error((Throwable)e);
        }
        finally {
            session.close();
        }
        return null;
    }

    private static void initializeLists(List objects) {
        for (Object posSavable : objects) {
            try {
                ((POSSavable)posSavable).initializeLists();
            }
            catch (HibernateException e) {
                POSSlideMenu.fixLineNumbersAction();
                ((POSSavable)posSavable).initializeLists();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder adjustCondition(Class<?> klass, String condition, String fieldPrefix) {
        ArrayList<String> klassFields = new ArrayList<String>();
        POSPersister.getKlassFields(klass, klassFields);
        StringBuilder newCondition = new StringBuilder();
        for (String string : condition.replace("(", "( ").split(" ")) {
            void var8_8;
            if (!string.equals("") && klassFields.contains(string)) {
                String string2 = fieldPrefix + string;
            }
            newCondition.append((String)var8_8 + " ");
        }
        return newCondition;
    }

    private static List<String> getKlassFields(Class<?> klass, List<String> fields) {
        if (klass == null || klass == Object.class) {
            return fields;
        }
        fields.addAll(Arrays.stream(klass.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()));
        POSPersister.getKlassFields(klass.getSuperclass(), fields);
        return fields;
    }

    public static List<?> searchFor(String query, DTOPageData pageData) {
        return POSPersister.searchFor(query, null, pageData);
    }

    public static List<?> searchFor(String query) {
        return POSPersister.searchFor(query, new HashMap<String, Object>());
    }

    public static List<?> searchFor(String query, Map<String, Object> parameters) {
        return POSPersister.searchFor(query, parameters, null, null);
    }

    public static <T extends POSSavable> List<T> searchFor(String query, Map<String, Object> parameters, DTOPageData pageData) {
        Transaction tx = null;
        try (Session session = POSPersister.openSession();){
            tx = session.beginTransaction();
            List<T> objects = POSPersister.searchFor(query, parameters, pageData, session);
            tx.commit();
            List<T> list = objects;
            return list;
        }
    }

    public static <T extends POSSavable> List<T> searchFor(String query, Map<String, Object> parameters, Session session) {
        return POSPersister.searchFor(query, parameters, null, session);
    }

    public static <T extends POSSavable> List<T> searchFor(String query, Map<String, Object> parameters, DTOPageData pageData, Session session) {
        if (session == null) {
            return POSPersister.searchFor(query, parameters, pageData);
        }
        Query q = session.createQuery(query);
        if (parameters != null) {
            POSPersister.updateParams(parameters, q);
        }
        POSPersister.setPagingData(q, pageData);
        List objects = q.list();
        if (ObjectChecker.isNotEmptyOrNull((Object)objects) && objects.get(0) instanceof POSSavable) {
            POSPersister.initializeLists(objects);
        }
        return objects;
    }

    public static void updateParams(Map<String, Object> parameters, Query q) {
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            if (param.getValue() instanceof Collection) {
                q.setParameterList(param.getKey(), (Collection)param.getValue());
                continue;
            }
            q.setParameter(param.getKey(), param.getValue());
        }
    }

    private static void setPagingData(Query query, DTOPageData pageData) {
        if (pageData == null) {
            return;
        }
        int startPage = pageData.getPageNumber();
        int pageSize = pageData.getPageSize();
        if (startPage >= 0 && pageSize > 0) {
            int startPosition = startPage * pageSize;
            query.setFirstResult(startPosition);
            query.setMaxResults(pageSize);
        }
    }

    public static <PersistedType extends POSMasterFile<?>> PersistedType materialize(Class<PersistedType> klass, PersistedType t) {
        if (!(t instanceof HibernateProxy)) {
            return t;
        }
        try {
            t.getCode();
        }
        catch (LazyInitializationException e) {
            return (PersistedType)((POSMasterFile)POSPersister.findByID(klass, t.getId()));
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <PersistedType extends POSSavable> PersistedType findByID(Class<PersistedType> klass, UUID id, boolean filterOnDimensions) {
        if (id == null || klass == null) {
            return null;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", id);
        Transaction tx = null;
        try (Session session = POSPersister.openSession();){
            tx = session.beginTransaction();
            if (ObjectChecker.isFalseOrNull((Boolean)filterOnDimensions)) {
                POSSavable object = (POSSavable)session.get(klass, (Object)id);
                PersistedType PersistedType = POSPersister.fetchFirstOne(tx, Arrays.asList(object));
                return PersistedType;
            }
            Query query = session.createQuery(" FROM " + klass.getSimpleName() + " where id = :id " + NamaPOSSearchDialog.filterOnDimensionCriteria(klass, parameters));
            POSPersister.updateParams(parameters, query);
            List list = query.list();
            PersistedType PersistedType = POSPersister.fetchFirstOne(tx, list);
            return PersistedType;
        }
        return null;
    }

    public static <PersistedType extends POSSavable> PersistedType findByID(Class<PersistedType> klass, String id) {
        return POSPersister.findByID(klass, ServerStringUtils.strToUUID((String)id));
    }

    public static <PersistedType extends POSSavable> PersistedType findByID(Class<PersistedType> klass, UUID id) {
        return POSPersister.findByID(klass, id, false);
    }

    private static <PersistedType extends POSSavable> PersistedType fetchFirstOne(Transaction tx, List<POSSavable> list) {
        boolean exceptionHappenned = false;
        try {
            if (ObjectChecker.isNotEmptyOrNull(list)) {
                POSSavable object = list.get(0);
                if (ObjectChecker.isEmptyOrNull((Object)object)) {
                    PersistedType PersistedType = null;
                    return PersistedType;
                }
                POSPersister.initializeLists(Arrays.asList(object));
                POSSavable pOSSavable = object;
                return (PersistedType)pOSSavable;
            }
            PersistedType object = null;
            return object;
        }
        catch (Exception e) {
            exceptionHappenned = true;
            throw e;
        }
        finally {
            if (exceptionHappenned) {
                tx.rollback();
            } else {
                tx.commit();
            }
        }
    }

    public static <PersistedType extends POSMasterFile> PersistedType findByCode(Class<?> klass, String code) {
        return POSPersister.findByCode(klass, code, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <PersistedType extends POSMasterFile> PersistedType findByCode(Class<?> klass, String code, boolean filterOnDimensions) {
        Session session = POSPersister.openSession();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("code", code);
        String filterOnDimensionCriteria = "";
        if (filterOnDimensions) {
            filterOnDimensionCriteria = NamaPOSSearchDialog.filterOnDimensionCriteria(klass, parameters);
        }
        try {
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery(" FROM " + klass.getSimpleName() + " where code = :code " + filterOnDimensionCriteria);
            POSPersister.updateParams(parameters, query);
            List list = query.list();
            POSMasterFile pOSMasterFile = (POSMasterFile)POSPersister.fetchFirstOne(tx, list);
            return (PersistedType)pOSMasterFile;
        }
        catch (Throwable e) {
            NaMaLogger.error((Throwable)e);
        }
        finally {
            session.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static POSUser findUser(String userId) {
        Transaction tx = null;
        try (Session session = POSPersister.openSession();){
            tx = session.beginTransaction();
            List list = session.createQuery(" FROM " + POSUser.class.getSimpleName() + " where userId = :userId ").setParameter("userId", (Object)userId).list();
            if (ObjectChecker.isNotEmptyOrNull((Object)list)) {
                POSUser user = (POSUser)list.get(0);
                POSPersister.initializeLists(Arrays.asList(user));
                tx.commit();
                POSUser pOSUser = user;
                return pOSUser;
            }
        }
        return null;
    }

    public static void deleteAllWithActionHistory(List<? extends POSMasterFile> objects) {
        POSPersister.deleteAll(objects);
        for (POSMasterFile pOSMasterFile : objects) {
            POSPersister.saveOrUpdate(POSActionHistory.create(pOSMasterFile, POSActionType.Deleted));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll(List<? extends POSMasterFile> objects) {
        if (ObjectChecker.isNotEmptyOrNull(objects)) {
            Transaction tx = null;
            try (Session session = POSPersister.openSession();){
                tx = session.beginTransaction();
                for (POSMasterFile pOSMasterFile : objects) {
                    POSPersister.delete(pOSMasterFile, session);
                }
                tx.commit();
            }
        }
    }

    public static void deleteWithActionHistory(POSMasterFile object) {
        if (POSPersister.delete(object).isSucceeded().booleanValue()) {
            POSPersister.saveOrUpdate(POSActionHistory.create(object, POSActionType.Deleted));
        }
    }

    public static void delete(POSSavable object, Session session) {
        object.preDeleteActions();
        session.delete((Object)object);
        object.postDeleteActions();
    }

    public static POSResult delete(POSSavable object) {
        POSResult posResult = new POSResult();
        Session session = POSPersister.openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            POSPersister.delete(object, session);
            tx.commit();
        }
        catch (Throwable e) {
            if (tx != null) {
                tx.rollback();
            }
            NaMaLogger.error((Throwable)e);
            POSPersister.addErrorsEntry(object, e);
            posResult.failure(POSResourcesUtil.id("Delete transaction failed", new Object[0]), new Object[0]);
            if (object instanceof POSItem) {
                session.close();
                ((POSItem)object).setSellable(false);
                POSPersister.saveOrUpdate(object);
            }
            throw e;
        }
        finally {
            if (session.isOpen()) {
                session.close();
            }
        }
        return posResult;
    }

    public static SessionFactory getFactory() {
        return factory;
    }

    public static <DTO extends BaseEntityDTO, WS extends EntityService> DTO getReference(EntityReferenceData ref) {
        if (ObjectChecker.isEmptyOrNull((Object)ref)) {
            return null;
        }
        EntityService service = (EntityService)ServiceUtility.getServiceClient((String)ref.getEntityType());
        FindByIDRequest id = new FindByIDRequest(ref);
        id.setFromAction(Boolean.valueOf(true));
        return (DTO)((BaseEntityDTO)service.findByID(id).getData());
    }

    public static void startup() {
        POSPersister.checkDataBaseConfig(POSGeneralSettings.getDBURL(), POSGeneralSettings.getDBPortNum(), POSGeneralSettings.getPosDBName(), POSGeneralSettings.getDBUser(), POSGeneralSettings.getDBPassword());
        if (PosSettingValidation.instance().isErrorInDBConfig()) {
            return;
        }
        if (POSPersister.isInitialized()) {
            return;
        }
        Configuration configuration = POSPersister.createConfiguration();
        try {
            factory = configuration.configure().buildSessionFactory();
        }
        catch (HibernateException e) {
            NaMaLogger.error((Throwable)e);
            System.exit(0);
        }
    }

    public static void checkDataBaseConfig(String dbUrl, String port, String dbName, String userName, String pass) {
        String dbConnection = "jdbc:sqlserver://" + dbUrl + ":" + port + ";database=" + dbName + ";encrypt=true;trustServerCertificate=true;";
        try (Connection connection = DriverManager.getConnection(dbConnection, userName, pass);
             PreparedStatement statement = connection.prepareStatement("SELECT SERVERPROPERTY('productversion') v, SERVERPROPERTY('edition')  e");
             ResultSet resultSet = statement.executeQuery();){
            resultSet.next();
            String versionStr = resultSet.getString(1);
            Integer majorVersion = ObjectChecker.tryParseInt((String)StringUtils.substringBefore((String)versionStr, (String)"."));
            if (majorVersion == null || majorVersion < 13) {
                PosSettingValidation.instance().setInvalidSqlServerVersion(true);
            }
        }
        catch (Exception e) {
            PosSettingValidation.instance().setErrorInDBConfig(true);
            NaMaLogger.error((Throwable)e);
        }
    }

    public static Configuration createConfiguration() {
        Configuration configuration = new Configuration();
        String dbConnection = "jdbc:sqlserver://" + POSGeneralSettings.getDBURL() + ":" + POSGeneralSettings.getDBPortNum() + ";database=" + POSGeneralSettings.getPosDBName();
        String connectionDriverCalss = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        configuration.setProperty("hibernate.connection.url", dbConnection);
        configuration.setProperty("hibernate.type.preferred_uuid_jdbc_type", "BINARY");
        configuration.setProperty("hibernate.connection.password", ObjectChecker.toStringOrEmpty((Object)POSGeneralSettings.getDBPassword()));
        configuration.setProperty("hibernate.connection.username", ObjectChecker.toStringOrEmpty((Object)POSGeneralSettings.getDBUser()));
        configuration.setProperty("hibernate.connection.encrypt", "true");
        configuration.setProperty("hibernate.connection.trustServerCertificate", "true");
        configuration.setProperty("hibernate.use_nationalized_character_data", "true");
        if ("sqlserver".equalsIgnoreCase(POSGeneralSettings.getDBType().toString())) {
            configuration.setProperty("hibernate.connection.driver_class", connectionDriverCalss);
            configuration.setProperty("hibernate.dialect", NaMaSQLServerDialect.class.getName());
        }
        return configuration;
    }

    public static HashMap<String, Object> params(Object ... paramters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < paramters.length; i += 2) {
            map.put((String)paramters[i], paramters[i + 1]);
        }
        return map;
    }

    public static void execute(String oql) {
        POSPersister.execute(oql, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String oql, HashMap<String, Object> params) {
        Transaction tx = null;
        try (Session session = POSPersister.openSession();){
            tx = session.beginTransaction();
            NativeQuery query = session.createNativeQuery(oql, Object.class);
            if (params != null) {
                POSPersister.updateParams(params, (Query)query);
            }
            query.executeUpdate();
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String oql, String paramName, Object paramVal) {
        Transaction tx = null;
        try (Session session = POSPersister.openSession();){
            tx = session.beginTransaction();
            NativeQuery query = session.createNativeQuery(oql, Object.class);
            if (ObjectChecker.isNotEmptyOrNull((Object)paramName)) {
                query = query.setParameter(paramName, paramVal);
            }
            query.executeUpdate();
            tx.commit();
        }
    }

    public static boolean testDBConnection() {
        return (Boolean)POSPersister.runPreparedStatement("select 1").getX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Boolean, BigDecimal> runPreparedStatement(String sql) {
        Pair pair = new Pair((Object)true, (Object)BigDecimal.ZERO);
        try (Session session = factory.openSession();){
            session.doWork(connection -> {
                try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        pair.setY((Object)resultSet.getBigDecimal(1));
                    }
                }
            });
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends POSSavable> T unproxy(T object) {
        if (object == null) {
            return object;
        }
        Transaction tx = null;
        try (Session session = POSPersister.openSession();){
            tx = session.beginTransaction();
            session.refresh(object);
            Object PersistedType = POSPersister.fetchFirstOne(tx, Arrays.asList(object));
            return (T)PersistedType;
        }
        return null;
    }

    public static <T extends POSSavable> T materializeProxy(Class<T> klass, T proxy) {
        if (proxy instanceof HibernateProxy) {
            UUID id = (UUID)((HibernateProxy)proxy).getHibernateLazyInitializer().getIdentifier();
            return POSPersister.findByID(klass, id);
        }
        return proxy;
    }
}

