/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.util.POSImgUtil;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class POSPreLoader
extends Preloader {
    private Stage preloaderStage;
    public static POSPreLoader instance;
    private ProgressBar progressBar;
    private Label startingLabel;
    private Button closeBtn;

    public POSPreLoader() {
        instance = this;
    }

    public void start(Stage primaryStage) throws Exception {
        this.preloaderStage = primaryStage;
        VBox loading = new VBox(40.0);
        loading.setPrefHeight(300.0);
        loading.setPrefWidth(800.0);
        Image img = POSResourcesUtil.loadImageFromResources("posSplashScreen.jpeg", 400.0, 150.0, true, true);
        ImageView imgView = new ImageView();
        imgView.setImage(img);
        loading.getChildren().add((Object)imgView);
        this.progressBar = new ProgressBar();
        this.progressBar.setPrefWidth(500.0);
        loading.getChildren().add((Object)this.progressBar);
        this.startingLabel = new Label("POS Starting Please wait ...");
        this.startingLabel.setFont(new Font(30.0));
        loading.getChildren().add((Object)this.startingLabel);
        loading.setAlignment(Pos.CENTER);
        BorderPane root = new BorderPane((Node)loading);
        root.setTop((Node)new HBox());
        this.closeBtn = new Button();
        this.closeBtn.getStyleClass().add((Object)"icon");
        this.closeBtn.setGraphic((Node)POSImgUtil.createSVGImageView("closePreLoader.svg"));
        this.closeBtn.setOnAction(event -> {
            POSPreLoader.closeIfNeeded();
            PosShortcutsUtil.terminateAll();
        });
        this.closeBtn.setVisible(false);
        this.closeBtn.setAlignment(Pos.TOP_LEFT);
        ((HBox)root.getTop()).getChildren().addAll((Object[])new Node[]{this.closeBtn});
        Scene scene = new Scene((Parent)root);
        primaryStage.getIcons().add((Object)POSImgUtil.fetchSVGImage("point-of-sale.svg"));
        primaryStage.initStyle(StageStyle.UNDECORATED);
        primaryStage.setWidth(800.0);
        primaryStage.setHeight(600.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public static void closeIfNeeded() {
        if (instance != null && POSPreLoader.instance.preloaderStage != null) {
            POSPreLoader.instance.preloaderStage.hide();
        }
    }

    public void updateErrorsLabel(String error) {
        NaMaLogger.error((Object)error);
        Platform.runLater(() -> {
            this.startingLabel.setText(error);
            this.startingLabel.setStyle("-fx-text-fill: red");
            this.closeBtn.setVisible(true);
            this.progressBar.setVisible(false);
        });
    }
}

