/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.util.POSInvoicesService;
import com.namasoft.pos.util.POSResult;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;

public class POSRemoteInvoiceDialog {
    private Dialog<ButtonType> dialog;
    private NamaTextField customerPhoneNumberTextField;
    private ButtonType okButtonType = new ButtonType(POSResourcesUtil.id("ok", new Object[0]), ButtonBar.ButtonData.OTHER);
    private ButtonType cancelButtonType = new ButtonType(POSResourcesUtil.id("cancel", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
    private AbsPosSalesScreen screen;

    public POSRemoteInvoiceDialog(AbsPosSalesScreen screen) {
        this.screen = screen;
        this.dialog = new Dialog();
        this.dialog.setTitle(POSResourcesUtil.id("searchInvoiceExternally", new Object[0]));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{this.okButtonType, this.cancelButtonType});
        this.dialog.getDialogPane().getScene().setNodeOrientation(POSResourcesUtil.getOrientation());
        GridPane grid = new GridPane();
        grid.setVgap(10.0);
        grid.setHgap(5.0);
        this.customerPhoneNumberTextField = new NamaTextField(POSFieldType.Text);
        NamaLabel customerPhoneNumberLabel = new NamaLabel(POSResourcesUtil.id("phoneNumber", new Object[0]));
        NamaLabel registerLabel = new NamaLabel(POSResourcesUtil.id("registerCode", new Object[0]));
        POSSettingsUtil.setFonts(20.0, this.getClass().getClassLoader(), new Node[]{this.customerPhoneNumberTextField, customerPhoneNumberLabel, registerLabel});
        grid.add((Node)customerPhoneNumberLabel, 0, 0);
        grid.add((Node)this.customerPhoneNumberTextField, 1, 0);
        this.dialog.getDialogPane().setContent((Node)grid);
    }

    public void showDialog() {
        POSResult posResult = new POSResult();
        this.customerPhoneNumberTextField.requestFocus();
        Button okButton = (Button)this.dialog.getDialogPane().lookupButton(this.okButtonType);
        okButton.setOnKeyPressed(event -> {
            String customerPhoneNumber = this.customerPhoneNumberTextField.getText();
            if (ObjectChecker.isAnyEqualToFirst((Object)event.getCode(), (Object[])new KeyCode[]{KeyCode.ENTER, KeyCode.TAB})) {
                this.okAction(posResult, customerPhoneNumber);
            }
        });
        this.customerPhoneNumberTextField.setOnKeyPressed(e -> {
            if (ObjectChecker.areEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                okButton.fire();
            }
        });
        Optional result = this.dialog.showAndWait();
        String customerPhoneNumber = this.customerPhoneNumberTextField.getText();
        if (result != null && result.isPresent() && result.get() == this.okButtonType && ObjectChecker.isNotEmptyOrNull((Object)customerPhoneNumber)) {
            this.okAction(posResult, customerPhoneNumber);
        } else {
            this.dialog.hide();
        }
    }

    public void okAction(POSResult posResult, String customerCode) {
        this.dialog.hide();
        POSSalesInvoice invoice = POSInvoicesService.fetchHeldInvoiceForCustomer(POSResourcesUtil.fetchMainRegister(), customerCode, posResult);
        if (posResult.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(posResult, this.screen.fetchStage());
            return;
        }
        this.screen.fireSelectItemAction(POSSalesInvoice.class, null, invoice);
    }
}

