/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ProjectPathUtil;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.stream.Collectors;
import javafx.scene.control.Control;
import javafx.scene.control.Label;

public class POSSalesScreenFieldsGenerator {
    public static void main(String[] args) throws IOException {
        POSResourcesUtil.generatingDataModel = true;
        StringBuilder builder = new StringBuilder();
        builder.append("package com.namasoft.namapos.postactions;\n\nimport java.util.*;\n\npublic class POSSalesScreenFields\n{\n\tprivate static List<String> fields;\n\n\tpublic static List<String> getFields()\n\t{\n\t\tif (fields == null)\n\t\t\tinitFields();\n\t\treturn fields;\n\t}\n\n\tprivate static void initFields()\n\t{\n\t\tfields = new ArrayList<>();\n");
        builder.append("\t\tfields.addAll(Arrays.asList(");
        POSSalesScreenFieldsGenerator.addSalesScreenFields(POSNewSalesScreen.class, builder);
        builder.append(" ));\n  \t}\n  }\n");
        Files.write(new File(ProjectPathUtil.POS_GUI_ROOT, "src/main/java/com/namasoft/namapos/postactions/POSSalesScreenFields.java").toPath(), builder.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void addSalesScreenFields(Class<?> klass, StringBuilder builder) {
        Class<?> superclass = klass.getSuperclass();
        if (superclass != null) {
            POSSalesScreenFieldsGenerator.addSalesScreenFields(superclass, builder);
        }
        builder.append(Arrays.stream(klass.getDeclaredFields()).filter(f -> (Control.class.isAssignableFrom(f.getType()) || NamaSearchBox.class.isAssignableFrom(f.getType())) && ObjectChecker.isFalse((Boolean)Label.class.isAssignableFrom(f.getType()))).map(f -> "\"" + f.getName() + "\"").collect(Collectors.joining(",")));
    }
}

