/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.namapos.enums.POSFieldType;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.PosRequiredFieldsLine;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.scene.control.Dialog;
import org.hibernate.Session;

public interface POSSavable {
    public UUID getId();

    public void setId(UUID var1);

    default public void assignIds() {
    }

    default public void initializeLists() {
    }

    default public void initializeSearchLevelLists() {
    }

    default public void postCommitAction(Session session) {
    }

    default public void markAsCommit() {
    }

    default public void preDeleteActions() {
    }

    default public void postDeleteActions() {
    }

    default public POSInvoiceClassification getPosInvoiceClassification() {
        return null;
    }

    default public String getSubsidiaryType() {
        return null;
    }

    default public POSCustomer getCustomer() {
        return null;
    }

    default public UUID getSubsidiaryID() {
        return null;
    }

    default public String getSubsidiaryNamaType() {
        return null;
    }

    default public <DTOType extends MasterFileDTO, POSKlass extends POSMasterFile> POSKlass fromReference(EntityReferenceData ref) {
        return POSSavable.staticFromReference(ref, this);
    }

    public static <DTOType extends MasterFileDTO, POSKlass extends POSMasterFile> POSKlass staticFromReference(EntityReferenceData ref) {
        return POSSavable.staticFromReference(ref, null);
    }

    public static <POSKlass extends POSMasterFile> EntityReferenceData staticToReference(POSKlass posEntity) {
        if (posEntity == null) {
            return null;
        }
        return posEntity.toEntityReferenceData();
    }

    public static <DTOType extends MasterFileDTO, POSKlass extends POSMasterFile> POSKlass staticFromReference(EntityReferenceData ref, POSSavable $this) {
        POSMasterFile posMasterFile = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)ref)) {
            Class posKlass = POSDataReaderUtil.constructNamaWithPOSTypesMap().get(ref.getEntityType());
            if (posKlass == null) {
                NaMaLogger.error((String)"************ could not find class for type {0} ", (Object[])new Object[]{ref.getEntityType()});
                return null;
            }
            posMasterFile = (POSMasterFile)POSPersister.findByID(posKlass, ref.getId());
            if (posMasterFile == null) {
                if ($this != null) {
                    POSPersister.saveOrUpdate($this);
                }
                posMasterFile = (POSMasterFile)ObjectCreatorUtil.creator((Class)posKlass).create();
                MasterFileDTO dto = (MasterFileDTO)POSPersister.getReference(ref);
                posMasterFile.updateData(dto);
                POSPersister.saveOrUpdate(posMasterFile);
            }
        }
        return (POSKlass)posMasterFile;
    }

    default public List<String> filterByFields() {
        return null;
    }

    default public Boolean mustBeDisable(String fieldId) {
        return false;
    }

    default public Map<String, Supplier<Object>> namaFieldsWithPosValues() {
        return null;
    }

    default public boolean relationWithCustomerApplied(String relation, POSCustomer customer) {
        return true;
    }

    default public boolean relationWithSalesManApplied(String relation, POSEmployee salesMan) {
        return true;
    }

    default public boolean relationWithClassificationApplied(String relation, POSInvoiceClassification classification) {
        return true;
    }

    default public boolean relationWithDocCategoryApplied(String relation, PosDocCategory category) {
        return true;
    }

    default public boolean relationWithWarehouseApplied(String relation, POSWarehouse warehouse) {
        return true;
    }

    default public boolean relationWithLocatorApplied(String relation, POSLocation location) {
        return true;
    }

    default public String calcNamaEntityType() {
        return "";
    }

    default public boolean hasEmptyReqFields(POSResult posResult) {
        if (ObjectChecker.isEmptyOrNull(this.namaFieldsWithPosValues())) {
            return false;
        }
        List<?> reqLines = POSPersister.listAll(PosRequiredFieldsLine.class, " where entityType ='" + this.calcNamaEntityType() + "'");
        if (ObjectChecker.isEmptyOrNull(reqLines)) {
            return false;
        }
        List lines = reqLines.stream().filter(l -> this.relationsApplied((PosRequiredFieldsLine)l)).collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(lines)) {
            return false;
        }
        boolean hasEmptyReqFields = false;
        for (PosRequiredFieldsLine line : lines) {
            hasEmptyReqFields = hasEmptyReqFields || this.lineWithEmptyRequired(posResult, line);
        }
        return hasEmptyReqFields;
    }

    default public boolean lineWithEmptyRequired(POSResult posResult, PosRequiredFieldsLine line) {
        Supplier<Object> fieldValSupplier = this.namaFieldsWithPosValues().get(line.getFieldID());
        if (fieldValSupplier == null) {
            return false;
        }
        Object fieldVal = fieldValSupplier.get();
        String id = POSResourcesUtil.id(this.getClass(), line.getFieldID());
        Dialog activatedDialog = AbsPosSalesScreen.getActivatedDialog();
        if (ObjectChecker.areEqual((Object)line.getPosFieldType(), (Object)POSFieldType.Required) && (ObjectChecker.isEmptyOrNull((Object)fieldVal) || fieldVal instanceof List && ((List)fieldVal).stream().filter(f -> f instanceof BigDecimal ? ObjectChecker.isEmptyOrZero((BigDecimal)((BigDecimal)f)) : ObjectChecker.isEmptyOrNull((Object)f)).count() > 0L)) {
            if (activatedDialog != null) {
                activatedDialog.close();
            }
            posResult.failure(id + " " + POSResourcesUtil.id("required", new Object[0]), new Object[0]);
            return true;
        }
        if (ObjectChecker.areEqual((Object)line.getPosFieldType(), (Object)POSFieldType.MustBeEmpty) && (ObjectChecker.isNotEmptyOrNull((Object)fieldVal) || fieldVal instanceof List && ((List)fieldVal).stream().filter(f -> f instanceof BigDecimal ? ObjectChecker.isNotEmptyOrZero((BigDecimal)((BigDecimal)f)) : ObjectChecker.isNotEmptyOrNull((Object)f)).count() > 0L)) {
            if (activatedDialog != null) {
                activatedDialog.close();
            }
            posResult.failure(id + " " + POSResourcesUtil.id("must be empty", new Object[0]), new Object[0]);
            return true;
        }
        return false;
    }

    default public boolean relationsApplied(PosRequiredFieldsLine l) {
        return this.relationWithCustomerApplied(l.getRelationWithCustomer(), l.getCustomer()) && this.relationWithClassificationApplied(l.getRelationWithClassification(), l.getInvoiceClassification()) && this.relationWithDocCategoryApplied(l.getRelationWithDocCategory(), l.getDocCategory()) && this.relationWithSalesManApplied(l.getRelationWithSalesMan(), l.getSalesMan()) && this.relationWithWarehouseApplied(l.getRelationWithWarehouse(), l.getWarehouse()) && this.relationWithLocatorApplied(l.getRelationWithLocator(), l.getLocator());
    }

    default public List<Object> filterFieldsInTableView() {
        return new ArrayList<Object>();
    }

    default public void afterCommitSuccessfully() {
    }
}

