/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.NamaSingleValue;
import com.namasoft.common.Pair;
import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.modules.namapos.enums.POSProcedures;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaCheckBox;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaConfirmationDialog;
import com.namasoft.namacontrols.NamaDatePicker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaPOSSearchDialog;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSLabeledTextField;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.PosSettingsDialog;
import com.namasoft.namacontrols.PosTempDocumentUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.HeavyPosSalesTest;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.InvoiceSplitter;
import com.namasoft.pos.application.MultiTableDialog;
import com.namasoft.pos.application.POSEditTablesFontDialog;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSInternalMsgScreen;
import com.namasoft.pos.application.POSInvoiceType;
import com.namasoft.pos.application.POSLockDialog;
import com.namasoft.pos.application.POSMenuButton;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSReportsScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.POSUtilsDialog;
import com.namasoft.pos.application.PosMenuSearchField;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosScreenCacheUtil;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.application.PricesInquiryDialog;
import com.namasoft.pos.application.TablesInquirmentDialog;
import com.namasoft.pos.application.customerwindow.CustomerDisplayWindow;
import com.namasoft.pos.application.toolbar.NamaToolBar;
import com.namasoft.pos.controllers.NamaJSON;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.POSActionLine;
import com.namasoft.pos.domain.details.POSCancelReservationGridLine;
import com.namasoft.pos.domain.details.POSCancelReservationMainLine;
import com.namasoft.pos.domain.details.POSCancelReservationOtherLine;
import com.namasoft.pos.domain.details.POSCancelReservationPayLine;
import com.namasoft.pos.domain.details.POSCreditNoteLine;
import com.namasoft.pos.domain.details.POSDepreciationReasonDiscLine;
import com.namasoft.pos.domain.details.POSDiscountCouponLine;
import com.namasoft.pos.domain.details.POSExchangeRateLine;
import com.namasoft.pos.domain.details.POSExtraCodeLine;
import com.namasoft.pos.domain.details.POSFieldFormatLine;
import com.namasoft.pos.domain.details.POSFreeGroupLine;
import com.namasoft.pos.domain.details.POSFreeItemLine;
import com.namasoft.pos.domain.details.POSHallTableLine;
import com.namasoft.pos.domain.details.POSInventoryLine;
import com.namasoft.pos.domain.details.POSInvoiceDiscountLine;
import com.namasoft.pos.domain.details.POSInvoiceFreeItemLine;
import com.namasoft.pos.domain.details.POSInvoiceTableLine;
import com.namasoft.pos.domain.details.POSItemBarcodePart1;
import com.namasoft.pos.domain.details.POSItemBarcodePart2;
import com.namasoft.pos.domain.details.POSItemBarcodePart3;
import com.namasoft.pos.domain.details.POSItemBarcodePart4;
import com.namasoft.pos.domain.details.POSItemBarcodePart5;
import com.namasoft.pos.domain.details.POSItemDimsDetail;
import com.namasoft.pos.domain.details.POSItemDiscountLine;
import com.namasoft.pos.domain.details.POSItemUnit;
import com.namasoft.pos.domain.details.POSLegalEntityTax;
import com.namasoft.pos.domain.details.POSMobileUIGridLine;
import com.namasoft.pos.domain.details.POSMobileUIMainLine;
import com.namasoft.pos.domain.details.POSOfferCouponLine;
import com.namasoft.pos.domain.details.POSOfferOnItemsCountLine;
import com.namasoft.pos.domain.details.POSOrderReservationGridLine;
import com.namasoft.pos.domain.details.POSOrderReservationLine;
import com.namasoft.pos.domain.details.POSOrderReservationMainLine;
import com.namasoft.pos.domain.details.POSOrderReservationOtherLine;
import com.namasoft.pos.domain.details.POSRegisterGridLine;
import com.namasoft.pos.domain.details.POSRegisterMainLine;
import com.namasoft.pos.domain.details.POSRegisterOtherLine;
import com.namasoft.pos.domain.details.POSRegisteryCodingParam;
import com.namasoft.pos.domain.details.POSRegisteryCurrecyLine;
import com.namasoft.pos.domain.details.POSRegisteryFavouriteDocLine;
import com.namasoft.pos.domain.details.POSRegisteryFavouriteLine;
import com.namasoft.pos.domain.details.POSRegisteryMethodLine;
import com.namasoft.pos.domain.details.POSReplacementGridLine;
import com.namasoft.pos.domain.details.POSReplacementLine;
import com.namasoft.pos.domain.details.POSReplacementMainLine;
import com.namasoft.pos.domain.details.POSReplacementOtherLine;
import com.namasoft.pos.domain.details.POSReplacementReturnPaymentLine;
import com.namasoft.pos.domain.details.POSReplacementSalesPaymentLine;
import com.namasoft.pos.domain.details.POSReportDefinitionLine;
import com.namasoft.pos.domain.details.POSReportResource;
import com.namasoft.pos.domain.details.POSReservationPaymentLine;
import com.namasoft.pos.domain.details.POSReservationTableLine;
import com.namasoft.pos.domain.details.POSReturnGridLine;
import com.namasoft.pos.domain.details.POSReturnMainLine;
import com.namasoft.pos.domain.details.POSReturnOtherLine;
import com.namasoft.pos.domain.details.POSReturnPaymentLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceCouponLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceCreditNoteLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceRemovedLine;
import com.namasoft.pos.domain.details.POSSalesPaymentLine;
import com.namasoft.pos.domain.details.POSSalesPriceListLine;
import com.namasoft.pos.domain.details.POSSalesRepalcementLine;
import com.namasoft.pos.domain.details.POSSalesReturnLine;
import com.namasoft.pos.domain.details.POSSavingSettingsLine;
import com.namasoft.pos.domain.details.POSServiceChargeLine;
import com.namasoft.pos.domain.details.POSShiftCloseLine;
import com.namasoft.pos.domain.details.POSShiftCloseTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSShiftLine;
import com.namasoft.pos.domain.details.POSShiftOpenLine;
import com.namasoft.pos.domain.details.POSShiftOpenTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSSizesAndColors;
import com.namasoft.pos.domain.details.POSStockReceiptGridLine;
import com.namasoft.pos.domain.details.POSStockReceiptMainLine;
import com.namasoft.pos.domain.details.POSStockReceiptOtherLine;
import com.namasoft.pos.domain.details.POSStockTakingDetailsDocLine;
import com.namasoft.pos.domain.details.POSStockTransferReqLine;
import com.namasoft.pos.domain.details.POSSubReport;
import com.namasoft.pos.domain.details.POSTakingGridLine;
import com.namasoft.pos.domain.details.POSTakingMainLine;
import com.namasoft.pos.domain.details.POSTakingOtherLine;
import com.namasoft.pos.domain.details.POSTransferGridLine;
import com.namasoft.pos.domain.details.POSTransferMainLine;
import com.namasoft.pos.domain.details.POSTransferOtherLine;
import com.namasoft.pos.domain.details.POSTranslationLine;
import com.namasoft.pos.domain.details.PosAdditionalItems1;
import com.namasoft.pos.domain.details.PosAdditionalItems10;
import com.namasoft.pos.domain.details.PosAdditionalItems2;
import com.namasoft.pos.domain.details.PosAdditionalItems3;
import com.namasoft.pos.domain.details.PosAdditionalItems4;
import com.namasoft.pos.domain.details.PosAdditionalItems5;
import com.namasoft.pos.domain.details.PosAdditionalItems6;
import com.namasoft.pos.domain.details.PosAdditionalItems7;
import com.namasoft.pos.domain.details.PosAdditionalItems8;
import com.namasoft.pos.domain.details.PosAdditionalItems9;
import com.namasoft.pos.domain.details.PosCancelReservTableLine;
import com.namasoft.pos.domain.details.PosCancelReservationLine;
import com.namasoft.pos.domain.details.PosDefaultsTemplateLine;
import com.namasoft.pos.domain.details.PosDeliveryCostLine;
import com.namasoft.pos.domain.details.PosMinChargeLine;
import com.namasoft.pos.domain.details.PosRequiredFieldsLine;
import com.namasoft.pos.domain.details.PosStockReceiptLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.POSActionHistory;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSItemRevision;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.upgrader.POSUpgrader;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSPaymentMethodsUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSWSClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TreeItem;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.controlsfx.control.BreadCrumbBar;

public class POSSlideMenu
extends NamaVBox {
    private TranslateTransition menuTranslation;
    private Boolean isShown = false;
    private POSMenuButton createPaymentToCreditNote = new POSMenuButton(POSProcedures.CreatePaymentToCreditNote, null, POSSecurityCapability.CanMakePayments);
    private POSMenuButton salesReturn = new POSMenuButton(POSProcedures.SalesReturn, "Ctrl+f1", POSSecurityCapability.CanMakeReturn);
    private POSMenuButton salesReplacement = new POSMenuButton(POSProcedures.SalesReplacement, "Shift+f1", POSSecurityCapability.CanMakeReplacement);
    private POSMenuButton shiftScreen = new POSMenuButton(POSProcedures.ShiftScreen, "F2", POSSecurityCapability.CanOpenCloseShift);
    private POSMenuButton inventoryScreen = new POSMenuButton(POSProcedures.InventoryScreen, "Ctrl+F2", POSSecurityCapability.CanMakeCashCount);
    private POSMenuButton lockScreen = new POSMenuButton(POSProcedures.LockScreen, "F11");
    private POSMenuButton showDataStatistics = new POSMenuButton(POSProcedures.ShowDataStatistics, "Ctrl+F4");
    private POSMenuButton inquiryItemPrice = new POSMenuButton(POSProcedures.InquiryItemPrice, "Ctrl+F9", POSSecurityCapability.CanInquireForPrice);
    private POSMenuButton terminate = new POSMenuButton(POSProcedures.Terminate, "alt+F4");
    private POSMenuButton invoicePayment = new POSMenuButton(POSProcedures.InvoicePayment, "F5");
    private POSMenuButton holdInvoice = new POSMenuButton(POSProcedures.HoldInvoice, "F6", POSSecurityCapability.CanHoldInvoice);
    private POSMenuButton showHeldInvoices = new POSMenuButton(POSProcedures.ShowHeldInvoices, "Ctrl+F6");
    private POSMenuButton deleteHeldInvoice = new POSMenuButton(POSProcedures.DeleteHeldInvoice, "Alt+F6", POSSecurityCapability.CanDeleteHold);
    private POSMenuButton openInvoice = new POSMenuButton(POSProcedures.OpenInvoice, "Ctrl+f3", POSSecurityCapability.CanOpenOldInvoice);
    private POSMenuButton applyDiscount = new POSMenuButton(POSProcedures.ApplyDiscount, "F10", POSSecurityCapability.CanMakeDocDisc);
    private POSMenuButton applyLineDiscount = new POSMenuButton(POSProcedures.ApplyLineDiscount, "Alt+1", POSSecurityCapability.CanMakeLineDisc);
    private POSMenuButton applyLineDiscount2 = new POSMenuButton(POSProcedures.ApplyLineDiscount2, "alt+2", POSSecurityCapability.CanMakeLineDisc2);
    private POSMenuButton applyLineDiscount3 = new POSMenuButton(POSProcedures.ApplyLineDiscount3, "alt+3", POSSecurityCapability.CanMakeLineDisc3);
    private POSMenuButton applyLineDiscount4 = new POSMenuButton(POSProcedures.ApplyLineDiscount4, "alt+4", POSSecurityCapability.CanMakeLineDisc4);
    private POSMenuButton applyLineDiscount5 = new POSMenuButton(POSProcedures.ApplyLineDiscount5, "alt+5", POSSecurityCapability.CanMakeLineDisc5);
    private POSMenuButton applyLineDiscount6 = new POSMenuButton(POSProcedures.ApplyLineDiscount6, "alt+6", POSSecurityCapability.CanMakeLineDisc6);
    private POSMenuButton applyLineDiscount7 = new POSMenuButton(POSProcedures.ApplyLineDiscount7, "alt+7", POSSecurityCapability.CanMakeLineDisc7);
    private POSMenuButton applyLineDiscount8 = new POSMenuButton(POSProcedures.ApplyLineDiscount8, "alt+8", POSSecurityCapability.CanMakeLineDisc8);
    private POSMenuButton returnAfterAllowedPeriod = new POSMenuButton(POSProcedures.ReturnAfterAllowedPeriod, "ctrl+r");
    private POSMenuButton deleteLine = new POSMenuButton(POSProcedures.DeleteLine, "Ctrl+delete", POSSecurityCapability.CanCancelSalesLine);
    private POSMenuButton accessSalesTable = new POSMenuButton(POSProcedures.AccessSalesTable, "PAGE_DOWN");
    private POSMenuButton accessHeader = new POSMenuButton(POSProcedures.AccessHeader, "PAGE_UP");
    private POSMenuButton openSearchTable = new POSMenuButton(POSProcedures.OpenSearchTable, "F3");
    private POSMenuButton changeFont = new POSMenuButton(POSProcedures.ChangeFont, "F4");
    private POSMenuButton deleteDiscount = new POSMenuButton(POSProcedures.DeleteDiscount, "Ctrl+F10");
    private POSMenuButton deleteAllHeldInvoices = new POSMenuButton(POSProcedures.DeleteAllHeldInvoices, "Shift+f6");
    private POSMenuButton changeCustomer = new POSMenuButton(POSProcedures.ChangeCustomer, "F7");
    private POSMenuButton deleteCustomer = new POSMenuButton(POSProcedures.DeleteCustomer, "Ctrl+f7");
    private POSMenuButton addNewCustomer = new POSMenuButton(POSProcedures.AddNewCustomer, "shift+f7", POSSecurityCapability.CanAddCustomer);
    private POSMenuButton changeSalesman = new POSMenuButton(POSProcedures.ChangeSalesman, "F8", POSSecurityCapability.CanEditSalesMan);
    private POSMenuButton deleteSalesman = new POSMenuButton(POSProcedures.DeleteSalesman, "Ctrl+f8", POSSecurityCapability.CanEditSalesMan);
    private POSMenuButton showNotifications = new POSMenuButton(POSProcedures.ShowNotifications, "Ctrl+f11");
    private POSMenuButton duplicateLine = new POSMenuButton(POSProcedures.DuplicateLine, "+");
    private POSMenuButton cancelLine = new POSMenuButton(POSProcedures.CancelLine, "-");
    private POSMenuButton editLineQty = new POSMenuButton(POSProcedures.EditLineQty, "Ctrl+q");
    private POSMenuButton changeInvoiceClassification = new POSMenuButton(POSProcedures.CanEditInvoiceClassification, "Ctrl+Shift+i", POSSecurityCapability.CanEditInvoiceClassification);
    private POSMenuButton editCustomer = new POSMenuButton(POSProcedures.EditCustomer, "Ctrl+Shift+c", POSSecurityCapability.CanEditCustomer);
    private POSMenuButton transferCreditNotes = new POSMenuButton(POSProcedures.TransferCreditNotes, "Ctrl+Shift+N");
    private POSMenuButton errorsShow = new POSMenuButton(POSProcedures.ErrorsShow, POSSecurityCapability.CanShowDataTransferErrors);
    private POSMenuButton activateServerLog = new POSMenuButton(POSProcedures.ActivateServerLog);
    private POSMenuButton listActionHistory = new POSMenuButton(POSProcedures.ListActionHistory);
    private POSMenuButton stockTransferReq = new POSMenuButton(POSProcedures.StockTransferReq, POSSecurityCapability.CanMakeStockTransferReq);
    private POSMenuButton shortfallsDoc = new POSMenuButton(POSProcedures.ShortfallsDoc, POSSecurityCapability.CanMakeShortfallsDoc);
    private POSMenuButton scrapDoc = new POSMenuButton(POSProcedures.ScrapDoc, POSSecurityCapability.CanMakeScrapDoc);
    private POSMenuButton receipts = new POSMenuButton(POSProcedures.Receipts, "F1", POSSecurityCapability.CanMakeReceipts);
    private POSMenuButton posPayments = new POSMenuButton(POSProcedures.POSPayments, "F1", POSSecurityCapability.CanMakePayments);
    private POSMenuButton salesScreen = new POSMenuButton(POSProcedures.SalesScreen, "F1");
    private POSMenuButton reservationScreen = new POSMenuButton(POSProcedures.ReservationScreen);
    private POSMenuButton cancelReservationScreen = new POSMenuButton(POSProcedures.CancelReservationScreen);
    private POSMenuButton writeInternalMsg = new POSMenuButton(POSProcedures.WriteInternalMsg);
    private POSMenuButton reports = new POSMenuButton(POSProcedures.Reports);
    private POSMenuButton securityActions = new POSMenuButton(POSProcedures.UserSecurityCapsByAnotherUser);
    private POSMenuButton downloadAppLogs = new POSMenuButton(POSProcedures.DownloadAppLogs);
    private POSMenuButton changePassword = new POSMenuButton(POSProcedures.ChangePassword);
    private POSMenuButton editSizes = new POSMenuButton(POSProcedures.EditSizes);
    private POSMenuButton stockTakingDetails = new POSMenuButton(POSProcedures.StockTakingDetails);
    private POSMenuButton resetColumnsSize = new POSMenuButton(POSProcedures.ResetColumnsSize);
    private POSMenuButton mobAppsQrCode = new POSMenuButton(POSProcedures.MobAppsQrCode);
    private POSMenuButton splitInvoice = new POSMenuButton(POSProcedures.SplitInvoice);
    private POSMenuButton invTables = new POSMenuButton(POSProcedures.InvTables);
    private POSMenuButton tablesInquiry = new POSMenuButton(POSProcedures.TablesInquiry);
    private POSMenuButton delayedPaymentInvoices = new POSMenuButton(POSProcedures.DelayedPaymentInvoices);
    private POSMenuButton recalcShiftCloseDetails = new POSMenuButton(POSProcedures.RecalcShiftCloseDetails);
    private POSMenuButton fixLineNumbers = new POSMenuButton(POSProcedures.FixLineNumbers);
    private POSMenuButton recommitInvoice = new POSMenuButton(POSProcedures.RecommitInvoices);
    private POSMenuButton showTempDocs = new POSMenuButton(POSProcedures.ShowTempDocs);
    private POSMenuButton deleteTempDocs = new POSMenuButton(POSProcedures.DeleteTempDocs);
    private POSMenuButton showImages = new POSMenuButton(POSGeneralSettings.getUseImages() ? "hideImages" : POSProcedures.ShowImages.name());
    private POSMenuButton showIDs = new POSMenuButton(POSProcedures.ShowIDs);
    private POSMenuButton showMore = new POSMenuButton(POSProcedures.ShowMore);
    private POSMenuButton upgrade = new POSMenuButton(POSProcedures.Upgrade);
    private POSMenuButton threadDumper = new POSMenuButton(POSProcedures.ThreadDumper);
    private POSMenuButton reSendAllDocs = new POSMenuButton(POSProcedures.ReSendAllDocs);
    private POSMenuButton settings = new POSMenuButton(POSProcedures.Settings);
    private POSMenuButton darkMode = new POSMenuButton("darkMode");
    private POSMenuButton modes = new POSMenuButton("systemMode");
    private POSMenuButton runUtils = new POSMenuButton(POSProcedures.RunPOSUtils.name());
    private POSMenuButton disablePrinting = new POSMenuButton(POSProcedures.DisablePrinting.name());
    private POSMenuButton stockReceipt = new POSMenuButton(POSProcedures.StockReceipt);
    private POSMenuButton hideShowOfferDialog = new POSMenuButton(POSProcedures.HideOffersDialog, POSSecurityCapability.AllowHideOffersDialog);
    private POSMenuButton salesManActions;
    private POSMenuButton invoiceActions;
    private POSMenuButton documents;
    private POSMenuButton dataSettings;
    private POSMenuButton uISettings;
    private POSMenuButton customerActions;
    private POSMenuButton tempDocs;
    private POSMenuButton customerDisplayWindowBtn = new POSMenuButton(POSProcedures.CustomerDisplayWindow);
    private List<Control> firstLevelBtns;
    private int offHeight = 50;
    private WeakChangeListener<Number> stageWidthChangeListener;
    private WeakChangeListener<Number> stageHeightChangeListener;
    private IHasToolBar screen;
    private BreadCrumbBar<POSMenuButton> breadCrumbBar;
    private TreeItem<POSMenuButton> breadCrumbRootItem;
    private ScrollPane scrollPane;
    private NamaVBox btnsContainer;
    private ColorAdjust colorAdjustEffect;
    private Map<POSProcedures, POSMenuButton> actionsMap = new HashMap<POSProcedures, POSMenuButton>();

    public Map<POSProcedures, POSMenuButton> getActionsMap() {
        return this.actionsMap;
    }

    public POSSlideMenu(IHasToolBar screen) {
        Stage stage = screen.fetchStage();
        this.setId(screen.menuId());
        this.getStyleClass().add((Object)"slide-menu");
        this.scrollPane = new ScrollPane();
        this.scrollPane.setId("new-menu-scroll-pane");
        this.scrollPane.setFitToHeight(true);
        NamaVBox.setVgrow((Node)this.scrollPane, (Priority)Priority.ALWAYS);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.btnsContainer = new NamaVBox();
        this.btnsContainer.setId("new-menu-buttons-container");
        POSSettingsUtil.addStyleSheetFor("css/application.css", (Parent)this);
        this.setTranslateX(stage.getWidth());
        this.autosize();
        this.applyWidthChangingEffects(stage, stage.getWidth() / 4.0);
        if (POSResourcesUtil.isArabic()) {
            this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        } else {
            this.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        }
        this.colorAdjustEffect = new ColorAdjust();
        this.colorAdjustEffect.setBrightness(-0.4);
        this.breadCrumbBar = new BreadCrumbBar();
        this.breadCrumbBar.setId("menu-breadCrumb-bar");
        if (POSResourcesUtil.isArabic()) {
            this.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        } else {
            this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        }
        this.breadCrumbRootItem = new TreeItem((Object)new POSMenuButton("main"));
        this.breadCrumbBar.setSelectedCrumb(this.breadCrumbRootItem);
        this.breadCrumbBar.setCrumbFactory((Callback<TreeItem<POSMenuButton>, Button>)((Callback)param -> new BreadCrumbBar.BreadCrumbButton(POSResourcesUtil.id(((POSMenuButton)param.getValue()).getTextId(), new Object[0]))));
        this.breadCrumbBar.setOnCrumbAction((EventHandler<BreadCrumbBar.BreadCrumbActionEvent<POSMenuButton>>)((EventHandler)bae -> {
            POSMenuButton value = (POSMenuButton)bae.getSelectedCrumb().getValue();
            if (value.getTextId().equalsIgnoreCase("main")) {
                this.fillContainer(this.firstLevelBtns);
            }
        }));
        if (this.getChildren().size() == 0) {
            this.addChildren(screen);
        }
        this.actionsMap.put(POSProcedures.SalesReturn, this.salesReturn);
        this.actionsMap.put(POSProcedures.POSPayments, this.posPayments);
        this.actionsMap.put(POSProcedures.ActivateServerLog, this.activateServerLog);
        this.actionsMap.put(POSProcedures.AccessHeader, this.accessHeader);
        this.actionsMap.put(POSProcedures.AccessSalesTable, this.accessSalesTable);
        this.actionsMap.put(POSProcedures.AddNewCustomer, this.addNewCustomer);
        this.actionsMap.put(POSProcedures.ApplyDiscount, this.applyDiscount);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount, this.applyLineDiscount);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount2, this.applyLineDiscount2);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount3, this.applyLineDiscount3);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount4, this.applyLineDiscount4);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount5, this.applyLineDiscount5);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount6, this.applyLineDiscount6);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount7, this.applyLineDiscount7);
        this.actionsMap.put(POSProcedures.ApplyLineDiscount8, this.applyLineDiscount8);
        this.actionsMap.put(POSProcedures.ReturnAfterAllowedPeriod, this.returnAfterAllowedPeriod);
        this.actionsMap.put(POSProcedures.CancelReservationScreen, this.cancelReservationScreen);
        this.actionsMap.put(POSProcedures.CanEditInvoiceClassification, this.changeInvoiceClassification);
        this.actionsMap.put(POSProcedures.ChangeFont, this.changeFont);
        this.actionsMap.put(POSProcedures.ChangePassword, this.changePassword);
        this.actionsMap.put(POSProcedures.ChangeCustomer, this.changeCustomer);
        this.actionsMap.put(POSProcedures.ChangeSalesman, this.changeSalesman);
        this.actionsMap.put(POSProcedures.CreatePaymentToCreditNote, this.createPaymentToCreditNote);
        this.actionsMap.put(POSProcedures.DelayedPaymentInvoices, this.delayedPaymentInvoices);
        this.actionsMap.put(POSProcedures.DeleteAllHeldInvoices, this.deleteAllHeldInvoices);
        this.actionsMap.put(POSProcedures.DeleteCustomer, this.deleteCustomer);
        this.actionsMap.put(POSProcedures.SalesReplacement, this.salesReplacement);
        this.actionsMap.put(POSProcedures.ShiftScreen, this.shiftScreen);
        this.actionsMap.put(POSProcedures.InventoryScreen, this.inventoryScreen);
        this.actionsMap.put(POSProcedures.LockScreen, this.lockScreen);
        this.actionsMap.put(POSProcedures.ShowDataStatistics, this.showDataStatistics);
        this.actionsMap.put(POSProcedures.InquiryItemPrice, this.inquiryItemPrice);
        this.actionsMap.put(POSProcedures.Terminate, this.terminate);
        this.actionsMap.put(POSProcedures.InvoicePayment, this.invoicePayment);
        this.actionsMap.put(POSProcedures.HoldInvoice, this.holdInvoice);
        this.actionsMap.put(POSProcedures.ShowHeldInvoices, this.showHeldInvoices);
        this.actionsMap.put(POSProcedures.DeleteHeldInvoice, this.deleteHeldInvoice);
        this.actionsMap.put(POSProcedures.OpenInvoice, this.openInvoice);
        this.actionsMap.put(POSProcedures.DeleteLine, this.deleteLine);
        this.actionsMap.put(POSProcedures.OpenSearchTable, this.openSearchTable);
        this.actionsMap.put(POSProcedures.DeleteDiscount, this.deleteDiscount);
        this.actionsMap.put(POSProcedures.DeleteSalesman, this.deleteSalesman);
        this.actionsMap.put(POSProcedures.ShowNotifications, this.showNotifications);
        this.actionsMap.put(POSProcedures.EditLineQty, this.editLineQty);
        this.actionsMap.put(POSProcedures.EditCustomer, this.editCustomer);
        this.actionsMap.put(POSProcedures.TransferCreditNotes, this.transferCreditNotes);
        this.actionsMap.put(POSProcedures.ErrorsShow, this.errorsShow);
        this.actionsMap.put(POSProcedures.ListActionHistory, this.listActionHistory);
        this.actionsMap.put(POSProcedures.StockTransferReq, this.stockTransferReq);
        this.actionsMap.put(POSProcedures.ShortfallsDoc, this.shortfallsDoc);
        this.actionsMap.put(POSProcedures.ScrapDoc, this.scrapDoc);
        this.actionsMap.put(POSProcedures.Receipts, this.receipts);
        this.actionsMap.put(POSProcedures.SalesScreen, this.salesScreen);
        this.actionsMap.put(POSProcedures.ReservationScreen, this.reservationScreen);
        this.actionsMap.put(POSProcedures.WriteInternalMsg, this.writeInternalMsg);
        this.actionsMap.put(POSProcedures.Reports, this.reports);
        this.actionsMap.put(POSProcedures.UserSecurityCapsByAnotherUser, this.securityActions);
        this.actionsMap.put(POSProcedures.DownloadAppLogs, this.downloadAppLogs);
        this.actionsMap.put(POSProcedures.EditSizes, this.editSizes);
        this.actionsMap.put(POSProcedures.StockTakingDetails, this.stockTakingDetails);
        this.actionsMap.put(POSProcedures.ResetColumnsSize, this.resetColumnsSize);
        this.actionsMap.put(POSProcedures.MobAppsQrCode, this.mobAppsQrCode);
        this.actionsMap.put(POSProcedures.SplitInvoice, this.splitInvoice);
        this.actionsMap.put(POSProcedures.InvTables, this.invTables);
        this.actionsMap.put(POSProcedures.TablesInquiry, this.tablesInquiry);
        this.actionsMap.put(POSProcedures.RecalcShiftCloseDetails, this.recalcShiftCloseDetails);
        this.actionsMap.put(POSProcedures.StockReceipt, this.stockReceipt);
        this.actionsMap.put(POSProcedures.FixLineNumbers, this.fixLineNumbers);
        this.actionsMap.put(POSProcedures.RecommitInvoices, this.recommitInvoice);
        this.actionsMap.put(POSProcedures.ShowImages, this.showImages);
        this.actionsMap.put(POSProcedures.CustomerDisplayWindow, this.customerDisplayWindowBtn);
        this.actionsMap.put(POSProcedures.RunPOSUtils, this.runUtils);
        this.actionsMap.put(POSProcedures.DisablePrinting, this.disablePrinting);
    }

    public void addToBreadCrumbs(POSMenuButton btn) {
        TreeItem newItem = new TreeItem((Object)btn);
        this.breadCrumbRootItem.getChildren().add((Object)newItem);
        this.breadCrumbBar.setSelectedCrumb((TreeItem<POSMenuButton>)newItem);
    }

    private void applyWidthChangingEffects(Stage stage, double width) {
        this.setWidth(width);
        this.setPrefWidth(width);
        this.menuTranslation = new TranslateTransition(Duration.millis((double)500.0), (Node)this);
        this.menuTranslation.setFromX(stage.getWidth());
        this.menuTranslation.setToX(stage.getWidth() - width);
    }

    public void show() {
        NamaBorderPane borderPane;
        if (this.screen != null && (borderPane = this.screen.fetchPane()) != null) {
            borderPane.getTop().setEffect((Effect)this.colorAdjustEffect);
            borderPane.getCenter().setEffect((Effect)this.colorAdjustEffect);
        }
        this.menuTranslation.setRate(1.0);
        this.menuTranslation.play();
        this.isShown = true;
    }

    public void hide() {
        NamaBorderPane borderPane;
        if (this.screen != null && (borderPane = this.screen.fetchPane()) != null) {
            if (borderPane.getTop() != null) {
                borderPane.getTop().setEffect(null);
            }
            borderPane.getCenter().setEffect(null);
        }
        this.menuTranslation.setRate(-1.0);
        this.menuTranslation.play();
        this.isShown = false;
    }

    public void addChildren(IHasToolBar screen) {
        Stage stage = screen.fetchStage();
        this.defineButtons(screen);
        this.screen = screen;
        this.getChildren().addAll((Object[])new Node[]{this.breadCrumbBar, new PosMenuSearchField(this.firstLevelBtns, this)});
        this.fillContainer(this.firstLevelBtns);
        this.getChildren().add((Object)this.scrollPane);
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanEditSettings).isSucceeded().booleanValue()) {
            this.settings.setId("menu-child");
            this.getChildren().add((Object)this.settings);
            this.resizeMenuButtons(stage, (Control)this.settings);
        }
        this.modes.setId("menu-child");
        this.modes.setOnAction(e -> {
            Dialog<ButtonType> uiModesDialog = this.createModesPane();
            uiModesDialog.showAndWait();
        });
        this.resizeMenuButtons(stage, (Control)this.modes);
        this.getChildren().add((Object)this.modes);
        this.stageWidthChangeListener = new WeakChangeListener((observable, oldValue, newValue) -> {
            double value = Double.parseDouble(String.valueOf(newValue));
            for (Node button : this.getChildren()) {
                ((Region)button).setPrefWidth(value / 4.0);
            }
        });
        stage.widthProperty().addListener(this.stageWidthChangeListener);
        this.stageHeightChangeListener = new WeakChangeListener((observable, oldValue, newValue) -> {
            double value = Double.parseDouble(String.valueOf(newValue));
            for (Node button : this.getChildren()) {
                if (!(button instanceof Button)) continue;
                this.resizeMenuButtons(stage, (Control)((Button)button));
            }
            this.resizeMenuImages();
        });
        stage.heightProperty().addListener(this.stageHeightChangeListener);
    }

    public void fillContainer(List<Control> buttons) {
        this.btnsContainer.getChildren().clear();
        Stage stage = this.screen.fetchStage();
        for (int i = 0; i < buttons.size(); ++i) {
            Control control = buttons.get(i);
            if (control instanceof Button) {
                Button btn = (Button)control;
                EventHandler oldHandler = btn.getOnAction();
                if (ObjectChecker.isNotEmptyOrNull((Object)oldHandler)) {
                    btn.setOnAction(e -> {
                        if (btn instanceof POSMenuButton && ObjectChecker.isEmptyOrNull(((POSMenuButton)btn).getNextBtns())) {
                            PosScene.menuHideEvent(this.screen);
                        }
                        oldHandler.handle(e);
                    });
                }
                btn.setId("menu-child");
            }
            this.resizeMenuButtons(stage, control);
            this.btnsContainer.getChildren().add((Object)control);
        }
        this.scrollPane.setContent((Node)this.btnsContainer);
        this.resizeMenuImages();
    }

    private void resizeMenuButtons(Stage stage, Control btn) {
        btn.setPrefWidth(stage.getWidth() / 4.0);
        if (btn instanceof Labeled) {
            ((Labeled)btn).setWrapText(true);
        }
    }

    private Dialog<ButtonType> createModesPane() {
        NamaDialog<ButtonType> systemModeDialog = new NamaDialog<ButtonType>("systemMode");
        systemModeDialog.getDialogPane().setId("system-mode-pane");
        NamaCheckBox traditionalMode = new NamaCheckBox("traditionalMode");
        NamaCheckBox compactMode = new NamaCheckBox("compactMode");
        NamaCheckBox colorfulMode = new NamaCheckBox("colorfulMode");
        NamaCheckBox darkMode = new NamaCheckBox("darkMode");
        traditionalMode.setSelected(ObjectChecker.isTrue((String)POSScreenSettings.getProperty("traditionalMode")));
        compactMode.setSelected(ObjectChecker.isTrue((String)POSScreenSettings.getProperty("compactMode")));
        colorfulMode.setSelected(ObjectChecker.isTrue((String)POSScreenSettings.getProperty("colorfulMode")));
        darkMode.setSelected(ObjectChecker.isTrue((String)POSScreenSettings.getProperty("darkMode")));
        NamaVBox systemModeContentPane = new NamaVBox(new Node[]{traditionalMode, compactMode, colorfulMode, darkMode});
        systemModeContentPane.setId("system-mode-content-pane");
        NamaHBox.setHgrow((Node)systemModeContentPane, (Priority)Priority.ALWAYS);
        systemModeDialog.content((Node)systemModeContentPane);
        systemModeDialog.setOkAction(e -> {
            POSSlideMenu.updateSystemModeSettings(traditionalMode.isSelected(), compactMode.isSelected(), colorfulMode.isSelected(), darkMode.isSelected());
            PosScreenCacheUtil.clear();
            this.salesScreen.fire();
            AbsPosSalesScreen currentScreen = (AbsPosSalesScreen)POSResourcesUtil.currentScreen;
            currentScreen.renderingExistDoc = true;
            currentScreen.afterCachedScreenReDraw();
            currentScreen.renderingExistDoc = false;
        });
        systemModeDialog.addOkButton("");
        systemModeDialog.addCancelButton("");
        return systemModeDialog;
    }

    private static void updateSystemModeSettings(boolean traditionalMode, boolean compactMode, boolean colorfulMode, boolean darkMode) {
        POSScreenSettings.getProperties().setProperty("traditionalMode", String.valueOf(traditionalMode));
        POSScreenSettings.getProperties().setProperty("compactMode", String.valueOf(compactMode));
        POSScreenSettings.getProperties().setProperty("colorfulMode", String.valueOf(colorfulMode));
        POSScreenSettings.getProperties().setProperty("darkMode", String.valueOf(darkMode));
        POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
    }

    public static void showQrCodeForMobApps() {
        try {
            Enumeration<NetworkInterface> networkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            VBox qrContainer = new VBox();
            qrContainer.setPrefHeight(300.0);
            qrContainer.setPrefWidth(400.0);
            qrContainer.setAlignment(Pos.CENTER);
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(networkInterfacesEnum);
            NamaDialog dialog = new NamaDialog("Select");
            NamaVBox box = new NamaVBox(5);
            if (networkInterfaces.size() == 1) {
                String ipAddress = ((NetworkInterface)networkInterfaces.get(0)).getInetAddresses().nextElement().getHostAddress();
                POSSlideMenu.showSelectedInfo(qrContainer, ipAddress);
            } else {
                ObservableList items = FXCollections.observableArrayList();
                for (NetworkInterface networkInterface : networkInterfaces) {
                    InetAddress inetAddress;
                    ArrayList<InetAddress> list = Collections.list(networkInterface.getInetAddresses());
                    if (ObjectChecker.isEmptyOrNull(list) || (inetAddress = (InetAddress)list.stream().filter(i -> i instanceof Inet4Address).findFirst().orElse(null)) == null) continue;
                    items.add((Object)new Pair((Object)networkInterface.getDisplayName(), (Object)inetAddress.getHostAddress()));
                }
                if (ObjectChecker.isNotEmptyOrNull((Object)items)) {
                    final NamaComboBox netWorksInterfaces = new NamaComboBox(items);
                    netWorksInterfaces.setConverter((StringConverter)new StringConverter<Pair<String, String>>(){

                        public String toString(Pair<String, String> object) {
                            return (String)object.getX();
                        }

                        public Pair<String, String> fromString(String string) {
                            return netWorksInterfaces.getItems().stream().filter(obj -> ((String)obj.getX()).equals(string)).findFirst().orElse(null);
                        }
                    });
                    box.getChildren().addAll((Object[])new Node[]{netWorksInterfaces});
                    netWorksInterfaces.setOnAction(event -> POSSlideMenu.showSelectedInfo(qrContainer, (String)((Pair)netWorksInterfaces.getSelectionModel().getSelectedItem()).getY()));
                    netWorksInterfaces.getSelectionModel().selectLast();
                    POSSlideMenu.showSelectedInfo(qrContainer, (String)((Pair)netWorksInterfaces.getSelectionModel().getSelectedItem()).getY());
                }
            }
            box.getChildren().addAll((Object[])new Node[]{qrContainer});
            box.setAlignment(Pos.TOP_CENTER);
            dialog.content((Node)box);
            dialog.addCancelButton("");
            dialog.showAndWait();
        }
        catch (SocketException e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private static void showSelectedInfo(VBox qrContainer, String ipAddress) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("url", "http://".concat(ipAddress).concat(":").concat("" + POSResourcesUtil.fetchMainRegister().getMachinePort()));
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (currentUser != null) {
            data.put("user", currentUser.getUserId());
        }
        ByteArrayOutputStream out = QRCode.from((String)NamaJSON.toString(data)).to(ImageType.PNG).withSize(280, 300).stream();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Image image = new Image((InputStream)in);
        ImageView view = new ImageView(image);
        qrContainer.getChildren().clear();
        qrContainer.getChildren().addAll((Object[])new Node[]{view});
    }

    private void defineButtons(IHasToolBar hasToolBar) {
        this.showNotifications.setOnAction(e -> PosScene.showNotificationsTable());
        this.transferCreditNotes.setOnAction(e -> PosScene.transferAllCreditNotes());
        this.changeInvoiceClassification.setOnAction(e -> PosScene.changeInvoiceClassification(hasToolBar));
        this.deleteDiscount.setOnAction(e -> PosScene.deleteDisc(hasToolBar));
        this.deleteAllHeldInvoices.setOnAction(e -> PosScene.deleteAllHeld(hasToolBar, e));
        this.changeCustomer.setOnAction(e -> PosScene.activeCustomer(hasToolBar));
        this.deleteCustomer.setOnAction(e -> PosScene.delCustomer(hasToolBar));
        this.addNewCustomer.setOnAction(e -> PosScene.addNewCustomer(hasToolBar));
        this.editLineQty.setOnAction(e -> PosScene.editLineQty(hasToolBar));
        this.changeSalesman.setOnAction(e -> PosScene.activeSalesMan(hasToolBar));
        this.deleteSalesman.setOnAction(e -> PosScene.delSalesMan(hasToolBar));
        this.salesReturn.setOnAction(e -> PosScene.drawSalesReturn(hasToolBar, hasToolBar.fetchStage(), e));
        this.salesReplacement.setOnAction(e -> PosScene.drawSalesReplacment(hasToolBar, hasToolBar.fetchStage(), e));
        this.stockReceipt.setOnAction(e -> PosScene.drawStockReceiptScreen(hasToolBar.fetchStage()));
        this.shiftScreen.setOnAction(e -> PosScene.drawShiftsScreen(hasToolBar.fetchStage(), hasToolBar, e));
        this.inventoryScreen.setOnAction(e -> PosScene.drawCashCountScreen(hasToolBar.fetchStage()));
        this.hideShowOfferDialog.setOnAction(e -> {
            if (this.screen == null || !(this.screen instanceof AbsPosSalesScreen)) {
                return;
            }
            Boolean showOfferDialogAgain = ObjectChecker.isTrue((Boolean)((AbsPosSalesScreen)this.screen).getShowOfferDialogAgain());
            ((AbsPosSalesScreen)this.screen).setShowOfferDialogAgain(showOfferDialogAgain == false);
            if (showOfferDialogAgain.booleanValue()) {
                this.hideShowOfferDialog.setText(POSProcedures.ShowOffersDialog.name());
            } else {
                this.hideShowOfferDialog.setText(POSProcedures.HideOffersDialog.name());
            }
        });
        this.lockScreen.setOnAction(e -> new POSLockDialog(hasToolBar));
        this.showDataStatistics.setOnAction(e -> hasToolBar.fetchScene().showDataStatusScreen(hasToolBar));
        this.inquiryItemPrice.setOnAction(e -> new PricesInquiryDialog(hasToolBar).draw());
        this.terminate.setOnAction(e -> PosScene.terminateAction(hasToolBar, hasToolBar.fetchStage(), e));
        this.applyDiscount.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                ((AbsPosSalesScreen)hasToolBar).discountAction();
            }
        });
        this.applyLineDiscount.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc));
        this.applyLineDiscount2.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc2));
        this.applyLineDiscount3.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc3));
        this.applyLineDiscount4.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc4));
        this.applyLineDiscount5.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc5));
        this.applyLineDiscount6.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc6));
        this.applyLineDiscount7.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc7));
        this.applyLineDiscount8.setOnAction(e -> POSSlideMenu.applyLineDisc(hasToolBar, POSSecurityCapability.CanMakeLineDisc8));
        this.returnAfterAllowedPeriod.setOnAction(e -> {
            AbsPOSSales patt0$temp;
            AbsPosSalesScreen salesScreen;
            block5: {
                block4: {
                    if (!(hasToolBar instanceof AbsPosSalesScreen)) break block4;
                    salesScreen = (AbsPosSalesScreen)hasToolBar;
                    patt0$temp = salesScreen.salesDoc;
                    if (patt0$temp instanceof IPOSDocFromInvoice) break block5;
                }
                return;
            }
            IPOSDocFromInvoice ret = (IPOSDocFromInvoice)((Object)patt0$temp);
            POSResult posResult = POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.AllowReturnAfterAllowedPeriod);
            if (posResult.isFailed().booleanValue()) {
                return;
            }
            NamaDialog d = new NamaDialog("salesReturn");
            POSLabeledTextField invCodeField = new POSLabeledTextField("invCode", salesScreen, POSFieldType.Text);
            Platform.runLater(() -> ((POSLabeledTextField)invCodeField).requestFocus());
            d.content((Node)invCodeField);
            d.addOkButton("ok");
            d.addCancelButton("cancel");
            d.setOkAction(eve -> {
                String invoiceCode = ObjectChecker.toStringOrEmpty((Object)invCodeField.getValue());
                GetResult<Integer> response = POSWSClient.instance.fetchReturnPeriodExtendedDaysForInvoice((SendRequest<String>)new SendRequest((Object)ServerStringUtils.toUUIDStr((Object)invoiceCode)));
                ret.setExtendedReturnOrReplacementDays((Integer)response.getData());
                salesScreen.selectInvoiceAction(null, invoiceCode);
            });
            d.showAndWait();
        });
        this.deleteLine.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                AbsPosSalesScreen.deleteLineFromTable(-1, (AbsPosSalesScreen)hasToolBar, ((AbsPosSalesScreen)hasToolBar).salesDoc, ((AbsPosSalesScreen)hasToolBar).salesTable);
            }
        });
        this.accessSalesTable.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                PosScene.accessSalesGridAction(hasToolBar);
            }
        });
        this.accessHeader.setOnAction(e -> PosScene.accessHeaderAction(hasToolBar));
        this.invoicePayment.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                PosScene.invPayAction(hasToolBar, true);
            }
        });
        this.invoicePayment.setManaged(ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchMainRegister().getCallCenterMode()));
        this.openSearchTable.setOnAction(e -> PosScene.showSearchTableAction(hasToolBar));
        this.holdInvoice.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                ((AbsPosSalesScreen)hasToolBar).holdInvoice();
            }
        });
        this.showHeldInvoices.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                ((AbsPosSalesScreen)hasToolBar).showListOfFeaturedInvoices(POSInvoiceType.Hold);
            }
        });
        this.deleteHeldInvoice.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                AbsPosSalesScreen.deleteAction(e, (AbsPosSalesScreen)hasToolBar);
            }
        });
        this.openInvoice.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                ((AbsPosSalesScreen)hasToolBar).openDocumentAction();
            }
        });
        this.errorsShow.setOnAction(event -> PosScene.showErrorsDialog(hasToolBar));
        this.activateServerLog.setOnAction(e -> {
            ServiceLoginProvider.setTrackLogs((!ServiceLoginProvider.getTrackLogs() ? 1 : 0) != 0);
            Button source = (Button)e.getSource();
            this.updateTrackServerLogButtonText(source);
            this.setManageAndVisibleProperty(this.fixLineNumbers, ServiceLoginProvider.getTrackLogs());
            this.setManageAndVisibleProperty(this.recommitInvoice, ServiceLoginProvider.getTrackLogs());
            this.setManageAndVisibleProperty(this.runUtils, ServiceLoginProvider.getTrackLogs());
        });
        this.updateTrackServerLogButtonText(this.activateServerLog);
        this.setManageAndVisibleProperty(this.fixLineNumbers, false);
        this.setManageAndVisibleProperty(this.recommitInvoice, false);
        this.setManageAndVisibleProperty(this.runUtils, false);
        this.listActionHistory.setOnAction(event -> {
            NamaSearchBox actionHistorySBox = new NamaSearchBox(POSActionHistory.class, hasToolBar, "actionHistorySBox", hasToolBar.fetchStage());
            POSSettingsUtil.setFonts(17.0, ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{actionHistorySBox});
            actionHistorySBox.getSearchBtn().fire();
        });
        this.createPaymentToCreditNote.setOnAction(event -> PosScene.createPaymentScreen(hasToolBar.fetchStage(), POSCreditNote.class.getSimpleName()));
        this.stockTransferReq.setOnAction(event -> PosScene.drawStockTransferReq(hasToolBar, hasToolBar.fetchStage(), event));
        this.shortfallsDoc.setOnAction(event -> PosScene.drawShortfallsDoc(hasToolBar, hasToolBar.fetchStage(), event));
        this.scrapDoc.setOnAction(event -> PosScene.drawScrapDoc(hasToolBar, hasToolBar.fetchStage(), event));
        this.changeFont.setOnAction(e -> PosScene.changeFontAction());
        this.terminate.setOnAction(e -> PosScene.terminateAction(hasToolBar, hasToolBar.fetchStage(), e));
        this.holdInvoice.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                ((AbsPosSalesScreen)hasToolBar).holdInvoice();
            }
        });
        POSSettingsUtil.setFonts(16.0, ClassLoader.getSystemClassLoader(), new Node[]{this.salesReturn, this.salesReplacement, this.stockReceipt, this.shiftScreen, this.inventoryScreen, this.lockScreen, this.inquiryItemPrice, this.showDataStatistics, this.showNotifications, this.errorsShow, this.listActionHistory, this.stockTransferReq, this.holdInvoice, this.showHeldInvoices, this.changeFont, this.terminate, this.reports, this.writeInternalMsg, this.receipts, this.reservationScreen, this.cancelReservationScreen, this.posPayments, this.salesScreen, this.activateServerLog, this.shortfallsDoc, this.scrapDoc, this.securityActions, this.downloadAppLogs});
        this.receipts.setOnAction(e -> PosScene.createReceiptScreen(hasToolBar.fetchStage()));
        this.reservationScreen.setOnAction(e -> PosScene.drawReservationScreen(hasToolBar.fetchStage()));
        this.cancelReservationScreen.setOnAction(e -> PosScene.drawCancelReservationScreen(hasToolBar.fetchStage()));
        this.posPayments.setOnAction(e -> PosScene.createPaymentScreen(hasToolBar.fetchStage(), ""));
        this.salesScreen.setOnAction(e -> PosScene.drawSalesScreen(hasToolBar.fetchStage()));
        this.reports.setTooltip(new POSTooltip("reports"));
        this.reports.setOnAction(event -> {
            NamaPOSSearchDialog searchDialog = new NamaPOSSearchDialog();
            POSReportsScreen reportScreen = new POSReportsScreen(hasToolBar, searchDialog);
            NamaSearchBox searchBox = new NamaSearchBox(POSReportDefinition.class, reportScreen, "", hasToolBar.fetchStage());
            searchDialog.showDialog(new ActionEvent(), searchBox, " where reportType <> 'UserForm'", new HashMap<String, Object>(), 0);
        });
        this.securityActions.setTooltip(new POSTooltip("userSecurityCapsByAnotherUser"));
        this.securityActions.setOnAction(event -> {
            NamaSearchBox searchBox = new NamaSearchBox(POSActionLine.class, hasToolBar, "", hasToolBar.fetchStage());
            NamaPOSSearchDialog searchDialog = new NamaPOSSearchDialog();
            searchDialog.showDialog(new ActionEvent(), searchBox, " where currentUser.id = :currUserId", POSPersister.params("currUserId", POSSettingsInfo.fetchConfiguration().getCurrentUser().getId()), 0);
        });
        this.downloadAppLogs.setTooltip(new POSTooltip("downloadAppLogs"));
        this.downloadAppLogs.setOnAction(event -> POSSettingsUtil.downloadAppLogs());
        this.writeInternalMsg.setOnAction(event -> {
            POSInternalMsgScreen internalMsgScreen = new POSInternalMsgScreen();
            internalMsgScreen.draw(hasToolBar.fetchStage());
        });
        ArrayList<Control> tempDocsBtns = new ArrayList<Control>();
        tempDocsBtns.addAll(Arrays.asList(this.showTempDocs, this.deleteTempDocs));
        this.showTempDocs.setOnAction(event -> {
            if (this.screen instanceof AbsPosSalesScreen) {
                PosTempDocumentUtil.showTempDocsSelectDialogIfNeeded(false, this.screen);
            }
        });
        this.deleteTempDocs.setOnAction(event -> PosTempDocumentUtil.deleteAllTempDocs());
        ArrayList<Control> docButtons = new ArrayList<Control>();
        docButtons.addAll(Arrays.asList(this.salesScreen, this.salesReturn, this.salesReplacement, this.stockTransferReq, this.stockReceipt, this.shiftScreen, this.inventoryScreen, this.receipts, this.posPayments, this.createPaymentToCreditNote, this.stockTakingDetails, this.writeInternalMsg, this.shortfallsDoc, this.scrapDoc));
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseReservationDoc())) {
            docButtons.addAll(Arrays.asList(this.reservationScreen, this.cancelReservationScreen));
        }
        this.tempDocs = new POSMenuButton("tempDocs", tempDocsBtns, this);
        this.documents = new POSMenuButton("documents", docButtons, this);
        this.dataSettings = new POSMenuButton("dataSettings", Arrays.asList(this.showDataStatistics, this.showNotifications, this.errorsShow, this.transferCreditNotes, this.activateServerLog), this);
        this.uISettings = new POSMenuButton("uISettings", Arrays.asList(this.changeFont, this.editSizes, this.resetColumnsSize), this);
        this.customerActions = new POSMenuButton("customerActions", Arrays.asList(this.changeCustomer, this.deleteCustomer, this.addNewCustomer, this.editCustomer), this);
        this.showImages.setOnAction(e -> {
            Boolean useImages = !POSGeneralSettings.getUseImages();
            POSGeneralSettings.setProperty((String)"useImages", (String)ObjectChecker.toStringOrEmpty((Object)useImages));
            if (ObjectChecker.isTrue((Boolean)useImages)) {
                this.showImages.setText(POSResourcesUtil.id("hideImages", new Object[0]));
            } else {
                this.showImages.setText(POSResourcesUtil.id(POSProcedures.ShowImages.name(), new Object[0]));
            }
        });
        this.recommitInvoice.setOnAction(e -> {
            List<POSSalesInvoice> list = POSPersister.listAll(POSSalesInvoice.class, " WHERE  valueDate > '2024-05-26'");
            for (POSSalesInvoice invoice : list) {
                POSPersister.saveOrUpdate(invoice);
            }
        });
        NamaSingleValue namaSingleValue = new NamaSingleValue(null);
        this.customerDisplayWindowBtn.setOnAction(e -> {
            if (ObjectChecker.isFalseOrNull((Boolean)(this.screen instanceof AbsPosSalesScreen))) {
                return;
            }
            CustomerDisplayWindow value = (CustomerDisplayWindow)((Object)((Object)namaSingleValue.getValue()));
            if (value == null) {
                namaSingleValue.setValue((Object)new CustomerDisplayWindow((AbsPosSalesScreen)this.screen));
                value = (CustomerDisplayWindow)((Object)((Object)namaSingleValue.getValue()));
            }
            if (value.isShowing()) {
                value.close();
            } else {
                value.show();
            }
        });
        this.runUtils.setOnAction(e -> new POSUtilsDialog(this.screen).showDialog());
        NamaSingleValue moreViewOn = new NamaSingleValue((Object)false);
        this.showMore.setOnAction(event -> {
            if (!(hasToolBar instanceof POSNewSalesScreen)) {
                return;
            }
            if (ObjectChecker.isEmptyOrNull(POSUISettingsUtil.otherLinesForTypes(hasToolBar.documentType()))) {
                return;
            }
            POSNewSalesScreen newSalesScreen = (POSNewSalesScreen)hasToolBar;
            if (ObjectChecker.isFalse((Boolean)((Boolean)moreViewOn.getValue()))) {
                moreViewOn.setValue((Object)true);
                newSalesScreen.switchToMore();
            } else {
                moreViewOn.setValue((Object)false);
                newSalesScreen.switchToHome();
            }
        });
        this.upgrade.setOnAction(event -> {
            try {
                String applicationVersion = POSResourcesUtil.calcAppVersion();
                String latestVersion = new Scanner(new URL("https://crm.namasoft.com/nlm/download.php?releasename=get").openStream(), "UTF-8").useDelimiter("\\A").next();
                if (ObjectChecker.areEqual((Object)applicationVersion, (Object)latestVersion)) {
                    NaMaLogger.error((Object)"You have latest version");
                } else {
                    POSUpgrader.downloadUpgraderAndStartIt();
                }
            }
            catch (IOException e) {
                NaMaLogger.error((Throwable)e);
            }
        });
        this.threadDumper.setOnAction(event -> PosSettingsDialog.threadDumberAction());
        this.reSendAllDocs.setOnAction(action -> NamaToolBar.resendAllAction(hasToolBar));
        this.updateDisablePrintingText();
        this.disablePrinting.setOnAction(e -> this.disableOrEnablePrinting());
        POSMenuButton actions = new POSMenuButton("actions", Arrays.asList(this.listActionHistory, this.lockScreen, this.inquiryItemPrice, this.terminate, this.reports, this.changePassword, this.mobAppsQrCode, this.splitInvoice, this.invTables, this.tablesInquiry, this.recalcShiftCloseDetails, this.hideShowOfferDialog, this.fixLineNumbers, this.showImages, this.recommitInvoice, this.customerDisplayWindowBtn, this.runUtils, this.showMore, this.upgrade, this.threadDumper, this.reSendAllDocs, this.disablePrinting, this.securityActions), this);
        this.showIDs.setOnAction(event -> {
            POSResourcesUtil.showIds = POSResourcesUtil.showIds != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
        });
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanShowFieldIds).isSucceeded().booleanValue()) {
            actions.getNextBtns().add((Control)this.showIDs);
        }
        this.settings.setOnAction(e -> Platform.runLater(() -> {
            if (ObjectChecker.isTrue((String)POSGeneralSettings.getProperty((String)"enable-torture-test"))) {
                new HeavyPosSalesTest().start(hasToolBar);
            } else {
                new PosSettingsDialog(hasToolBar).showSettingsDialog();
            }
        }));
        this.editCustomer.setOnAction(e -> PosScene.showEditCustomer(hasToolBar));
        this.changePassword.setOnAction(event -> BorderPaneCreator.changePassword(hasToolBar.fetchStage(), hasToolBar));
        this.editSizes.setOnAction(event -> new POSEditTablesFontDialog().showDialog());
        this.stockTakingDetails.setOnAction(event -> PosScene.drawStockTakingDoc(hasToolBar.fetchStage()));
        POSSettingsUtil.setFonts(16.0, ClassLoader.getSystemClassLoader(), new Node[]{this.invoicePayment, this.deleteHeldInvoice, this.openInvoice, this.inquiryItemPrice, this.applyDiscount, this.applyLineDiscount, this.deleteLine, this.accessSalesTable, this.accessHeader, this.openSearchTable, this.deleteDiscount, this.deleteAllHeldInvoices, this.changeCustomer, this.deleteCustomer, this.addNewCustomer, this.changeSalesman, this.deleteSalesman, this.duplicateLine, this.cancelLine, this.editLineQty, this.changeInvoiceClassification, this.editCustomer, this.transferCreditNotes, this.createPaymentToCreditNote, this.changePassword, this.editSizes, this.stockTakingDetails});
        this.salesManActions = new POSMenuButton("salesManActions", Arrays.asList(this.changeSalesman, this.deleteSalesman), this);
        this.invoiceActions = new POSMenuButton("invoiceActions", Arrays.asList(this.holdInvoice, this.showHeldInvoices, this.invoicePayment, this.deleteHeldInvoice, this.openInvoice, this.applyDiscount, this.applyLineDiscount, this.applyLineDiscount2, this.applyLineDiscount3, this.applyLineDiscount4, this.applyLineDiscount5, this.applyLineDiscount6, this.applyLineDiscount7, this.applyLineDiscount8, this.returnAfterAllowedPeriod, this.deleteLine, this.accessSalesTable, this.accessHeader, this.openSearchTable, this.deleteDiscount, this.deleteAllHeldInvoices, this.duplicateLine, this.cancelLine, this.editLineQty, this.changeInvoiceClassification, this.delayedPaymentInvoices), this);
        this.resetColumnsSize.setOnAction(event -> {
            boolean resizeColumnsSize = NamaConfirmationDialog.showDialogAndWait("If you click OK, all customized sizes will be reset and the system will exit.", null, event);
            if (resizeColumnsSize) {
                Properties properties = POSScreenSettings.getProperties();
                properties.clear();
                POSScreenSettings.saveSetting(properties);
                PosShortcutsUtil.terminateAll();
            }
        });
        this.mobAppsQrCode.setOnAction(event -> POSSlideMenu.showQrCodeForMobApps());
        this.splitInvoice.setOnAction(event -> {
            if (hasToolBar instanceof AbsPosSalesScreen && ((AbsPosSalesScreen)hasToolBar).isInvoice()) {
                new InvoiceSplitter((AbsPosSalesScreen)hasToolBar).display();
            }
        });
        this.tablesInquiry.setOnAction(event -> new TablesInquirmentDialog((AbsPosSalesScreen)hasToolBar).display());
        this.recalcShiftCloseDetails.setOnAction(e -> {
            NamaDialog fromDateDialog = new NamaDialog("RecalcShiftCloseDetails");
            fromDateDialog.headerText("Please enter start date for recalculation");
            NamaDatePicker datePicker = new NamaDatePicker();
            fromDateDialog.content((Node)datePicker);
            fromDateDialog.addOkButton("");
            fromDateDialog.addCancelButton("");
            Optional result = fromDateDialog.showAndWait();
            if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
                POSPaymentMethodsUtil.recalcAllShiftCloseDocsFromDate(POSResourcesUtil.fetchMainRegister(), LocalDateUtils.localDateToDate((LocalDate)((LocalDate)datePicker.getValue())));
            }
        });
        this.fixLineNumbers.setOnAction(e -> POSSlideMenu.fixLineNumbersAction());
        this.invTables.setOnAction(event -> {
            if (hasToolBar instanceof AbsPosSalesScreen && (((AbsPosSalesScreen)hasToolBar).isInvoice() || ((AbsPosSalesScreen)hasToolBar).isOrderReservation() || ((AbsPosSalesScreen)hasToolBar).isCancelReservation())) {
                new MultiTableDialog((AbsPosSalesScreen)hasToolBar).showDialog();
            }
        });
        this.delayedPaymentInvoices.setOnAction(event -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                ((AbsPosSalesScreen)hasToolBar).showListOfFeaturedInvoices(POSInvoiceType.DelayedPayment);
            }
        });
        this.firstLevelBtns = new ArrayList<POSMenuButton>(Arrays.asList(this.documents, this.dataSettings, this.invoiceActions, this.salesManActions, this.customerActions, this.uISettings, actions, this.downloadAppLogs));
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getTempAutoSaveCurrentDoc())) {
            this.firstLevelBtns.add((Control)this.tempDocs);
        }
    }

    private static void applyLineDisc(IHasToolBar hasToolBar, POSSecurityCapability securityCapability) {
        if (hasToolBar instanceof AbsPosSalesScreen) {
            ((AbsPosSalesScreen)hasToolBar).lineDiscountAction(securityCapability);
        }
    }

    private void setManageAndVisibleProperty(POSMenuButton button, boolean TrackLogs) {
        button.setVisible(TrackLogs);
        button.setManaged(TrackLogs);
    }

    private void updateTrackServerLogButtonText(Button source) {
        if (ServiceLoginProvider.getTrackLogs()) {
            source.setText(POSResourcesUtil.id("deactivateServerLog", new Object[0]));
        } else {
            source.setText(POSResourcesUtil.id("activateServerLog", new Object[0]));
        }
    }

    public void disableOrEnablePrinting() {
        POSResourcesUtil.disablePrinting = POSResourcesUtil.disablePrinting == false;
        this.updateDisablePrintingText();
    }

    private void updateDisablePrintingText() {
        if (POSResourcesUtil.disablePrinting.booleanValue()) {
            this.disablePrinting.setText(POSResourcesUtil.id("enablePrinting", new Object[0]));
        } else {
            this.disablePrinting.setText(POSResourcesUtil.id("disablePrinting", new Object[0]));
        }
    }

    private void addImagesToButtons() {
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getShortcutImgBtnsToTextBtns())) {
            return;
        }
        this.salesScreen.setSVGIcon("sales.svg");
        this.salesReturn.setSVGIcon("return.svg");
        this.salesReplacement.setSVGIcon("replacement.svg");
        this.stockTransferReq.setSVGIcon("stockTransfer.svg");
        this.stockReceipt.setSVGIcon("stockReceipt.svg");
        this.shiftScreen.setSVGIcon("shiftScreen.svg");
        this.inventoryScreen.setSVGIcon("cashCount.svg");
        this.posPayments.setSVGIcon("cashPayment.svg");
        this.receipts.setSVGIcon("cashReceipt.svg");
        this.reservationScreen.setSVGIcon("reserv.svg");
        this.cancelReservationScreen.setSVGIcon("cancelReservation.svg");
        this.holdInvoice.setSVGIcon("hold.svg");
        this.lockScreen.setSVGIcon("lock.svg");
        this.showDataStatistics.setSVGIcon("dataStatistics.svg");
        this.showNotifications.setSVGIcon("notificationMenuBtn.svg");
        this.errorsShow.setSVGIcon("errorsMenuBtn.svg");
        this.reports.setSVGIcon("reportsMenuBtn.svg");
        this.terminate.setSVGIcon("exit.svg");
        this.writeInternalMsg.setSVGIcon("msgMenuBtn.svg");
        this.changeFont.setSVGIcon("fontMenuBtn.svg");
        this.inquiryItemPrice.setSVGIcon("priceInquireMenuBtn.svg");
    }

    public void resizeMenuImages() {
        Stage stage = this.screen.fetchStage();
        double height = stage.getHeight();
        this.setHeight(height - (double)this.offHeight);
        this.setPrefHeight(height - (double)this.offHeight);
    }

    public Boolean isShown() {
        return this.isShown;
    }

    public static void fixLineNumbersAction() {
        POSSlideMenu.updateLineNumUsingOrderByLineNum(POSSalesInvoiceLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(POSSalesInvoiceRemovedLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(POSSalesReturnLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(POSStockTakingDetailsDocLine.class.getSimpleName(), "doc_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(PosCancelReservationLine.class.getSimpleName(), "cancelReservation_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(POSOrderReservationLine.class.getSimpleName(), "reservation_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(POSSalesRepalcementLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(PosStockReceiptLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByLineNum(POSStockTransferReqLine.class.getSimpleName(), "request_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSSalesPaymentLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSSalesInvoiceCreditNoteLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSSalesInvoiceCouponLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSInvoiceTableLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReturnPaymentLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosCancelReservTableLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSCancelReservationPayLine.class.getSimpleName(), "cancelReservation_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReservationPaymentLine.class.getSimpleName(), "reservation_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReservationTableLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReplacementSalesPaymentLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReplacementReturnPaymentLine.class.getSimpleName(), "invoice_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisteryCurrecyLine.class.getSimpleName(), "register_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisterMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisterMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisteryMethodLine.class.getSimpleName(), "register_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisteryCodingParam.class.getSimpleName(), "register_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisteryFavouriteLine.class.getSimpleName(), "register_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSHallTableLine.class.getSimpleName(), "register_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisteryFavouriteDocLine.class.getSimpleName(), "register_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisterOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisterOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSRegisterGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReturnMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReplacementMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSTransferMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSTakingMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSOrderReservationMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSCancelReservationMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSStockReceiptMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReturnOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReplacementOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSTransferOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSTakingOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSOrderReservationOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSCancelReservationOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSStockReceiptOtherLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReturnGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReplacementGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSTransferGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSTakingGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSOrderReservationGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSCancelReservationGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSStockReceiptGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSMobileUIMainLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSMobileUIGridLine.class.getSimpleName(), "posSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSCreditNoteLine.class.getSimpleName(), "creditNote_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSDepreciationReasonDiscLine.class.getSimpleName(), "depreciationReason_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSDiscountCouponLine.class.getSimpleName(), "coupon_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSExchangeRateLine.class.getSimpleName(), "exchangeRate_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSInventoryLine.class.getSimpleName(), "inventory_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSSizesAndColors.class.getSimpleName(), "posItem");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemRevision.class.getSimpleName(), "posItem");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemUnit.class.getSimpleName(), "posItem");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemDimsDetail.class.getSimpleName(), "posItem");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemBarcodePart1.class.getSimpleName(), "parser_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemBarcodePart2.class.getSimpleName(), "parser_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemBarcodePart3.class.getSimpleName(), "parser_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemBarcodePart4.class.getSimpleName(), "parser_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemBarcodePart5.class.getSimpleName(), "parser_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSFreeGroupLine.class.getSimpleName(), "itemGroup");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReportDefinitionLine.class.getSimpleName(), "mainReport_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSSubReport.class.getSimpleName(), "mainReport_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReportResource.class.getSimpleName(), "mainReport_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSServiceChargeLine.class.getSimpleName(), "serviceChargeSettings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSShiftLine.class.getSimpleName(), "shift_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSShiftCloseLine.class.getSimpleName(), "shift_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSShiftCloseTakenElementsPerShiftLine.class.getSimpleName(), "posShiftClose_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSShiftOpenLine.class.getSimpleName(), "shift_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSShiftOpenTakenElementsPerShiftLine.class.getSimpleName(), "posShiftOpen_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSLegalEntityTax.class.getSimpleName(), "posTax");
        POSSlideMenu.updateLineNumUsingOrderByID(POSTranslationLine.class.getSimpleName(), "posTranslation_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSReplacementLine.class.getSimpleName(), "posTranslation_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosDefaultsTemplateLine.class.getSimpleName(), "defaultsTemplate_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosDefaultsTemplateLine.class.getSimpleName(), "defaultsTemplate_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosDeliveryCostLine.class.getSimpleName(), "posDeliveryCost_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosMinChargeLine.class.getSimpleName(), "minCharge_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSItemDiscountLine.class.getSimpleName(), "salesOffer_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSFreeItemLine.class.getSimpleName(), "salesOffer_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSInvoiceDiscountLine.class.getSimpleName(), "salesOffer_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSInvoiceFreeItemLine.class.getSimpleName(), "salesOffer_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSOfferOnItemsCountLine.class.getSimpleName(), "salesOffer_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSOfferCouponLine.class.getSimpleName(), "salesOffer_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSSalesPriceListLine.class.getSimpleName(), "priceList_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSSavingSettingsLine.class.getSimpleName(), "settings_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems1.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems2.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems3.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems4.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems5.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems6.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems7.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems8.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems9.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosAdditionalItems10.class.getSimpleName(), "addItems_id");
        POSSlideMenu.updateLineNumUsingOrderByID(PosRequiredFieldsLine.class.getSimpleName(), "reqFields_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSFieldFormatLine.class.getSimpleName(), "genRefOverrider_id");
        POSSlideMenu.updateLineNumUsingOrderByID(POSExtraCodeLine.class.getSimpleName(), "genRefOverrider_id");
    }

    private static void updateLineNumUsingOrderByLineNum(String simpleName, String partitionBy) {
        POSPersister.execute("WITH numbers AS (\nSELECT id, ROW_NUMBER() OVER (PARTITION BY " + partitionBy + " ORDER BY lineNumber) - 1 ln FROM \n" + simpleName + ")\n UPDATE l  SET lineNumber = ln FROM " + simpleName + " l inner join numbers on numbers.id = l.id");
    }

    private static void updateLineNumUsingOrderByID(String simpleName, String partitionBy) {
        POSPersister.execute("WITH numbers AS (\nSELECT id, ROW_NUMBER() OVER (PARTITION BY " + partitionBy + " ORDER BY id) - 1 ln FROM \n" + simpleName + ")\n UPDATE l  SET lineNumber = ln FROM " + simpleName + " l inner join numbers on numbers.id = l.id");
    }
}

