/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.constants.DownloadPurpose;
import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSImgUtil;
import com.namasoft.upgrader.FileDownloader;
import com.namasoft.upgrader.ProgressHandler;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URLEncoder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.imageio.ImageIO;

public class POSTotalsShowPanel
extends VBox {
    private Stage stage;
    private AbsPosSalesScreen screen;
    public static ScheduledExecutorService imagesFetcher = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "images-fetcher"));

    public POSTotalsShowPanel(AbsPosSalesScreen screen) {
        this.setId("total-show-panel");
        this.stage = screen.fetchStage();
        this.screen = screen;
    }

    public void updateItemImg(String id, String itemCode) {
        this.updateRecordImg(id, "InvItem", itemCode);
    }

    public void updateRecordImg(String id, String entityType, String itemCode) {
        if (POSResourcesUtil.getUseItemsImage()) {
            if (this.getChildren().size() == 1 || this.getChildren().size() == 3) {
                this.getChildren().remove(this.getChildren().size() - 1);
            }
            if (ObjectChecker.isEmptyOrNull((Object)id)) {
                return;
            }
            POSHasImage item = (POSHasImage)POSPersister.findByID(POSDataReaderUtil.constructNamaWithPOSTypesMap().get(entityType), id);
            if (item.isHasImage().booleanValue()) {
                this.updateImg(id, entityType, itemCode);
            }
        }
    }

    public void updateImg(String id, String entityType, String itemCode) {
        VBox pane = new VBox();
        ImageView imgView = new ImageView();
        imgView.setFitWidth(250.0);
        imgView.setFitHeight(170.0);
        imgView.fitWidthProperty().bind((ObservableValue)this.stage.widthProperty().divide(10));
        imgView.fitHeightProperty().bind((ObservableValue)this.stage.widthProperty().divide(8));
        pane.getChildren().addAll((Object[])new Node[]{imgView});
        this.getChildren().addAll((Object[])new Node[]{pane});
        POSTotalsShowPanel.asyncFetchItemImageIntoView(imgView, id, entityType, 250, itemCode);
    }

    public static void asyncFetchItemImageIntoView(ImageView imgView, String id, String entityType, Integer preferredWidth, String itemCode) {
        imagesFetcher.execute(() -> POSTotalsShowPanel.fetchItemImageIntoView_(id, entityType, preferredWidth, itemCode, img -> Platform.runLater(() -> {
            imgView.setImage(img);
            imgView.setPreserveRatio(true);
            imgView.setSmooth(true);
        })));
    }

    public static Image fetchCachedItemImage(String id, String itemCode, Integer preferredWidth, Integer preferredHeight) {
        Image itemImg = null;
        try {
            BufferedImage bImg;
            File input = POSTotalsShowPanel.fetchCachedItemImageFile(id, itemCode, preferredWidth);
            if (!input.exists() && preferredWidth != null) {
                itemImg = POSImgUtil.scaleItemImg(id, itemCode, preferredWidth, preferredHeight);
            }
            if (input.exists() && ObjectChecker.isNotEmptyOrNull((Object)(bImg = ImageIO.read(input)))) {
                itemImg = SwingFXUtils.toFXImage((BufferedImage)bImg, null);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
        return itemImg;
    }

    public static File fetchCachedItemImageFile(String id, String itemCode, Integer preferredWidth) {
        try {
            String imagesFolderPath = POSGeneralSettings.getImagesFolderPath();
            File imagesFolder = new File(imagesFolderPath);
            if (!imagesFolder.exists()) {
                imagesFolder.mkdir();
            }
            return new File(POSImgUtil.fetchItemImagePathName(id, itemCode, preferredWidth));
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    public static <T extends POSMasterFile> Image fetchItemImageIntoView_(String id, String entityType, Integer preferredWidth, String itemCode, Consumer<Image> consumer) {
        POSMasterFile item = (POSMasterFile)POSPersister.findByID(POSDataReaderUtil.constructNamaWithPOSTypesMap().get(entityType), id);
        if (!((POSHasImage)((Object)item)).isHasImage().booleanValue()) {
            return null;
        }
        Image itemImg = POSTotalsShowPanel.fetchCachedItemImage(id, itemCode, preferredWidth, preferredWidth);
        String imagesFolderPath = POSGeneralSettings.getImagesFolderPath();
        if (itemImg == null) {
            try {
                itemImg = POSTotalsShowPanel.fetchImageFromServer(itemImg, imagesFolderPath, id, entityType, itemCode, preferredWidth);
                if (itemImg == null) {
                    ((POSHasImage)((Object)item)).setHasImage(false);
                    POSPersister.saveOrUpdate(item);
                }
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
                itemImg = POSTotalsShowPanel.fetchImageFromServer(itemImg, imagesFolderPath, id, entityType, itemCode, preferredWidth);
            }
        }
        if (itemImg != null && itemImg.getWidth() > 0.0) {
            consumer.accept(itemImg);
        }
        return itemImg;
    }

    public static Image fetchImageFromServer(Image itemImg, String imagesFolderPath, String id, String entityType, String itemCode, Integer prefferedWidth) {
        NaMaLogger.info((String)"Fetching image for item {0} from server", (Object[])new Object[]{id});
        try {
            String downloadURL = POSTotalsShowPanel.downloadURL("recordId", id, entityType, itemCode);
            if (ObjectChecker.isNotEmptyOrNull((Object)downloadURL)) {
                String cachedImgUrl = POSImgUtil.fetchItemImagePathName(id, itemCode, prefferedWidth);
                FileDownloader.download((String)downloadURL, (ProgressHandler)ProgressHandler.NULL, (File)new File(cachedImgUrl));
                POSMasterFile byID = (POSMasterFile)POSPersister.findByID(POSDataReaderUtil.constructNamaWithPOSTypesMap().get(entityType), id);
                if (!POSImgUtil.useSizeAndColorAttachmentAsImageInPOS() || ObjectChecker.areEqual((Object)itemCode, (Object)byID.getCode()) || ObjectChecker.isEmptyOrNull((Object)itemCode)) {
                    byID.setImgDownloadLink(cachedImgUrl);
                    POSPersister.saveOrUpdate(byID);
                }
                itemImg = POSImgUtil.scaleItemImg(id, itemCode, prefferedWidth, prefferedWidth);
            }
        }
        catch (Exception ex) {
            NaMaLogger.error((Throwable)ex);
        }
        return itemImg;
    }

    public static String downloadURL(String idParamName, String id, String entityType, String itemCode) {
        Object url = "";
        String guiServerURL = POSGeneralSettings.getGuiServerURL();
        if (ObjectChecker.isNotEmptyOrNull((Object)guiServerURL)) {
            url = POSTotalsShowPanel.downloadUrlPart(idParamName, id, entityType, guiServerURL);
            if (POSImgUtil.useSizeAndColorAttachmentAsImageInPOS() && ObjectChecker.isNotEmptyOrNull((Object)itemCode)) {
                url = (String)url + "&itemCode=" + URLEncoder.encode(itemCode);
            }
        }
        return url;
    }

    private static String downloadUrlPart(String idParamName, String id, String entityType, String guiServerURL) {
        DownloadPurpose purpose = DownloadPurpose.DOWNLOAD;
        boolean redirect = false;
        boolean noCache = false;
        Object redirectVal = "&redirect=" + redirect;
        if (redirect) {
            redirectVal = "";
        }
        String url = guiServerURL + "file.download?" + idParamName + "=" + id + (String)(purpose != null ? "&purpose=" + String.valueOf(purpose) : "") + (String)redirectVal + "&entitytype=" + entityType + "&locale=" + (POSResourcesUtil.getCurrentLang() == Language.Arabic ? "ar" : "en") + (String)(noCache ? "&nocahce=" + System.currentTimeMillis() : "");
        return url;
    }
}

