/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.constants.DBTranslationResp;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.details.POSReplacementLine;
import com.namasoft.pos.domain.details.POSTranslationLine;
import com.namasoft.pos.domain.entities.POSTranslationOverrider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class POSTranslationOverriderUtil {
    private static List<DBTranslationResp> dbTranslations = null;

    public static List<DBTranslationResp> calcDbTranslations() {
        if (dbTranslations != null) {
            return dbTranslations;
        }
        dbTranslations = new ArrayList<DBTranslationResp>();
        List<POSTranslationOverrider> allOverriders = POSPersister.listAll(POSTranslationOverrider.class);
        if (ObjectChecker.isNotEmptyOrNull(allOverriders)) {
            for (POSTranslationOverrider translationOverRider : allOverriders) {
                if (translationOverRider.getInActive().booleanValue()) continue;
                DBTranslationResp dbTranslationResp = new DBTranslationResp();
                dbTranslations.add(dbTranslationResp);
                if (ObjectChecker.isNotEmptyOrNull((Object)translationOverRider.getPriority())) {
                    dbTranslationResp.setOrder(Long.valueOf(translationOverRider.getPriority().longValue()));
                }
                ConcurrentHashMap<String, String> arabic = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> replacements = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> english = new ConcurrentHashMap<String, String>();
                for (POSTranslationLine translationLine : translationOverRider.getTranslations()) {
                    if (ObjectChecker.isNotEmptyOrNull((Object)translationLine.getArabic())) {
                        arabic.put(translationLine.calcLineId(), translationLine.getArabic());
                    }
                    if (!ObjectChecker.isNotEmptyOrNull((Object)translationLine.getEnglish())) continue;
                    english.put(translationLine.calcLineId(), translationLine.getEnglish());
                }
                for (POSReplacementLine replacement : translationOverRider.getReplacments()) {
                    replacements.put(replacement.getText(), replacement.getReplacement());
                }
                dbTranslationResp.setArabic(arabic);
                dbTranslationResp.setEnglish(english);
                dbTranslationResp.setReplacements(replacements);
            }
        }
        return dbTranslations;
    }
}

