/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.ItemPropertiesDisplayMethod;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.PosAdditionalItemBtnObj;
import com.namasoft.pos.application.PosAdditionalItemsGroupPane;
import com.namasoft.pos.domain.details.AbsPosAdditionalItems;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSUnit;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;

public class PosAdditionalItemBtn
extends ToggleButton {
    private POSItem item;
    private POSUnit posUnit;
    private String propertyText;
    private String property;
    private String btnTitle;
    private boolean defaultBtn;

    public PosAdditionalItemBtn(Map.Entry<String, String> codeAndName, POSItem posItem, PosAdditionalItemsGroupPane group, AbsPosAdditionalItems line, ItemPropertiesDisplayMethod displayMethod, boolean defaultProperty) {
        this.setUserData(codeAndName);
        String itemName = null;
        if (posItem != null) {
            itemName = posItem.nameByLanguage();
        }
        String title = null;
        if (displayMethod != null) {
            title = this.fetchFormattedCodeName(codeAndName.getKey(), codeAndName.getValue(), displayMethod);
        }
        this.btnTitle = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{title, itemName});
        this.setText(this.btnTitle);
        if (posItem != null) {
            this.item = POSPersister.findByID(POSItem.class, posItem.getId());
        }
        this.propertyText = title;
        this.property = ObjectChecker.toStringOrEmpty((Object)((Object)group.getGroupForProperty()));
        this.setStyle("-fx-background-color: rgba(116,199,237,0.42); -fx-text-fill: #000000;");
        POSSettingsUtil.setFonts(20.0, ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{this});
        this.setPrefHeight(100.0);
        this.setPrefWidth(150.0);
        this.setWrapText(true);
        if (ObjectChecker.isTrue((Boolean)defaultProperty)) {
            this.setAsDefault();
        }
        this.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                group.addSubGroupForItem(this.item);
                return;
            }
            group.removeSubGroupsForItem(this.item);
        });
        this.setOnAction(event -> {
            if (ObjectChecker.isFalseOrNull((Boolean)group.isMultiSelect())) {
                group.getButtons().stream().filter(b -> b != this).forEach(b -> {
                    b.setSelected(false);
                    b.setStyle("-fx-background-color: rgba(116,199,237,0.42); -fx-text-fill: #000000;");
                });
            }
            if (this.isSelected()) {
                this.setStyle("-fx-background-color: rgb(116,174,237); -fx-text-fill: #000000;");
            } else {
                this.setStyle("-fx-background-color: rgba(116,199,237,0.42); -fx-text-fill: #000000;");
            }
        });
        if (line != null) {
            this.posUnit = line.getDefaultUnit();
            if (ObjectChecker.isTrue((Boolean)line.getDefaultItem())) {
                this.setAsDefault();
            }
        }
    }

    public void setAsDefault() {
        this.defaultBtn = true;
        this.setSelected(true);
        this.setStyle("-fx-background-color: rgb(116,174,237); -fx-text-fill: #000000;");
    }

    private String fetchFormattedCodeName(String code, String name, ItemPropertiesDisplayMethod displayMethod) {
        if (ObjectChecker.areEqual((Object)ItemPropertiesDisplayMethod.CodeOnly, (Object)displayMethod)) {
            return ObjectChecker.isEmptyOrNull((Object)code) ? null : code;
        }
        if (ObjectChecker.areEqual((Object)ItemPropertiesDisplayMethod.NameOnly, (Object)displayMethod)) {
            return ObjectChecker.isEmptyOrNull((Object)name) ? null : name;
        }
        return ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{code, name}) ? null : code + " - " + name;
    }

    public POSItem getItem() {
        return this.item;
    }

    public String getPropertyText() {
        return this.propertyText;
    }

    public POSUnit getPosUnit() {
        return this.posUnit;
    }

    public PosAdditionalItemBtnObj toNormalBtn() {
        PosAdditionalItemBtnObj btnObj = new PosAdditionalItemBtnObj();
        btnObj.setBtnTitle(this.btnTitle == null ? "" : this.btnTitle);
        btnObj.setPropertyText(this.propertyText == null ? "" : this.propertyText);
        btnObj.setProperty(this.property);
        btnObj.setDefaultBtn(ObjectChecker.isTrue((Boolean)this.defaultBtn));
        btnObj.setCodeAndName((Map.Entry)this.getUserData());
        btnObj.setItemCode(this.item == null ? null : this.item.getCode());
        btnObj.setUnitId(this.posUnit == null ? null : this.posUnit.getId());
        return btnObj;
    }
}

