/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.DTOPageData;
import com.namasoft.modules.namapos.enums.ItemPropertiesDisplayMethod;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.POSAdditionalItemsSubGroupPane;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosAdditionalItemBtn;
import com.namasoft.pos.application.PosAdditionalItemsDialog;
import com.namasoft.pos.application.PosItemBasicProperty;
import com.namasoft.pos.controllers.PosAdditionalItemsGroup;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPosAdditionalItems;
import com.namasoft.pos.domain.details.PosAdditionalItemsLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class PosAdditionalItemsGroupPane
extends TitledPane {
    private boolean multiSelect;
    private boolean required;
    private List<AbsPosAdditionalItems> additionalItems;
    private PosItemBasicProperty groupForProperty;
    private int btnsPerRow = 5;
    private List<PosAdditionalItemBtn> buttons = new ArrayList<PosAdditionalItemBtn>();
    private GridPane paneContent;
    private NamaVBox subGroupsPane;
    private List<PosAdditionalItemsGroupPane> subGroups = new ArrayList<PosAdditionalItemsGroupPane>();
    private POSItem basicItem;
    private int countOfItemsPerPage = 10;
    private Label pageInfoLabel = new NamaLabel();
    private TextField searchField;
    private int listingCurrentPage = 0;
    private int listingMaxPage = 0;
    private Button prevBtn = new Button(">>");
    private Button nextBtn = new Button("<<");
    private String defaultRevision = null;
    private static HashMap<String, TypeCriteriaObj> typeCriteriaMap = new HashMap();

    public PosAdditionalItemsGroupPane(POSItem basicItem, List<AbsPosAdditionalItems> lines, PosAdditionalItemsLine settingsLine, int countOfItems) {
        this(basicItem, lines, settingsLine.getCanMultiSelect(), settingsLine.getMakeAddItemsRequired(), basicItem.nameByLanguage() + " : " + ObjectChecker.toStringOrEmpty((Object)settingsLine.getTitleInPOS()), null, null, countOfItems, settingsLine.getAddSearchButton(), settingsLine.getAddPagingButton());
    }

    public PosAdditionalItemsGroupPane(POSItem basicItem, List<AbsPosAdditionalItems> lines, Boolean canMultiSelect, Boolean makeRequired, String title, PosItemBasicProperty property, String strPropertiesDisplayMethod, int countOfItems, Boolean addSearchBtn, Boolean addPagingBtn) {
        ItemPropertiesDisplayMethod propertiesDisplayMethod = ObjectChecker.isNotEmptyOrNull((Object)strPropertiesDisplayMethod) ? ItemPropertiesDisplayMethod.valueOf((String)strPropertiesDisplayMethod) : ItemPropertiesDisplayMethod.CodeAndName;
        ScrollPane pane = new ScrollPane();
        this.paneContent = new GridPane();
        this.paneContent.setVgap(5.0);
        this.paneContent.setHgap(5.0);
        this.multiSelect = canMultiSelect;
        this.required = makeRequired;
        this.additionalItems = lines;
        this.groupForProperty = property;
        if (countOfItems > 0) {
            this.countOfItemsPerPage = countOfItems;
        }
        this.basicItem = basicItem;
        this.subGroupsPane = new NamaVBox();
        GridPane headerPane = new GridPane();
        Label titleOfTitledPane = new Label(title);
        this.searchField = new TextField();
        this.searchField.setPromptText(POSResourcesUtil.id("search", new Object[0]) + " ...");
        NamaHBox btnsBox = new NamaHBox();
        NamaHBox searchHBox = new NamaHBox();
        this.prevBtn.setVisible(false);
        this.nextBtn.setVisible(false);
        btnsBox.getChildren().addAll((Object[])new Node[]{this.prevBtn, this.nextBtn});
        this.disableSearchAndPaging(true);
        this.expandedProperty().addListener((observableValue, aBoolean, expanded) -> {
            if (expanded.booleanValue()) {
                this.disableSearchAndPaging(false);
            } else {
                this.disableSearchAndPaging(true);
            }
        });
        headerPane.add((Node)titleOfTitledPane, 0, 0);
        headerPane.add((Node)searchHBox, 1, 0);
        HBox pageInfo = new HBox();
        pageInfo.setPadding(new Insets(5.0, 20.0, 5.0, 20.0));
        pageInfo.getChildren().add((Object)this.pageInfoLabel);
        POSSettingsUtil.setFonts(18.0, ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{titleOfTitledPane, this.prevBtn, this.nextBtn, this.pageInfoLabel});
        headerPane.add((Node)pageInfo, 2, 0);
        headerPane.add((Node)btnsBox, 3, 0);
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> this.listItemsAndFillGroup((String)newValue));
        this.nextBtn.setOnAction(actionEvent -> {
            if (this.listingCurrentPage < this.listingMaxPage) {
                ++this.listingCurrentPage;
                this.listItemsAndFillGroup();
            }
        });
        this.prevBtn.setOnAction(actionEvent -> {
            if (this.listingCurrentPage > 0) {
                --this.listingCurrentPage;
                this.listItemsAndFillGroup();
            }
        });
        this.nextBtn.setTooltip((Tooltip)new POSTooltip("next"));
        this.prevBtn.setTooltip((Tooltip)new POSTooltip("previous"));
        if (addSearchBtn.booleanValue()) {
            searchHBox.getChildren().add((Object)this.searchField);
            HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        }
        if (addPagingBtn.booleanValue()) {
            this.prevBtn.setVisible(true);
            this.nextBtn.setVisible(true);
        }
        headerPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{PosAdditionalItemsGroupPane.createGridWidthConstraint(30), PosAdditionalItemsGroupPane.createGridWidthConstraint(45), PosAdditionalItemsGroupPane.createGridWidthConstraint(15), PosAdditionalItemsGroupPane.createGridWidthConstraint(10)});
        this.setGraphic((Node)headerPane);
        this.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        pane.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        pane.setContent((Node)this.paneContent);
        this.setContent((Node)pane);
        this.setExpanded(false);
        POSSettingsUtil.setFonts(20.0, ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{this});
        if (this.groupForProperty != null) {
            Map<Object, Object> properties = new HashMap();
            if (ObjectChecker.areEqual((Object)((Object)this.groupForProperty), (Object)((Object)PosItemBasicProperty.Revision))) {
                properties = POSItem.fetchRevisions(basicItem.getCode());
            } else if (ObjectChecker.areEqual((Object)((Object)this.groupForProperty), (Object)((Object)PosItemBasicProperty.Color))) {
                properties = POSItem.fetchColors(basicItem);
            } else if (ObjectChecker.areEqual((Object)((Object)this.groupForProperty), (Object)((Object)PosItemBasicProperty.Size))) {
                properties = POSItem.fetchSizes(basicItem);
            }
            properties.entrySet().forEach(prop -> this.buttons.add(new PosAdditionalItemBtn((Map.Entry<String, String>)prop, null, this, null, propertiesDisplayMethod, this.isDefaultProperty(this.groupForProperty, basicItem, (Map.Entry<String, String>)prop))));
            this.fillPaneContent();
        } else if (ObjectChecker.isNotEmptyOrNull(this.additionalItems)) {
            this.listItemsAndFillGroup();
        }
    }

    private void disableSearchAndPaging(boolean disabled) {
        this.prevBtn.setDisable(disabled);
        this.nextBtn.setDisable(disabled);
        this.searchField.setDisable(disabled);
        this.pageInfoLabel.setDisable(disabled);
    }

    private void listItemsAndFillGroup() {
        this.listItemsAndFillGroup(null);
    }

    private void listItemsAndFillGroup(String textToSearch) {
        Object query = " where ( ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        int index = 1;
        for (AbsPosAdditionalItems line : this.additionalItems) {
            TypeCriteriaObj typeCriteriaObj = PosAdditionalItemsGroupPane.typeCriteriaMap(line.getItemType());
            if (ObjectChecker.isNotEmptyOrNull((Object)typeCriteriaObj)) {
                query = (String)query + typeCriteriaObj.query + index;
                params.put(typeCriteriaObj.paramId + index, typeCriteriaObj.function.apply(line.getItemID()));
            }
            query = index < this.additionalItems.size() ? (String)query + " or " : (String)query + " ) ";
            ++index;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)textToSearch)) {
            query = POSResourcesUtil.isArabic() ? (String)query + " and name1 like :val " : (String)query + " and name2 like :val ";
            params.put("val", "%" + textToSearch + "%");
        }
        Number count = POSPersister.count(POSItem.class, (String)query, params);
        this.listingMaxPage = count.intValue() / this.countOfItemsPerPage;
        this.pageInfoLabel.setText(this.listingCurrentPage + 1 + " - " + (this.listingMaxPage + 1) + " " + POSResourcesUtil.id("page", new Object[0]));
        List<?> items = POSPersister.selectTop(POSItem.class, (String)query, this.countOfItemsPerPage, "asc", params, true, new DTOPageData(this.listingCurrentPage, this.countOfItemsPerPage), Arrays.asList("id", "code", "name1", "name2"), "code");
        this.buttons.clear();
        if (ObjectChecker.isNotEmptyOrNull(items)) {
            items.forEach(i -> this.buttons.add(new PosAdditionalItemBtn(null, (POSItem)i, this, this.fetchAdditionalLineForItem((POSItem)i), null, false)));
        }
        this.fillPaneContent();
    }

    private AbsPosAdditionalItems fetchAdditionalLineForItem(POSItem item) {
        return this.additionalItems.stream().filter(l -> ObjectChecker.areEqual((Object)l.getItemID(), (Object)item.getId()) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getSection(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass1(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass2(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass3(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass4(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass5(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass6(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass7(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass8(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass9(), l) || PosAdditionalItemsGroupPane.isEqualItemDim(item.getItemClass10(), l)).findFirst().orElse(null);
    }

    private static boolean isEqualItemDim(POSMasterFile obj, AbsPosAdditionalItems l) {
        return ObjectChecker.isNotEmptyOrNull((Object)obj) && ObjectChecker.areEqual((Object)l.getItemID(), (Object)obj.getId());
    }

    private static ColumnConstraints createGridWidthConstraint(int widthPercent) {
        ColumnConstraints constraints = new ColumnConstraints();
        constraints.setPercentWidth((double)widthPercent);
        constraints.setHgrow(Priority.ALWAYS);
        return constraints;
    }

    private void fillPaneContent() {
        this.paneContent.getChildren().clear();
        int col = 0;
        int row = 0;
        for (PosAdditionalItemBtn btn : this.buttons) {
            if (col == this.btnsPerRow) {
                ++row;
                col = 0;
            }
            this.paneContent.add((Node)btn, col++, row);
        }
        if (col != 0) {
            col = 0;
        }
        int n = ++row;
        ++row;
        this.paneContent.add((Node)this.subGroupsPane, col, n, this.btnsPerRow, 1);
    }

    public void addSubGroupForItem(POSItem item) {
        if (item == null) {
            return;
        }
        PosItemAdditionalItems posItemAdditionalItems = POSResourcesUtil.fetchAdditionalItemsForItem(item);
        if (posItemAdditionalItems == null) {
            return;
        }
        POSAdditionalItemsSubGroupPane subGroupPane = new POSAdditionalItemsSubGroupPane(item);
        subGroupPane.setText(this.getText() + " : " + item.nameByLanguage());
        subGroupPane.setExpanded(false);
        subGroupPane.setStyle("-fx-text-fill: green");
        POSSettingsUtil.setFonts(22.0, ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{subGroupPane});
        NamaVBox container = new NamaVBox();
        container.setSpacing(3.0);
        List<PosAdditionalItemsGroupPane> groups = PosAdditionalItemsDialog.createGroups(posItemAdditionalItems, item);
        container.getChildren().addAll(groups);
        subGroupPane.setContent((Node)container);
        this.subGroupsPane.getChildren().add((Object)subGroupPane);
        this.subGroups.addAll(groups);
    }

    public void removeSubGroupsForItem(POSItem item) {
        this.subGroupsPane.getChildren().removeIf(g -> ObjectChecker.areEqual((Object)((POSAdditionalItemsSubGroupPane)((Object)g)).getItem().getId(), (Object)item.getId()));
        this.subGroups.removeIf(g -> ObjectChecker.areEqual((Object)g.getBasicItem().getId(), (Object)item.getId()));
    }

    public List<PosAdditionalItemsGroupPane> getSubGroups() {
        return this.subGroups;
    }

    private boolean isDefaultProperty(PosItemBasicProperty groupForProperty, POSItem basicItem, Map.Entry<String, String> prop) {
        if (ObjectChecker.areNotEqual((Object)((Object)groupForProperty), (Object)((Object)PosItemBasicProperty.Revision))) {
            return false;
        }
        String string = this.defaultRevision = this.defaultRevision == null ? ObjectChecker.toStringOrEmpty((Object)POSItem.findDefaultRevision(basicItem.getCode())) : this.defaultRevision;
        if (ObjectChecker.isEmptyOrNull((Object)this.defaultRevision)) {
            return false;
        }
        return ObjectChecker.areEqual((Object)prop.getKey(), (Object)this.defaultRevision);
    }

    public POSItem getBasicItem() {
        return this.basicItem;
    }

    public static TypeCriteriaObj typeCriteriaMap(String type) {
        if (ObjectChecker.isNotEmptyOrNull(typeCriteriaMap)) {
            return typeCriteriaMap.get(type);
        }
        typeCriteriaMap.put("InvItem", new TypeCriteriaObj(" id = :id", "id", o -> o));
        typeCriteriaMap.put("ItemSection", new TypeCriteriaObj(" section = :section", "section", o -> POSPersister.findByID(POSItemSection.class, o)));
        typeCriteriaMap.put("ItemClass1", new TypeCriteriaObj(" itemClass1 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass1.class, o)));
        typeCriteriaMap.put("ItemClass2", new TypeCriteriaObj(" itemClass2 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass2.class, o)));
        typeCriteriaMap.put("ItemClass3", new TypeCriteriaObj(" itemClass3 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass3.class, o)));
        typeCriteriaMap.put("ItemClass4", new TypeCriteriaObj(" itemClass4 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass4.class, o)));
        typeCriteriaMap.put("ItemClass5", new TypeCriteriaObj(" itemClass5 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass5.class, o)));
        typeCriteriaMap.put("ItemClass6", new TypeCriteriaObj(" itemClass6 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass6.class, o)));
        typeCriteriaMap.put("ItemClass7", new TypeCriteriaObj(" itemClass7 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass7.class, o)));
        typeCriteriaMap.put("ItemClass8", new TypeCriteriaObj(" itemClass8 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass8.class, o)));
        typeCriteriaMap.put("ItemClass9", new TypeCriteriaObj(" itemClass9 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass9.class, o)));
        typeCriteriaMap.put("ItemClass10", new TypeCriteriaObj(" itemClass10 = :itemClass", "itemClass", o -> POSPersister.findByID(POSItemClass10.class, o)));
        return typeCriteriaMap.get(type);
    }

    public PosItemBasicProperty getGroupForProperty() {
        return this.groupForProperty;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<PosAdditionalItemBtn> getButtons() {
        return this.buttons;
    }

    public List<PosAdditionalItemBtn> getSelectedButtons() {
        return this.buttons.stream().filter(b -> b.isSelected()).collect(Collectors.toList());
    }

    public PosAdditionalItemsGroup toNormalGroup() {
        PosAdditionalItemsGroup group = new PosAdditionalItemsGroup();
        group.setTitle(this.getText());
        group.setMultiSelect(this.multiSelect);
        group.setRequired(this.required);
        group.setGroupForProperty(this.groupForProperty);
        group.setButtons(this.buttons.stream().map(PosAdditionalItemBtn::toNormalBtn).collect(Collectors.toList()));
        return group;
    }

    static class TypeCriteriaObj {
        String query;
        String paramId;
        Function<UUID, Object> function;

        public TypeCriteriaObj(String query, String params, Function<UUID, Object> function) {
            this.query = query;
            this.paramId = params;
            this.function = function;
        }
    }
}

