/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.LoggingConfigurator;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.CryptoUtils;
import com.namasoft.common.utils.NaMaLayersConnector;
import com.namasoft.common.utils.NaMaLayersConnectorHelper;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfigResponse;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaConfirmationDialog;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.Migrator.POSMigratorUtil;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.LoginScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSPreLoader;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTempFontFilesCleaner;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.application.PosThreadDumper;
import com.namasoft.pos.application.priceChecker.POSPriceChecker;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSAnalysisset;
import com.namasoft.pos.domain.entities.POSBranch;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSDepartment;
import com.namasoft.pos.domain.entities.POSLegalEntity;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSector;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.util.POSDataReaderRunner;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSDataWriterRunner;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSImgUtil;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSNaMaLayersConnectorHelper;
import com.namasoft.pos.util.POSOnlineOrderReaderRunner;
import com.namasoft.pos.util.POSOnlineOrderWriterRunner;
import com.namasoft.pos.util.POSQuantitiesReaderRunner;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.pos.util.TooltipFetcherRunner;
import com.namasoft.upgrader.Platform;
import com.namasoft.upgrader.ProcessesUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import javafx.application.Application;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.JOptionPane;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.client.RestTemplate;

@SpringBootApplication
@ComponentScan(value={"com.namasoft.pos.controllers"})
public class PosEntryPoint
extends Application
implements IHasToolBar {
    private PosScene scene;
    private Stage stage;
    private static final int PORT = 6253;
    public static ServerSocket socket;
    public static IHasToolBar lastScreen;
    private NamaBorderPane pane;
    private BorderPaneCreator paneCreator;
    protected POSIdleMonitor idleMonitor;
    private Boolean initSucessed = true;
    private boolean dbError;
    private HashMap<String, IPOSFieldInfo> map = new HashMap();
    private LoginScreen loginScreen = new LoginScreen();
    public static final RestTemplate restTemplate;

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return this.map;
    }

    public void init() throws Exception {
        try {
            this.internalInit();
        }
        catch (Exception e) {
            POSResourcesUtil.checkIfIncompatibleVersionWithNama(e);
            throw e;
        }
    }

    private void internalInit() {
        ServiceUtility.setReceiveTimeout((long)30000L);
        LoggingConfigurator.setNAMASOFT_LOGFileName((String)"namapos.log");
        LoggingConfigurator.configureUsingCode((boolean)false);
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> NaMaLogger.error((Throwable)e));
        this.writeProcessIdToFile();
        if (!POSGeneralSettings.runMoreThanOnePOS() && this.isSystemRunning()) {
            this.showPOSIsAlreadyRunningDialog();
            return;
        }
        if (POSGeneralSettings.emptyOrInvalidSettings()) {
            this.initSucessed = false;
            return;
        }
        this.buildNamaServerUrl();
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{POSGeneralSettings.getRegisterCode(), POSGeneralSettings.getPOSServerURL(), POSGeneralSettings.getDBURL(), POSGeneralSettings.getDBUser(), POSGeneralSettings.getDBPortNum(), POSGeneralSettings.getPosDBName(), POSGeneralSettings.getDBPassword()})) {
            this.dbError = true;
            POSPreLoader.instance.updateErrorsLabel(POSResourcesUtil.id("Please enter empty properties in file", new Object[0]) + " " + POSGeneralSettings.settingsFilePath);
            return;
        }
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{POSGeneralSettings.getLoginID(), POSGeneralSettings.getLoginPassword()}) && ObjectChecker.isEmptyOrNull((Object)POSGeneralSettings.getAPIKey())) {
            this.dbError = true;
            POSPreLoader.instance.updateErrorsLabel(POSResourcesUtil.id("Please enter empty properties in file", new Object[0]) + " " + POSGeneralSettings.settingsFilePath);
            return;
        }
        this.initiateShutdownSocketListener();
        POSPersister.startup();
        if (!POSPersister.testDBConnection()) {
            POSPreLoader.instance.updateErrorsLabel(POSResourcesUtil.id("Error in database configuration", new Object[0]));
            this.dbError = true;
            return;
        }
        ServiceLoginProvider.setServerURL((String)POSGeneralSettings.getPOSServerURL());
        ServiceLoginProvider.setLanguage((Language)POSResourcesUtil.getCurrentLang());
        POSScreenSettings.createSettingsFileIfNotFound();
        NaMaLogger.info((Object)("Current java version is ***************************** " + System.getProperty("java.version")));
        NaMaLogger.info((Object)("Current Release version is ***************************** " + POSResourcesUtil.calcAppVersion()));
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        PosEntryPoint.loadConfigurations(false);
        this.createFontsFolder();
        TooltipFetcherRunner.startInANewThread();
        if (!this.initSucessed.booleanValue()) {
            return;
        }
        this.loadPublicDimsIfNotLoaded();
        POSMigratorUtil.migrateIfNeeded();
        if (POSPersister.count(POSUser.class, "", new HashMap<String, Object>()).intValue() == 0 || ObjectChecker.isEmptyOrNull((Object)register)) {
            POSDataReaderUtil.loadBasicDataFromQueue();
        }
        if (!this.initSucessed.booleanValue()) {
            return;
        }
        this.alertAndExitIfRegisterNotFound();
        register = POSResourcesUtil.fetchMainRegister();
        if (ObjectChecker.isTrue((Boolean)register.getSubRegisterForCaptainOrder()) && !POSGeneralSettings.isPriceCheckerMode()) {
            POSResourcesUtil.errorAndWaitThenExit(POSResourcesUtil.id("Register {0} is a sub-register designed exclusively for Captain Order.", register.getCode()) + POSResourcesUtil.id("Please firstly define right register code in nama.properties", new Object[0]));
            this.initSucessed = false;
            return;
        }
        if (!this.initSucessed.booleanValue()) {
            return;
        }
        POSResourcesUtil.fetchGlobalConfig();
        if (register.hasSpringBootProps() && ObjectChecker.isFalse_OrNull((String)"do-not-start-spring-boot")) {
            HashMap<String, Integer> props = new HashMap<String, Integer>();
            props.put("server.port", register.getMachinePort());
            new SpringApplicationBuilder(new Class[0]).properties(props).sources(new Class[]{PosEntryPoint.class}).headless(false).run(new String[0]);
        }
        DisplayPoleConnectorUtil.createDisplayPoleConnectorIfNeeded(register);
        DisplayPoleConnectorUtil.writeIdleMsg(register);
        POSResourcesUtil.cacheRegisterConfigFields();
        POSResourcesUtil.cacheFieldsAllowedValues();
        POSRegistery.cachePgwMethods(register);
        PosShortcutsUtil.initializeShortCuts();
        if (POSGeneralSettings.isMaster() && POSGeneralSettings.getDataReadTimeInMS() > 0) {
            POSDataReaderRunner.start();
        }
        POSDataWriterRunner.start();
        POSQuantitiesReaderRunner.start();
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchMainRegister().getCallCenterMode())) {
            POSOnlineOrderWriterRunner.start();
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchMainRegister().getReadOnlineOrdersFromCallCenter())) {
            POSOnlineOrderReaderRunner.start();
        }
        PosEntryPoint.generatePOSAPIKeyIfNotFound();
    }

    private static void generatePOSAPIKeyIfNotFound() {
        if (ObjectChecker.isNotEmptyOrNull((Object)POSGeneralSettings.getAPIKey())) {
            return;
        }
        try {
            GetResult<String> result = POSWSClient.instance.generatePOSApiKey(new ServiceRequest());
            if (result.succeded()) {
                POSGeneralSettings.setProperty((String)"apiKey", (String)CryptoUtils.decrypt((String)((String)result.getData())));
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private boolean isSystemRunning() {
        try {
            socket = new ServerSocket(6253, 0, InetAddress.getLocalHost());
        }
        catch (BindException e) {
            return true;
        }
        catch (IOException e) {
            System.err.println("Unexpected error.");
            e.printStackTrace();
            System.exit(2);
            return true;
        }
        return false;
    }

    private void showPOSIsAlreadyRunningDialog() {
        Dialog dialog = new Dialog((Frame)null, POSResourcesUtil.id("Warning", new Object[0]), true);
        dialog.setLayout(new BorderLayout());
        dialog.setSize(400, 100);
        dialog.setResizable(false);
        Label label = new Label(POSResourcesUtil.id("POS is already running", new Object[0]));
        label.setAlignment(1);
        dialog.add((Component)label, "North");
        Button showPOSButton = new Button(POSResourcesUtil.id("Show POS", new Object[0]));
        Button restartButton = new Button(POSResourcesUtil.id("Restart", new Object[0]));
        showPOSButton.addActionListener(e -> {
            boolean hasError = PosEntryPoint.showRunningPOS();
            if (hasError) {
                label.setText(POSResourcesUtil.id("POS is already running, but could not show it. Please press restart button.", new Object[0]));
            } else {
                NaMaLogger.error((Object)"Shutting down because another screen was found");
                System.exit(0);
            }
        });
        restartButton.addActionListener(e -> {
            dialog.setVisible(false);
            PosEntryPoint.restartPOSFromAnotherInstance();
            dialog.dispose();
        });
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout(1, 2, 2));
        buttonPanel.add(showPOSButton);
        buttonPanel.add(restartButton);
        dialog.add((Component)buttonPanel, "South");
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private static void restartPOSFromAnotherInstance() {
        NaMaLogger.error((Object)"Restart POS");
        String pid = "";
        try (BufferedReader processIdFile = new BufferedReader(new FileReader("PID"));){
            pid = processIdFile.readLine();
            if (ObjectChecker.isEmptyOrNull((Object)pid)) {
                return;
            }
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
        }
        String killCommand = System.getProperty("os.name").toLowerCase().contains("win") ? "taskkill /PID " + pid + " /F" : "kill -9 " + pid;
        try {
            Process killProcess = Runtime.getRuntime().exec(killCommand);
            int exitCode = killProcess.waitFor();
            if (exitCode == 0) {
                NaMaLogger.info((Object)("Process " + pid + " terminated successfully."));
                NaMaLogger.info((Object)"Restart POS");
                Process openProcess = Runtime.getRuntime().exec("pos-launcher.exe");
                int opened = openProcess.waitFor();
                if (opened == 0) {
                    NaMaLogger.info((Object)"POS reopened successfully.");
                } else {
                    NaMaLogger.error((Object)"POS reopened failed");
                }
            } else {
                NaMaLogger.error((Object)("Failed to terminate process " + pid + ". Exit code: " + exitCode));
            }
        }
        catch (IOException | InterruptedException e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private static boolean showRunningPOS() {
        boolean errors = false;
        try {
            Socket clientSocket = new Socket(InetAddress.getLocalHost(), 6253);
            OutputStream out = clientSocket.getOutputStream();
            String string = "SHOW-POS\n";
            out.write(string.getBytes());
            out.close();
            clientSocket.close();
        }
        catch (ConnectException e) {
            NaMaLogger.error((Object)"No running instance of POS was found.", (Throwable)e);
            errors = true;
        }
        catch (IOException e) {
            NaMaLogger.error((Object)"No running instance of POS was found.", (Throwable)e);
            errors = true;
        }
        return errors;
    }

    public static String buildServerUrl(String serverUrl, String portNum, String posServerURL) {
        return PosEntryPoint.buildNamaServerUrl(serverUrl, portNum, posServerURL, false);
    }

    private void buildNamaServerUrl() {
        PosEntryPoint.buildNamaServerUrl(null, null, null, true);
    }

    private static String buildNamaServerUrl(String serverUrl, String portNum, String posServerURL, boolean updateInProps) {
        Object namaServerUrl = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{serverUrl, POSGeneralSettings.getProperty((String)"namaServerURL")});
        if (ObjectChecker.isEmptyOrNull((Object)namaServerUrl)) {
            String portNumPart = ":" + (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{portNum, POSGeneralSettings.getProperty((String)"server.port")});
            Object posServerURLProperty = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{posServerURL, POSGeneralSettings.getProperty((String)"sever.url")});
            if (PosEntryPoint.urlDoesNotContainsHTPP((String)posServerURLProperty)) {
                posServerURLProperty = "http://" + (String)posServerURLProperty + portNumPart + "/";
            }
            namaServerUrl = posServerURLProperty;
        } else {
            if (PosEntryPoint.urlDoesNotContainsHTPP((String)(namaServerUrl = ((String)namaServerUrl).trim()))) {
                namaServerUrl = "http://" + (String)namaServerUrl;
            }
            if (!((String)namaServerUrl).endsWith("/")) {
                namaServerUrl = (String)namaServerUrl + "/";
            }
        }
        if (updateInProps) {
            POSGeneralSettings.removeProperty((String)"server.port");
            POSGeneralSettings.removeProperty((String)"sever.url");
            POSGeneralSettings.setProperty((String)"namaServerURL", (String)namaServerUrl);
        }
        return namaServerUrl;
    }

    private static boolean urlDoesNotContainsHTPP(String posServerURLProperty) {
        return posServerURLProperty != null && !posServerURLProperty.toLowerCase().contains("http://") && !posServerURLProperty.toLowerCase().contains("https://");
    }

    private void loadPublicDimsIfNotLoaded() {
        Object publicLegalEntity = POSPersister.findByCode(POSLegalEntity.class, "PUBLIC");
        Object publicSector = POSPersister.findByCode(POSSector.class, "PUBLIC");
        Object publicBranch = POSPersister.findByCode(POSBranch.class, "PUBLIC");
        Object publicAnalysisSet = POSPersister.findByCode(POSAnalysisset.class, "PUBLIC");
        Object publicDept = POSPersister.findByCode(POSDepartment.class, "PUBLIC");
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{publicLegalEntity, publicSector, publicBranch, publicAnalysisSet, publicDept})) {
            return;
        }
        POSDataReaderUtil.loadPublicDimsDataFromQueue();
    }

    private void writeProcessIdToFile() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            if (processName.contains("@")) {
                processName = processName.split("@")[0];
            }
            File processIdFile = new File("PID");
            FileWriter writer = new FileWriter(processIdFile);
            writer.write(processName);
            writer.close();
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private void initiateShutdownSocketListener() {
        if (ObjectChecker.isEmptyOrNull((Object)socket)) {
            return;
        }
        Thread socketListener = new Thread("socketListener"){

            @Override
            public void run() {
                while (!socket.isClosed()) {
                    try {
                        Socket client = socket.accept();
                        BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                        String message = in.readLine();
                        if (message.trim().contains("SHUTDOWN-POS")) {
                            NaMaLogger.info((Object)"Shutting down pos to upgrade the release");
                            socket.close();
                            PosShortcutsUtil.terminateAll();
                        } else if (message.contains("SHOW-POS")) {
                            NaMaLogger.info((Object)"Showing POS From Different Run");
                            PosShortcutsUtil.displayStage(PosEntryPoint.this.fetchStage(), lastScreen);
                        }
                        in.close();
                        client.close();
                    }
                    catch (Exception e) {
                        NaMaLogger.error((Throwable)e);
                    }
                }
            }
        };
        socketListener.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        socketListener.setDaemon(true);
        socketListener.start();
    }

    private void alertAndExitIfRegisterNotFound() {
        POSRegistery fetchedRegister = POSResourcesUtil.fetchMainRegister();
        if (ObjectChecker.isNotEmptyOrNull((Object)fetchedRegister)) {
            fetchedRegister.cacheRegisteryFields();
            POSCurrency registerCurrency = fetchedRegister.fetchCurrency();
            if (ObjectChecker.isNotEmptyOrNull((Object)registerCurrency)) {
                POSMoneyUtils.fractionalDecimalPlaces = registerCurrency.getFractionDecimalPlaces();
                POSMoneyUtils.displayDecimalPlaces = ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{registerCurrency.getDisplayDecimalPlaces(), registerCurrency.getFractionDecimalPlaces()});
            }
            return;
        }
        if (this.registerExist()) {
            return;
        }
        POSDataReaderUtil.loadBasicDataFromQueue();
        fetchedRegister = POSResourcesUtil.fetchMainRegister();
        if (fetchedRegister == null) {
            this.initSucessed = false;
            POSResourcesUtil.errorAndWaitThenExit(POSResourcesUtil.id("Please firstly define right register code in nama.properties", new Object[0]));
        }
    }

    public static void loadConfigurations(boolean reloadAnyWay) {
        POSResourcesUtil.currentSetting = POSSettingsInfo.fetchConfiguration();
        if (!reloadAnyWay && ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.currentSetting)) {
            return;
        }
        try {
            SendRequest serviceRequest = new SendRequest((Object)POSGeneralSettings.getRegisterCode());
            serviceRequest.setLoginId(POSGeneralSettings.getLoginID());
            serviceRequest.setPasswordHash(ServerStringUtils.hash((String)POSGeneralSettings.getLoginPassword()));
            GetResult<DTOPOSConfigResponse> posConfig = POSWSClient.instance.fetchPOSConfig((SendRequest<String>)serviceRequest);
            POSResourcesUtil.currentSetting = POSSettingsInfo.fetchConfiguration();
            if (POSResourcesUtil.currentSetting == null) {
                POSResourcesUtil.currentSetting = new POSSettingsInfo();
            }
            POSResourcesUtil.currentSetting.setCode("Configurations");
            POSResourcesUtil.currentSetting.setGlobalConfigXML(((DTOPOSConfigResponse)posConfig.getData()).getGlobalConfigXML());
            POSResourcesUtil.currentSetting.setPosConfigXML(((DTOPOSConfigResponse)posConfig.getData()).getPosConfigXML());
            POSResourcesUtil.currentSetting.setScConfigXML(((DTOPOSConfigResponse)posConfig.getData()).getScConfigXML());
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        POSPersister.saveOrUpdate(POSResourcesUtil.currentSetting);
    }

    public void start(Stage primStage) {
        try {
            this.doStart(primStage);
            int sameVersionAsServer = POSResourcesUtil.isTheSameVersionAsServer();
            if (sameVersionAsServer > 0) {
                NamaConfirmationDialog.showDialogAndWait("Server version is greater than POS version, So please upgrade the version", null, null);
            } else if (sameVersionAsServer < 0) {
                NamaConfirmationDialog.showDialogAndWait("Server version is less than POS version, So please upgrade the server version", null, null);
            }
            if (POSResourcesUtil.checkIfNewHSErrFilesExist()) {
                NamaConfirmationDialog.showDialogAndWait("There is problem in java version (JDK). So please contact technical support to solve it.", null, null);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            throw e;
        }
    }

    private void doStart(Stage primStage) {
        if (this.dbError) {
            return;
        }
        POSResourcesUtil.loadTranslations();
        if (!this.initSucessed.booleanValue() && !POSGeneralSettings.emptyOrInvalidSettings()) {
            this.alertAndExitIfRegisterNotFound();
        }
        primStage.getIcons().add((Object)POSImgUtil.fetchSVGImage("point-of-sale.svg"));
        this.stage = primStage;
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        if (Screen.getScreens().size() > 1) {
            primaryScreenBounds = ((Screen)Screen.getScreens().getFirst()).getVisualBounds();
            this.stage.setX(primaryScreenBounds.getMinX());
            this.stage.setY(primaryScreenBounds.getMinY());
        }
        if (POSGeneralSettings.emptyOrInvalidSettings()) {
            POSGeneralSettings.createSettingsFileIfNotFound(this);
            if (!POSGeneralSettings.emptyOrInvalidSettings()) {
                PosEntryPoint.restartPOS();
            }
        }
        this.stage.setMaximized(true);
        if (this.paneCreator == null) {
            this.paneCreator = new BorderPaneCreator();
        }
        if (this.initSucessed.booleanValue() && POSGeneralSettings.isPriceCheckerMode()) {
            POSPriceChecker.draw(this.stage, this.paneCreator);
        } else {
            this.pane = this.paneCreator.createBorderPane(this);
            this.scene = new PosScene((Parent)this.pane, primaryScreenBounds.getWidth(), primaryScreenBounds.getHeight(), this, this.stage);
            POSSettingsUtil.addStyleSheetFor("css/loginscreen.css", (Parent)this.pane);
            this.scene.setNodeOrientation(POSResourcesUtil.getOrientation());
            this.scene.setFill((Paint)Color.TRANSPARENT);
            this.stage.setScene((Scene)this.scene);
            this.stage.setTitle(POSResourcesUtil.id("Namasoft", new Object[0]));
            this.stage.getIcons().add((Object)POSImgUtil.fetchSVGImage("point-of-sale.svg"));
            this.stage.initStyle(StageStyle.UNIFIED);
            if (this.initSucessed.booleanValue()) {
                this.stage.show();
            }
        }
        POSTempFontFilesCleaner.initialize();
        POSPreLoader.closeIfNeeded();
    }

    public static void restartPOS() {
        NaMaLogger.error((Object)"Restart POS");
        try {
            ProcessesUtil.runProcessToConsole((File)new File("."), (String[])new String[]{"cmd", "/c", "pos-launcher.exe"});
            System.exit(0);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private void createFontsFolder() {
        File fontsFolder = new File("Fonts");
        if (!fontsFolder.exists()) {
            fontsFolder.mkdirs();
        }
    }

    private boolean registerExist() {
        POSRegistery fetchRegister = POSResourcesUtil.fetchMainRegister();
        return ObjectChecker.isNotEmptyOrNull((Object)fetchRegister);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length == 0 && !Platform.isInDebugMode()) {
            JOptionPane.showMessageDialog(null, "Please run using pos-launcher.exe");
            System.exit(1);
        }
        String firstArg = args.length > 0 ? args[0] : "";
        POSGeneralSettings.setSettingsFilePath((String)"nama.properties");
        LoggingConfigurator.configureUsingCode((boolean)false);
        NaMaLayersConnector.addHelper((NaMaLayersConnectorHelper)new POSNaMaLayersConnectorHelper());
        if (ManagementFactory.getRuntimeMXBean().getClassPath().contains("dump") || firstArg.contains("dump")) {
            PosThreadDumper.main(args);
            return;
        }
        System.setProperty("prism.order", POSGeneralSettings.getProperty((String)"fx-prism-order", (String)"sw"));
        System.setProperty("prism.lcdtext", POSGeneralSettings.getProperty((String)"fx-prism-lcd-text", (String)"false"));
        System.setProperty("prism.text", POSGeneralSettings.getProperty((String)"fx-prism-text", (String)"t2k"));
        System.setProperty("javafx.preloader", POSPreLoader.class.getName());
        Application.launch(PosEntryPoint.class, (String[])args);
    }

    @Override
    public Node fetchPaneCenter() {
        return this.loginScreen.draw(this.stage, this.paneCreator);
    }

    @Override
    public <T extends POSMasterFile> void afterCachedScreenReDraw() {
        this.loginScreen.afterCashedScreenReDraw();
    }

    @Override
    public PosScene fetchScene() {
        return this.scene;
    }

    @Override
    public Stage fetchStage() {
        return this.stage;
    }

    @Override
    public NamaBorderPane fetchPane() {
        return this.pane;
    }

    @Override
    public String screenTitle() {
        return "";
    }

    @Override
    public POSIdleMonitor fetchMonitor() {
        return this.idleMonitor;
    }

    @Override
    public String fetchScreenEntityType() {
        return null;
    }

    @Override
    public void doPostSaveAction() {
    }

    @Override
    public BorderPaneCreator fetchPaneCreator() {
        return this.paneCreator;
    }

    @Override
    public POSDocumentType documentType() {
        return POSDocumentType.entryPoint;
    }

    static {
        restTemplate = new RestTemplate();
    }
}

