/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSMenuButton;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSlideMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.StackPane;

public class PosMenuSearchField
extends StackPane {
    private NamaTextField textField;
    private List<Control> sourceData;
    private POSSlideMenu posSlideMenu;

    public PosMenuSearchField(List<Control> data, POSSlideMenu menu) {
        this.setId("menu-search-pane");
        this.sourceData = data;
        this.posSlideMenu = menu;
        this.textField = new NamaTextField(POSFieldType.Text);
        this.textField.setId("menu-search-field");
        this.textField.textProperty().addListener((observable, oldValue, newValue) -> this.searchInMenu((String)newValue));
        this.textField.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.searchInMenu(this.textField.getText());
            }
        });
        NamaButton searchButton = new NamaButton();
        searchButton.setSVGIcon("searchInT.svg");
        searchButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.getChildren().addAll((Object[])new Node[]{this.textField, searchButton});
        StackPane.setAlignment((Node)searchButton, (Pos)Pos.CENTER_LEFT);
        this.setNodeOrientation(POSResourcesUtil.getOrientation());
    }

    private void searchInMenu(String searchText) {
        if (ObjectChecker.isEmptyOrNull((Object)searchText)) {
            this.posSlideMenu.fillContainer(this.sourceData);
            return;
        }
        ArrayList<Control> data = new ArrayList<Control>();
        for (Control src : this.sourceData) {
            if (!(src instanceof POSMenuButton)) {
                data.add(src);
                continue;
            }
            POSMenuButton srcBtn = (POSMenuButton)src;
            if (!ObjectChecker.isNotEmptyOrNull(srcBtn.getNextBtns())) continue;
            data.addAll(srcBtn.getNextBtns());
        }
        List<Control> btnsWithText = data.stream().filter(d -> d instanceof POSMenuButton && this.btnContainsText(searchText, (POSMenuButton)d)).collect(Collectors.toList());
        this.posSlideMenu.fillContainer(btnsWithText);
    }

    private boolean btnContainsText(String searchText, POSMenuButton d) {
        return d.getTextId().toLowerCase().contains(searchText.toLowerCase()) || d.getArabicText().toLowerCase().contains(searchText.toLowerCase()) || d.getEnglishText().toLowerCase().contains(searchText.toLowerCase());
    }
}

