/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.Matcher;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaConfirmationDialog;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaPasswordField;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSAddCustomerDialog;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSLabeledTextField;
import com.namasoft.namacontrols.PosCopyMenu;
import com.namasoft.namacontrols.PosTempDocumentUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSShiftScreen;
import com.namasoft.pos.application.LoginScreen;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.NamaObservable;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSInternalMsgScreen;
import com.namasoft.pos.application.POSInvoiceType;
import com.namasoft.pos.application.POSLockDialog;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSNewShiftsScreen;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSRemoteInvoiceDialog;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSShiftInventoryScreen;
import com.namasoft.pos.application.POSSlideMenu;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosMenuSearchField;
import com.namasoft.pos.application.PosScreenCacheUtil;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.application.PricesInquiryDialog;
import com.namasoft.pos.application.TableUtils;
import com.namasoft.pos.application.toolbar.NamaToolBar;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSError;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSNotification;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.util.LoginUtil;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSNotificationsTask;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import java.awt.TrayIcon;
import java.io.File;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.Duration;

public class PosScene
extends Scene {
    public static String lockDialogHeader = "";
    public static TextArea status;
    public static NamaTableView<POSError> errors;
    private static POSNotificationsTask notificationsTask;
    private TrayIcon trayIcon;

    public static void updateStatus(String data) {
        Platform.runLater(() -> {
            if (status == null) {
                status = new TextArea();
            }
            status.setText(data);
            status.setScrollTop(Double.MAX_VALUE);
        });
    }

    public static void monitorIdleness(IHasToolBar screen) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (ObjectChecker.isNotEmptyOrNull((Object)currentUser) && ObjectChecker.isNotEmptyOrNull((Object)currentUser.getSecurity())) {
            BigDecimal autoTerminateTime;
            if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.lastIdleMonitor)) {
                POSResourcesUtil.lastIdleMonitor.stopMonitoring();
            }
            if (ObjectChecker.isNotEmptyOrZero((BigDecimal)(autoTerminateTime = POSResourcesUtil.safeGetValue(POSResourcesUtil.fetchPOSConfig().getAutoTerminateTime())))) {
                POSIdleMonitor m = screen.fetchMonitor();
                m = new POSIdleMonitor(Duration.minutes((double)autoTerminateTime.doubleValue()), () -> new POSLockDialog(screen), true);
                m.register((Node)screen.fetchPane(), (EventType<? extends Event>)Event.ANY);
                POSResourcesUtil.lastIdleMonitor = m;
                POSResourcesUtil.idleMonitorNode = screen.fetchPane();
            }
        }
    }

    public PosScene(Parent root, double width, double height, IHasToolBar screen, Stage stage) {
        super(root, width, height);
        if (screen instanceof AbsPosSalesScreen) {
            this.eventOnSalesChildren(root, screen);
        }
        EventHandler menuEvent = e -> PosScene.menuHideEvent(screen);
        root.setOnMouseClicked(menuEvent);
        this.addMenuEventToRootChildren(root, (EventHandler<MouseEvent>)menuEvent);
        this.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.shortcutsHandlers(screen, stage, (KeyEvent)event));
    }

    public static void menuHideEvent(IHasToolBar screen) {
        POSSlideMenu menu = (POSSlideMenu)screen.fetchPane().lookup("#" + screen.menuId());
        if (menu != null && menu.isShown().booleanValue()) {
            menu.hide();
        }
    }

    public static void disableOrEnablePrinting(IHasToolBar screen) {
        POSSlideMenu menu = (POSSlideMenu)screen.fetchPane().lookup("#" + screen.menuId());
        if (menu != null) {
            menu.disableOrEnablePrinting();
        }
    }

    public static void onCloseRequestEvent(Consumer<Event> callback, Event event) {
        boolean close = NamaConfirmationDialog.showDialogAndWait("The program will be closed, do you want to continue?", null, event);
        if (ObjectChecker.isFalse((Boolean)close)) {
            event.consume();
        } else {
            callback.accept(event);
        }
    }

    public static void drawStockTakingDoc(Stage stage) {
        PosScene.drawStockTakingDoc(stage, null);
    }

    public static void drawStockTakingDoc(Stage stage, PosDocCategory docCategory) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.StockTakingDetails)).draw(stage, POSDocumentType.StockTakingDetails, docCategory);
    }

    public static void drawStockReceiptScreen(Stage stage) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.POSStockReceipt)).draw(stage, POSDocumentType.POSStockReceipt);
    }

    public void addMenuEventToRootChildren(Parent root, EventHandler<MouseEvent> menuEvent) {
        ObservableList children = root.getChildrenUnmodifiable();
        for (Node child : children) {
            boolean menuBtn;
            boolean bl = menuBtn = child instanceof PosMenuSearchField || child instanceof Button && (((Button)child).getTooltip() != null && ((Button)child).getTooltip().getText().equals(POSResourcesUtil.id("menu", new Object[0])) || child.getId() != null && child.getId().equals("menu-child"));
            if (menuBtn) continue;
            child.setOnMouseClicked(menuEvent);
            if (!(child instanceof Parent)) continue;
            this.addMenuEventToRootChildren((Parent)child, menuEvent);
        }
    }

    private void eventOnSalesChildren(Parent root, IHasToolBar screen) {
        List<Node> list = ((AbsPosSalesScreen)screen).basicContainers();
        list.forEach(node -> this.recursivleyAddEvent(screen, (Node)node));
        root.setOnMouseClicked(e -> PosScene.focusFirstCellInRow(screen));
    }

    private void recursivleyAddEvent(IHasToolBar screen, Node parent) {
        parent.setOnMouseClicked(e -> PosScene.focusFirstCellInRow(screen));
        if (!(parent instanceof Parent)) {
            return;
        }
        for (Node node : ((Parent)parent).getChildrenUnmodifiable()) {
            this.recursivleyAddEvent(screen, node);
        }
    }

    public static void focusFirstCellInRow(IHasToolBar screen) {
        ObservableList selectedCells = screen.fetchScreenTable().getSelectionModel().getSelectedCells();
        if (ObjectChecker.isNotEmptyOrNull((Object)selectedCells)) {
            int row = ((TablePosition)selectedCells.get(0)).getRow();
            screen.fetchScreenTable().getSelectionModel().select(row, (TableColumn)screen.fetchScreenTable().getColumns().get(0));
        }
    }

    public static void drawCancelReservationScreen(Stage stage) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.POSCancelReservation)).draw(stage, POSDocumentType.POSCancelReservation);
    }

    public static void drawReservationScreen(Stage stage) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.POSOrderReservation)).draw(stage, POSDocumentType.POSOrderReservation);
    }

    public static void drawSalesScreen(Stage stage) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Invoice)).draw(stage, POSDocumentType.Invoice);
    }

    public static void drawSalesScreen(Stage stage, PosDocCategory docCategory) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Invoice)).draw(stage, POSDocumentType.Invoice, docCategory);
    }

    private static boolean notSavedOrChangedData(POSShiftInventoryScreen posShiftInventoryScreen) {
        if (posShiftInventoryScreen.isShift()) {
            UUID id = posShiftInventoryScreen.getShiftOrInventory().getId();
            AbsPOSShiftInventory shift = (AbsPOSShiftInventory)POSPersister.findByID(posShiftInventoryScreen.getShiftOrInventory().getClass(), id.toString());
            if (ObjectChecker.isEmptyOrNull((Object)shift)) {
                return PosScene.screenHasAddedLines(posShiftInventoryScreen);
            }
            return PosScene.hasChangedLines(posShiftInventoryScreen, shift.fetchDetails());
        }
        UUID id = posShiftInventoryScreen.getShiftOrInventory().getId();
        POSInventory inventory = POSPersister.findByID(POSInventory.class, id.toString());
        if (ObjectChecker.isEmptyOrNull((Object)inventory)) {
            return PosScene.screenHasAddedLines(posShiftInventoryScreen);
        }
        return PosScene.hasChangedLines(posShiftInventoryScreen, inventory.fetchDetails());
    }

    private static boolean screenHasAddedLines(POSShiftInventoryScreen posShiftInventoryScreen) {
        ObservableList items = posShiftInventoryScreen.getTable().getItems();
        for (AbsPOSInventoryLine absPOSInventoryLine : items) {
            if (!ObjectChecker.areNotEqual((Object)absPOSInventoryLine.getActualRemaining(), (Object)absPOSInventoryLine.getAccountantRemaining())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChangedLines(POSShiftInventoryScreen posShiftInventoryScreen, List<? extends AbsPOSInventoryLine> details) {
        List<AbsPOSInventoryLine> fetchDetails = posShiftInventoryScreen.getShiftOrInventory().fetchDetails();
        for (int i = details.size() - 1; i >= 0; --i) {
            if (!ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{details.get(i).getPaymentWay(), details.get(i).getCurrency()})) continue;
            details.remove(i);
        }
        ArrayList intersection = new ArrayList();
        CollectionsUtility.compareTwoLists(details, fetchDetails, (Matcher)new Matcher<AbsPOSInventoryLine>(){

            public boolean match(AbsPOSInventoryLine obj1, AbsPOSInventoryLine obj2) {
                return ObjectChecker.areEqual((Object)obj1.getAccountantRemaining(), (Object)obj2.getAccountantRemaining()) && ObjectChecker.areEqual((Object)obj1.getPaymentWay(), (Object)obj2.getPaymentWay()) && ObjectChecker.areEqual((Object)obj1.getCurrency(), (Object)obj2.getCurrency());
            }
        }, intersection, new ArrayList(), new ArrayList());
        int changedLinesCount = 0;
        for (AbsPOSInventoryLine line : fetchDetails) {
            if (!ObjectChecker.areNotEqual((Object)line.getAccountantRemaining(), (Object)line.getActualRemaining())) continue;
            ++changedLinesCount;
        }
        if (changedLinesCount == 0) {
            return false;
        }
        return intersection.size() != details.size();
    }

    private void shortcutsHandlers(IHasToolBar screen, Stage stage, KeyEvent event) {
        TablePosition focusedCell;
        AbsPosSalesScreen salesScreen;
        AbsPosSalesScreen absPosSalesScreen = salesScreen = screen instanceof AbsPosSalesScreen ? (AbsPosSalesScreen)screen : null;
        if (event.getCode().equals((Object)KeyCode.TAB) && salesScreen != null && ObjectChecker.isNotEmptyOrNull((Object)(focusedCell = salesScreen.salesTable.getFocusModel().getFocusedCell()))) {
            Object colToEdit;
            TableColumn col = focusedCell.getTableColumn();
            int row = focusedCell.getRow();
            Object object = colToEdit = ObjectChecker.isAnyEqualToFirst((Object)col, (Object[])new TableColumn[]{salesScreen.qtyCol}) ? salesScreen.itemCodeCol : salesScreen.qtyCol;
            if (ObjectChecker.isAnyEqualToFirst((Object)col, (Object[])new TableColumn[]{salesScreen.qtyCol, salesScreen.itemCodeCol})) {
                event.consume();
                Platform.runLater(() -> {
                    salesScreen.salesTable.getFocusModel().focus(row, colToEdit);
                    salesScreen.salesTable.getSelectionModel().select(row, colToEdit);
                    salesScreen.salesTable.edit(row, (TableColumn)colToEdit);
                });
                return;
            }
        }
        if (POSResourcesUtil.currentSetting.getCurrentUser() == null || POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseShortcuts).isFailed().booleanValue()) {
            return;
        }
        KeyCombination keyCombination = PosShortcutsUtil.fetchHeaderFieldsShortcuts().keySet().stream().filter(k -> k.match(event)).findFirst().orElse(null);
        if (keyCombination != null && salesScreen != null) {
            String fieldID = PosShortcutsUtil.fetchHeaderFieldsShortcuts().get(keyCombination);
            boolean fired = PosScene.fireField(fieldID, screen, POSNewSalesScreen.class);
            if (ObjectChecker.isFalse((Boolean)fired)) {
                PosScene.fireField(fieldID, screen, AbsPosSalesScreen.class);
            }
        } else if (PosShortcutsUtil.transferCreditNotes.match(event)) {
            PosScene.transferAllCreditNotes();
        } else if (PosShortcutsUtil.showAllNotifications.match(event)) {
            PosScene.showNotificationsTable();
        } else if (PosShortcutsUtil.editInvoiceClassification.match(event)) {
            PosScene.changeInvoiceClassification(screen);
            if (event.isAltDown()) {
                PosScene.showSearchTableAction(screen);
            }
        } else if (PosShortcutsUtil.editCustomer.match(event)) {
            PosScene.showEditCustomer(screen);
        } else if (PosShortcutsUtil.duplicateLineShortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.duplicateLine(true);
        } else if (event.getCode().equals((Object)KeyCode.SUBTRACT) && screen instanceof AbsPosSalesScreen) {
            if (!salesScreen.isReplacement() && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanMakeNegativeDuplicate).isSucceeded().booleanValue()) {
                salesScreen.duplicateLine(false);
            }
        } else if (PosShortcutsUtil.payDialogShortcuts.match(event)) {
            if (salesScreen.stockTransferOrTaking() || salesScreen.reservationWithoutPayment() || salesScreen.isStockReceipt() || salesScreen.isShortfallsOrScrap()) {
                salesScreen.saveDocWithoutPaymentAction();
            } else {
                PosScene.invPayAction(screen, true);
            }
        } else if (PosShortcutsUtil.deleteHeldInvoices.match(event) && screen instanceof AbsPosSalesScreen && salesScreen.getSalesDoc().getHold()) {
            AbsPosSalesScreen.deleteAction((Event)event, salesScreen);
        } else if (PosShortcutsUtil.gridAccessShortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            PosScene.accessSalesGridAction(screen);
        } else if (PosShortcutsUtil.payWithoutPrintingDialogShortcuts.match(event)) {
            if (salesScreen.stockTransferOrTaking() || salesScreen.reservationWithoutPayment() || salesScreen.isStockReceipt() || salesScreen.isShortfallsOrScrap()) {
                salesScreen.saveDocWithoutPaymentAction();
            } else {
                PosScene.invPayAction(screen, false);
            }
        } else if (PosShortcutsUtil.showDataStatusScreen.match(event)) {
            this.showDataStatusScreen(screen);
        } else if (PosShortcutsUtil.changeFont.match(event)) {
            PosScene.changeFontAction();
        } else if (PosShortcutsUtil.activateCustomer.match(event)) {
            PosScene.activeCustomer(screen);
            if (event.isAltDown()) {
                PosScene.showSearchTableAction(screen);
            }
        } else if (PosShortcutsUtil.activateItem.match(event)) {
            if (salesScreen == null) {
                return;
            }
            Platform.runLater(() -> salesScreen.getItemCodeField().requestFocus());
            if (event.isAltDown()) {
                PosScene.showSearchTableAction(screen);
            }
        } else if (PosShortcutsUtil.activateSalesMan.match(event)) {
            PosScene.activeSalesMan(screen);
            if (event.isAltDown()) {
                PosScene.showSearchTableAction(screen);
            }
        } else if (PosShortcutsUtil.deleteCustomer.match(event)) {
            PosScene.delCustomer(screen);
        } else if (PosShortcutsUtil.deleteSalesMan.match(event)) {
            PosScene.delSalesMan(screen);
        } else if (PosShortcutsUtil.addNewCustomer.match(event)) {
            PosScene.addNewCustomer(screen);
        } else if (PosShortcutsUtil.deleteDiscountShortcut.match(event)) {
            PosScene.deleteDisc(screen);
        } else if (PosShortcutsUtil.deleteAllHeld.match(event)) {
            PosScene.deleteAllHeld(screen, (Event)event);
        } else if (PosShortcutsUtil.editLineQty.match(event)) {
            PosScene.editLineQty(screen);
        } else if (PosShortcutsUtil.editDeliveryCost.match(event) && salesScreen.salesDoc != null) {
            POSResult result = POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanEditDeliveryCost);
            if (result.isFailed().booleanValue()) {
                POSErrorAndInfoMessagesUtil.showError(result, stage);
                return;
            }
            NamaDialog dialog = new NamaDialog("deliveryCost");
            POSLabeledTextField deliveryCostField = new POSLabeledTextField("deliveryCost", salesScreen, POSFieldType.Decimal);
            deliveryCostField.setId("delivery-cost-dialog-text-field");
            deliveryCostField.setPrefWidth(Screen.getPrimary().getVisualBounds().getWidth() / 4.0);
            Platform.runLater(() -> deliveryCostField.getField().requestFocus());
            deliveryCostField.setOnKeyReleased(e -> {
                if (ObjectChecker.areNotEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                    return;
                }
                dialog.fetchOkBtn().fire();
            });
            dialog.content((Node)deliveryCostField);
            dialog.addCancelButton("");
            dialog.setOkAction(e -> {
                salesScreen.salesDoc.setCustomDeliveryCost(ObjectChecker.toBigDecimalIfNumber((Object)deliveryCostField.getField().fetchValue()));
                salesScreen.salesDoc.calculateDeliveryCost();
                AbsPOSSalesLine deliveryCostLine = salesScreen.salesDoc.fetchDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)AbsPOSSales.fetchDeliveryItem())).findFirst().orElse(null);
                if (deliveryCostLine == null) {
                    return;
                }
                salesScreen.salesDoc.calcUnitPriceAndFreeLines(POSResourcesUtil.fetchMainRegister(), deliveryCostLine, true, salesScreen);
            });
            dialog.showAndWait();
        } else if (PosShortcutsUtil.openHeldInvoice.match(event)) {
            new POSRemoteInvoiceDialog(salesScreen).showDialog();
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.holdInvoiceShortcuts) && PosShortcutsUtil.holdInvoiceShortcuts.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.holdInvoice();
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.deleteLineShortcut) && PosShortcutsUtil.deleteLineShortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            AbsPosSalesScreen.deleteLineFromTable(-1, salesScreen, salesScreen.salesDoc, salesScreen.salesTable);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.discountShortcut) && PosShortcutsUtil.discountShortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.discountAction();
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscountShortcut) && PosShortcutsUtil.lineDiscountShortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscount2Shortcut) && PosShortcutsUtil.lineDiscount2Shortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc2);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscount3Shortcut) && PosShortcutsUtil.lineDiscount3Shortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc3);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscount4Shortcut) && PosShortcutsUtil.lineDiscount4Shortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc4);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscount5Shortcut) && PosShortcutsUtil.lineDiscount5Shortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc5);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscount6Shortcut) && PosShortcutsUtil.lineDiscount6Shortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc6);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscount7Shortcut) && PosShortcutsUtil.lineDiscount7Shortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc7);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lineDiscount8Shortcut) && PosShortcutsUtil.lineDiscount8Shortcut.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.lineDiscountAction(POSSecurityCapability.CanMakeLineDisc8);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.lockScreen) && PosShortcutsUtil.lockScreen.match(event)) {
            new POSLockDialog(screen);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.help) && PosShortcutsUtil.help.match(event)) {
            AbsPosSalesScreen.showHelpMenu(screen);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.newSalesShortcut) && PosShortcutsUtil.newSalesShortcut.match(event)) {
            ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Invoice)).draw(screen.fetchStage(), POSDocumentType.Invoice);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.openInvoice) && PosShortcutsUtil.openInvoice.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.openDocumentAction();
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.showHeldInvoices) && PosShortcutsUtil.showHeldInvoices.match(event) && screen instanceof AbsPosSalesScreen) {
            salesScreen.showListOfFeaturedInvoices(POSInvoiceType.Hold);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.priceInquiry) && PosShortcutsUtil.priceInquiry.match(event)) {
            new PricesInquiryDialog(screen).draw();
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.reprint) && PosShortcutsUtil.reprint.match(event)) {
            NamaToolBar.reprintDocumentAction(screen);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.disablePrinting) && PosShortcutsUtil.disablePrinting.match(event)) {
            PosScene.disableOrEnablePrinting(screen);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.terminateShortcut) && PosShortcutsUtil.terminateShortcut.match(event)) {
            PosScene.terminateAction(screen, stage, (Event)event);
        } else {
            boolean salesWithNoSelectedLines;
            boolean bl = salesWithNoSelectedLines = screen instanceof AbsPosSalesScreen && salesScreen.getSalesTable().getSelectionModel().getSelectedIndex() < 0;
            if (PosShortcutsUtil.shiftScreen.match(event) && (!(screen instanceof AbsPosSalesScreen) || salesWithNoSelectedLines)) {
                PosScene.drawShiftsScreen(stage, screen, (Event)event);
            } else if (PosShortcutsUtil.inventoryScreen.match(event)) {
                PosScene.drawCashCountScreen(stage);
            } else if (PosShortcutsUtil.moveBetweenScreensShortcut.match(event)) {
                PosScene.moveAction(screen, stage, (Event)event);
            } else if (PosShortcutsUtil.returnShortcut.match(event)) {
                PosScene.drawSalesReturn(screen, stage, (Event)event);
            } else if (PosShortcutsUtil.replacementShortcut.match(event)) {
                PosScene.drawSalesReplacment(screen, stage, (Event)event);
            } else if (PosShortcutsUtil.showSearchTable.match(event)) {
                PosScene.showSearchTableAction(screen);
            } else if (PosShortcutsUtil.accessHeaderFields.match(event)) {
                PosScene.accessHeaderAction(screen);
            } else if (event.getCode().equals((Object)KeyCode.ENTER) || event.getCode().equals((Object)KeyCode.SPACE)) {
                if (screen instanceof LoginScreen && ((LoginScreen)screen).getLoginBtn().isFocused()) {
                    ((LoginScreen)screen).getLoginBtn().fire();
                }
                if (screen instanceof POSPaymentReciptScreen) {
                    if (((POSPaymentReciptScreen)screen).getOkBtn().isFocused()) {
                        ((POSPaymentReciptScreen)screen).getOkBtn().fire();
                    }
                    if (((POSPaymentReciptScreen)screen).getNoBtn().isFocused()) {
                        ((POSPaymentReciptScreen)screen).getNoBtn().fire();
                    }
                }
                if (screen instanceof POSShiftInventoryScreen) {
                    if (((POSShiftInventoryScreen)screen).getOkBtn().isFocused()) {
                        ((POSShiftInventoryScreen)screen).getOkBtn().fire();
                    }
                    if (((POSShiftInventoryScreen)screen).getNoBtn().isFocused()) {
                        ((POSShiftInventoryScreen)screen).getNoBtn().fire();
                    }
                }
            } else if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
                if (screen.fetchScene().getFocusOwner() instanceof NamaTextField) {
                    ((NamaTextField)screen.fetchScene().getFocusOwner()).clear();
                } else {
                    screen.escapeAction();
                }
            }
        }
    }

    private static boolean fireField(String fieldID, IHasToolBar screen, Class<?> klass) {
        try {
            Field field = klass.getDeclaredField(fieldID);
            Node node = (Node)field.get(screen);
            if (node instanceof ButtonBase) {
                ((ButtonBase)node).fire();
            } else {
                ((Node)field.get(screen)).requestFocus();
            }
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }

    public static void showEditCustomer(IHasToolBar screen) {
        if (screen instanceof AbsPosSalesScreen && !POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanEditCustomer).isFailed().booleanValue()) {
            NamaDialog dialog = new NamaDialog("editCustomer");
            NamaLabel label = new NamaLabel("customer");
            NamaSearchBox customerCodeTextField = new NamaSearchBox(POSCustomer.class, screen, "customer", screen.fetchStage());
            Platform.runLater(() -> customerCodeTextField.requestFocus());
            NamaHBox content = new NamaHBox(new Node[]{label, customerCodeTextField});
            content.setId("edit-customer-dialog-content");
            dialog.content((Node)content);
            dialog.addOkButton("");
            dialog.addCancelButton("");
            Optional result = dialog.showAndWait();
            AbsPosSalesScreen.setActivatedDialog(dialog);
            if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY) && ObjectChecker.isNotEmptyOrNull((Object)customerCodeTextField.getIdBox().getText())) {
                POSCustomer customer = POSPersister.findByID(POSCustomer.class, customerCodeTextField.getIdBox().getText());
                if (customer != null) {
                    POSAddCustomerDialog posAddCustomerDialog = new POSAddCustomerDialog();
                    posAddCustomerDialog.setCurrentRecord(customer);
                    posAddCustomerDialog.showDialog(screen, "");
                }
            } else {
                dialog.hide();
            }
        }
    }

    public static void changeInvoiceClassification(IHasToolBar screen) {
        Platform.runLater(() -> ((AbsPosSalesScreen)screen).invoiceClassification.requestFocus());
    }

    public static void editLineQty(IHasToolBar screen) {
        if (!(screen instanceof AbsPosSalesScreen)) {
            return;
        }
        AbsPosSalesScreen salesScreen = (AbsPosSalesScreen)screen;
        if (ObjectChecker.isEmptyOrNull(salesScreen.getSalesTable()) || ObjectChecker.isEmptyOrNull((Object)salesScreen.getSalesTable().getItems())) {
            return;
        }
        if (salesScreen.salesDoc == null || salesScreen.salesDoc.isOldPaidInvoice()) {
            return;
        }
        int selectedIndex = PosScene.fetchSelectedIndex(salesScreen);
        NamaDialog dialog = new NamaDialog("Edit Line Quantity");
        NamaHBox hBox = new NamaHBox();
        NamaTextField qtyField = new NamaTextField();
        NamaLabel qty = new NamaLabel(POSResourcesUtil.id("qty", new Object[0]));
        hBox.getChildren().addAll((Object[])new Node[]{qty, qtyField});
        Platform.runLater(() -> qtyField.requestFocus());
        qtyField.setOnKeyPressed(e -> {
            if (ObjectChecker.areEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                dialog.hide();
                PosScene.updateLineQty(salesScreen, selectedIndex, qtyField);
            }
        });
        dialog.content((Node)hBox);
        Optional result = dialog.showAndWait();
        AbsPosSalesScreen.setActivatedDialog(dialog);
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY) && ObjectChecker.isNotEmptyOrNull((Object)qtyField.getText())) {
            PosScene.updateLineQty(salesScreen, selectedIndex, qtyField);
        }
    }

    private static void updateLineQty(AbsPosSalesScreen salesScreen, int selectedIndex, NamaTextField qtyField) {
        ObservableList items = salesScreen.getSalesTable().getItems();
        AbsPOSSalesLine line = (AbsPOSSalesLine)items.get(selectedIndex);
        line.getQty().setValue(new BigDecimal(qtyField.getText()));
        line.fetchSalesDoc().updateLineValues(line);
        items.set(selectedIndex, (Object)line);
        salesScreen.salesDoc.refreshViewAfterAddLine(line.getItem().getId().toString(), salesScreen, line.getItemCode());
    }

    private static int fetchSelectedIndex(AbsPosSalesScreen salesScreen) {
        int selectedIndex = salesScreen.getSalesTable().getSelectionModel().getSelectedIndex();
        if (selectedIndex == -1 || selectedIndex >= salesScreen.getSalesTable().getItems().size()) {
            selectedIndex = salesScreen.getSalesTable().getItems().size() - 1;
        }
        return selectedIndex;
    }

    public static void drawStockTransferReq(IHasToolBar screen, Stage stage, Event e) {
        PosScene.drawStockTransferReq(screen, stage, e, null);
    }

    public static void drawShortfallsDoc(IHasToolBar screen, Stage stage, Event e) {
        PosScene.drawShortfallsDoc(screen, stage, e, null);
    }

    public static void drawScrapDoc(IHasToolBar screen, Stage stage, Event e) {
        PosScene.drawScrapDoc(screen, stage, e, null);
    }

    public static void drawStockTransferReq(IHasToolBar screen, Stage stage, Event e, PosDocCategory docCategory) {
        if (POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakeStockTransferReq).isSucceeded().booleanValue()) {
            ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.StockTransferReq)).draw(stage, POSDocumentType.StockTransferReq, docCategory);
        }
    }

    public static void drawShortfallsDoc(IHasToolBar screen, Stage stage, Event e, PosDocCategory docCategory) {
        if (POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakeShortfallsDoc).isSucceeded().booleanValue()) {
            ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.ShortfallsDoc)).draw(stage, POSDocumentType.ShortfallsDoc, docCategory);
        }
    }

    public static void drawScrapDoc(IHasToolBar screen, Stage stage, Event e, PosDocCategory docCategory) {
        if (POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakeScrapDoc).isSucceeded().booleanValue()) {
            ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.ScrapDoc)).draw(stage, POSDocumentType.ScrapDoc, docCategory);
        }
    }

    public static void drawSalesReplacment(IHasToolBar screen, Stage stage, Event e) {
        PosScene.drawSalesReplacment(screen, stage, e, null);
    }

    public static void drawSalesReplacment(IHasToolBar screen, Stage stage, Event e, PosDocCategory docCategory) {
        if (POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakeReplacement).isFailed().booleanValue()) {
            return;
        }
        if (screen instanceof AbsPosSalesScreen && ((AbsPosSalesScreen)screen).isInvoice()) {
            if (((AbsPosSalesScreen)screen).notSavedOrChangedData()) {
                POSSecurityCapability capability = POSSecurityCapability.CanCancelInvoiceBeforeSave;
                POSResult result = POSSecurityUtil.checkIfHasCapability(capability);
                if (result.isFailed().booleanValue()) {
                    return;
                }
                if (ObjectChecker.isFalse((Boolean)AbsPosSalesScreen.doNotCacheLastScreenDoc(((AbsPosSalesScreen)screen).docType)) || PosScene.continueWithoutSaving(e, screen)) {
                    PosScene.salesReplacement(stage, docCategory);
                }
            } else {
                PosScene.salesReplacement(stage, docCategory);
            }
        } else {
            PosScene.salesReplacement(stage, docCategory);
        }
    }

    private static void salesReplacement(Stage stage, PosDocCategory docCategory) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Replacement)).draw(stage, POSDocumentType.Replacement, docCategory);
    }

    public static void showNotificationsTable() {
        NamaDialog dialog = new NamaDialog("Notifications");
        ListView listView = new ListView();
        listView.setPrefWidth(400.0);
        dialog.content((Node)listView);
        dialog.addCancelButton("");
        listView.getItems().add((Object)"Loading notifications...");
        dialog.show();
        Task<List<POSNotification>> fetchNotificationsTask = new Task<List<POSNotification>>(){

            protected List<POSNotification> call() throws Exception {
                return POSDataReaderUtil.readEmpNotifications();
            }
        };
        fetchNotificationsTask.setOnSucceeded(arg_0 -> PosScene.lambda$showNotificationsTable$18((Task)fetchNotificationsTask, listView, arg_0));
        fetchNotificationsTask.setOnFailed(arg_0 -> PosScene.lambda$showNotificationsTable$19(listView, (Task)fetchNotificationsTask, arg_0));
        Thread notificationsThread = new Thread((Runnable)fetchNotificationsTask, "Notifications Thread");
        notificationsThread.setDaemon(true);
        notificationsThread.start();
    }

    public static void changeFontAction() {
        NamaDialog dialog = new NamaDialog("Change Font");
        NamaHBox box = new NamaHBox();
        NamaLabel label = new NamaLabel(POSResourcesUtil.id("Change Font", new Object[0]));
        ObservableList items = FXCollections.observableArrayList();
        items.add((Object)"default");
        File folder = new File("Fonts");
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)folder.listFiles())) {
            for (File fileEntry : folder.listFiles()) {
                if (fileEntry.isDirectory()) continue;
                items.add((Object)fileEntry.getName());
            }
        }
        ComboBox fontNames = new ComboBox(items);
        fontNames.setPrefHeight(30.0);
        fontNames.setPrefWidth(200.0);
        fontNames.setValue((Object)((String)items.get(items.size() - 1)));
        box.getChildren().addAll((Object[])new Node[]{label, fontNames});
        box.setAlignment(Pos.BASELINE_CENTER);
        dialog.content((Node)box);
        dialog.addOkButton("");
        dialog.addCancelButton("");
        Optional result = dialog.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            PosScene.updateFont((ComboBox<String>)fontNames);
        }
    }

    private static void updateFont(ComboBox<String> fontNames) {
        if (ObjectChecker.isNotEmptyOrNull((Object)fontNames.getValue())) {
            POSSettingsInfo configuration = POSSettingsInfo.fetchConfiguration();
            configuration.setFontName((String)fontNames.getValue());
            POSPersister.saveOrUpdateWithActionHistory(configuration, null);
        }
    }

    public void showDataStatusScreen(IHasToolBar screen) {
        NamaDialog statisDialog = new NamaDialog("Data Statistics");
        status = new TextArea();
        status.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        status.textProperty().addListener((observable, oldValue, newValue) -> {
            status.selectPositionCaret(status.getLength());
            status.deselect();
        });
        status.setEditable(false);
        status.setMinWidth(screen.fetchStage().getWidth() / 2.0);
        status.setMinHeight(screen.fetchStage().getHeight() / 2.5);
        status.setScrollTop(Double.MAX_VALUE);
        Platform.runLater(() -> status.setText(POSDataReaderUtil.getCurrentStatistics()));
        NamaVBox namaVBox = new NamaVBox();
        namaVBox.getChildren().addAll((Object[])new Node[]{status});
        namaVBox.setSpacing(5.0);
        NamaButton clearBtn = new NamaButton();
        clearBtn.setSVGIcon("delete.svg");
        clearBtn.setTooltip(new POSTooltip("clear"));
        namaVBox.getChildren().addAll((Object[])new Node[]{clearBtn});
        clearBtn.setOnAction(event -> {
            status.clear();
            POSDataReaderUtil.clearCurrentStatistics();
        });
        statisDialog.content((Node)namaVBox);
        statisDialog.initStyle(StageStyle.UNIFIED);
        statisDialog.showAndWait();
    }

    public static void cancelInvoiceBeforeSave(IHasToolBar screen, KeyEvent event) {
        POSSecurityCapability capability = POSSecurityCapability.CanCancelInvoiceBeforeSave;
        POSResult result = POSSecurityUtil.checkIfHasCapability(capability);
        AbsPosSalesScreen posSalesScreen = (AbsPosSalesScreen)screen;
        if (!result.isFailed().booleanValue() && posSalesScreen.notSavedOrChangedData() && PosScene.continueWithoutSaving((Event)event, screen) || !posSalesScreen.notSavedOrChangedData()) {
            PosTempDocumentUtil.deleteTempDocIfNeeded(posSalesScreen.salesDoc);
            ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(((AbsPosSalesScreen)screen).docType)).draw(screen.fetchStage(), ((AbsPosSalesScreen)screen).docType);
        }
    }

    public static void drawSalesReturn(IHasToolBar screen, Stage stage, Event e) {
        PosScene.drawSalesReturn(screen, stage, e, null);
    }

    public static void drawSalesReturn(IHasToolBar screen, Stage stage, Event e, PosDocCategory docCategory) {
        POSResult capResult = POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakeReturn);
        if (capResult.isFailed().booleanValue()) {
            return;
        }
        if (screen instanceof AbsPosSalesScreen && ((AbsPosSalesScreen)screen).isInvoice()) {
            if (((AbsPosSalesScreen)screen).notSavedOrChangedData()) {
                POSSecurityCapability capability = POSSecurityCapability.CanCancelInvoiceBeforeSave;
                POSResult result = POSSecurityUtil.checkIfHasCapability(capability);
                if (result.isFailed().booleanValue()) {
                    return;
                }
                if (ObjectChecker.isFalse((Boolean)AbsPosSalesScreen.doNotCacheLastScreenDoc(((AbsPosSalesScreen)screen).docType)) || PosScene.continueWithoutSaving(e, screen)) {
                    PosScene.salesReturn(stage, docCategory);
                }
            } else {
                PosScene.salesReturn(stage, docCategory);
            }
        } else {
            PosScene.salesReturn(stage, docCategory);
        }
    }

    private static void salesReturn(Stage stage, PosDocCategory docCategory) {
        ((AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Return)).draw(stage, POSDocumentType.Return, docCategory);
    }

    public static void accessMenusAction(IHasToolBar screen) {
        ObservableList selectedCells = ((AbsPosSalesScreen)screen).getSalesTable().getSelectionModel().getSelectedCells();
        for (TablePosition pos : selectedCells) {
            AbsPOSSalesLine selectedItem;
            ObservableList items = ((AbsPosSalesScreen)screen).getSalesTable().getItems();
            if (pos.getRow() >= items.size() || !ObjectChecker.isNotEmptyOrNull((Object)(selectedItem = (AbsPOSSalesLine)items.get(pos.getRow()))) || !ObjectChecker.isNotEmptyOrNull((Object)selectedItem.getItemCode())) continue;
            pos.getTableColumn().getCellFactory().call((Object)pos.getTableColumn());
        }
    }

    public static void accessHeaderAction(IHasToolBar screen) {
        if (screen instanceof AbsPosSalesScreen && ((AbsPosSalesScreen)screen).isInvoice()) {
            ((AbsPosSalesScreen)screen).getCustomerCodeTextField().getCodeBox().requestFocus();
        }
        if (screen instanceof AbsPosSalesScreen && !((AbsPosSalesScreen)screen).isInvoice()) {
            ((AbsPosSalesScreen)screen).getInvCodeTextField().requestFocus();
        }
        if (screen instanceof POSPaymentReciptScreen) {
            ((POSPaymentReciptScreen)screen).getSubsidiary().getTypeCombo().requestFocus();
        }
    }

    public static void accessSalesGridAction(IHasToolBar screen) {
        Platform.runLater(() -> {
            AbsPosSalesScreen newSalesScreen = (AbsPosSalesScreen)screen;
            TableView<AbsPOSSalesLine> salesTable = newSalesScreen.getSalesTable();
            salesTable.requestFocus();
            TableView.TableViewSelectionModel selectionModel = salesTable.getSelectionModel();
            selectionModel.select(salesTable.getItems().size() - 1, (TableColumn)salesTable.getColumns().get(1));
        });
    }

    public static void terminateAction(IHasToolBar screen, Stage stage, Event e) {
        screen.terminateAction(stage, e);
    }

    public static void continueOrCancelCheck(Stage stage, Event e, IHasToolBar screen) {
        if (PosScene.continueWithoutSaving(e, screen)) {
            PosShortcutsUtil.terminate(stage, e, screen);
        }
    }

    public static void showSearchTableAction(IHasToolBar screen) {
        Platform.runLater(() -> {
            if (screen.fetchScene().getFocusOwner().getParent() instanceof HBox && screen.fetchScene().getFocusOwner().getParent().getParent() instanceof NamaSearchBox) {
                ((NamaSearchBox)screen.fetchScene().getFocusOwner().getParent().getParent()).getSearchBtn().fire();
            } else {
                PosScene.accessMenusAction(screen);
            }
        });
    }

    public static void invPayAction(IHasToolBar screen, boolean shouldPrintAfterPayment) {
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchMainRegister().getCallCenterMode())) {
            POSErrorAndInfoMessagesUtil.showError("This register is in Call Center Mode. Invoice payments are disabled.", screen.fetchStage());
            return;
        }
        screen.fetchPane().requestFocus();
        Object t = screen.document();
        if (t instanceof AbsPOSSales) {
            AbsPOSSales doc = (AbsPOSSales)t;
            if (screen instanceof AbsPosSalesScreen) {
                AbsPosSalesScreen scr = (AbsPosSalesScreen)screen;
                doc.updateTotals(scr);
            }
        }
        PosScene.focusFirstCellInRow(screen);
        AbsPosSalesScreen salesScreen = (AbsPosSalesScreen)screen;
        Dialog activatedDialog = salesScreen.getActivatedDialog();
        if (activatedDialog == null || !(activatedDialog instanceof MultiplePaymentDialog) && !activatedDialog.isShowing()) {
            salesScreen.multiCashAction(shouldPrintAfterPayment);
        } else {
            ((MultiplePaymentDialog)activatedDialog).processAction((AbsPOSSales)screen.document());
        }
    }

    public static void moveAction(IHasToolBar screen, Stage stage, Event e) {
        if (screen instanceof AbsPosSalesScreen && ((AbsPosSalesScreen)screen).isInvoice()) {
            PosScene.createPaymentScreen(stage, "");
        }
        if (screen instanceof POSPaymentReciptScreen && ((POSPaymentReciptScreen)screen).isPayment()) {
            PosScene.createReceiptScreen(stage);
        }
        if (screen instanceof POSPaymentReciptScreen && !((POSPaymentReciptScreen)screen).isPayment()) {
            PosScene.drawSalesScreen(stage);
        }
        if (screen instanceof POSInternalMsgScreen) {
            PosScene.drawSalesScreen(stage);
        }
        if (screen instanceof POSShiftInventoryScreen && ((POSShiftInventoryScreen)screen).isShift()) {
            PosScene.fromShiftToSales(screen, stage, e);
        }
        if (screen instanceof POSShiftInventoryScreen && !((POSShiftInventoryScreen)screen).isShift()) {
            PosScene.fromShiftToSales(screen, stage, e);
        }
        if (screen instanceof AbsPosSalesScreen && !((AbsPosSalesScreen)screen).isInvoice()) {
            PosScene.drawSalesScreen(stage);
        }
    }

    private static void fromShiftToSales(IHasToolBar screen, Stage stage, Event e) {
        if (PosScene.notSavedOrChangedData((POSShiftInventoryScreen)screen)) {
            if (PosScene.continueWithoutSaving(e, screen)) {
                PosScene.drawSalesScreen(stage);
            }
        } else {
            PosScene.drawSalesScreen(stage);
        }
    }

    public static void createReceiptScreen(Stage stage) {
        POSResult result = POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakeReceipts);
        if (!result.isFailed().booleanValue()) {
            ((POSPaymentReciptScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Receipt)).draw(stage, false, "");
        } else {
            PosScene.drawSalesScreen(stage);
        }
    }

    public static void createPaymentScreen(Stage stage, String payType) {
        POSResult result = POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakePayments);
        if (!result.isFailed().booleanValue()) {
            ((POSPaymentReciptScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Payment)).draw(stage, true, payType);
        } else {
            PosScene.createReceiptScreen(stage);
        }
    }

    public static boolean confirmDelete(Event e, Dialog parentDialog, IHasToolBar screen) {
        boolean delete = NamaConfirmationDialog.showDialogAndWait("Are you sure you want to delete?", parentDialog, e);
        PosScene.removeCachedDocForScreen(screen, delete);
        return delete;
    }

    public static boolean continueWithoutSaving(Event e, IHasToolBar screen) {
        return PosScene.continueWithoutSaving(e, null, screen);
    }

    public static boolean continueWithoutSaving(Event e, Dialog parentDialog, IHasToolBar screen) {
        boolean continueWithoutSaving = NamaConfirmationDialog.showDialogAndWait("Do you want to continue without saving the data?", parentDialog, e);
        PosScene.removeCachedDocForScreen(screen, continueWithoutSaving);
        return continueWithoutSaving;
    }

    private static void removeCachedDocForScreen(IHasToolBar screen, boolean remove) {
        if (remove && screen instanceof AbsPosSalesScreen) {
            POSResourcesUtil.lastScreensDocs.remove((Object)((AbsPosSalesScreen)screen).docType);
        }
    }

    public ClassLoader fetchClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public static POSUser showSecurityDialog(POSSecurityCapability capability, boolean preventCapability) {
        NamaDialog dialog = new NamaDialog("lock");
        dialog.headerText(lockDialogHeader);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        NamaTextField username = new NamaTextField(true, POSFieldType.Text, null, null);
        username.setPromptText(POSResourcesUtil.id("Username", new Object[0]));
        NamaPasswordField password = new NamaPasswordField();
        password.setPromptText(POSResourcesUtil.id("password", new Object[0]));
        grid.add((Node)new NamaLabel("Username"), 0, 0);
        grid.add((Node)username, 1, 0);
        grid.add((Node)new NamaLabel("password"), 0, 1);
        grid.add((Node)password, 1, 1);
        dialog.content((Node)grid);
        dialog.addOkButton("");
        dialog.addCancelButton("");
        username.setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                Platform.runLater(() -> ((NamaPasswordField)password).requestFocus());
            }
        });
        password.setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                dialog.fetchOkBtn().fire();
            }
        });
        Platform.runLater(() -> {
            PauseTransition pause = new PauseTransition(Duration.millis((double)100.0));
            pause.setOnFinished(e -> {
                dialog.getDialogPane().requestFocus();
                username.requestFocus();
            });
            pause.play();
        });
        Optional result = dialog.showAndWait();
        boolean userCanDo = true;
        Boolean userHasTheCapability = POSSecurityUtil.userCan(username.getText(), password.getText(), capability).isSucceeded();
        if (userHasTheCapability.booleanValue() && preventCapability) {
            userCanDo = false;
        }
        if (!userHasTheCapability.booleanValue() && !preventCapability) {
            userCanDo = false;
        }
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY) && userCanDo) {
            lockDialogHeader = "";
            dialog.close();
            return LoginUtil.authenticateUser(username.getText(), password.getText(), new POSResult());
        }
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.CANCEL_CLOSE)) {
            lockDialogHeader = "";
            dialog.close();
            return null;
        }
        lockDialogHeader = "Wrong user name or password";
        return PosScene.showSecurityDialog(capability, preventCapability);
    }

    public static void drawCashCountScreen(Stage stage) {
        POSResult result = POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanMakeCashCount);
        if (!result.isFailed().booleanValue()) {
            ((POSNewShiftsScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.CashCount)).draw(stage, false);
        }
    }

    public static void drawShiftsScreen(Stage stage, IHasToolBar screen, Event e) {
        POSDocumentType type;
        POSDocumentType pOSDocumentType = type = ObjectChecker.isEmptyOrNull((Object)POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister())) ? POSDocumentType.ShiftOpen : POSDocumentType.ShiftClose;
        if (!PosScene.canOpenCloseShift(type)) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)screen) && screen instanceof AbsPosSalesScreen && ((AbsPosSalesScreen)screen).notSavedOrChangedData()) {
            POSSecurityCapability capability = POSSecurityCapability.CanCancelInvoiceBeforeSave;
            POSResult result = POSSecurityUtil.checkIfHasCapability(capability);
            if (result.isFailed().booleanValue()) {
                return;
            }
            if (ObjectChecker.isFalse((Boolean)AbsPosSalesScreen.doNotCacheLastScreenDoc(((AbsPosSalesScreen)screen).docType)) || PosScene.continueWithoutSaving(e, screen)) {
                ((IPOSShiftScreen)((Object)PosScreenCacheUtil.fetchCachedScreen(type))).draw(stage, true);
            }
        } else {
            ((IPOSShiftScreen)((Object)PosScreenCacheUtil.fetchCachedScreen(type))).draw(stage, true);
        }
    }

    private static boolean canOpenCloseShift(POSDocumentType type) {
        POSResult result = POSSecurityUtil.userCan(POSSecurityCapability.CanOpenCloseShift);
        if (result.isSucceeded().booleanValue()) {
            return true;
        }
        result = ObjectChecker.areEqual((Object)((Object)type), (Object)((Object)POSDocumentType.ShiftOpen)) ? POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanOpenShift) : POSSecurityUtil.checkIfHasCapabilityForNewDoc(POSSecurityCapability.CanCloseShift);
        return result.isSucceeded();
    }

    public static void deleteDisc(IHasToolBar screen) {
        if (screen instanceof AbsPosSalesScreen) {
            ((AbsPosSalesScreen)screen).getDiscountPercentTextField().setText("0");
            ((AbsPosSalesScreen)screen).getSalesDoc().setDiscountPercent(BigDecimal.ZERO);
            ((AbsPosSalesScreen)screen).getSalesDoc().setDiscountValue(BigDecimal.ZERO);
            ((AbsPosSalesScreen)screen).getSalesDoc().updateLineAndTotalMoney((AbsPosSalesScreen)screen, true);
            ((AbsPosSalesScreen)screen).updateFieldsEvent(Arrays.asList("discountP"), ((AbsPosSalesScreen)screen).getSalesDoc());
        }
    }

    public static void deleteAllHeld(IHasToolBar hasToolBar, Event e) {
        if (PosScene.confirmDelete(e, null, hasToolBar)) {
            List<?> allHeldInvoices = POSPersister.listAll(POSSalesInvoice.class, " where hold = true");
            POSPersister.deleteAllWithActionHistory(allHeldInvoices);
            List<?> allHeldReturns = POSPersister.listAll(POSSalesReturn.class, " where hold = true");
            POSPersister.deleteAllWithActionHistory(allHeldReturns);
            List<?> allHeldReplacements = POSPersister.listAll(POSSalesReplacement.class, " where hold = true");
            POSPersister.deleteAllWithActionHistory(allHeldReplacements);
        }
    }

    public static void activeCustomer(final IHasToolBar hasToolBar) {
        if (hasToolBar instanceof AbsPosSalesScreen) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AbsPosSalesScreen)hasToolBar).getCustomerCodeTextField().getCodeBox().requestFocus();
                }
            });
        }
    }

    public static void delCustomer(final IHasToolBar hasToolBar) {
        if (hasToolBar instanceof AbsPosSalesScreen) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AbsPosSalesScreen)hasToolBar).getCustomerCodeTextField().getCodeBox().clear();
                    ((AbsPosSalesScreen)hasToolBar).getCustomerCodeTextField().getNameBox().clear();
                }
            });
        }
    }

    public static void addNewCustomer(IHasToolBar hasToolBar) {
        if (hasToolBar instanceof AbsPosSalesScreen) {
            ((AbsPosSalesScreen)hasToolBar).getAddCustomerBtn().fire();
        }
    }

    public static void activeSalesMan(final IHasToolBar hasToolBar) {
        if (hasToolBar instanceof AbsPosSalesScreen) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AbsPosSalesScreen)hasToolBar).getSalesManCodeTextField().getCodeBox().requestFocus();
                }
            });
        }
    }

    public static void delSalesMan(IHasToolBar hasToolBar) {
        if (hasToolBar instanceof AbsPosSalesScreen && !POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanEditSalesMan).isFailed().booleanValue()) {
            Platform.runLater(() -> {
                AbsPosSalesScreen salesScreen = (AbsPosSalesScreen)hasToolBar;
                salesScreen.getSalesManCodeTextField().getCodeBox().clear();
                salesScreen.getSalesManCodeTextField().getNameBox().clear();
            });
        }
    }

    public static POSNotificationsTask getNotificationsTask() {
        return notificationsTask;
    }

    public static void setNotificationsTask(POSNotificationsTask notificationsTask) {
        PosScene.notificationsTask = notificationsTask;
    }

    public static void showErrorsDialog(IHasToolBar screen) {
        if (POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanShowDataTransferErrors).isFailed().booleanValue()) {
            return;
        }
        NamaDialog errorsDialog = new NamaDialog("Errors Statistics");
        errors = new NamaTableView();
        errors.setPrefWidth(screen.fetchStage().getWidth() / 1.5);
        errors.setPrefHeight(screen.fetchStage().getHeight() / 2.0);
        errors.setItems(FXCollections.observableArrayList(POSDataWriterUtil.transferErrors));
        POSTableColumn lineNumCol = new POSTableColumn("#");
        lineNumCol.setCellValueFactory(param -> new NamaObservable<Integer>(errors.getItems().indexOf(param.getValue()) + 1));
        lineNumCol.setPrefWidth(30.0);
        POSTableColumn entityTypeCol = new POSTableColumn("entityType");
        entityTypeCol.setCellValueFactory((Callback)new PropertyValueFactory("entityType"));
        double width = errors.getPrefWidth() - 30.0;
        entityTypeCol.setPrefWidth(width / 5.0);
        POSTableColumn codeCol = new POSTableColumn("code");
        codeCol.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        codeCol.setPrefWidth(width / 5.0);
        POSTableColumn failureCol = new POSTableColumn("failure");
        failureCol.setCellValueFactory((Callback)new PropertyValueFactory("failure"));
        failureCol.setPrefWidth(width / 5.0);
        POSTableColumn timeCol = new POSTableColumn("onTime");
        timeCol.setCellValueFactory((Callback)new PropertyValueFactory("onTime"));
        timeCol.setPrefWidth(width / 5.0);
        POSTableColumn logCol = new POSTableColumn("log");
        logCol.setCellValueFactory((Callback)new PropertyValueFactory("log"));
        logCol.setPrefWidth(width / 5.0);
        errors.getColumns().addAll((Object[])new TableColumn[]{lineNumCol, entityTypeCol, codeCol, failureCol, timeCol, logCol});
        TableUtils.applyMultipleCellSelection(errors, entityTypeCol, codeCol, failureCol, logCol);
        errors.setEditable(false);
        NamaVBox namaVBox = new NamaVBox();
        new PosCopyMenu((Control)errors).bind();
        namaVBox.getChildren().addAll((Object[])new Node[]{errors});
        namaVBox.setSpacing(5.0);
        NamaHBox btns = new NamaHBox();
        btns.setSpacing(2.0);
        NamaButton clearBtn = new NamaButton();
        clearBtn.setSVGIcon("delete.svg");
        clearBtn.setTooltip(new POSTooltip("clear"));
        NamaButton resetFailures = new NamaButton();
        resetFailures.setSVGIcon("reset.svg");
        resetFailures.setTooltip(new POSTooltip("resetFailures"));
        resetFailures.setOnAction(event -> POSRegistery.resetFailureTimesAction());
        NamaButton copyAllCells = new NamaButton();
        copyAllCells.setSVGIcon("copy.svg");
        copyAllCells.setTooltip(new POSTooltip("copyAllCells"));
        copyAllCells.setOnMouseClicked(event -> TableUtils.copyAllCellsToClipboard(errors));
        NamaLabel countLabel = new NamaLabel();
        countLabel.setAlignment(Pos.BASELINE_CENTER);
        btns.getChildren().addAll((Object[])new Node[]{clearBtn, resetFailures, copyAllCells, countLabel});
        namaVBox.getChildren().addAll((Object[])new Node[]{btns});
        clearBtn.setOnAction(event -> {
            errors.getItems().clear();
            POSDataWriterUtil.transferErrors = new ArrayList<POSError>();
        });
        errorsDialog.content((Node)namaVBox);
        errorsDialog.initStyle(StageStyle.UNIFIED);
        countLabel.setText(POSDataWriterUtil.transferErrors.size() + " " + POSResourcesUtil.id("records", new Object[0]));
        errors.scrollTo(POSDataWriterUtil.transferErrors.size() - 1);
        TableUtils.installCopyPasteHandler(errors);
        errorsDialog.showAndWait();
    }

    public static void transferAllCreditNotes() {
        List<POSCreditNote> notes = POSPersister.selectTop(POSCreditNote.class, " where sent = false", 250);
        POSDataWriterUtil.writePOSCreditNote(POSResourcesUtil.fetchMainRegister(), notes);
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public void setTrayIcon(TrayIcon trayIcon) {
        this.trayIcon = trayIcon;
    }

    public static boolean connectionIsUp() {
        return !PosScene.connectionIsDown();
    }

    public static boolean connectionIsDown() {
        return PosScene.noConnection();
    }

    public static boolean noConnection() {
        try {
            ServiceLoginProvider.loginIfNotLoggedIn((String)POSGeneralSettings.getPOSServerURL(), (String)POSGeneralSettings.getLoginPassword(), (String)POSGeneralSettings.getLoginID(), (String)POSGeneralSettings.getAPIKey());
        }
        catch (Exception exception) {
            NaMaLogger.error((Throwable)exception);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$showNotificationsTable$19(ListView listView, Task fetchNotificationsTask, WorkerStateEvent e) {
        listView.getItems().clear();
        listView.getItems().add((Object)("Failed to load notifications: " + fetchNotificationsTask.getException().getMessage()));
    }

    private static /* synthetic */ void lambda$showNotificationsTable$18(Task fetchNotificationsTask, ListView listView, WorkerStateEvent e) {
        List notifications = (List)fetchNotificationsTask.getValue();
        listView.getItems().clear();
        for (POSNotification posNotification : notifications) {
            listView.getItems().add((Object)posNotification.getSubject());
        }
    }

    static {
        errors = new NamaTableView();
    }
}

