/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSBusinessFunction;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSCreditNoteAndCouponUtil;
import com.namasoft.pos.application.POSLockDialog;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSTotalsShowPanel;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.details.ShortcutLine;
import com.namasoft.pos.domain.entities.POSActionHistory;
import com.namasoft.pos.domain.entities.Shortcuts;
import com.namasoft.pos.domain.valueobjects.POSActionType;
import com.namasoft.pos.util.POSDataReaderRunner;
import com.namasoft.pos.util.POSDataWriterRunner;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSOnlineOrderReaderRunner;
import com.namasoft.pos.util.POSOnlineOrderWriterRunner;
import com.namasoft.pos.util.POSQuantitiesReaderRunner;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;

public class PosShortcutsUtil {
    public static KeyCombination replacementShortcut;
    public static KeyCombination moveBetweenScreensShortcut;
    public static KeyCombination returnShortcut;
    public static KeyCombination newSalesShortcut;
    public static KeyCombination shiftScreen;
    public static KeyCombination inventoryScreen;
    public static KeyCombination showSearchTable;
    public static KeyCombination openInvoice;
    public static KeyCombination terminateShortcut;
    public static KeyCombination payDialogShortcuts;
    public static KeyCombination payWithoutPrintingDialogShortcuts;
    public static KeyCombination invoicePayShortcuts;
    public static KeyCombination holdInvoiceShortcuts;
    public static KeyCombination deleteHeldInvoices;
    public static KeyCombination showHeldInvoices;
    public static KeyCombination discountShortcut;
    public static KeyCombination lineDiscountShortcut;
    public static KeyCombination lineDiscount2Shortcut;
    public static KeyCombination lineDiscount3Shortcut;
    public static KeyCombination lineDiscount4Shortcut;
    public static KeyCombination lineDiscount5Shortcut;
    public static KeyCombination lineDiscount6Shortcut;
    public static KeyCombination lineDiscount7Shortcut;
    public static KeyCombination lineDiscount8Shortcut;
    public static KeyCombination deleteLineShortcut;
    public static KeyCombination duplicateLineShortcut;
    public static KeyCombination lockScreen;
    public static KeyCombination help;
    public static KeyCombination priceInquiry;
    public static KeyCombination gridAccessShortcut;
    public static KeyCombination accessHeaderFields;
    public static KeyCombination showDataStatusScreen;
    public static KeyCombination changeFont;
    public static KeyCombination deleteDiscountShortcut;
    public static KeyCombination deleteAllHeld;
    public static KeyCombination activateCustomer;
    public static KeyCombination activateItem;
    public static KeyCombination deleteCustomer;
    public static KeyCombination addNewCustomer;
    public static KeyCombination activateSalesMan;
    public static KeyCombination deleteSalesMan;
    public static KeyCombination showAllNotifications;
    public static KeyCombination editLineQty;
    public static KeyCombination editInvoiceClassification;
    public static KeyCombination transferCreditNotes;
    public static KeyCombination editCustomer;
    public static KeyCombination reprint;
    public static KeyCombination payUsingRewardPoints;
    public static KeyCombination disablePrinting;
    public static KeyCombination editDeliveryCost;
    public static KeyCombination openHeldInvoice;
    public static boolean trayIconAdded;
    private static Map<POSBusinessFunction, String> userShortCuts;
    private static Map<KeyCombination, String> headerFieldsShortcuts;

    private static void initializeShortCutsIfNeeded() {
        if (replacementShortcut != null) {
            return;
        }
        PosShortcutsUtil.initializeShortCuts();
    }

    public static void initializeShortCuts() {
        replacementShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.Replacement, "Shift+f1"));
        moveBetweenScreensShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.MoveBetweenScreens, "f1"));
        returnShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.Return, "Ctrl+f1"));
        newSalesShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.NewSales, "alt+f1"));
        shiftScreen = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ShiftScreen, "f2"));
        inventoryScreen = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.InventoryScreen, "Ctrl+f2"));
        showSearchTable = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ShowSearchTable, "f3"));
        openInvoice = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.OpenInvoice, "Ctrl+f3"));
        terminateShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.Terminate, "alt+f4"));
        payDialogShortcuts = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.PayDialog, "f5"));
        payWithoutPrintingDialogShortcuts = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.MultiPayDialog, "Ctrl+f5"));
        invoicePayShortcuts = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.InvoicePay, "f5"));
        holdInvoiceShortcuts = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.HoldInvoice, "f6"));
        deleteHeldInvoices = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DeleteHeldInvoices, "alt+f6"));
        showHeldInvoices = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ShowHeldInvoices, "ctrl+f6"));
        discountShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.Discount, "f10"));
        lineDiscountShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount, "alt+1"));
        lineDiscount2Shortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount2, "alt+2"));
        lineDiscount3Shortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount3, "alt+3"));
        lineDiscount4Shortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount4, "alt+4"));
        lineDiscount5Shortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount5, "alt+5"));
        lineDiscount6Shortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount6, "alt+6"));
        lineDiscount7Shortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount7, "alt+7"));
        lineDiscount8Shortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LineDiscount8, "alt+8"));
        deleteLineShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DeleteLine, "Ctrl+delete"));
        duplicateLineShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DuplicateLine, KeyCode.ADD.getName()));
        lockScreen = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.LockScreen, "f11"));
        help = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.Help, "f12"));
        priceInquiry = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.PriceInquiry, "ctrl+f9"));
        gridAccessShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.GridAccess, KeyCode.PAGE_DOWN.getName()));
        accessHeaderFields = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.AccessHeaderFields, KeyCode.PAGE_UP.getName()));
        showDataStatusScreen = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ShowDataStatusScreen, "ctrl+f4"));
        changeFont = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ChangeFont, "f4"));
        deleteDiscountShortcut = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DeleteDiscount, "Ctrl+f10"));
        deleteAllHeld = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DeleteAllHeld, "Shift+f6"));
        deleteCustomer = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DeleteCustomer, "Ctrl+f7"));
        addNewCustomer = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.AddNewCustomer, "shift+f7"));
        deleteSalesMan = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DeleteSalesMan, "Ctrl+f8"));
        showAllNotifications = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ShowAllNotifications, "Ctrl+f11"));
        editLineQty = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.EditLineQty, "Ctrl+q"));
        transferCreditNotes = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.TransferCreditNotes, "Ctrl+Shift+N"));
        editCustomer = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.EditCustomer, "Ctrl+Shift+c"));
        reprint = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.Reprint, "alt+p"));
        payUsingRewardPoints = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.PayUsingRewardPoints, "alt+r"));
        disablePrinting = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.DisablePrinting, "Ctrl+d"));
        editDeliveryCost = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.EditDeliveryCost, "alt+v"));
        openHeldInvoice = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.OpenHeldInvoice, "ctrl+i"));
        PosShortcutsUtil.initSearchDialogHeaderFieldsShortcut();
    }

    private static void initSearchDialogHeaderFieldsShortcut() {
        activateCustomer = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ActivateCustomer, "f7", true));
        activateSalesMan = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ActivateSalesMan, "f8", true));
        activateItem = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.ActivateItem, "Ctrl+F", true));
        editInvoiceClassification = KeyCodeCombination.keyCombination((String)PosShortcutsUtil.fetchShortCut(POSBusinessFunction.EditInvoiceClassification, "Ctrl+shift+i", true));
    }

    private static String fetchShortCut(POSBusinessFunction posBusinessFunction, String defaultShortCut) {
        return PosShortcutsUtil.fetchShortCut(posBusinessFunction, defaultShortCut, false);
    }

    private static String fetchShortCut(POSBusinessFunction posBusinessFunction, String defaultShortCut, boolean isSearchDialogHeaderField) {
        String userShortCut;
        if (!POSPersister.isInitialized()) {
            return defaultShortCut;
        }
        if (userShortCuts == null) {
            PosShortcutsUtil.defineUserShortCuts();
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)(userShortCut = userShortCuts.get(posBusinessFunction)))) {
            return isSearchDialogHeaderField ? PosShortcutsUtil.modifySearchDialogShortcut(userShortCut) : userShortCut;
        }
        if (userShortCuts.containsValue(defaultShortCut)) {
            return "NoShortCut";
        }
        return isSearchDialogHeaderField ? PosShortcutsUtil.modifySearchDialogShortcut(defaultShortCut) : defaultShortCut;
    }

    private static String modifySearchDialogShortcut(String shortCut) {
        if (shortCut.contains("Alt")) {
            return shortCut.replace("Alt", "Ignore Alt");
        }
        return "Ignore Alt+" + shortCut;
    }

    private static void defineUserShortCuts() {
        userShortCuts = new HashMap<POSBusinessFunction, String>();
        if (POSResourcesUtil.fetchMainRegister() == null) {
            return;
        }
        Shortcuts shortcuts = POSResourcesUtil.fetchMainRegister().fetchShortcuts();
        if (shortcuts == null) {
            shortcuts = (Shortcuts)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getShortcuts());
        }
        if (ObjectChecker.isEmptyOrNull((Object)shortcuts)) {
            return;
        }
        for (ShortcutLine shortCut : shortcuts.getDetails()) {
            if (!ObjectChecker.isNotEmptyOrNull((Object)shortCut.getBusinessFunction())) continue;
            userShortCuts.put(POSBusinessFunction.valueOf((String)shortCut.getBusinessFunction()), PosShortcutsUtil.describe(shortCut));
        }
    }

    public static String describe(ShortcutLine shortCut) {
        if (ObjectChecker.isEmptyOrNull((Object)shortCut.getTheKey())) {
            return "NoShortCut";
        }
        StringBuilder builder = new StringBuilder();
        if (ObjectChecker.isTrue((Boolean)shortCut.getUseAlt())) {
            builder.append("Alt+");
        }
        if (ObjectChecker.isTrue((Boolean)shortCut.getUseCtrl())) {
            builder.append("Ctrl+");
        }
        if (ObjectChecker.isTrue((Boolean)shortCut.getUseShift())) {
            builder.append("Shift+");
        }
        builder.append(shortCut.getTheKey().toLowerCase());
        return builder.toString();
    }

    public static void terminate(final Stage stage, Event terminateEvent, final IHasToolBar screen) {
        POSResourcesUtil.addTrayIcon = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getRunPosInBackground());
        if (POSResourcesUtil.addTrayIcon.booleanValue() && SystemTray.isSupported()) {
            Platform.setImplicitExit((boolean)false);
            try (InputStream image = PosScene.class.getClassLoader().getResourceAsStream("posTray.jpg");){
                final SystemTray tray = SystemTray.getSystemTray();
                Dimension size = tray.getTrayIconSize();
                BufferedImage bi = ImageIO.read(image);
                int trayIconWidth = new TrayIcon((Image)bi).getSize().width;
                final TrayIcon trayIcon = new TrayIcon(bi.getScaledInstance(trayIconWidth, -1, 4), "Nama POS");
                ((PosScene)stage.getScene()).setTrayIcon(trayIcon);
                PopupMenu popup = new PopupMenu();
                MenuItem showItem = new MenuItem("Display");
                MenuItem exitItem = new MenuItem("Exit");
                exitItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PosShortcutsUtil.terminateAll();
                        tray.remove(trayIcon);
                    }
                });
                showItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PosShortcutsUtil.displayStage(stage, screen);
                    }
                });
                popup.add(showItem);
                popup.add(exitItem);
                trayIcon.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            PosShortcutsUtil.displayStage(stage, screen);
                        }
                    }
                });
                trayIcon.setPopupMenu(popup);
                if (!trayIconAdded) {
                    tray.add(trayIcon);
                    trayIconAdded = true;
                }
                stage.hide();
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        } else {
            PosShortcutsUtil.terminateAll();
        }
    }

    public static void displayStage(Stage stage, IHasToolBar screen) {
        Platform.runLater(() -> {
            stage.show();
            stage.toFront();
            new POSLockDialog(screen);
        });
    }

    public static void terminateAll(WindowEvent e) {
        PosShortcutsUtil.terminateAll();
    }

    public static void terminateAll() {
        try {
            POSDataReaderRunner.stop();
            POSDataWriterRunner.stop();
            POSQuantitiesReaderRunner.stop();
            POSOnlineOrderWriterRunner.stop();
            POSOnlineOrderReaderRunner.stop();
            POSDataWriterUtil.executor.shutdownNow();
            POSTotalsShowPanel.imagesFetcher.shutdownNow();
            POSCreditNoteAndCouponUtil.executorService.shutdownNow();
            if (PosEntryPoint.socket != null && !PosEntryPoint.socket.isClosed()) {
                PosEntryPoint.socket.close();
            }
            DisplayPoleConnectorUtil.closeDisplayPoleConnection();
            if (ObjectChecker.isNotEmptyOrNull((Object)PosScene.getNotificationsTask())) {
                PosScene.getNotificationsTask().shutdownNow();
            }
            if (POSPersister.isInitialized()) {
                POSPersister.saveOrUpdate(POSActionHistory.create(null, POSActionType.LogOut));
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        finally {
            Platform.exit();
            System.exit(0);
        }
    }

    public static Map<KeyCombination, String> fetchHeaderFieldsShortcuts() {
        if (headerFieldsShortcuts != null) {
            return headerFieldsShortcuts;
        }
        headerFieldsShortcuts = new ConcurrentHashMap<KeyCombination, String>();
        Shortcuts shortcuts = POSResourcesUtil.fetchMainRegister().fetchShortcuts();
        if (shortcuts == null) {
            shortcuts = (Shortcuts)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getShortcuts());
        }
        if (shortcuts != null) {
            for (ShortcutLine detail : shortcuts.getDetails()) {
                if (!ObjectChecker.isNotEmptyOrNull((Object)detail.getScreenFieldID())) continue;
                headerFieldsShortcuts.put(KeyCodeCombination.keyCombination((String)PosShortcutsUtil.describe(detail)), detail.getScreenFieldID());
            }
        }
        return headerFieldsShortcuts;
    }

    public static void resetShortCuts() {
        userShortCuts = null;
        PosShortcutsUtil.initializeShortCuts();
    }

    static {
        try {
            PosShortcutsUtil.initializeShortCutsIfNeeded();
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        trayIconAdded = false;
    }
}

