/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.NamaText;
import com.namasoft.namacontrols.tablecells.POSTableCell;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSTotalsShowPanel;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.ItemPriceLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemCode;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSSecurityUtil;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PricesInquiryDialog
extends NamaDialog<ButtonType>
implements IHasToolBar {
    private NamaSearchBox itemField;
    private NamaTableView<ItemPriceLine> table;
    private IHasToolBar screen;
    private ObservableList<ItemPriceLine> observableArrayList;
    private ImageView imgView = new ImageView();
    private HashMap<String, IPOSFieldInfo> map = new HashMap();

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return this.map;
    }

    public PricesInquiryDialog(IHasToolBar screen) {
        super("PricesInquiry");
        this.setScreen(screen);
        PosEntryPoint.lastScreen = this;
    }

    public void draw() {
        if (POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanInquireForPrice).isFailed().booleanValue()) {
            return;
        }
        ObservableList observableArrayList = FXCollections.observableArrayList();
        this.itemField = new NamaSearchBox(POSItem.class, this, "", this.screen.fetchStage());
        this.itemField.setFromDialog(this);
        this.itemField.hideName();
        this.itemField.getCodeBox().setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                this.addLineToTable(this.itemField.getCodeBox().getText());
                this.itemField.getCodeBox().clear();
                this.itemField.requestFocus();
            }
        });
        Platform.runLater(() -> this.itemField.requestFocus());
        this.table = new NamaTableView();
        BorderPane box = new BorderPane();
        GridPane header = new GridPane();
        NamaText itemLabel = new NamaText("itemCode ", new Object[0]);
        this.setResizable(true);
        POSTableColumn itemCode = new POSTableColumn("itemCode");
        POSTableColumn itemName1 = new POSTableColumn("name1");
        POSTableColumn itemName2 = new POSTableColumn("name2");
        POSTableColumn itemPrice = new POSTableColumn("unitPrice");
        POSTableColumn itemUOM = new POSTableColumn("uom");
        POSTableColumn img = new POSTableColumn("image");
        double colWidth = this.screen.fetchScene().getWidth() / 6.5;
        itemCode.setPrefWidth(colWidth);
        itemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        itemCode.setCellFactory(POSTableCell.defaultCellFactory());
        itemCode.setEditable(false);
        itemName1.setPrefWidth(colWidth);
        itemName1.setCellValueFactory((Callback)new PropertyValueFactory("itemName1"));
        itemName1.setCellFactory(POSTableCell.defaultCellFactory());
        itemName1.setEditable(false);
        itemName2.setPrefWidth(colWidth);
        itemName2.setCellValueFactory((Callback)new PropertyValueFactory("itemName2"));
        itemName2.setCellFactory(POSTableCell.defaultCellFactory());
        itemName2.setEditable(false);
        itemPrice.setPrefWidth(colWidth);
        itemPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        itemPrice.setCellFactory(POSTableCell.stringBigDecimalConverter());
        itemUOM.setPrefWidth(colWidth);
        itemUOM.setCellValueFactory((Callback)new PropertyValueFactory("uom"));
        itemUOM.setCellFactory((Callback)new Callback<TableColumn<ItemPriceLine, POSUnit>, TableCell<ItemPriceLine, POSUnit>>(this){

            public TableCell<ItemPriceLine, POSUnit> call(TableColumn<ItemPriceLine, POSUnit> param) {
                return new POSTableCell(this){

                    public void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        this.setText(ObjectChecker.isEmptyOrNull((Object)item) ? "" : ((POSUnit)item).getCode());
                    }
                };
            }
        });
        img.setPrefWidth(colWidth);
        img.setResizable(true);
        img.setCellValueFactory((Callback)new PropertyValueFactory("imgUrl"));
        img.setCellFactory(param -> {
            TableCell<ItemPriceLine, String> cell = new TableCell<ItemPriceLine, String>(this){

                protected void updateItem(String url, boolean empty) {
                    if (ObjectChecker.isNotEmptyOrNull((Object)url)) {
                        ImageView imageview = new ImageView(new Image(url, 100.0, 50.0, true, true));
                        this.setGraphic((Node)imageview);
                    } else {
                        this.setGraphic(null);
                    }
                }
            };
            return cell;
        });
        this.table.getColumns().addAll((Object[])new TableColumn[]{itemCode, itemName1, itemName2, itemPrice, itemUOM, img});
        GridPane itemGrid = new GridPane();
        itemGrid.setHgap(10.0);
        itemGrid.add((Node)itemLabel, 0, 0);
        itemGrid.add((Node)this.itemField, 1, 0);
        header.add((Node)itemGrid, 0, 0);
        header.add((Node)this.imgView, 1, 0);
        box.setTop((Node)header);
        box.setCenter(this.table);
        this.content((Node)box);
        this.addCancelButton("");
        this.showAndWait();
        Platform.runLater(() -> this.itemField.requestFocus());
    }

    public IHasToolBar getScreen() {
        return this.screen;
    }

    public void setScreen(IHasToolBar screen) {
        this.screen = screen;
    }

    @Override
    public Node fetchPaneCenter() {
        return this.screen.fetchPaneCenter();
    }

    @Override
    public PosScene fetchScene() {
        return this.screen.fetchScene();
    }

    @Override
    public Stage fetchStage() {
        return this.screen.fetchStage();
    }

    public ObservableList<ItemPriceLine> getObservableArrayList() {
        return this.observableArrayList;
    }

    public void setObservableArrayList(ObservableList<ItemPriceLine> observableArrayList) {
        this.observableArrayList = observableArrayList;
    }

    public void addLineToTable(String code) {
        POSItemCode posItemCode = (POSItemCode)POSPersister.findByCode(POSItemCode.class, code);
        if (posItemCode != null) {
            this.addLine(posItemCode);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("searchValue", "%" + code + "%");
            List<POSItemCode> results = POSPersister.selectTop(POSItemCode.class, " where name1 like :searchValue or name2 like :searchValue", 10, params);
            for (POSItemCode itemCode : results) {
                this.addLine(itemCode);
            }
        }
    }

    private void addLine(POSItemCode posItemCode) {
        if (ObjectChecker.isEmptyOrNull((Object)posItemCode)) {
            return;
        }
        ItemPriceLine itemPriceLine = new ItemPriceLine();
        POSItem item = posItemCode.fetchItem();
        itemPriceLine.setItemCode(posItemCode.getCode());
        itemPriceLine.setItemName1((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{posItemCode.getName1(), item.getName1()}));
        itemPriceLine.setItemName2((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{posItemCode.getName2(), item.getName2()}));
        itemPriceLine.setPrice(posItemCode.getCurrentPrice());
        itemPriceLine.setUom((POSUnit)ObjectChecker.getFirstNotEmptyObj((Object[])new POSUnit[]{posItemCode.getUnit(), item.getDefaultSalesUnit()}));
        this.table.getItems().add((Object)itemPriceLine);
        ImageView itemImageView = new ImageView();
        if (ObjectChecker.isNotEmptyOrNull((Object)itemImageView)) {
            this.imgView.setImage(itemImageView.getImage());
        } else {
            this.imgView.setImage(null);
        }
        this.imgView.setFitWidth(150.0);
        this.imgView.setFitHeight(100.0);
        POSTotalsShowPanel.asyncFetchItemImageIntoView(this.imgView, item.getId().toString(), "InvItem", 250, posItemCode.getCode());
    }

    @Override
    public NamaBorderPane fetchPane() {
        return null;
    }

    @Override
    public String screenTitle() {
        return "";
    }

    @Override
    public POSIdleMonitor fetchMonitor() {
        return null;
    }

    @Override
    public String fetchScreenEntityType() {
        return null;
    }

    @Override
    public void doPostSaveAction() {
    }

    @Override
    public void fireSelectItemAction(Class<?> onKlass, TableView<POSMasterFile> table, POSMasterFile selectedItem) {
        if (onKlass == POSItem.class) {
            this.addLineToTable(selectedItem.getCode());
        }
    }

    @Override
    public BorderPaneCreator fetchPaneCreator() {
        return null;
    }
}

