/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.pos.domain.reporting.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class TinyColor {
    private static ScriptEngine scriptEngine = null;
    private static ConcurrentHashMap<String, Boolean> isDarkCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> isValidCache = new ConcurrentHashMap();

    public static boolean isDark(String color) {
        if (isDarkCache.containsKey(color)) {
            return isDarkCache.get(color);
        }
        try {
            TinyColor.createScriptEngineIfNeeded();
            boolean value = (Boolean)scriptEngine.eval("isDark('" + color + "')");
            isDarkCache.put(color, value);
            return value;
        }
        catch (Exception e) {
            isDarkCache.put(color, false);
            return false;
        }
    }

    public static boolean isValid(String color) {
        if (isValidCache.containsKey(color)) {
            return isValidCache.get(color);
        }
        try {
            TinyColor.createScriptEngineIfNeeded();
            boolean value = (Boolean)scriptEngine.eval("isValid('" + color + "')");
            isValidCache.put(color, value);
            return value;
        }
        catch (Exception e) {
            isValidCache.put(color, false);
            return false;
        }
    }

    private static void createScriptEngineIfNeeded() throws ScriptException {
        if (scriptEngine == null) {
            ScriptEngineManager mgr = new ScriptEngineManager();
            scriptEngine = mgr.getEngineByName("JavaScript");
            try (InputStream is = TinyColor.class.getClassLoader().getResourceAsStream("tinycolor.js");){
                scriptEngine.eval(FileUtils.readStream(is));
            }
            catch (IOException e) {
                NaMaLogger.error((Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws ScriptException {
        System.out.println(TinyColor.isDark("green"));
        System.out.println(TinyColor.isDark("green"));
        System.out.println(TinyColor.isDark("red"));
        System.out.println(TinyColor.isDark("black"));
        System.out.println(TinyColor.isDark("white"));
        System.out.println(TinyColor.isValid("white"));
        System.out.println(TinyColor.isValid("mai"));
    }
}

