/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.customerwindow;

import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.results.ReadAttachmentResult;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTotalsShowPanel;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.customerwindow.CustomerDisplayWindowFooterBox;
import com.namasoft.pos.application.customerwindow.CustomerDisplayWindowHeaderBox;
import com.namasoft.pos.application.customerwindow.CustomerDisplayWindowTableView;
import com.namasoft.pos.util.POSImgUtil;
import jakarta.xml.ws.WebServiceException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public class CustomerDisplayWindow
extends Stage {
    private NamaHBox root;
    private Boolean isShowing;
    private double xOffset = 0.0;
    private double yOffset = 0.0;

    public CustomerDisplayWindow(AbsPosSalesScreen mainScreen) {
        Rectangle2D visualBounds = Screen.getPrimary().getVisualBounds();
        if (Screen.getScreens().size() > 1) {
            visualBounds = ((Screen)Screen.getScreens().get(1)).getVisualBounds();
            this.setX(visualBounds.getMinX());
            this.setY(visualBounds.getMinY());
        }
        this.setOnShowing(e -> {
            this.isShowing = true;
        });
        mainScreen.getStage().sceneProperty().addListener((observable, oldScene, newScene) -> {
            if (newScene == mainScreen.getScene() && this.isShowing.booleanValue()) {
                this.show();
            } else {
                this.hide();
            }
        });
        this.root = new NamaHBox();
        this.root.setId("customer-window-root");
        this.root.getStylesheets().add((Object)((Object)((Object)this)).getClass().getClassLoader().getResource("css/customer-window.css").toExternalForm());
        this.root.setOnMousePressed(event -> {
            this.xOffset = event.getSceneX();
            this.yOffset = event.getSceneY();
        });
        this.root.setOnMouseDragged(event -> {
            this.setX(event.getScreenX() - this.xOffset);
            this.setY(event.getScreenY() - this.yOffset);
        });
        ImageView imageView = this.createImageView(visualBounds);
        if (imageView != null) {
            this.root.getChildren().add((Object)imageView);
        }
        CustomerDisplayWindowHeaderBox header = new CustomerDisplayWindowHeaderBox(mainScreen);
        CustomerDisplayWindowTableView salesTable = new CustomerDisplayWindowTableView(mainScreen, visualBounds.getWidth());
        CustomerDisplayWindowFooterBox footer = new CustomerDisplayWindowFooterBox(mainScreen, visualBounds.getWidth());
        NamaVBox content = new NamaVBox(new Node[]{header, salesTable, footer});
        content.setId("customer-window-content");
        NamaHBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
        this.root.getChildren().add((Object)content);
        Scene scene = new Scene((Parent)this.root, visualBounds.getWidth(), visualBounds.getHeight());
        scene.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.setFullScreen(!this.isFullScreen());
            }
        });
        this.initOwner((Window)POSResourcesUtil.fetchCurrentScreenStage());
        this.setMaximized(true);
        this.initStyle(StageStyle.TRANSPARENT);
        this.centerOnScreen();
        this.setScene(scene);
        this.setOnCloseRequest(e -> mainScreen.clearOnFieldChangedListeners());
    }

    private ImageView createImageView(Rectangle2D visualBounds) {
        try {
            int imgWidth = ((Double)ObjectChecker.getFirstNotEmptyObj((Object[])new Double[]{POSUISettingsUtil.getPosUISettingsOptions().getCustomerDisplayWindowImgWidth(), visualBounds.getWidth() / 3.0})).intValue();
            int imgHeight = (int)visualBounds.getHeight();
            String imageId = POSUISettingsUtil.getPosUISettingsOptions().getCustomerDisplayWindowImgId();
            Image image = POSTotalsShowPanel.fetchCachedItemImage(imageId, null, imgWidth, imgHeight);
            if (image != null) {
                return new ImageView(image);
            }
            ReadAttachmentResult readAttachmentResult = POSResourcesUtil.fetchMainRegister().readAttachment(imageId);
            if (readAttachmentResult == null || readAttachmentResult.getData() == null) {
                return null;
            }
            InputStream inputStream = readAttachmentResult.getData().getInputStream();
            image = POSImgUtil.saveImgWithNewSize(imgWidth, imgHeight, new File(POSImgUtil.fetchItemImagePathName(imageId, null, imgWidth)), ImageIO.read(inputStream));
            return new ImageView(image);
        }
        catch (NaMaServiceExcepption | WebServiceException | IOException e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    public void close() {
        this.isShowing = false;
        super.close();
    }
}

