/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.toolbar;

import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.KeyPadButton;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.PosSettingsDialog;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.application.toolbar.POSTitleBar;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import java.util.List;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class NamaToolBar
extends ToolBar
implements IPOSToolBar {
    private NamaVBox root;
    private POSTitleBar titleBar;
    private NamaHBox content;
    private IHasToolBar screen;

    public NamaToolBar(HBox box, IHasToolBar hasToolBar) {
        super(new Node[]{box});
        this.screen = hasToolBar;
    }

    public NamaToolBar(IHasToolBar hasToolBar) {
        this.createToolBar(hasToolBar);
    }

    private void createToolBar(IHasToolBar hasToolBar) {
        POSSettingsInfo configuration;
        this.setId("new-tool-bar");
        this.screen = hasToolBar;
        this.root = new NamaVBox();
        this.root.setId("tool-bar-root");
        NamaHBox.setHgrow((Node)this.root, (Priority)Priority.ALWAYS);
        this.titleBar = new POSTitleBar(hasToolBar);
        this.content = new NamaHBox();
        this.content.getStyleClass().add((Object)"tool-bar-content");
        if (ObjectChecker.isAnyEqualToFirst((Object)((Object)hasToolBar.documentType()), (Object[])new POSDocumentType[]{POSDocumentType.Payment, POSDocumentType.Receipt, POSDocumentType.Msg})) {
            this.content.getStyleClass().add((Object)"payment-receipt-msg-tool-bar-content");
        }
        if ((configuration = POSSettingsInfo.fetchConfiguration()) == null) {
            return;
        }
        this.refreshLangBox(false);
        if (!(hasToolBar instanceof PosEntryPoint)) {
            if (POSSecurityUtil.userCan(POSSecurityCapability.CanRePrintDocuments).isSucceeded().booleanValue()) {
                NamaButton rePrint = new NamaButton();
                rePrint.setTooltip(new POSTooltip("rePrintDocument"));
                rePrint.setSVGIcon("Print.svg");
                rePrint.setOnAction(action -> NamaToolBar.reprintDocumentAction(this.screen));
                this.content.getChildren().add((Object)rePrint);
            }
            KeyPadButton logoutBtn = new KeyPadButton("");
            logoutBtn.setSVGIcon("logout.svg");
            logoutBtn.setTooltip(new POSTooltip("logout"));
            logoutBtn.setOnAction(event -> {
                if (PosScene.continueWithoutSaving(event, null)) {
                    hasToolBar.fetchPaneCreator().exitToLoginScreen(hasToolBar.fetchStage());
                } else {
                    event.consume();
                }
            });
            this.content.getChildren().add((Object)logoutBtn);
            NamaButton openDocBtn = new NamaButton();
            openDocBtn.setTooltip(new POSTooltip("showDocument"));
            openDocBtn.setSVGIcon("select.svg");
            openDocBtn.setOnAction(e -> {
                if (POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanOpenOldInvoice).isFailed().booleanValue()) {
                    return;
                }
                Object document = hasToolBar.document();
                NamaSearchBox openDocSearch = new NamaSearchBox(document.getClass(), hasToolBar, "", hasToolBar.fetchStage(), true, true);
                openDocSearch.getSearchBtn().fire();
            });
            this.content.getChildren().add((Object)openDocBtn);
            KeyPadButton settingsBtn = new KeyPadButton("");
            settingsBtn.setTooltip(new POSTooltip("settings"));
            settingsBtn.setSVGIcon("settings.svg");
            settingsBtn.setAlignment(Pos.CENTER);
            settingsBtn.setOnAction(e -> {
                POSResult result = POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanEditSettings);
                if (!result.isFailed().booleanValue()) {
                    Platform.runLater(() -> new PosSettingsDialog(hasToolBar).showSettingsDialog());
                }
            });
            this.content.getChildren().add((Object)settingsBtn);
            NamaButton reSendAll = new NamaButton();
            reSendAll.setTooltip(new POSTooltip("sendAll"));
            reSendAll.setSVGIcon("transfer.svg");
            reSendAll.setOnAction(action -> NamaToolBar.resendAllAction(hasToolBar));
            this.content.getChildren().add((Object)reSendAll);
            if ("1".equals(POSGeneralSettings.getProperty((String)"showFixDates"))) {
                NamaButton resetInvoiceTime = new NamaButton();
                resetInvoiceTime.setTooltip(new POSTooltip("resetInvoiceTime"));
                resetInvoiceTime.setSVGIcon("resetTime.svg");
                resetInvoiceTime.setOnAction(action -> {
                    String query = " where hold = false and sent = false";
                    List<?> invoices = POSPersister.listAll(POSSalesInvoice.class, query);
                    List<?> returns = POSPersister.listAll(POSSalesReturn.class, query);
                    List<?> replacements = POSPersister.listAll(POSSalesReplacement.class, query);
                    AbsPosSalesScreen.updateSalesDocsValueDate(invoices);
                    AbsPosSalesScreen.updateSalesDocsValueDate(returns);
                    AbsPosSalesScreen.updateSalesDocsValueDate(replacements);
                });
                this.content.getChildren().add((Object)resetInvoiceTime);
            }
        }
        NamaButton changeLanguage = new NamaButton();
        changeLanguage.setOnAction(event -> POSResourcesUtil.changeLanguage(POSResourcesUtil.currentScreen));
        changeLanguage.setSVGIcon("language.svg");
        changeLanguage.setTooltip(new POSTooltip(POSResourcesUtil.isArabic() ? "English" : "Arabic"));
        this.content.getChildren().add((Object)changeLanguage);
        this.content.getChildren().forEach(child -> {
            Labeled l;
            if (child instanceof Labeled && (l = (Labeled)child).getGraphic() != null) {
                l.setId("has-icon");
            }
        });
        this.root.getChildren().addAll((Object[])new Node[]{this.titleBar, this.content});
        this.getItems().add((Object)this.root);
        POSSettingsUtil.addStyleSheetFor("css/toolbar.css", (Parent)this);
    }

    public static void reprintDocumentAction(IHasToolBar screen) {
        NamaToolBar.reprintDocumentAction(screen, null);
    }

    public static void reprintDocumentAction(IHasToolBar screen, POSMasterFile document) {
        if (ObjectChecker.isEmptyOrNull((Object)document)) {
            document = screen.document();
        }
        if (document == null) {
            NamaToolBar.printLastDocument(screen);
            return;
        }
        if (ObjectChecker.isTrue((Boolean)document.getComitBefore())) {
            POSReportDefinition.printForm(POSResourcesUtil.fetchMainRegister(), document, (Callback<Void>)((Callback)c -> Platform.runLater(() -> screen.doPostSaveAction())));
        } else if (document.userEnteredData()) {
            POSResult posResult = new POSResult();
            posResult.failure("You must save document first", new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(posResult, screen.fetchStage());
        } else {
            NamaToolBar.printLastDocument(screen);
        }
    }

    private static void printLastDocument(IHasToolBar screen) {
        Boolean printLastDoc = POSResourcesUtil.fetchPOSConfig().getPrintLastDocIfNoCurrentOpenDoc();
        if (ObjectChecker.isFalseOrNull((Boolean)printLastDoc)) {
            return;
        }
        String extraExpression = POSDataWriterUtil.calcExtraExpression(screen.fetchScreenKlass());
        List<?> list = POSPersister.selectTop(screen.fetchScreenKlass(), " where 1=1 " + extraExpression, 1, " desc ", POSPersister.params(new Object[0]), "valueDate", "code");
        if (ObjectChecker.isEmptyOrNull(list)) {
            return;
        }
        POSMasterFile lastDocument = (POSMasterFile)list.getFirst();
        if (lastDocument != null) {
            lastDocument.setOldDoc(true);
        }
        NamaToolBar.reprintDocumentAction(screen, lastDocument);
    }

    public static void resendAllAction(IHasToolBar hasToolBar) {
        if (POSGeneralSettings.canWriteData()) {
            if (POSResourcesUtil.noDataToSend()) {
                POSResult posResult = new POSResult();
                posResult.failure("No Data to send", new Object[0]);
                POSErrorAndInfoMessagesUtil.showError(posResult, hasToolBar.fetchStage());
            } else {
                POSDataWriterUtil.writeData(POSResourcesUtil.fetchMainRegister());
            }
        }
    }

    @Override
    public void refreshLangBox(boolean toLoginScreen) {
        if (toLoginScreen) {
            this.getItems().clear();
        }
    }

    @Override
    public <T extends POSMasterFile> void updateInformation(T doc) {
        this.titleBar.refresh();
    }

    @Override
    public void resetElapsedTimeFromLastConnection() {
        this.titleBar.resetElapsedTimeFromLastConnection();
    }
}

