/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.toolbar;

import com.namasoft.common.NamaSingleValue;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.modules.namapos.enums.POSProcedures;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.KeyPadButton;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSMenuButton;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSlideMenu;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.customerwindow.CustomerDisplayWindow;
import com.namasoft.pos.application.toolbar.NamaToolBar;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.POSFavProcedureLine;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.PosSalesUtil;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.stage.Screen;

public class POSSalesScreenButtonsBox
extends NamaHBox {
    private NamaButton removeDiscsBtn;
    private NamaButton removeTaxesBtn;
    private NamaButton openDocumentBtn;
    private NamaButton logoutBtn;
    private NamaButton rePrint;
    private NamaButton changeLanguage;
    private NamaButton paymentsDetails;
    private NamaButton deleteBtn;
    private NamaButton printFullBtn;
    private NamaButton addServiceItemBtn;
    private NamaButton addDeliveryItemBtn;
    private NamaButton updateSalesManBtn;
    private KeyPadButton customerDisplayWindow;
    private Map<String, KeyPadButton> procedureBtns = new HashMap<String, KeyPadButton>();

    public POSSalesScreenButtonsBox() {
        this.setSpacing(3.0);
    }

    public void createButtonsBox(IHasToolBar hasToolBar) {
        this.rePrint = new NamaButton();
        this.rePrint.setTooltip(new POSTooltip("rePrintDocument"));
        this.rePrint.setSVGIcon("print.svg");
        this.rePrint.setOnAction(action -> NamaToolBar.reprintDocumentAction(hasToolBar));
        this.paymentsDetails = new NamaButton();
        this.paymentsDetails.setTooltip(new POSTooltip("showPaymentsDetails"));
        this.paymentsDetails.setDisable(POSSecurityUtil.userCan(POSSecurityCapability.CanShowPaymentsDetails).isFailed());
        this.paymentsDetails.setOnAction(e -> {
            if (hasToolBar instanceof AbsPosSalesScreen) {
                ((AbsPosSalesScreen)hasToolBar).showPaymentsDetails();
            }
        });
        this.paymentsDetails.setSVGIcon("multi_payment.svg");
        this.changeLanguage = new NamaButton();
        this.changeLanguage.setOnAction(event -> {
            POSResourcesUtil.changeLanguage(hasToolBar);
            String langBtnTooltip = POSResourcesUtil.isArabic() ? "English" : "Arabic";
            this.changeLanguage.setTooltip(new POSTooltip(langBtnTooltip));
        });
        String langBtnTooltip = POSResourcesUtil.isArabic() ? POSResourcesUtil.id("English", new Object[0]) : POSResourcesUtil.id("Arabic", new Object[0]);
        this.changeLanguage.setSVGIcon("language.svg");
        this.changeLanguage.setTooltip(new POSTooltip(langBtnTooltip));
        this.removeDiscsBtn = new NamaButton();
        this.printFullBtn = new NamaButton();
        this.printFullBtn.setSVGIcon("PrintFInv.svg");
        this.printFullBtn.setTooltip(new POSTooltip("printFullInvoice"));
        this.printFullBtn.setOnAction(e -> {
            if (!(hasToolBar instanceof AbsPosSalesScreen)) {
                return;
            }
            AbsPOSSales salesDoc = ((AbsPosSalesScreen)hasToolBar).getSalesDoc();
            if (ObjectChecker.isTrue((Boolean)salesDoc.getHold()) && POSSecurityUtil.checkIfHasCapability(hasToolBar, salesDoc, POSSecurityCapability.CanPrintHeldInvoice).isFailed().booleanValue()) {
                return;
            }
            if (ObjectChecker.isFalseOrNull((Boolean)salesDoc.getComitBefore())) {
                POSResult posResult = new POSResult();
                posResult.failure("You must save document first", new Object[0]);
                POSErrorAndInfoMessagesUtil.showError(posResult, hasToolBar.fetchStage());
                return;
            }
            POSReportDefinition.printFullForm(POSResourcesUtil.fetchMainRegister(), salesDoc, (Callback<Void>)Callback.NULL);
            hasToolBar.doPostSaveAction();
        });
        this.openDocumentBtn = new NamaButton("");
        this.openDocumentBtn.setTooltip(new POSTooltip("showDocument"));
        this.openDocumentBtn.setSVGIcon("select.svg");
        this.logoutBtn = new NamaButton("");
        this.logoutBtn.setTooltip(new POSTooltip("exit"));
        this.logoutBtn.setSVGIcon("logout.svg");
        this.logoutBtn.setOnAction(event -> {
            if (PosScene.continueWithoutSaving(event, hasToolBar)) {
                hasToolBar.fetchPaneCreator().exitToLoginScreen(hasToolBar.fetchStage());
            } else {
                event.consume();
            }
        });
        this.removeDiscsBtn.setTooltip(new POSTooltip("Remove Discounts"));
        this.removeDiscsBtn.setSVGIcon("remDisc.svg");
        this.removeTaxesBtn = new NamaButton();
        this.removeTaxesBtn.setTooltip(new POSTooltip("Remove Taxes"));
        this.removeTaxesBtn.setSVGIcon("remTax.svg");
        Boolean canRemoveDiscs = ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{POSSecurityUtil.userCan(POSSecurityCapability.CanMakeLineDisc).isFailed(), POSSecurityUtil.userCan(POSSecurityCapability.CanCancelTaxes).isFailed()});
        this.removeDiscsBtn.setDisable(canRemoveDiscs);
        Boolean canRemoveTaxes = ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{POSSecurityUtil.userCan(POSSecurityCapability.CanMakeLineTaxes).isFailed(), POSSecurityUtil.userCan(POSSecurityCapability.CanCancelTaxes).isFailed()});
        this.removeTaxesBtn.setDisable(canRemoveTaxes);
        this.deleteBtn = new NamaButton();
        this.deleteBtn.setTooltip(new POSTooltip("Discard"));
        this.deleteBtn.setSVGIcon("removeDoc.svg");
        this.deleteBtn.setDisable(POSSecurityUtil.userCan(POSSecurityCapability.CanDeleteHold).isFailed());
        this.deleteBtn.setOnAction(e -> AbsPosSalesScreen.deleteAction(e, (AbsPosSalesScreen)hasToolBar));
        this.rePrint.setDisable(POSSecurityUtil.userCan(POSSecurityCapability.CanRePrintDocuments).isFailed());
        this.removeDiscsBtn.setOnAction(e -> ((AbsPosSalesScreen)hasToolBar).removeDiscountsAction());
        this.removeTaxesBtn.setOnAction(e -> ((AbsPosSalesScreen)hasToolBar).removeTaxesAction());
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanOpenOldInvoice).isFailed().booleanValue()) {
            this.openDocumentBtn.setDisable(true);
        }
        this.openDocumentBtn.setOnAction(e -> ((AbsPosSalesScreen)hasToolBar).openDocumentAction());
        this.getChildren().addAll((Object[])new Node[]{this.removeDiscsBtn, this.printFullBtn, this.rePrint, this.deleteBtn, this.logoutBtn, this.paymentsDetails, this.removeTaxesBtn, this.openDocumentBtn, this.changeLanguage});
        this.addServiceItemBtn = new NamaButton("");
        this.addServiceItemBtn.setTooltip(new POSTooltip("addServiceItem"));
        this.addServiceItemBtn.setOnAction(e -> {
            AbsPosSalesScreen screen = (AbsPosSalesScreen)hasToolBar;
            POSResult result = PosSalesUtil.addServiceItemToInvoice(screen, screen.getSalesDoc(), new POSResult());
            if (result.isFailed().booleanValue()) {
                POSErrorAndInfoMessagesUtil.showError(result, screen.fetchStage());
            }
        });
        this.addServiceItemBtn.setSVGIcon("serviceCharge.svg");
        this.addServiceItemBtn.setPadding(new Insets(5.0));
        if (AbsPOSSales.fetchServiceItem() != null) {
            this.getChildren().add((Object)this.addServiceItemBtn);
        }
        this.addDeliveryItemBtn = new NamaButton("");
        this.addDeliveryItemBtn.setTooltip(new POSTooltip("addDeliveryItem"));
        this.addDeliveryItemBtn.setOnAction(e -> {
            AbsPosSalesScreen screen = (AbsPosSalesScreen)hasToolBar;
            POSResult result = PosSalesUtil.addDeliveryItemToInvoice(screen, screen.getSalesDoc(), new POSResult());
            if (result.isFailed().booleanValue()) {
                POSErrorAndInfoMessagesUtil.showError(result, screen.fetchStage());
            }
        });
        this.addDeliveryItemBtn.setSVGIcon("delivery.svg");
        this.addDeliveryItemBtn.setPadding(new Insets(5.0));
        if (AbsPOSSales.fetchDeliveryItem() != null) {
            this.getChildren().add((Object)this.addDeliveryItemBtn);
        }
        if (POSSecurityUtil.userCan(POSSecurityCapability.AllowSalesmanUpdate).isSucceeded().booleanValue()) {
            this.updateSalesManBtn = new NamaButton("");
            this.updateSalesManBtn.setTooltip(new POSTooltip("updateSalesMan"));
            this.updateSalesManBtn.setOnAction(e -> ((AbsPosSalesScreen)hasToolBar).updateSalesMan());
            this.updateSalesManBtn.setSVGIcon("employeeExchange.svg");
            this.updateSalesManBtn.setPadding(new Insets(5.0));
            this.getChildren().add((Object)this.updateSalesManBtn);
        }
        this.getChildren().forEach(b -> b.setId("has-icon"));
        if (Screen.getScreens().size() > 1) {
            this.customerDisplayWindow = new KeyPadButton("customerDisplayWindow");
            this.customerDisplayWindow.setId("pcrocedureBtn");
            NamaSingleValue namaSingleValue = new NamaSingleValue(null);
            this.customerDisplayWindow.setOnAction(e -> {
                if (ObjectChecker.isFalseOrNull((Boolean)(hasToolBar instanceof AbsPosSalesScreen))) {
                    return;
                }
                CustomerDisplayWindow value = (CustomerDisplayWindow)((Object)((Object)namaSingleValue.getValue()));
                if (value == null) {
                    namaSingleValue.setValue((Object)new CustomerDisplayWindow((AbsPosSalesScreen)hasToolBar));
                    value = (CustomerDisplayWindow)((Object)((Object)namaSingleValue.getValue()));
                }
                if (value.isShowing()) {
                    value.close();
                } else {
                    value.show();
                }
            });
            this.getChildren().add((Object)this.customerDisplayWindow);
        }
        POSSlideMenu slideMenu = new POSSlideMenu(hasToolBar);
        for (POSFavProcedureLine procedure : POSUISettingsUtil.posUISettings.getProcedures()) {
            POSMenuButton posMenuButton;
            if (ObjectChecker.areEqual((Object)procedure.getPosProcedure(), (Object)POSProcedures.FixLineNumbers) && !ServiceLoginProvider.getTrackLogs() || ObjectChecker.isFalseOrNull((Boolean)(posMenuButton = slideMenu.getActionsMap().get(POSProcedures.valueOf((String)procedure.getPosProcedure()))).canBeAddedToMenu())) continue;
            KeyPadButton btn = new KeyPadButton(procedure.getPosProcedure());
            btn.setId("procedureBtn");
            btn.setOnAction(e -> posMenuButton.getOnAction().handle(e));
            this.getChildren().add((Object)btn);
            this.procedureBtns.put(procedure.getPosProcedure(), btn);
        }
    }
}

