/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.toolbar;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.details.DTOPOSConfigFavouriteDocLine;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.pos.application.FavouriteDocBtn;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.details.POSRegisteryFavouriteDocLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Priority;

public class POSToolbarFavouriteDocsBox
extends NamaHBox {
    public POSToolbarFavouriteDocsBox(IHasToolBar hasToolBar) {
        NamaHBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.constructFavDocsBox(hasToolBar);
    }

    private void constructFavDocsBox(IHasToolBar hasToolBar) {
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        if (posRegistery == null) {
            return;
        }
        List favouriteDocs = posRegistery.getFavouriteDocs();
        List configFavouriteDocs = POSResourcesUtil.fetchPOSConfig().getFavouriteDocs();
        if (ObjectChecker.isEmptyOrNull(favouriteDocs) && ObjectChecker.isNotEmptyOrNull((Object)configFavouriteDocs)) {
            favouriteDocs = CollectionsUtility.convert((Collection)configFavouriteDocs, object -> new POSRegisteryFavouriteDocLine((DTOPOSConfigFavouriteDocLine)object));
        }
        if (ObjectChecker.isEmptyOrNull(favouriteDocs)) {
            return;
        }
        Double favDocW = ObjectChecker.getFirstNotEmptyOrZero((Double[])new Double[]{POSUISettingsUtil.getPosUISettingsOptions().getFavouriteDocBtnWidth(), 100.0});
        Double favDocH = ObjectChecker.getFirstNotEmptyOrZero((Double[])new Double[]{POSUISettingsUtil.getPosUISettingsOptions().getFavouriteDocBtnHeight(), 50.0});
        for (POSRegisteryFavouriteDocLine favouriteDocLine : favouriteDocs) {
            this.getChildren().add((Object)new FavouriteDocBtn(favouriteDocLine, favDocW, favDocH, (POSNewSalesScreen)hasToolBar));
        }
    }

    public void refresh() {
        this.getChildren().forEach(child -> {
            if (child instanceof FavouriteDocBtn) {
                FavouriteDocBtn favBtn = (FavouriteDocBtn)child;
                favBtn.refreshContent();
            }
        });
    }
}

