/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.controllers;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.DTOPageData;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesInvoice;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.controllers.MobilePOSResult;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.util.POSResult;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InvoicesController {
    @GetMapping(value={"/invoice/"})
    public DTONamaPOSSalesInvoice fetchHeldInvoices(@RequestParam(name="customerCode") String customerCode, @RequestParam(name="invoiceCode") String invoiceCode) {
        List salesInvoices;
        Object basicQuery = "SELECT inv FROM POSSalesInvoice inv WHERE hold = true ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (ObjectChecker.isNotEmptyOrNull((Object)invoiceCode)) {
            basicQuery = (String)basicQuery + " AND code =:invCode ";
            parameters.put("invCode", invoiceCode);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)customerCode)) {
            basicQuery = (String)basicQuery + " AND (inv.customer.code=:customerCode OR inv.customer.phoneNumber=:customerCode) ";
            parameters.put("customerCode", customerCode);
        }
        if (ObjectChecker.isEmptyOrNull(salesInvoices = POSPersister.searchFor((String)basicQuery, parameters, DTOPageData.all()))) {
            return null;
        }
        return ((POSSalesInvoice)salesInvoices.getFirst()).toDTO();
    }

    @PostMapping(value={"/invoices/{invoiceId}"})
    public MobilePOSResult deleteHeldInvoice(@PathVariable(name="invoiceId") String invoiceId) {
        POSSalesInvoice salesInvoice = POSPersister.findByID(POSSalesInvoice.class, invoiceId);
        if (salesInvoice == null) {
            return null;
        }
        POSResult result = POSPersister.delete(salesInvoice);
        return new MobilePOSResult().fromNormalResult(result, null);
    }
}

