/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.controllers;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.controllers.MobileDTOInvTableLine;
import com.namasoft.pos.controllers.MobileDTOInvoiceLine;
import com.namasoft.pos.controllers.MobileInvoicesController;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSTable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class MobileDTOInvoice
implements Serializable {
    private UUID id;
    private String code;
    private String entityType;
    private EntityReferenceData invClassification;
    private EntityReferenceData customer;
    private EntityReferenceData salesMan;
    private EntityReferenceData table;
    private BigDecimal netPrice;
    private BigDecimal totalPrice;
    private String valueDate;
    private String valueTime;
    private BigDecimal discountPercent;
    private BigDecimal discountValue;
    private List<MobileDTOInvoiceLine> lines;
    private List<MobileDTOInvTableLine> tables;
    private boolean paid;
    private String description1;
    private String remarks;
    private MobileDTOInvoiceLine lastModifiedLine;

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public boolean isPaid() {
        return this.paid;
    }

    public void setPaid(boolean paid) {
        this.paid = paid;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getValueTime() {
        return this.valueTime;
    }

    public void setValueTime(String valueTime) {
        this.valueTime = valueTime;
    }

    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public BigDecimal getDiscountValue() {
        return this.discountValue;
    }

    public void setDiscountValue(BigDecimal discountValue) {
        this.discountValue = discountValue;
    }

    public String getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(String valueDate) {
        this.valueDate = valueDate;
    }

    public EntityReferenceData getCustomer() {
        return this.customer;
    }

    public void setCustomer(EntityReferenceData customer) {
        this.customer = customer;
    }

    public EntityReferenceData getSalesMan() {
        return this.salesMan;
    }

    public void setSalesMan(EntityReferenceData salesMan) {
        this.salesMan = salesMan;
    }

    public BigDecimal getNetPrice() {
        return this.netPrice;
    }

    public void setNetPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public List<MobileDTOInvoiceLine> getLines() {
        return this.lines;
    }

    public void setLines(List<MobileDTOInvoiceLine> lines) {
        this.lines = lines;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public EntityReferenceData getInvClassification() {
        return this.invClassification;
    }

    public void setInvClassification(EntityReferenceData invClassification) {
        this.invClassification = invClassification;
    }

    public List<MobileDTOInvTableLine> getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList<MobileDTOInvTableLine>();
        }
        return this.tables;
    }

    public void setTables(List<MobileDTOInvTableLine> tables) {
        this.tables = tables;
    }

    public String getDescription1() {
        return this.description1;
    }

    public void setDescription1(String description1) {
        this.description1 = description1;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public MobileDTOInvoiceLine getLastModifiedLine() {
        return this.lastModifiedLine;
    }

    public void setLastModifiedLine(MobileDTOInvoiceLine lastModifiedLine) {
        this.lastModifiedLine = lastModifiedLine;
    }

    public MobileDTOInvoice fromNormalInvoice(POSSalesInvoice salesInvoice) {
        POSInvoiceClassification invoiceClassification = salesInvoice.getPosInvoiceClassification();
        POSCustomer customer = salesInvoice.getCustomer();
        POSEmployee salesMan = salesInvoice.getSalesMan();
        POSTable table = salesInvoice.getTable();
        this.updateNulls();
        if (ObjectChecker.isNotEmptyOrNull((Object)invoiceClassification)) {
            this.setInvClassification(new EntityReferenceData(invoiceClassification.calcNamaEntityType(), ServerStringUtils.toUUIDStr((Object)invoiceClassification.id), invoiceClassification.getCode(), invoiceClassification.getCode(), invoiceClassification.getCode(), invoiceClassification.getName1(), invoiceClassification.getName2()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)customer)) {
            this.setCustomer(customer.toEntityReferenceData());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)salesMan)) {
            this.setSalesMan(salesMan.toEntityReferenceData());
        } else if (ObjectChecker.isNotEmptyOrNull((Object)salesInvoice.getCurrentUser())) {
            this.setSalesMan(salesInvoice.getCurrentUser().toEntityReferenceData());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)table)) {
            this.setTable(table.toEntityReferenceData());
        }
        this.setCode(salesInvoice.getCode());
        this.setId(salesInvoice.getId());
        this.setEntityType(salesInvoice.calcNamaEntityType());
        this.setNetPrice(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoice.getNetPrice()));
        this.setTotalPrice(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoice.getTotalPrice()));
        if (salesInvoice.getValueDate() != null) {
            this.setValueDate(MobileInvoicesController.DATE_FORMAT.format(salesInvoice.getValueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()));
        }
        if (salesInvoice.getValueTime() != null) {
            this.setValueTime(MobileInvoicesController.TIME_FORMAT.format(salesInvoice.getValueTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()));
        }
        this.setDiscountPercent(salesInvoice.getDiscountPercent());
        this.setDiscountValue(salesInvoice.getDiscountValue());
        this.setDescription1(salesInvoice.getDescription1());
        this.setRemarks(salesInvoice.getRemarks());
        this.setPaid(salesInvoice.isOldPaidInvoice());
        this.setLastModifiedLine(MobileDTOInvoiceLine.fromNormalLine((POSSalesInvoiceLine)salesInvoice.getLastModifiedLine()));
        if (ObjectChecker.isNotEmptyOrNull(salesInvoice.getDetails())) {
            this.getLines().addAll(salesInvoice.getDetails().stream().map(MobileDTOInvoiceLine::fromNormalLine).collect(Collectors.toList()));
        }
        if (ObjectChecker.isNotEmptyOrNull(salesInvoice.getTableLines())) {
            this.getTables().addAll(salesInvoice.getTableLines().stream().map(MobileDTOInvTableLine::fromNormalLine).collect(Collectors.toList()));
        }
        return this;
    }

    public EntityReferenceData getTable() {
        return this.table;
    }

    public void setTable(EntityReferenceData table) {
        this.table = table;
    }

    public void updateNulls() {
        this.setInvClassification(null);
        this.setCustomer(null);
        this.setSalesMan(null);
        this.setLines(new ArrayList<MobileDTOInvoiceLine>());
        this.setTable(null);
    }

    public POSSalesInvoice toActualInvoice() {
        POSSalesInvoice salesInvoice = null;
        try {
            List<MobileDTOInvTableLine> tables;
            salesInvoice = POSPersister.findByID(POSSalesInvoice.class, this.getId());
            if (salesInvoice == null) {
                salesInvoice = new POSSalesInvoice();
            }
            salesInvoice.setCode(this.getCode());
            salesInvoice.setId(this.getId());
            if (ObjectChecker.isNotEmptyOrNull((Object)this.getInvClassification())) {
                salesInvoice.setPosInvoiceClassification(POSPersister.findByID(POSInvoiceClassification.class, this.getInvClassification().getId()));
            }
            if (this.getCustomer() != null) {
                if (ObjectChecker.isNotEmptyOrNull((Object)this.getCustomer().getId())) {
                    salesInvoice.setCustomer(POSPersister.findByID(POSCustomer.class, this.getCustomer().getId()));
                } else if (ObjectChecker.isNotEmptyOrNull((Object)this.getCustomer().getCode())) {
                    salesInvoice.setCustomer((POSCustomer)POSPersister.findByCode(POSCustomer.class, this.getCustomer().getCode()));
                }
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)this.getSalesMan())) {
                salesInvoice.setSalesMan(POSPersister.findByID(POSEmployee.class, this.getSalesMan().getId()));
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)this.getTable())) {
                salesInvoice.setTable(POSPersister.findByID(POSTable.class, this.getTable().getId()));
            }
            salesInvoice.setNetPrice(this.getNetPrice());
            salesInvoice.setTotalPrice(this.getTotalPrice());
            salesInvoice.setValueDate(MobileInvoicesController.parseDate(this.getValueDate()));
            salesInvoice.setValueTime(MobileInvoicesController.parseTime(this.getValueTime()));
            salesInvoice.setDiscountPercent(this.getDiscountPercent());
            salesInvoice.setDiscountValue(this.getDiscountValue());
            salesInvoice.setDescription1(this.getDescription1());
            salesInvoice.setRemarks(this.getRemarks());
            List<MobileDTOInvoiceLine> lines = this.getLines();
            if (ObjectChecker.isNotEmptyOrNull(lines)) {
                salesInvoice.getDetails().clear();
                for (MobileDTOInvoiceLine m : lines) {
                    salesInvoice.getDetails().add(m.toActualInvoiceLine(salesInvoice));
                }
            }
            if (ObjectChecker.isNotEmptyOrNull(tables = this.getTables())) {
                salesInvoice.getTableLines().clear();
                for (MobileDTOInvTableLine m : tables) {
                    salesInvoice.getTableLines().add(m.toActualInvTableLine(salesInvoice));
                }
            }
            salesInvoice.setFromCaptainOrder(true);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return salesInvoice;
    }
}

