/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.controllers;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class MobileDTOInvoiceLine
implements Serializable {
    private UUID id;
    private String itemCode;
    private String itemId;
    private String itemName1;
    private String itemName2;
    private String uomCode;
    private String uomId;
    private String uomName1;
    private String uomName2;
    private String itemImageAsBase64;
    private BigDecimal qty;
    private BigDecimal unitPrice;
    private BigDecimal totalPrice;
    private BigDecimal disc1Percent;
    private BigDecimal disc2Percent;
    private BigDecimal disc1Val;
    private BigDecimal disc2Val;
    private BigDecimal tax1Percent;
    private BigDecimal tax1Val;
    private BigDecimal tax2Percent;
    private BigDecimal tax2Val;
    private BigDecimal netPrice;
    private Boolean freeLine;
    private UUID masterRowId;
    private String revisionId;
    private String colorCode;
    private String colorName;
    private String sizeCode;
    private String sizeName;
    private String warehouseIssueMethod;
    private String itemActualCode;
    private String remarks;
    private Date prepFormPrintDate;
    private Boolean deactivateEmpDiscountsValidations;

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getUomName1() {
        return this.uomName1;
    }

    public void setUomName1(String uomName1) {
        this.uomName1 = uomName1;
    }

    public String getUomName2() {
        return this.uomName2;
    }

    public void setUomName2(String uomName2) {
        this.uomName2 = uomName2;
    }

    public String getItemName2() {
        return this.itemName2;
    }

    public void setItemName2(String itemName2) {
        this.itemName2 = itemName2;
    }

    public String getItemName1() {
        return this.itemName1;
    }

    public void setItemName1(String itemName1) {
        this.itemName1 = itemName1;
    }

    public String getItemImageAsBase64() {
        return this.itemImageAsBase64;
    }

    public void setItemImageAsBase64(String itemImageAsBase64) {
        this.itemImageAsBase64 = itemImageAsBase64;
    }

    public String getUomId() {
        return this.uomId;
    }

    public void setUomId(String uomId) {
        this.uomId = uomId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public String getSizeCode() {
        return this.sizeCode;
    }

    public void setSizeCode(String sizeCode) {
        this.sizeCode = sizeCode;
    }

    public String getSizeName() {
        return this.sizeName;
    }

    public void setSizeName(String sizeName) {
        this.sizeName = sizeName;
    }

    public String getUomCode() {
        return this.uomCode;
    }

    public void setUomCode(String uomCode) {
        this.uomCode = uomCode;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getDisc1Percent() {
        return this.disc1Percent;
    }

    public void setDisc1Percent(BigDecimal disc1Percent) {
        this.disc1Percent = disc1Percent;
    }

    public BigDecimal getDisc2Percent() {
        return this.disc2Percent;
    }

    public void setDisc2Percent(BigDecimal disc2Percent) {
        this.disc2Percent = disc2Percent;
    }

    public BigDecimal getDisc1Val() {
        return this.disc1Val;
    }

    public void setDisc1Val(BigDecimal disc1Val) {
        this.disc1Val = disc1Val;
    }

    public BigDecimal getDisc2Val() {
        return this.disc2Val;
    }

    public void setDisc2Val(BigDecimal disc2Val) {
        this.disc2Val = disc2Val;
    }

    public BigDecimal getTax1Percent() {
        return this.tax1Percent;
    }

    public void setTax1Percent(BigDecimal tax1Percent) {
        this.tax1Percent = tax1Percent;
    }

    public BigDecimal getTax1Val() {
        return this.tax1Val;
    }

    public void setTax1Val(BigDecimal tax1Val) {
        this.tax1Val = tax1Val;
    }

    public BigDecimal getTax2Percent() {
        return this.tax2Percent;
    }

    public void setTax2Percent(BigDecimal tax2Percent) {
        this.tax2Percent = tax2Percent;
    }

    public BigDecimal getTax2Val() {
        return this.tax2Val;
    }

    public void setTax2Val(BigDecimal tax2Val) {
        this.tax2Val = tax2Val;
    }

    public BigDecimal getNetPrice() {
        return this.netPrice;
    }

    public void setNetPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
    }

    public Boolean getFreeLine() {
        return this.freeLine;
    }

    public void setFreeLine(Boolean freeLine) {
        this.freeLine = freeLine;
    }

    public UUID getMasterRowId() {
        return this.masterRowId;
    }

    public void setMasterRowId(UUID masterRowId) {
        this.masterRowId = masterRowId;
    }

    public String getWarehouseIssueMethod() {
        return this.warehouseIssueMethod;
    }

    public void setWarehouseIssueMethod(String warehouseIssueMethod) {
        this.warehouseIssueMethod = warehouseIssueMethod;
    }

    public String getItemActualCode() {
        return this.itemActualCode;
    }

    public void setItemActualCode(String itemActualCode) {
        this.itemActualCode = itemActualCode;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getPrepFormPrintDate() {
        return this.prepFormPrintDate;
    }

    public void setPrepFormPrintDate(Date prepFormPrintDate) {
        this.prepFormPrintDate = prepFormPrintDate;
    }

    public Boolean getDeactivateEmpDiscountsValidations() {
        return this.deactivateEmpDiscountsValidations;
    }

    public void setDeactivateEmpDiscountsValidations(Boolean deactivateEmpDiscountsValidations) {
        this.deactivateEmpDiscountsValidations = deactivateEmpDiscountsValidations;
    }

    public static MobileDTOInvoiceLine fromNormalLine(POSSalesInvoiceLine salesInvoiceLine) {
        POSItemSpecificDimensions itemDimensions;
        if (salesInvoiceLine == null) {
            return null;
        }
        MobileDTOInvoiceLine line = new MobileDTOInvoiceLine();
        line.updateNulls();
        line.setItemCode(salesInvoiceLine.getItemCode());
        line.setItemActualCode(salesInvoiceLine.getItemActualCode());
        line.setId(salesInvoiceLine.getId());
        if (ObjectChecker.isNotEmptyOrNull((Object)salesInvoiceLine.getItem())) {
            line.setItemId(ServerStringUtils.toUUIDStr((Object)salesInvoiceLine.getItem().getId()));
            line.setItemName1(salesInvoiceLine.getItem().getName1());
            line.setItemName2(salesInvoiceLine.getItem().getName2());
            line.setItemImageAsBase64(salesInvoiceLine.getItemImageAsBase64());
        }
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{salesInvoiceLine.getQty()})) {
            line.setQty(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getQty().getValue()));
            if (ObjectChecker.isNotEmptyOrNull((Object)salesInvoiceLine.getQty().getUom())) {
                line.setUomCode(salesInvoiceLine.getQty().getUom().getCode());
                line.setUomId(ServerStringUtils.toUUIDStr((Object)salesInvoiceLine.getQty().getUom().getId()));
                line.setUomName1(salesInvoiceLine.getQty().getUom().getName1());
                line.setUomName2(salesInvoiceLine.getQty().getUom().getName2());
            }
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)(itemDimensions = salesInvoiceLine.getItemDimensions()))) {
            line.setRevisionId(itemDimensions.getRevisionId());
            line.setColorCode(itemDimensions.getColor());
            line.setColorName(itemDimensions.getColorName());
            line.setSizeCode(itemDimensions.getSize());
            line.setSizeName(itemDimensions.getSizeName());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)salesInvoiceLine.getDiscount1())) {
            line.setDisc1Percent(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getDiscount1().getPercentage()));
            line.setDisc1Val(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getDiscount1().getValue()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)salesInvoiceLine.getDiscount2())) {
            line.setDisc2Percent(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getDiscount2().getPercentage()));
            line.setDisc2Val(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getDiscount2().getValue()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)salesInvoiceLine.getTax1())) {
            line.setTax1Percent(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getTax1().getPercentage()));
            line.setTax1Val(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getTax1().getValue()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)salesInvoiceLine.getTax2())) {
            line.setTax2Percent(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getTax2().getPercentage()));
            line.setTax2Val(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getTax2().getValue()));
        }
        line.setFreeLine(salesInvoiceLine.getFreeLine());
        line.setMasterRowId(salesInvoiceLine.getMasterRowId());
        line.setUnitPrice(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getUnitPrice()));
        line.setTotalPrice(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getTotalPrice()));
        line.setNetPrice(ObjectChecker.toZeroIfNull((BigDecimal)salesInvoiceLine.getNetPrice()));
        line.setWarehouseIssueMethod(salesInvoiceLine.getWarehouseIssueMethod());
        line.setRemarks(salesInvoiceLine.getRemarks());
        line.setPrepFormPrintDate(salesInvoiceLine.getPrepFormPrintDate());
        line.setDeactivateEmpDiscountsValidations(salesInvoiceLine.getDeactivateEmpDiscountsValidations());
        return line;
    }

    private void updateNulls() {
        this.setNetPrice(BigDecimal.ZERO);
        this.setQty(BigDecimal.ZERO);
        this.setTotalPrice(BigDecimal.ZERO);
        this.setFreeLine(false);
        this.setTax1Val(BigDecimal.ZERO);
        this.setTax1Percent(BigDecimal.ZERO);
        this.setTax2Percent(BigDecimal.ZERO);
        this.setTax2Val(BigDecimal.ZERO);
        this.setDisc1Val(BigDecimal.ZERO);
        this.setDisc1Percent(BigDecimal.ZERO);
        this.setDisc2Percent(BigDecimal.ZERO);
        this.setDisc2Val(BigDecimal.ZERO);
        this.setUnitPrice(BigDecimal.ZERO);
        this.setUomId("");
        this.setUomCode("");
        this.setItemId("");
        this.setItemCode("");
        this.setItemName1("");
        this.setItemName2("");
        this.setUomName1("");
        this.setUomName2("");
        this.setItemActualCode("");
        this.setDeactivateEmpDiscountsValidations(false);
    }

    public POSSalesInvoiceLine toActualInvoiceLine(POSSalesInvoice salesInvoice) {
        POSSalesInvoiceLine invoiceLine = new POSSalesInvoiceLine();
        invoiceLine.setInvoice(salesInvoice);
        invoiceLine.setId(this.getId());
        invoiceLine.setItemCode(ObjectChecker.toStringOrEmpty((Object)this.getItemCode()));
        invoiceLine.setItemActualCode(ObjectChecker.toStringOrEmpty((Object)this.getItemActualCode()));
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getItemId())) {
            POSItem item = POSPersister.findByID(POSItem.class, this.getItemId());
            invoiceLine.setItem(item);
            invoiceLine.setItemName(item.nameByLanguage());
        }
        POSQuantity qty = new POSQuantity();
        qty.setValue(this.getQty());
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getUomId())) {
            qty.setUom(POSPersister.findByID(POSUnit.class, this.getUomId()));
        }
        invoiceLine.setQty(qty);
        invoiceLine.setUnitPrice(this.getUnitPrice());
        invoiceLine.setTotalPrice(this.getTotalPrice());
        invoiceLine.setDiscount1(new POSDiscountTax(this.getDisc1Percent(), this.getDisc1Val()));
        invoiceLine.setDiscount2(new POSDiscountTax(this.getDisc2Percent(), this.getDisc2Val()));
        invoiceLine.setTax1(new POSDiscountTax(this.getTax1Percent(), this.getTax1Val()));
        invoiceLine.setTax2(new POSDiscountTax(this.getTax2Percent(), this.getTax2Val()));
        invoiceLine.setFreeLine(this.getFreeLine());
        invoiceLine.setNetPrice(this.getNetPrice());
        invoiceLine.setMasterRowId(this.getMasterRowId());
        invoiceLine.setItemDimensions(new POSItemSpecificDimensions());
        invoiceLine.getItemDimensions().setRevisionId(this.getRevisionId());
        invoiceLine.getItemDimensions().setSize(this.getSizeCode());
        invoiceLine.getItemDimensions().setSizeName(this.getSizeName());
        invoiceLine.getItemDimensions().setColor(this.getColorCode());
        invoiceLine.getItemDimensions().setColorName(this.getColorName());
        invoiceLine.getPrice();
        invoiceLine.setWarehouseIssueMethod(this.getWarehouseIssueMethod());
        invoiceLine.setRemarks(this.getRemarks());
        invoiceLine.setPrepFormPrintDate(this.getPrepFormPrintDate());
        invoiceLine.setDeactivateEmpDiscountsValidations(this.getDeactivateEmpDiscountsValidations());
        invoiceLine.setItemImageAsBase64(this.getItemImageAsBase64());
        return invoiceLine;
    }
}

