/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.controllers;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.ObjectCreator;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.controllers.MobileDTOAbsPOSShiftLine;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.details.POSShiftCloseLine;
import com.namasoft.pos.domain.details.POSShiftOpenLine;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.util.POSShiftInventoryService;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MobileDTOPOSShift {
    private String code;
    private String shiftDate;
    private String shiftTime;
    private EntityReferenceData register;
    private String remarks;
    private EntityReferenceData user;
    private String entityType;
    private List<MobileDTOAbsPOSShiftLine> shiftLines;

    public MobileDTOPOSShift() {
    }

    public MobileDTOPOSShift(AbsPOSShiftInventory<?> shift) {
        this.setCode(shift.getCode());
        this.setShiftDate(POSShiftInventoryService.dateFormat.format(shift.getShiftDate().toInstant().atZone(ZoneId.systemDefault())));
        this.setShiftTime(shift.getShiftTime());
        this.setRegister(POSSavable.staticToReference(shift.getRegistery()));
        this.setRemarks(shift.getRemarks());
        this.setUser(POSSavable.staticToReference(shift.getPosUser()));
        this.setEntityType(shift.calcNamaEntityType());
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getShiftDate() {
        return this.shiftDate;
    }

    public void setShiftDate(String shiftDate) {
        this.shiftDate = shiftDate;
    }

    public String getShiftTime() {
        return this.shiftTime;
    }

    public void setShiftTime(String shiftTime) {
        this.shiftTime = shiftTime;
    }

    public EntityReferenceData getRegister() {
        return this.register;
    }

    public void setRegister(EntityReferenceData register) {
        this.register = register;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public EntityReferenceData getUser() {
        return this.user;
    }

    public void setUser(EntityReferenceData user) {
        this.user = user;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public List<MobileDTOAbsPOSShiftLine> getShiftLines() {
        if (this.shiftLines == null) {
            this.shiftLines = new ArrayList<MobileDTOAbsPOSShiftLine>();
        }
        return this.shiftLines;
    }

    public void setShiftLines(List<MobileDTOAbsPOSShiftLine> shiftLines) {
        this.shiftLines = shiftLines;
    }

    public AbsPOSShiftInventory toPOSShift() {
        AbsPOSShiftInventory shift = null;
        if (ObjectChecker.areEqual((Object)this.entityType, (Object)"POSShiftClosing")) {
            shift = new POSShiftClose();
            this.initActualShift(shift, (ObjectCreator<? extends AbsPOSInventoryLine>)((ObjectCreator)POSShiftCloseLine::new));
        } else {
            shift = new POSShiftOpen();
            this.initActualShift(shift, (ObjectCreator<? extends AbsPOSInventoryLine>)((ObjectCreator)POSShiftOpenLine::new));
        }
        return shift;
    }

    private void initActualShift(AbsPOSShiftInventory shift, ObjectCreator<? extends AbsPOSInventoryLine> lineCreator) {
        try {
            shift.setCode(this.code);
            Date date = POSShiftInventoryService.parseDate(this.shiftDate);
            shift.setShiftDate(date);
            shift.setShiftTime(this.shiftTime);
            shift.setRegistery(POSResourcesUtil.fetchRegister(this.register.getId()));
            shift.setPosUser((POSUser)POSSavable.staticFromReference(this.user));
            shift.setRemarks(this.remarks);
            for (MobileDTOAbsPOSShiftLine shiftLineDTO : this.shiftLines) {
                AbsPOSInventoryLine line = (AbsPOSInventoryLine)lineCreator.create();
                line.setPaymentWay(shiftLineDTO.getPaymentWay());
                line.setCurrency(shiftLineDTO.getCurrency());
                line.setAccountantRemaining(shiftLineDTO.getAccountantRemaining());
                line.setActualRemaining(shiftLineDTO.getActualRemaining());
                line.setDifference(shiftLineDTO.getDifference());
                line.setNarration(shiftLineDTO.getNarration());
                line.setNarration2(shiftLineDTO.getNarration2());
                line.setPaymentMethodId(shiftLineDTO.getPaymentMethodId());
                line.setCurrencyId(shiftLineDTO.getCurrencyId());
                line.setDisableActualBalance(shiftLineDTO.getDisableActualBalance());
                shift.fetchDetails().add(line);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }
}

