/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.displayPole;

import com.namasoft.common.flatobjects.BasicObjectPropertyResolver;
import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.flatobjects.tempo.ComplexRenderer;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.modules.namapos.enums.PoleCommunicationType;
import com.namasoft.pos.displayPole.DisplayPoleConnector;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.PosPoleDisplaySpecs;
import com.namasoft.pos.util.POSGeneralSettings;

public class DisplayPoleConnectorUtil {
    private static DisplayPoleConnector displayPoleConnector;

    public static DisplayPoleConnector createDisplayPoleConnectorIfNeeded(POSRegistery fetchedRegister) {
        displayPoleConnector = new DisplayPoleConnector();
        PosPoleDisplaySpecs posPoleDisplaySpecs = fetchedRegister.getPosPoleDisplaySpecs();
        if (ObjectChecker.isEmptyOrNull((Object)posPoleDisplaySpecs)) {
            return displayPoleConnector;
        }
        if (ObjectChecker.areNotEqual((Object)posPoleDisplaySpecs.getCommunicationType(), (Object)PoleCommunicationType.CommPort)) {
            return displayPoleConnector;
        }
        String portName = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{POSGeneralSettings.getCommPortName(), posPoleDisplaySpecs.getPrinterOrPortNumber(), "COM4"});
        displayPoleConnector.setPosPoleDisplaySpecs(posPoleDisplaySpecs);
        displayPoleConnector.init();
        displayPoleConnector.open(portName);
        return displayPoleConnector;
    }

    public static void closeDisplayPoleConnection() {
        if (displayPoleConnector != null) {
            displayPoleConnector.close();
        }
    }

    public static void writeIdleMsg(POSRegistery registery) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{displayPoleConnector, displayPoleConnector.getPosPoleDisplaySpecs()})) {
            return;
        }
        DisplayPoleConnectorUtil.renderTemplateMsg(displayPoleConnector.getPosPoleDisplaySpecs().getIdleTemplate(), registery);
    }

    private static void clearDisplayPole() {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{displayPoleConnector, displayPoleConnector.getPosPoleDisplaySpecs()})) {
            return;
        }
        displayPoleConnector.clearDisplay();
    }

    public static void writeAddingLineMsg(AbsPOSSales obj) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{displayPoleConnector, displayPoleConnector.getPosPoleDisplaySpecs()})) {
            return;
        }
        DisplayPoleConnectorUtil.renderTemplateMsg(displayPoleConnector.getPosPoleDisplaySpecs().getLineAddingTemplate(), obj);
    }

    public static void writeTotalMsg(POSMasterFile obj) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{displayPoleConnector, displayPoleConnector.getPosPoleDisplaySpecs()})) {
            return;
        }
        DisplayPoleConnectorUtil.renderTemplateMsg(displayPoleConnector.getPosPoleDisplaySpecs().getTotalTemplate(), obj);
    }

    public static void writeRemainingMsg(POSMasterFile obj) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{displayPoleConnector, displayPoleConnector.getPosPoleDisplaySpecs()})) {
            return;
        }
        DisplayPoleConnectorUtil.renderTemplateMsg(displayPoleConnector.getPosPoleDisplaySpecs().getRemainingTemplate(), obj);
    }

    public static void writeDeleteLineMsg(POSMasterFile obj) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{displayPoleConnector, displayPoleConnector.getPosPoleDisplaySpecs()})) {
            return;
        }
        DisplayPoleConnectorUtil.renderTemplateMsg(displayPoleConnector.getPosPoleDisplaySpecs().getDeleteLineTemplate(), obj);
    }

    private static void renderTemplateMsg(String template, Object object) {
        ComplexRenderer complexRenderer = new ComplexRenderer(template);
        String result = complexRenderer.parse().render((RendererPropertyResolver)new BasicObjectPropertyResolver(object)).toString();
        DisplayPoleConnectorUtil.poleLogInfo("Template: {0}\nResult: {1}", template, result);
        DisplayPoleConnectorUtil.writeConsideringCLEARLINE(result);
    }

    public static void poleLogInfo(String info, Object ... args) {
        if (POSGeneralSettings.logPoleIsEnabled()) {
            NaMaLogger.info((String)("POLE LOG: " + info), (Object[])args);
        }
    }

    private static void writeConsideringCLEARLINE(String s) {
        if (ObjectChecker.isEmptyOrNull((Object)s)) {
            return;
        }
        if (!s.contains("@CLEARLINE@")) {
            displayPoleConnector.write(s.trim());
            return;
        }
        String before = StringUtils.substringBefore((String)s, (String)"@CLEARLINE@");
        if (ObjectChecker.isNotEmptyOrNull((Object)before)) {
            displayPoleConnector.write(before.trim());
        }
        DisplayPoleConnectorUtil.clearDisplayPole();
        String after = StringUtils.substringAfter((String)s, (String)"@CLEARLINE@");
        DisplayPoleConnectorUtil.writeConsideringCLEARLINE(after);
    }
}

