/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSCurrency;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.math.BigDecimal;
import java.util.UUID;

@MappedSuperclass
public abstract class AbsPOSInventoryLine
implements POSSavable,
IPOSFinancialEffect {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private String paymentWay;
    @Column(precision=20, scale=10)
    private BigDecimal actualRemaining;
    @Column(precision=20, scale=10)
    private BigDecimal accountantRemaining;
    @Column(precision=20, scale=10)
    private BigDecimal difference;
    private String currency;
    @Column(name="method_id", length=16)
    private UUID paymentMethodId;
    @Column(name="currency_id", length=16)
    private UUID currencyId;
    private Boolean disableActualBalance;
    private String narration;
    private String narration2;

    public AbsPOSInventoryLine() {
    }

    public AbsPOSInventoryLine(String paymentWay, BigDecimal value) {
        this.setPaymentWay(paymentWay);
        this.setAccountantRemaining(value);
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(UUID currencyId) {
        this.currencyId = currencyId;
    }

    public Boolean getDisableActualBalance() {
        return this.disableActualBalance;
    }

    public void setDisableActualBalance(Boolean disableActualBalance) {
        this.disableActualBalance = disableActualBalance;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public String getNarration2() {
        return this.narration2;
    }

    public void setNarration2(String narration2) {
        this.narration2 = narration2;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public String getPaymentWay() {
        return this.paymentWay;
    }

    public void setPaymentWay(String paymentWay) {
        this.paymentWay = paymentWay;
    }

    public BigDecimal getActualRemaining() {
        return this.actualRemaining;
    }

    public void setActualRemaining(BigDecimal actualRemaining) {
        this.actualRemaining = actualRemaining;
    }

    public BigDecimal getAccountantRemaining() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.accountantRemaining)) {
            return BigDecimal.ZERO;
        }
        return this.accountantRemaining;
    }

    public void setAccountantRemaining(BigDecimal accountantRemaining) {
        this.accountantRemaining = accountantRemaining;
    }

    public BigDecimal getDifference() {
        return this.difference;
    }

    public void setDifference(BigDecimal difference) {
        this.difference = difference;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(UUID paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    @Override
    public BigDecimal getAmount() {
        return this.getDifference();
    }

    @Override
    public Boolean isCash() {
        return this.getPaymentWay().equalsIgnoreCase(POSResourcesUtil.id("cash", new Object[0])) || ObjectChecker.isNotEmptyOrNull((Object)MultiplePaymentDialog.cashMethodID()) && ObjectChecker.areEqual((Object)this.getPaymentMethodId(), (Object)MultiplePaymentDialog.cashMethodID());
    }

    @Override
    public Boolean isDebit() {
        return this.getPaymentWay().equalsIgnoreCase(POSResourcesUtil.id("debitValue", new Object[0]));
    }

    @Override
    public POSCurrency fetchCurrency() {
        return POSPersister.findByID(POSCurrency.class, this.getCurrencyId());
    }

    @Override
    public String getPaymentMethodName() {
        return this.paymentWay;
    }

    @Override
    public Boolean mustBeDisable(String fieldId) {
        return this.isDebit();
    }
}

