/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IHasPOSFinancialEffect;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.IPOSHasDateAndTime;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSCreditNoteAndCouponUtil;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.WritalblePOSFile;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSGenReference;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.util.POSFinancialUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.hibernate.Session;

@MappedSuperclass
public abstract class AbsPOSPayReceipt
extends WritalblePOSFile
implements IPOSFinancialEffect,
IHasPOSFinancialEffect,
IPOSHasDateAndTime {
    private UUID subsidiaryID;
    private String subsidiaryType;
    private String subsidiaryCode;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosDocCategory docCategory;
    @Column(precision=20, scale=10)
    private BigDecimal value;
    @Transient
    private POSPaymentReciptScreen view;
    private Boolean sent = false;
    private String shiftCode;
    @Temporal(value=TemporalType.DATE)
    private Date valueDate;
    private String type;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUser currentUser;
    @Temporal(value=TemporalType.TIME)
    private Date valueTime;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSPaymentMethod paymentMethod;
    private String attach1FilePath;
    private String attach2FilePath;
    @Column(length=16)
    private UUID registerId;
    private String namaDocToPayCode;
    @Column(length=16)
    private UUID shiftOpenId;
    @Transient
    private Map<String, Supplier<Object>> fieldsValues = new HashMap<String, Supplier<Object>>();

    public UUID getShiftOpenId() {
        return this.shiftOpenId;
    }

    public void setShiftOpenId(UUID shiftOpenId) {
        this.shiftOpenId = shiftOpenId;
    }

    public String getNamaDocToPayCode() {
        return this.namaDocToPayCode;
    }

    public void setNamaDocToPayCode(String namaDocToPayCode) {
        this.namaDocToPayCode = namaDocToPayCode;
    }

    public String getAttach1FilePath() {
        return this.attach1FilePath;
    }

    public void setAttach1FilePath(String attach1FilePath) {
        this.attach1FilePath = attach1FilePath;
    }

    public String getAttach2FilePath() {
        return this.attach2FilePath;
    }

    public void setAttach2FilePath(String attach2FilePath) {
        this.attach2FilePath = attach2FilePath;
    }

    public POSPaymentMethod getPaymentMethod() {
        this.paymentMethod = POSPersister.materialize(POSPaymentMethod.class, this.paymentMethod);
        return this.paymentMethod;
    }

    public void setPaymentMethod(POSPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Date getValueTime() {
        return this.valueTime;
    }

    public void setValueTime(Date valueTime) {
        this.valueTime = valueTime;
    }

    public PosDocCategory getDocCategory() {
        this.docCategory = POSPersister.materialize(PosDocCategory.class, this.docCategory);
        return this.docCategory;
    }

    public void setDocCategory(PosDocCategory docCategory) {
        this.docCategory = docCategory;
    }

    public POSPaymentReciptScreen getView() {
        return this.view;
    }

    public void setView(POSPaymentReciptScreen view) {
        this.view = view;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public void updateCurrency(String currencyID) {
        POSCurrency currency = POSPersister.findByID(POSCurrency.class, currencyID);
        if (ObjectChecker.isNotEmptyOrNull((Object)currency)) {
            this.setCurrency(currency);
        }
    }

    public void updateDocCategory(PosDocCategory docCategory) {
        this.setDocCategory(docCategory);
    }

    public void updateSubsidiary(POSMasterFile<?> subsidiary, BigDecimal amount, POSResult result) {
        this.setSubsidiaryID(subsidiary.getId());
        this.setSubsidiaryCode(subsidiary.getCode());
        if (subsidiary instanceof POSGenReference) {
            POSGenReference genReference = (POSGenReference)subsidiary;
            this.setSubsidiaryType(genReference.getType());
        } else {
            this.setSubsidiaryType(subsidiary.getClass().getSimpleName());
        }
        if (subsidiary instanceof POSCreditNote) {
            POSCreditNote creditNote = (POSCreditNote)subsidiary;
            POSCreditNoteAndCouponUtil.addPaidPartToCreditNote(POSResourcesUtil.fetchMainRegister(), new PaymentInfo(amount, creditNote.getCode()), this, result);
        }
    }

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    @Override
    public String getShiftCode() {
        return this.shiftCode;
    }

    public void setShiftCode(String shiftCode) {
        this.shiftCode = shiftCode;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    @Override
    public UUID getSubsidiaryID() {
        return this.subsidiaryID;
    }

    public void setSubsidiaryID(UUID subsidiaryID) {
        this.subsidiaryID = subsidiaryID;
    }

    @Override
    public String getSubsidiaryType() {
        return this.subsidiaryType;
    }

    public void setSubsidiaryType(String subsidiaryType) {
        this.subsidiaryType = subsidiaryType;
    }

    public String getSubsidiaryCode() {
        return this.subsidiaryCode;
    }

    public void setSubsidiaryCode(String subsidiaryCode) {
        this.subsidiaryCode = subsidiaryCode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "value", "subsidiaryType", "subsidiaryCode", "valueDate", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public POSCurrency fetchCurrency() {
        return this.getCurrency();
    }

    @Override
    public Boolean isCash() {
        return ObjectChecker.isEmptyOrNull((Object)this.getPaymentMethod()) || ObjectChecker.areEqual((Object)MultiplePaymentDialog.cashMethodID(), (Object)this.getPaymentMethod().getId());
    }

    @Override
    public Boolean isDebit() {
        return false;
    }

    @Override
    public UUID getPaymentMethodId() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getPaymentMethod())) {
            return this.getPaymentMethod().getId();
        }
        return MultiplePaymentDialog.cashMethodID();
    }

    @Override
    public Date fetchValueDate() {
        return this.getValueDate();
    }

    @Override
    public Date fetchValueTime() {
        return this.getValueTime();
    }

    @Override
    public void postCommitAction(Session session) {
        POSFinancialUtil.applyEffects(this, session);
    }

    @Override
    public List<? extends IPOSFinancialEffect> effects() {
        return Arrays.asList(this);
    }

    public abstract void writeToServer(POSRegistery var1, boolean var2, Callback var3);

    public POSUser getCurrentUser() {
        this.currentUser = POSPersister.materialize(POSUser.class, this.currentUser);
        return this.currentUser;
    }

    public void setCurrentUser(POSUser currentUser) {
        this.currentUser = currentUser;
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.addAll(Arrays.asList("valueDate", "shiftCode", "subsidiaryType", "subsidiaryCode"));
        return list;
    }

    @Override
    public String getPaymentMethodName() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getPaymentMethod())) {
            return this.getPaymentMethod().nameByLanguage();
        }
        return MultiplePaymentDialog.searchForCashMethodName();
    }

    @Override
    public Date fetchDate() {
        return this.getValueDate();
    }

    @Override
    public Date fetchTime() {
        return this.getValueTime();
    }

    @Override
    public void updateDate(Date date) {
        this.setValueDate(date);
    }

    @Override
    public void updateTime(Date time) {
        this.setValueTime(time);
    }

    public UUID getRegisterId() {
        return this.registerId;
    }

    public void setRegisterId(UUID registerId) {
        this.registerId = registerId;
    }

    @Override
    public boolean relationWithCustomerApplied(String relation, POSCustomer customer) {
        if (ObjectChecker.isAnyEqualToFirst((Object)this.getSubsidiaryType(), (Object[])new String[]{"Customer", "POSCustomer"})) {
            return true;
        }
        return AbsPOSSales.relationWithObjApplied(relation, customer, POSPersister.findByID(POSCustomer.class, this.getSubsidiaryID()));
    }

    @Override
    public Map<String, Supplier<Object>> namaFieldsWithPosValues() {
        if (ObjectChecker.isNotEmptyOrNull(this.fieldsValues)) {
            return this.fieldsValues;
        }
        this.fieldsValues.put("remarks", this::getRemarks);
        this.fieldsValues.put("paymentMethod", this::getPaymentMethod);
        return this.fieldsValues;
    }

    @Override
    public boolean searchOnAllFields() {
        return true;
    }

    @Override
    public List<String> fetchReferenceFieldsIDs() {
        return Arrays.asList("money.currency", "cancelReservation", "docsFromNama", "paymentMethod", "fromInvoiceCode", "subsidiary");
    }

    @Override
    public POSRegistery register() {
        return POSResourcesUtil.fetchRegisterIgnoringInActiveAndPreventUsage(this.registerId);
    }
}

