/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.entities.POSCurrency;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.math.BigDecimal;
import java.util.UUID;

@MappedSuperclass
public abstract class AbsPOSPaymentLine
implements POSSavable,
IPOSFinancialEffect {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    private String methodName;
    @Column(precision=20, scale=10)
    private BigDecimal value;
    private String authorizationNumber;
    private String shiftCode;
    @Column(name="method_id", length=16)
    private UUID method_id;
    private Boolean cash;
    private Boolean paidFromTerminal;
    private String panNum;
    private String stanNum;
    private String terminalId;
    private String schemeId;
    private String merchantId;
    private String ecrRefNum;

    public AbsPOSPaymentLine() {
    }

    public AbsPOSPaymentLine(String methodName, BigDecimal value) {
        this.methodName = methodName;
        this.value = value;
    }

    public String getPanNum() {
        return this.panNum;
    }

    public void setPanNum(String panNum) {
        this.panNum = panNum;
    }

    public String getStanNum() {
        return this.stanNum;
    }

    public void setStanNum(String stanNum) {
        this.stanNum = stanNum;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public String getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(String schemeId) {
        this.schemeId = schemeId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getEcrRefNum() {
        return this.ecrRefNum;
    }

    public void setEcrRefNum(String ecrRefNum) {
        this.ecrRefNum = ecrRefNum;
    }

    public Boolean getPaidFromTerminal() {
        return this.paidFromTerminal;
    }

    public void setPaidFromTerminal(Boolean paidFromTerminal) {
        this.paidFromTerminal = paidFromTerminal;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public abstract void updateInvoice(AbsPOSSales var1);

    public String getAuthorizationNumber() {
        return this.authorizationNumber;
    }

    public void setAuthorizationNumber(String authorizationNumber) {
        this.authorizationNumber = authorizationNumber;
    }

    @Override
    public String getShiftCode() {
        return this.shiftCode;
    }

    public void setShiftCode(String shiftCode) {
        this.shiftCode = shiftCode;
    }

    public UUID getMethod_id() {
        return this.method_id;
    }

    public void setMethod_id(UUID method_id) {
        this.method_id = method_id;
    }

    @Override
    public Boolean isDebit() {
        return false;
    }

    @Override
    public Boolean isCash() {
        return this.getCash();
    }

    public Boolean getCash() {
        return this.cash;
    }

    public void setCash(Boolean cash) {
        this.cash = cash;
    }

    @Override
    public UUID getPaymentMethodId() {
        return this.getMethod_id();
    }

    @Override
    public POSCurrency fetchCurrency() {
        return this.getCurrency();
    }

    @Override
    public String getPaymentMethodName() {
        POSPaymentMethod paymentMethod;
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getPaymentMethodId()) && ObjectChecker.isNotEmptyOrNull((Object)(paymentMethod = POSPersister.findByID(POSPaymentMethod.class, this.getPaymentMethodId())))) {
            return paymentMethod.nameByLanguage();
        }
        return this.methodName;
    }
}

