/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.Pair;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.GenericValue;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.MoneyEffectType;
import com.namasoft.common.utilities.MultiKeyHash;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.NaMaProfiler;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ItemBarCodeParser.CommonItemBarcodeParser;
import com.namasoft.common.utils.ItemBarCodeParser.CommonReferencePropertyValueParser;
import com.namasoft.common.utils.ItemBarCodeParser.DTOCommonItemBarcodePart;
import com.namasoft.common.utils.ItemBarCodeParser.DTOCommonItemBarcodeSpecs;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.ListOfGenericValues;
import com.namasoft.modules.commonbasic.contracts.entities.DTOTaxPlan;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGlobalConfigInfo;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMoneyEffectDetails;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxConfiguration;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.namapos.contracts.valueobjects.DTOPosServiceCharge;
import com.namasoft.modules.namapos.enums.POSLineCollectionMethod;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.namapos.enums.PosReqFieldRelationWithRef;
import com.namasoft.modules.namapos.enums.PosServiceItemCalcType;
import com.namasoft.modules.namapos.enums.WarehouseIssueMethod;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOSupplyChainConfigurations;
import com.namasoft.modules.supplychain.enums.FreeGroupPolicy;
import com.namasoft.modules.supplychain.enums.YesNoInheritedPolicy;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.PosTempDocumentUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasPOSFinancialEffect;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.IPOSHasDateAndTime;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSFreeItemsGroupDialog;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.application.PaymentDialogHelper;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.application.PosAdditionalItemsDialog;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.IPOSDocFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.WritalblePOSFile;
import com.namasoft.pos.domain.details.AbsPOSItemBarcodePart;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.AbsPOSSalesTableLine;
import com.namasoft.pos.domain.details.POSDepreciationReasonDiscLine;
import com.namasoft.pos.domain.details.POSFreeGroupLine;
import com.namasoft.pos.domain.details.POSItemDiscountLine;
import com.namasoft.pos.domain.details.POSLegalEntityTax;
import com.namasoft.pos.domain.details.POSOfferOnItemsCountLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceRemovedLine;
import com.namasoft.pos.domain.details.POSSalesReturnLine;
import com.namasoft.pos.domain.details.POSServiceChargeLine;
import com.namasoft.pos.domain.details.POSSpecialItemLine;
import com.namasoft.pos.domain.details.PosDeliveryCostLine;
import com.namasoft.pos.domain.details.PosMinChargeLine;
import com.namasoft.pos.domain.details.PosTableLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSDepreciationReason;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemBarcodeParser;
import com.namasoft.pos.domain.entities.POSItemBarcodeSpecs;
import com.namasoft.pos.domain.entities.POSItemCode;
import com.namasoft.pos.domain.entities.POSItemCodeType;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReturnReason;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSStockTakingDetailsDoc;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSTaxPlan;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosAddressRegion;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.domain.entities.PosDeliveryCost;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import com.namasoft.pos.domain.entities.PosMinCharge;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import com.namasoft.pos.domain.valueobjects.POSItemSalesFreeItem;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceReq;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceRes;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceResDetail;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.domain.valueobjects.POSSalesDiscountResultUnit;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqType;
import com.namasoft.pos.util.POSConfigurationUtil;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSEntityUtil;
import com.namasoft.pos.util.POSFinancialUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSMediaUtil;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSPricesCachingUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSalesHeaderDiscountResp;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import org.hibernate.Session;

@MappedSuperclass
public abstract class AbsPOSSales
extends WritalblePOSFile
implements IPOSDocFile,
IHasPOSFinancialEffect,
IPOSHasDateAndTime {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCustomer customer;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    @Column(precision=20, scale=10)
    private BigDecimal lineTotalsBeforeDiscs;
    @Column(precision=20, scale=10)
    private BigDecimal totalPrice;
    @Column(precision=20, scale=10)
    private BigDecimal discountPercent;
    @Column(precision=20, scale=10)
    private BigDecimal discountValue;
    @Column(precision=20, scale=10)
    private BigDecimal netPrice;
    private String customerCode;
    private String customerName;
    private String address;
    private Boolean hold = false;
    private Boolean sent = false;
    private String shiftCode;
    @Column(length=16)
    private UUID shiftId;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSWarehouse warehouse;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSLocation location;
    @Temporal(value=TemporalType.DATE)
    private Date valueDate;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee salesMan;
    @Column(precision=20, scale=10)
    private BigDecimal paidCash;
    @Column(precision=20, scale=10)
    private BigDecimal change;
    @Column(precision=20, scale=10)
    private BigDecimal totalPaid;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSTable table;
    private Date holdTime;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification posInvoiceClassification;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosDocCategory docCategory;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier1 priceClassifier1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier2 priceClassifier2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier3 priceClassifier3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier4 priceClassifier4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier5 priceClassifier5;
    @Transient
    private DTOInvoiceMoney invoiceMoney;
    @Column(length=16)
    private UUID registerId;
    @Column(precision=20, scale=10)
    private BigDecimal discount2Value;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUser currentUser;
    @Transient
    private Boolean fromRemoteRegister = false;
    @Transient
    private Boolean postCommitActionsApplied = false;
    @Temporal(value=TemporalType.TIME)
    private Date valueTime;
    @Column(precision=20, scale=10)
    private BigDecimal currencyRate;
    private UUID subsidiaryID;
    private String subsidiaryType;
    private String subsidiaryNamaType;
    private String subsidiaryCode;
    @Transient
    private AbsPOSSalesLine lastModifiedLine;
    @Transient
    private AbsPOSSalesLine lastDeletedLine;
    private String attach1FilePath;
    private String attach2FilePath;
    private String attach3FilePath;
    private String attach4FilePath;
    private String attach5FilePath;
    @Column(precision=20, scale=10)
    private BigDecimal tax1Total;
    @Column(precision=20, scale=10)
    private BigDecimal tax2Total;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount1;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount2;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount3;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount4;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount5;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount6;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount7;
    @Column(precision=20, scale=10)
    private BigDecimal afterDiscount8;
    @Column(precision=20, scale=10)
    private BigDecimal discount1Total;
    @Column(precision=20, scale=10)
    private BigDecimal discount2Total;
    @Column(precision=20, scale=10)
    private BigDecimal discount3Total;
    @Column(precision=20, scale=10)
    private BigDecimal discount4Total;
    @Column(precision=20, scale=10)
    private BigDecimal discount5Total;
    @Column(precision=20, scale=10)
    private BigDecimal discount6Total;
    @Column(precision=20, scale=10)
    private BigDecimal discount7Total;
    @Column(precision=20, scale=10)
    private BigDecimal discount8Total;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosAddressRegion addressRegion;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee driver;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSOrderReservation reservation;
    private Boolean paymentDelayed = false;
    @Temporal(value=TemporalType.DATE)
    private Date deliveryDate;
    private String strDeliveryTime;
    @Transient
    public SimpleDoubleProperty totalProperty = new SimpleDoubleProperty();
    private static final Map<Integer, Function<AbsPOSSalesLine, POSDiscountTax>> DISCOUNTS = new HashMap<Integer, Function<AbsPOSSalesLine, POSDiscountTax>>();
    private static final Map<String, Function<AbsPOSSalesLine, BigDecimal>> serviceChargeCalcFrom = new HashMap<String, Function<AbsPOSSalesLine, BigDecimal>>();
    @Transient
    private BigDecimal customDeliveryCost;
    public static final List<String> allDocsCommonFields = Arrays.asList("details", "subsidiary", "attach1", "attach2", "attach3", "attach4", "attach5");
    public static final List<String> SalesDocCommonFieldIds = CollectionsUtility.join((List[])new List[]{allDocsCommonFields, Arrays.asList("totalPrice", "discountP", "discountV", "customer", "currency", "currencyRate", "warehouse", "location", "code", "salesMan", "driver", "addressRegion", "table", "docCategory", "priceClassifier1", "priceClassifier2", "priceClassifier3", "priceClassifier4", "priceClassifier5", "discount2Val", "customerAddress", "n1", "n2", "n3", "n4", "n5", "date1", "date2", "date3", "date4", "date5", "description1", "description2", "description3", "description4", "description5", "deliveryDate", "deliveryTime", "posInvoiceClassification", "netPrice", "beforeDiscsTaxs")});
    @Transient
    private Map<String, Supplier<Object>> fieldsValues = new HashMap<String, Supplier<Object>>();

    public String getTablesCodes() {
        List tables = this.fetchTables().stream().map(AbsPOSSalesTableLine::getPosTable).collect(Collectors.toList());
        return tables.stream().filter(ObjectChecker::isNotEmptyOrNull).distinct().map(POSMasterFile::getCode).collect(Collectors.joining(" , "));
    }

    public String getTablesIDs() {
        List tables = this.fetchTables().stream().map(AbsPOSSalesTableLine::getPosTable).collect(Collectors.toList());
        return tables.stream().filter(ObjectChecker::isNotEmptyOrNull).distinct().map(t -> ServerStringUtils.toUUIDStr((Object)t.getId())).collect(Collectors.joining(" , "));
    }

    public void setTablesCodes(String codes) {
    }

    public String getTablesNames() {
        List tables = this.fetchTables().stream().map(AbsPOSSalesTableLine::getPosTable).collect(Collectors.toList());
        return tables.stream().filter(ObjectChecker::isNotEmptyOrNull).distinct().map(POSMasterFile::nameByLanguage).collect(Collectors.joining(" , "));
    }

    public void setTablesNames(String tablesNames) {
    }

    public void updateTables(List<PosTableLine> lines) {
        if (this.createTableLine() == null) {
            return;
        }
        ArrayList lineList = new ArrayList();
        lines.stream().forEach(l -> {
            Object invoiceTableLine = this.createTableLine();
            invoiceTableLine.assignIds();
            ((AbsPOSSalesTableLine)invoiceTableLine).updateInvoice(this);
            ((AbsPOSSalesTableLine)invoiceTableLine).setPosTable(POSPersister.findByID(POSTable.class, l.getTableID()));
            lineList.add(invoiceTableLine);
        });
        this.updateTableLines(lineList);
    }

    public <T extends AbsPOSSalesTableLine> void updateTableLines(List<T> tableLines) {
    }

    public <T extends AbsPOSSalesTableLine> T createTableLine() {
        return null;
    }

    public <T extends AbsPOSSalesTableLine> List<T> fetchTables() {
        return new ArrayList();
    }

    @Override
    public String getSubsidiaryNamaType() {
        return this.subsidiaryNamaType;
    }

    public void setSubsidiaryNamaType(String subsidiaryNamaType) {
        this.subsidiaryNamaType = subsidiaryNamaType;
    }

    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getStrDeliveryTime() {
        return this.strDeliveryTime;
    }

    public void setStrDeliveryTime(String strDeliveryTime) {
        this.strDeliveryTime = strDeliveryTime;
    }

    public Boolean getPaymentDelayed() {
        if (this.paymentDelayed == null) {
            this.paymentDelayed = false;
        }
        return this.paymentDelayed;
    }

    public void setPaymentDelayed(Boolean paymentDelayed) {
        this.paymentDelayed = paymentDelayed;
    }

    public POSOrderReservation getReservation() {
        this.reservation = POSPersister.materialize(POSOrderReservation.class, this.reservation);
        return this.reservation;
    }

    public void setReservation(POSOrderReservation reservation) {
        this.reservation = reservation;
    }

    public POSEmployee getDriver() {
        this.driver = POSPersister.materialize(POSEmployee.class, this.driver);
        return this.driver;
    }

    public void setDriver(POSEmployee driver) {
        this.driver = driver;
    }

    public PosAddressRegion getAddressRegion() {
        this.addressRegion = POSPersister.materialize(PosAddressRegion.class, this.addressRegion);
        return this.addressRegion;
    }

    public void setAddressRegion(PosAddressRegion addressRegion) {
        this.addressRegion = addressRegion;
    }

    public BigDecimal getTax1Total() {
        return this.tax1Total;
    }

    public void setTax1Total(BigDecimal tax1Total) {
        this.tax1Total = tax1Total;
    }

    public BigDecimal getTax2Total() {
        return this.tax2Total;
    }

    public void setTax2Total(BigDecimal tax2Total) {
        this.tax2Total = tax2Total;
    }

    public BigDecimal getAfterDiscount1() {
        return this.afterDiscount1;
    }

    public void setAfterDiscount1(BigDecimal afterDiscount1) {
        this.afterDiscount1 = afterDiscount1;
    }

    public BigDecimal getAfterDiscount2() {
        return this.afterDiscount2;
    }

    public void setAfterDiscount2(BigDecimal afterDiscount2) {
        this.afterDiscount2 = afterDiscount2;
    }

    public BigDecimal getAfterDiscount3() {
        return this.afterDiscount3;
    }

    public void setAfterDiscount3(BigDecimal afterDiscount3) {
        this.afterDiscount3 = afterDiscount3;
    }

    public BigDecimal getAfterDiscount4() {
        return this.afterDiscount4;
    }

    public void setAfterDiscount4(BigDecimal afterDiscount4) {
        this.afterDiscount4 = afterDiscount4;
    }

    public BigDecimal getAfterDiscount5() {
        return this.afterDiscount5;
    }

    public void setAfterDiscount5(BigDecimal afterDiscount5) {
        this.afterDiscount5 = afterDiscount5;
    }

    public BigDecimal getAfterDiscount6() {
        return this.afterDiscount6;
    }

    public void setAfterDiscount6(BigDecimal afterDiscount6) {
        this.afterDiscount6 = afterDiscount6;
    }

    public BigDecimal getAfterDiscount7() {
        return this.afterDiscount7;
    }

    public void setAfterDiscount7(BigDecimal afterDiscount7) {
        this.afterDiscount7 = afterDiscount7;
    }

    public BigDecimal getAfterDiscount8() {
        return this.afterDiscount8;
    }

    public void setAfterDiscount8(BigDecimal afterDiscount8) {
        this.afterDiscount8 = afterDiscount8;
    }

    public BigDecimal getDiscount1Total() {
        return this.discount1Total;
    }

    public void setDiscount1Total(BigDecimal discount1Total) {
        this.discount1Total = discount1Total;
    }

    public BigDecimal getDiscount2Total() {
        return this.discount2Total;
    }

    public void setDiscount2Total(BigDecimal discount2Total) {
        this.discount2Total = discount2Total;
    }

    public BigDecimal getDiscount3Total() {
        return this.discount3Total;
    }

    public void setDiscount3Total(BigDecimal discount3Total) {
        this.discount3Total = discount3Total;
    }

    public BigDecimal getDiscount4Total() {
        return this.discount4Total;
    }

    public void setDiscount4Total(BigDecimal discount4Total) {
        this.discount4Total = discount4Total;
    }

    public BigDecimal getDiscount5Total() {
        return this.discount5Total;
    }

    public void setDiscount5Total(BigDecimal discount5Total) {
        this.discount5Total = discount5Total;
    }

    public BigDecimal getDiscount6Total() {
        return this.discount6Total;
    }

    public void setDiscount6Total(BigDecimal discount6Total) {
        this.discount6Total = discount6Total;
    }

    public BigDecimal getDiscount7Total() {
        return this.discount7Total;
    }

    public void setDiscount7Total(BigDecimal discount7Total) {
        this.discount7Total = discount7Total;
    }

    public BigDecimal getDiscount8Total() {
        return this.discount8Total;
    }

    public void setDiscount8Total(BigDecimal discount8Total) {
        this.discount8Total = discount8Total;
    }

    public String getAttach3FilePath() {
        return this.attach3FilePath;
    }

    public void setAttach3FilePath(String attach3FilePath) {
        this.attach3FilePath = attach3FilePath;
    }

    public String getAttach4FilePath() {
        return this.attach4FilePath;
    }

    public void setAttach4FilePath(String attach4FilePath) {
        this.attach4FilePath = attach4FilePath;
    }

    public String getAttach5FilePath() {
        return this.attach5FilePath;
    }

    public void setAttach5FilePath(String attach5FilePath) {
        this.attach5FilePath = attach5FilePath;
    }

    public String getAttach1FilePath() {
        return this.attach1FilePath;
    }

    public void setAttach1FilePath(String attach1FilePath) {
        this.attach1FilePath = attach1FilePath;
    }

    public String getAttach2FilePath() {
        return this.attach2FilePath;
    }

    public void setAttach2FilePath(String attach2FilePath) {
        this.attach2FilePath = attach2FilePath;
    }

    @Override
    public UUID getSubsidiaryID() {
        return this.subsidiaryID;
    }

    public void setSubsidiaryID(UUID subsidiaryID) {
        this.subsidiaryID = subsidiaryID;
    }

    @Override
    public String getSubsidiaryType() {
        return this.subsidiaryType;
    }

    public void setSubsidiaryType(String subsidiaryType) {
        this.subsidiaryType = subsidiaryType;
    }

    public String getSubsidiaryCode() {
        return this.subsidiaryCode;
    }

    public void setSubsidiaryCode(String subsidiaryCode) {
        this.subsidiaryCode = subsidiaryCode;
    }

    public BigDecimal getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(BigDecimal currencyRate) {
        this.currencyRate = currencyRate;
    }

    public Date getValueTime() {
        return this.valueTime;
    }

    public void setValueTime(Date valueTime) {
        this.valueTime = valueTime;
    }

    public Boolean getFromRemoteRegister() {
        return this.fromRemoteRegister;
    }

    public void setFromRemoteRegister(Boolean fromRemoteRegister) {
        this.fromRemoteRegister = fromRemoteRegister;
    }

    public UUID getRegisterId() {
        return this.registerId;
    }

    public void setRegisterId(UUID registerId) {
        this.registerId = registerId;
    }

    public POSSalesPriceClassifier2 getPriceClassifier2() {
        this.priceClassifier2 = POSPersister.materialize(POSSalesPriceClassifier2.class, this.priceClassifier2);
        return this.priceClassifier2;
    }

    public void setPriceClassifier2(POSSalesPriceClassifier2 priceClassifier2) {
        this.priceClassifier2 = priceClassifier2;
    }

    public POSSalesPriceClassifier3 getPriceClassifier3() {
        this.priceClassifier3 = POSPersister.materialize(POSSalesPriceClassifier3.class, this.priceClassifier3);
        return this.priceClassifier3;
    }

    public void setPriceClassifier3(POSSalesPriceClassifier3 priceClassifier3) {
        this.priceClassifier3 = priceClassifier3;
    }

    public POSSalesPriceClassifier4 getPriceClassifier4() {
        this.priceClassifier4 = POSPersister.materialize(POSSalesPriceClassifier4.class, this.priceClassifier4);
        return this.priceClassifier4;
    }

    public void setPriceClassifier4(POSSalesPriceClassifier4 priceClassifier4) {
        this.priceClassifier4 = priceClassifier4;
    }

    public POSSalesPriceClassifier5 getPriceClassifier5() {
        this.priceClassifier5 = POSPersister.materialize(POSSalesPriceClassifier5.class, this.priceClassifier5);
        return this.priceClassifier5;
    }

    public void setPriceClassifier5(POSSalesPriceClassifier5 priceClassifier5) {
        this.priceClassifier5 = priceClassifier5;
    }

    public POSSalesPriceClassifier1 getPriceClassifier1() {
        this.priceClassifier1 = POSPersister.materialize(POSSalesPriceClassifier1.class, this.priceClassifier1);
        return this.priceClassifier1;
    }

    public void setPriceClassifier1(POSSalesPriceClassifier1 priceClassifier1) {
        this.priceClassifier1 = priceClassifier1;
    }

    public POSTable getTable() {
        this.table = POSPersister.materialize(POSTable.class, this.table);
        return this.table;
    }

    public PosDocCategory getDocCategory() {
        this.docCategory = POSPersister.materialize(PosDocCategory.class, this.docCategory);
        return this.docCategory;
    }

    public void setDocCategory(PosDocCategory docCategory) {
        this.docCategory = docCategory;
    }

    @Override
    public PosDocCategory fetchDocCategory() {
        return this.getDocCategory();
    }

    public void setTable(POSTable table) {
        this.table = table;
    }

    public POSEmployee getSalesMan() {
        this.salesMan = POSPersister.materialize(POSEmployee.class, this.salesMan);
        return this.salesMan;
    }

    public void setSalesMan(POSEmployee salesMan) {
        this.salesMan = salesMan;
    }

    public BigDecimal getTotalPaid() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.totalPaid);
    }

    public void setTotalPaid(BigDecimal totalPaid) {
        this.totalPaid = totalPaid;
    }

    public BigDecimal getPaidCash() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.paidCash);
    }

    public void setPaidCash(BigDecimal paidCash) {
        this.paidCash = paidCash;
    }

    public BigDecimal getRemainingChange() {
        return this.change;
    }

    public void setRemainingChange(BigDecimal remainingChange) {
        this.change = remainingChange;
    }

    public POSWarehouse getWarehouse() {
        this.warehouse = POSPersister.materialize(POSWarehouse.class, this.warehouse);
        return this.warehouse;
    }

    public void setWarehouse(POSWarehouse warehouse) {
        this.warehouse = warehouse;
    }

    public POSLocation getLocation() {
        this.location = POSPersister.materialize(POSLocation.class, this.location);
        return this.location;
    }

    public void setLocation(POSLocation location) {
        this.location = location;
    }

    public String getShiftCode() {
        return this.shiftCode;
    }

    public void setShiftCode(String shiftCode) {
        this.shiftCode = shiftCode;
    }

    public void updateShiftData(POSRegistery register) {
        POSShiftOpen lastOpenShift = POSResourcesUtil.fetchLastOpenShift(register);
        this.shiftId = lastOpenShift.getId();
        this.shiftCode = lastOpenShift.getCode();
    }

    public UUID getShiftId() {
        return this.shiftId;
    }

    public void setShiftId(UUID shiftId) {
        this.shiftId = shiftId;
    }

    public boolean getHold() {
        return this.hold;
    }

    public void setHold(boolean hold) {
        this.hold = hold;
    }

    @Override
    public POSCustomer getCustomer() {
        this.customer = POSPersister.materialize(POSCustomer.class, this.customer);
        return this.customer;
    }

    public void setCustomer(POSCustomer customer) {
        this.customer = customer;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public BigDecimal getNetPrice() {
        return this.netPrice;
    }

    public void setNetPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void assignIds() {
        this.getId();
        if (ObjectChecker.isNotEmptyOrNull(this.fetchDetails())) {
            for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
                absPOSSalesLine.getId();
                absPOSSalesLine.updateInvoice(this);
            }
        }
        BigDecimal totalPaid = BigDecimal.ZERO;
        if (ObjectChecker.isNotEmptyOrNull(this.fetchPayments())) {
            for (AbsPOSPaymentLine absPOSPaymentLine : this.fetchPayments()) {
                absPOSPaymentLine.getId();
                absPOSPaymentLine.updateInvoice(this);
                absPOSPaymentLine.setShiftCode(this.getShiftCode());
                absPOSPaymentLine.setCurrency(this.getCurrency());
                totalPaid = totalPaid.add(absPOSPaymentLine.getValue());
            }
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getPaidCash())) {
            totalPaid = totalPaid.add(ObjectChecker.toZeroIfNull((BigDecimal)this.getPaidCash()).subtract(ObjectChecker.toZeroIfNull((BigDecimal)this.getRemainingChange())));
        }
        this.setTotalPaid(totalPaid);
        AbsPOSSales absPOSSales = this;
        if (absPOSSales instanceof POSOrderReservation) {
            POSOrderReservation pOSOrderReservation = (POSOrderReservation)absPOSSales;
            pOSOrderReservation.setReservationAmount(ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{pOSOrderReservation.getReservationAmount(), totalPaid}));
        }
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void updateLineValues(AbsPOSSalesLine line) {
        DTOInvoiceMoney invoiceMoney = this.getInvoiceMoney();
        if (invoiceMoney == null) {
            invoiceMoney = this.updateMoney();
        }
        invoiceMoney.setHeaderDiscount(new DTOMoneyEffectDetails());
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getDiscountPercent())) {
            invoiceMoney.getHeaderDiscount().setPercentage(this.getDiscountPercent());
        } else if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getDiscountValue())) {
            BigDecimal beforeDiscountValue = POSMoneyUtils.getBeforeHeaderDiscountTotalValue(invoiceMoney);
            invoiceMoney.getHeaderDiscount().setPercentage(NaMaMath.calcPercentage((BigDecimal)beforeDiscountValue, (BigDecimal)this.getDiscountValue(), (Integer)POSMoneyUtils.percentageScale));
        }
        List<AbsPOSSalesLine> details = Arrays.asList(line);
        if (line == null) {
            details = this.fetchDetails();
        }
        for (AbsPOSSalesLine salesLine : details) {
            salesLine.updateTotal();
            salesLine.setPrice(null);
        }
        this.updateTotalPrice();
        DTOTaxPlan headerTaxPlan = POSResourcesUtil.fetchPosConfigDtoTaxPlan();
        DTOTaxPlan lineTaxPlan = POSResourcesUtil.fetchItemDtoTaxPlanFrom(line == null ? null : line.getItem());
        DTOTaxConfiguration taxConfiguration = DTOTaxPlan.fetchTaxConfiguration((DTOTaxPlan)headerTaxPlan, (DTOTaxPlan)lineTaxPlan, (EntityReferenceData)POSResourcesUtil.fetchMainRegister().fetchLegalEntityRef(), (Date)this.valueDate, (DTOGlobalConfigInfo)POSResourcesUtil.fetchGlobalConfig().getInfo(), (String)this.calcNamaEntityType());
        POSMoneyUtils.applyLinePricesInMoney(new ListOfGenericValues(), details, invoiceMoney, true, taxConfiguration);
        Integer fractionDecimalPlaces = this.getCurrency() != null ? this.getCurrency().getFractionDecimalPlaces() : 2;
        this.setNetPrice(NaMaMath.round((BigDecimal)AbsPOSSales.calcInvoiceNet(this.fetchDetails()), (Integer)fractionDecimalPlaces));
        this.setDiscountPercent(NaMaMath.round((BigDecimal)invoiceMoney.getHeaderDiscount().getPercentage(), (Integer)POSMoneyUtils.getPercentageScale()));
        this.setDiscountValue(NaMaMath.round((BigDecimal)invoiceMoney.getHeaderDiscount().getValue(), (Integer)fractionDecimalPlaces));
        this.setTax1Total(NaMaMath.round((BigDecimal)invoiceMoney.getTax1Total(), (Integer)fractionDecimalPlaces));
        this.setTax2Total(NaMaMath.round((BigDecimal)invoiceMoney.getTax2Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount1Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount1Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount2Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount2Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount3Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount3Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount4Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount4Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount5Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount5Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount6Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount6Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount7Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount7Total(), (Integer)fractionDecimalPlaces));
        this.setDiscount8Total(NaMaMath.round((BigDecimal)invoiceMoney.getDiscount8Total(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount1(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount1(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount2(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount2(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount3(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount3(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount4(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount4(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount5(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount5(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount6(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount6(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount7(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount7(), (Integer)fractionDecimalPlaces));
        this.setAfterDiscount8(NaMaMath.round((BigDecimal)invoiceMoney.getAfterDiscount8(), (Integer)fractionDecimalPlaces));
        if (line == null) {
            this.setInvoiceMoney(invoiceMoney);
        }
    }

    protected static BigDecimal calcInvoiceNet(List<? extends AbsPOSSalesLine> salesLines) {
        BigDecimal net = BigDecimal.ZERO;
        for (AbsPOSSalesLine absPOSSalesLine : salesLines) {
            net = net.add(ObjectChecker.toZeroIfNull((BigDecimal)absPOSSalesLine.getNetPrice()));
        }
        return net;
    }

    public void updateLineAndTotalMoney(AbsPosSalesScreen view, boolean updateTotals) {
        if (updateTotals) {
            this.updateLineValues(null);
        }
        BigDecimal netPrice = NaMaMath.round((BigDecimal)this.getNetPrice().subtract(ObjectChecker.toZeroIfNull((BigDecimal)this.getDiscount2Value())), (Integer)POSMoneyUtils.fractionalDecimalPlaces);
        this.setNetPrice(netPrice);
        if (ObjectChecker.isNotEmptyOrNull((Object)view)) {
            Platform.runLater(() -> {
                view.getSalesTable().getItems().clear();
                view.getSalesTable().getItems().addAll(this.fetchDetails());
            });
            if (ObjectChecker.isEmptyOrZero((BigDecimal)netPrice) || ObjectChecker.isEmptyOrNull(this.fetchDetails())) {
                this.totalProperty.set(0.0);
            } else {
                this.totalProperty.set(NaMaMath.round((BigDecimal)netPrice, (Integer)POSMoneyUtils.displayDecimalPlaces).doubleValue());
            }
            view.updateFieldsEvent(Arrays.asList("totalPrice", "discountV", "discountP", "beforeDiscsTaxs", "discsTotal", "taxesTotal"), this);
        }
    }

    public void updateTotalPrice() {
        this.setTotalPrice(BigDecimal.ZERO);
        for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
            this.setTotalPrice(this.getTotalPrice().add(ObjectChecker.toZeroIfNull((BigDecimal)absPOSSalesLine.getTotalPrice())));
        }
    }

    public void duplicateLine(int lineIndex, boolean sameQties, AbsPosSalesScreen view) {
        if (!view.getSalesTable().isEditable()) {
            return;
        }
        if (lineIndex < 0 && this.fetchDetails().size() <= 0) {
            return;
        }
        AbsPOSSalesLine line = null;
        if ((ObjectChecker.isEmptyOrNull((Object)lineIndex) || lineIndex == -1) && this.fetchDetails().size() > 0) {
            line = this.fetchDetails().get(this.fetchDetails().size() - 1);
        } else if (lineIndex < this.fetchDetails().size()) {
            line = this.fetchDetails().get(lineIndex);
        }
        POSQuantity qty = new POSQuantity(line.getQty().getValue(), ObjectChecker.isNotEmptyOrNull((Object)line.getQty().getUom()) ? line.getQty().getUom().getCode() : "");
        Object newLine = this.createBasicLine();
        ((AbsPOSSalesLine)newLine).setCommonValues(qty, line.getUnitPrice(), line.getTotalPrice(), line.getItem(), line.getItemCode(), line.getDiscount1(), line.getDiscount2(), line.getTax1(), line.getTax2(), line.getNetPrice(), line.getDiscount3(), line.getDiscount4(), line.getDiscount5(), line.getDiscount6(), line.getDiscount7(), line.getDiscount8());
        ((AbsPOSSalesLine)newLine).setRemarks(line.getRemarks());
        ((AbsPOSSalesLine)newLine).setItemActualCode(line.getItemActualCode());
        ((AbsPOSSalesLine)newLine).setWarehouseIssueMethod(line.getWarehouseIssueMethod());
        ((AbsPOSSalesLine)newLine).setCurrency(line.getCurrency());
        ((AbsPOSSalesLine)newLine).setItemDimensions(line.getItemDimensions());
        ((AbsPOSSalesLine)newLine).getQty().setValue(((AbsPOSSalesLine)newLine).getQty().getValue().abs());
        if (!sameQties) {
            ((AbsPOSSalesLine)newLine).getQty().setValue(((AbsPOSSalesLine)newLine).getQty().getValue().negate());
            this.updateLineValues((AbsPOSSalesLine)newLine);
        }
        this.fetchDetails().add((AbsPOSSalesLine)newLine);
        view.getSalesTable().getItems().add(newLine);
        this.updateTotals(view);
        this.calcDiscountsFromOffersConditionally(view);
        PosTempDocumentUtil.saveOrUpdateTempDocIfNeeded(this);
    }

    public void deleteSalesLineAction(POSRegistery register, int lineIndex, AbsPosSalesScreen view) {
        boolean salesReturnDoc = this instanceof POSSalesReturn;
        if (salesReturnDoc) {
            POSResult result = POSSecurityUtil.checkIfHasCapability(view, this, POSSecurityCapability.CanRemoveSalesReturnFreeItems);
            if (((POSSalesReturnLine)this.fetchDetails().get(lineIndex)).getInvoiceLineId() != null && this.fetchDetails().get(lineIndex).getFreeLine().booleanValue() && result.isFailed().booleanValue()) {
                return;
            }
        }
        if (!salesReturnDoc && POSSecurityUtil.checkIfHasCapability(view, this, POSSecurityCapability.CanCancelSalesLine).isFailed().booleanValue()) {
            return;
        }
        this.deleteSalesLine(register, lineIndex, view);
        this.updateTotals(view);
        if (view != null) {
            this.refreshViewAfterAddLine(null, view, null);
        }
        this.calcDiscountsFromOffers(register, view);
        DisplayPoleConnectorUtil.writeDeleteLineMsg(this);
        PosTempDocumentUtil.saveOrUpdateTempDocIfNeeded(this);
    }

    private void deleteSalesLine(POSRegistery register, int lineIndex, AbsPosSalesScreen view) {
        if (lineIndex >= 0 && lineIndex < this.fetchDetails().size()) {
            if (!this.fetchDetails().get(lineIndex).getFreeLine().booleanValue()) {
                this.removeRelatedFreeLines(register, this.fetchDetails().get(lineIndex), view);
            }
            AbsPOSSalesLine line = this.fetchDetails().remove(lineIndex);
            this.setLastDeletedLine(line);
            this.addToRemovedLinesIfNeeded(register, line);
        }
        if (view == null) {
            return;
        }
        ObservableList items = view.getSalesTable().getItems();
        if (items.size() > lineIndex) {
            items.remove(lineIndex);
        }
    }

    private void addToRemovedLinesIfNeeded(POSRegistery register, AbsPOSSalesLine line) {
        if (!(this instanceof POSSalesInvoice) || AbsPOSSales.shouldNotTrackRemovedLines(register)) {
            return;
        }
        POSSalesInvoiceRemovedLine removedLine = new POSSalesInvoiceRemovedLine();
        PosSalesUtil.copySalesLine(line, removedLine, line.fetchSalesDoc());
        ((POSSalesInvoice)this).getRemovedLines().add(removedLine);
    }

    private static boolean shouldNotTrackRemovedLines(POSRegistery register) {
        String trackRemovedLines = register.getTrackInvoiceRemovedLines();
        if (ObjectChecker.areEqual((Object)trackRemovedLines, (Object)YesNoInheritedPolicy.No)) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)trackRemovedLines, (Object)YesNoInheritedPolicy.Yes)) {
            return false;
        }
        return !ObjectChecker.areEqual((Object)POSResourcesUtil.fetchPOSConfig().getTrackInvoiceRemovedLines(), (Object)YesNoInheritedPolicy.Yes);
    }

    private static void fillDISCOUNTSMap() {
        if (ObjectChecker.isNotEmptyOrNull(DISCOUNTS)) {
            return;
        }
        DISCOUNTS.put(1, AbsPOSSalesLine::getDiscount1);
        DISCOUNTS.put(2, AbsPOSSalesLine::getDiscount2);
        DISCOUNTS.put(3, AbsPOSSalesLine::getDiscount3);
        DISCOUNTS.put(4, AbsPOSSalesLine::getDiscount4);
        DISCOUNTS.put(5, AbsPOSSalesLine::getDiscount5);
        DISCOUNTS.put(6, AbsPOSSalesLine::getDiscount6);
        DISCOUNTS.put(7, AbsPOSSalesLine::getDiscount7);
        DISCOUNTS.put(8, AbsPOSSalesLine::getDiscount8);
    }

    public void depreciateLine(int lineIndex, POSDepreciationReason depreciationReason, AbsPosSalesScreen view) {
        if (depreciationReason == null) {
            return;
        }
        if (!view.getSalesTable().isEditable()) {
            return;
        }
        if (lineIndex < 0 || lineIndex >= this.fetchDetails().size()) {
            return;
        }
        AbsPOSSalesLine line = this.fetchDetails().get(lineIndex);
        if (line == null) {
            return;
        }
        line.setDepreciationReason(depreciationReason);
        AbsPOSSales.fillDISCOUNTSMap();
        BigDecimal remainingPercentAfterDiscount = new BigDecimal(100);
        for (POSDepreciationReasonDiscLine discount : depreciationReason.getDiscounts()) {
            POSDiscountTax discountObject = DISCOUNTS.get(Integer.valueOf(discount.getDiscount().substring(discount.getDiscount().length() - 1))).apply(line);
            BigDecimal equivalentPercent = NaMaMath.divide((BigDecimal)discount.getPercentage().multiply(new BigDecimal(100)), (BigDecimal)remainingPercentAfterDiscount, (Integer)10);
            remainingPercentAfterDiscount = remainingPercentAfterDiscount.subtract(discount.getPercentage());
            discountObject.setPercentage(equivalentPercent);
        }
        this.updateLineValues(line);
        this.updateTotals(view);
        this.calcDiscountsFromOffersConditionally(view);
    }

    public void depreciateAll(POSDepreciationReason depreciationReason, AbsPosSalesScreen view) {
        if (depreciationReason == null) {
            return;
        }
        if (!view.getSalesTable().isEditable()) {
            return;
        }
        AbsPOSSales.fillDISCOUNTSMap();
        for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
            if (absPOSSalesLine == null) continue;
            absPOSSalesLine.setDepreciationReason(depreciationReason);
            BigDecimal remainingPercentAfterDiscount = new BigDecimal(100);
            for (POSDepreciationReasonDiscLine discount : depreciationReason.getDiscounts()) {
                POSDiscountTax discountObject = DISCOUNTS.get(Integer.valueOf(discount.getDiscount().substring(discount.getDiscount().length() - 1))).apply(absPOSSalesLine);
                BigDecimal equivalentPercent = NaMaMath.divide((BigDecimal)discount.getPercentage().multiply(new BigDecimal(100)), (BigDecimal)remainingPercentAfterDiscount, (Integer)10);
                remainingPercentAfterDiscount = remainingPercentAfterDiscount.subtract(discount.getPercentage());
                discountObject.setPercentage(equivalentPercent);
            }
            this.updateLineValues(absPOSSalesLine);
        }
        this.updateTotals(view);
        this.calcDiscountsFromOffersConditionally(view);
    }

    public void calcDiscountsFromOffersConditionally(AbsPosSalesScreen view) {
        this.calcDiscountsFromOffersConditionally(POSResourcesUtil.fetchMainRegister(), view);
    }

    public void calcDiscountsFromOffersConditionally(POSRegistery register, AbsPosSalesScreen view) {
        Boolean invDiscountCalculationFromOffers = POSResourcesUtil.fetchSupplyChainConfig().getActivateInvDiscountCalculationFromOffers();
        if (ObjectChecker.isFalseOrNull((Boolean)invDiscountCalculationFromOffers)) {
            this.updateLineAndTotalMoney(view, true);
            return;
        }
        this.calcDiscountsFromOffers(register, view);
    }

    private <T extends AbsPOSSalesLine> List<T> fetchSlaveLines(AbsPOSSalesLine masterLine) {
        return this.fetchDetails().stream().filter(ObjectChecker.equalsPredicate((Object)masterLine.getId(), AbsPOSSalesLine::getId)).collect(Collectors.toList());
    }

    public void calcDiscountsFromOffers(POSRegistery register, AbsPosSalesScreen view) {
        POSInvoiceClassification invClassifition = (POSInvoiceClassification)ObjectChecker.getFirstNotNullObj((Object[])new POSInvoiceClassification[]{this.getPosInvoiceClassification(), POSResourcesUtil.calcInvoiceClassification(register)});
        POSItemSalesPriceReq requestHeader = POSSalesPriceUtil.createSalesPriceRequestHeader(new ArrayList<BigDecimal>(), new Date(), invClassifition, POSSalesPriceReqType.All, this.currentUser, this.fetchDetails(), ObjectChecker.toZeroIfNull((BigDecimal)this.getDiscountPercent()).toString(), this.getTotalPrice(), ObjectChecker.toZeroIfNull((BigDecimal)this.getNetPrice()).toString(), this);
        BigDecimal total = POSMoneyUtils.calculateTotalFor(MoneyEffectType.HeaderDiscount, this.fetchDetails(), this);
        List<AbsPOSSalesLine> includedLinesInDisc = this.fetchDetails();
        DTOSupplyChainConfigurations configurations = POSResourcesUtil.fetchSupplyChainConfig();
        if (ObjectChecker.isTrue((Boolean)configurations.getExcludeItemsWithDiscInHeaderDisc())) {
            includedLinesInDisc = this.fetchDetails().stream().filter(l -> ObjectChecker.areAllEmptyOrZero((BigDecimal[])new BigDecimal[]{l.getDiscount1().getValue(), l.getDiscount2().getValue(), l.getDiscount3().getValue(), l.getDiscount4().getValue(), l.getDiscount5().getValue(), l.getDiscount6().getValue(), l.getDiscount7().getValue(), l.getDiscount8().getValue()})).collect(Collectors.toList());
        }
        if (ObjectChecker.isTrue((Boolean)configurations.getExcludeItemsWithFreeItemsInHeaderDisc())) {
            includedLinesInDisc = this.fetchDetails().stream().filter(l -> this.fetchSlaveLines((AbsPOSSalesLine)l).size() == 0).collect(Collectors.toList());
        }
        BigDecimal valueToCalcFrom = includedLinesInDisc.stream().map(o -> o.getNetPrice().add(ObjectChecker.toZeroIfNull((BigDecimal)o.getHeaderDicount().getValue()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        POSSalesHeaderDiscountResp discountPercent = POSSalesPriceUtil.calculateHeaderDicount(requestHeader, total, valueToCalcFrom);
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.getDiscountPercent()) || ObjectChecker.isAnyNotEmptyOrZero((BigDecimal[])new BigDecimal[]{discountPercent.getMinDiscountPercent(), discountPercent.getMaxDiscountPercent()}) && NaMaMath.notBetween((BigDecimal)this.getDiscountPercent(), (BigDecimal)discountPercent.getMinDiscountPercent(), (BigDecimal)discountPercent.getMaxDiscountPercent())) {
            this.setDiscountPercent(NaMaMath.round((BigDecimal)discountPercent.getMinDiscountPercent(), (Integer)POSMoneyUtils.getPercentageScale()));
            this.setDiscountValue(NaMaMath.calcPercentageValue((BigDecimal)total, (BigDecimal)ObjectChecker.toZeroIfNull((BigDecimal)this.getDiscountPercent())));
            this.updateLineAndTotalMoney(view, true);
            if (ObjectChecker.isTrue((Boolean)discountPercent.getIgnoreOtherOffers())) {
                POSSalesPriceUtil.cancelOtherOffers(this.fetchDetails(), this, view);
            }
        }
    }

    public void addItemsList(POSRegistery register, List<POSMasterFile> items, BigDecimal qty, Boolean free, POSOfferOnItemsCountLine offerLine, POSFreeItemGroup freeItemGroup, boolean freeItemsOnInvoiceOffer, boolean freeItemsOnItemCount, AbsPosSalesScreen view) {
        BigDecimal lineQty = qty;
        if (qty.compareTo(BigDecimal.ONE) > 0) {
            lineQty = NaMaMath.divide((BigDecimal)qty, (BigDecimal)BigDecimal.valueOf(items.size()), (Integer)2).setScale(0, RoundingMode.HALF_DOWN);
        }
        for (POSMasterFile item : items) {
            if (items.indexOf(item) == items.size() - 1) {
                lineQty = qty.subtract(lineQty.multiply(BigDecimal.valueOf(items.size() - 1)));
            }
            if (free.booleanValue()) {
                this.addSalesFreeLine(register, (POSItem)item, view.getSalesTable().getItems().size(), lineQty, AbsPOSSales.fetchUnitFor((POSItem)item, freeItemGroup), new POSItemSpecificDimensions(), null, offerLine, freeItemGroup, freeItemsOnInvoiceOffer, freeItemsOnItemCount, view);
                continue;
            }
            this.addSalesLine(register, item.getCode(), view.getSalesTable().getItems().size(), qty, false, view, new POSResult());
        }
        this.refreshViewAfterAddLine(items.get(items.size() - 1).getId().toString(), view, null);
    }

    public static POSUnit fetchUnitFor(POSItem item, POSFreeItemGroup freeItemGroup) {
        POSUnit unit = item.getDefaultSalesUnit();
        if (freeItemGroup != null) {
            freeItemGroup = POSPersister.findByID(POSFreeItemGroup.class, freeItemGroup.getId());
            unit = freeItemGroup.getDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)item)).map(l -> l.getQty().getUom()).findFirst().orElse(unit);
        }
        return unit;
    }

    public AbsPOSSalesLine addSalesLine(POSRegistery register, String itemCode, int lineNumber, BigDecimal qty, Boolean refreshView, AbsPosSalesScreen view, POSResult result) {
        return this.addSalesLine(register, itemCode, lineNumber, qty, refreshView, view, false, null, result);
    }

    public AbsPOSSalesLine addSalesLine(POSRegistery register, String itemCode, int lineNumber, BigDecimal qty, Boolean refreshView, AbsPosSalesScreen view, Boolean fromAdditionalItemsDialog, POSUnit posUnit, POSResult result) {
        boolean hasAdditionalItems;
        PosItemAdditionalItems additionalItems;
        boolean sellable;
        if (view != null) {
            view.getItemCodeField().clear();
        }
        if (view != null && !view.getSalesTable().isEditable()) {
            result.failure(POSResourcesUtil.id("canNotEditInSalesGrid", new Object[0]), new Object[0]);
            return null;
        }
        NaMaProfiler.get().start("restofwork");
        NaMaProfiler.get().start("afterGetPriceResponse");
        POSItemCode posItemCode = (POSItemCode)POSPersister.findByCode(POSItemCode.class, itemCode);
        if (ObjectChecker.isEmptyOrNull((Object)posItemCode)) {
            POSMediaUtil.playItemNotFoundSound();
            result.failure(POSResourcesUtil.id("notExistItem", new Object[0]), new Object[0]);
            return null;
        }
        UUID itemId = posItemCode.getItemId();
        POSItem item = POSPersister.findByID(POSItem.class, itemId, true);
        boolean bl = sellable = ObjectChecker.isTrue((Boolean)item.getSellable()) || ObjectChecker.isAnyEqualToFirst((Object)((Object)this.docType()), (Object[])new POSDocumentType[]{POSDocumentType.StockTransferReq, POSDocumentType.StockTakingDetails, POSDocumentType.ShortfallsDoc, POSDocumentType.ScrapDoc});
        if (ObjectChecker.isEmptyOrNull((Object)item) || !sellable) {
            return null;
        }
        if (this.isRepeatedServiceItem(view, item, result).isFailed().booleanValue()) {
            return null;
        }
        if (this.isRepeatedServiceOrDeliveryItem(view, item, result, false).isFailed().booleanValue()) {
            return null;
        }
        if (this.isRepeatedMinChargeItem(view, item, result).isFailed().booleanValue()) {
            return null;
        }
        BigDecimal currentPrice = BigDecimal.ZERO;
        boolean pricesMustBeCalculated = !(this instanceof POSStockTransferReq) && !(this instanceof POSStockTakingDetailsDoc);
        AbsPOSSalesLine line = this.setLineValues(register, lineNumber, qty, item, currentPrice, posItemCode, false, view);
        if (posUnit != null) {
            line.getQty().setUom(posUnit);
        }
        if (pricesMustBeCalculated) {
            this.calcUnitPriceAndFreeLines(register, line, false, view);
            if (ObjectChecker.isEmptyOrZero((BigDecimal)line.getUnitPrice()) && ObjectChecker.isEmptyOrNull((Object)line.getPriceListLineId()) && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotUseItemWithPriceZero()) && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotCheckItemsWithoutPriceList())) {
                result.failure(POSResourcesUtil.id("item {0} With No Price", item.nameByLanguage()), new Object[0]);
                return line;
            }
        }
        if (refreshView.booleanValue() && view != null) {
            this.refreshViewAfterAddLine(item.getId().toString(), view, line.getItemCode());
        }
        this.calcDiscountsFromOffersConditionally(register, view);
        this.setLastModifiedLine(line);
        DisplayPoleConnectorUtil.writeAddingLineMsg(this);
        PosTempDocumentUtil.saveOrUpdateTempDocIfNeeded(this);
        if (view != null && !fromAdditionalItemsDialog.booleanValue() && (additionalItems = POSResourcesUtil.fetchAdditionalItemsForItem(item)) != null && ((hasAdditionalItems = ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{additionalItems.getAdditionalItems1(), additionalItems.getAdditionalItems2(), additionalItems.getAdditionalItems3(), additionalItems.getAdditionalItems4(), additionalItems.getAdditionalItems5(), additionalItems.getAdditionalItems6(), additionalItems.getAdditionalItems7(), additionalItems.getAdditionalItems8(), additionalItems.getAdditionalItems9(), additionalItems.getAdditionalItems10()})) || this.shouldShowPropertyAndNotProvided(posItemCode.getSize(), additionalItems.getShowItemSizes()) || this.shouldShowPropertyAndNotProvided(posItemCode.getColor(), additionalItems.getShowItemColors()) || this.shouldShowPropertyAndNotProvided(posItemCode.getRevision(), additionalItems.getShowItemRevisions()))) {
            new PosAdditionalItemsDialog(additionalItems, view, lineNumber, item).showDialog();
        }
        return line;
    }

    private boolean shouldShowPropertyAndNotProvided(String property, Boolean showProperty) {
        if (ObjectChecker.isNotEmptyOrNull((Object)property)) {
            return false;
        }
        return ObjectChecker.isTrue((Boolean)showProperty);
    }

    private POSResult isRepeatedServiceItem(AbsPosSalesScreen view, POSItem item, POSResult posResult) {
        return this.isRepeatedServiceOrDeliveryItem(view, item, posResult, true);
    }

    private POSResult isRepeatedServiceOrDeliveryItem(AbsPosSalesScreen view, POSItem item, POSResult posResult, boolean isServiceItem) {
        POSItem serviceItem = isServiceItem ? AbsPOSSales.fetchServiceItem() : AbsPOSSales.fetchDeliveryItem();
        String msg = isServiceItem ? "Service item is already added" : "Delivery item is already added";
        AbsPOSSalesLine serviceLine = this.fetchDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)serviceItem)).findFirst().orElse(null);
        if (serviceLine != null && ObjectChecker.areEqual((Object)item, (Object)serviceItem)) {
            posResult.failure(POSResourcesUtil.id(msg, new Object[0]), new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(posResult, view.fetchStage());
        }
        return posResult;
    }

    public void removeServiceItem(AbsPosSalesScreen view) {
        this.removeItem(view, AbsPOSSales.fetchServiceItem());
    }

    public void removeDeliveryItem(AbsPosSalesScreen view) {
        this.removeItem(view, AbsPOSSales.fetchDeliveryItem());
    }

    public void removeMinChargeItem(AbsPosSalesScreen view) {
        this.removeItem(view, AbsPOSSales.fetchMinChargeItem());
    }

    private void removeItem(AbsPosSalesScreen view, POSItem item) {
        ObservableList items = view != null ? view.getSalesTable().getItems() : this.fetchDetails();
        Integer lineIndex = items.stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)item)).map(arg_0 -> AbsPOSSales.lambda$removeItem$10((List)items, arg_0)).findFirst().orElse(null);
        if (lineIndex != null && ObjectChecker.isNotNegative((Integer)lineIndex)) {
            this.deleteSalesLineAction(POSResourcesUtil.fetchMainRegister(), lineIndex, view);
        }
    }

    public static POSItem fetchServiceItem() {
        DTOPosServiceCharge configServiceCharge = POSResourcesUtil.fetchPOSConfig().getServiceCharge();
        return (POSItem)ObjectChecker.getFirstNotNullObj((Object[])new POSItem[]{POSResourcesUtil.fetchMainRegister().getServiceChargeItem(), configServiceCharge == null ? null : (POSItem)POSSavable.staticFromReference(configServiceCharge.getItem())});
    }

    public static POSItem fetchMinChargeItem() {
        return (POSItem)ObjectChecker.getFirstNotNullObj((Object[])new POSItem[]{POSResourcesUtil.fetchMainRegister().getMinChargeItem(), (POSItem)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getMinChargeItem())});
    }

    private POSResult isRepeatedMinChargeItem(AbsPosSalesScreen view, POSItem item, POSResult posResult) {
        POSItem minChargeItem = AbsPOSSales.fetchMinChargeItem();
        AbsPOSSalesLine minChargeLine = this.fetchDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)minChargeItem)).findFirst().orElse(null);
        if (minChargeLine != null && ObjectChecker.areEqual((Object)item, (Object)minChargeItem)) {
            posResult.failure(POSResourcesUtil.id("Minimum Charge item is already added", new Object[0]), new Object[0]);
            POSErrorAndInfoMessagesUtil.showInfo(posResult, view.fetchStage());
        }
        return posResult;
    }

    public void addMinChargeItemToInvoice(AbsPosSalesScreen hasToolBar, POSResult result) {
        POSItem item = AbsPOSSales.fetchMinChargeItem();
        if (item == null) {
            result.failure(POSResourcesUtil.id("No min charge item defined", new Object[0]), new Object[0]);
        } else {
            this.addSalesLine(POSResourcesUtil.fetchMainRegister(), item.getCode(), this.fetchDetails().size(), BigDecimal.ONE, true, hasToolBar, result);
        }
    }

    public static POSItem fetchDeliveryItem() {
        EntityReferenceData configDeliveryItem = POSResourcesUtil.fetchPOSConfig().getDeliveryItem();
        return (POSItem)ObjectChecker.getFirstNotNullObj((Object[])new POSItem[]{POSResourcesUtil.fetchMainRegister().getDeliveryItem(), configDeliveryItem != null ? (POSItem)POSSavable.staticFromReference(configDeliveryItem) : null});
    }

    public void refreshViewAfterAddLine(String id, AbsPosSalesScreen view, String itemCode) {
        this.updateTotals(view);
        view.getItemCodeField().clear();
        view.getShowPane().updateItemImg(id, itemCode);
    }

    public AbsPOSSalesLine addSalesFreeLine(POSRegistery register, POSItem item, int lineNumber, BigDecimal qty, POSUnit uom, POSItemSpecificDimensions dimensions, UUID masterId, Boolean notFreeButDiscount, String discLocation, BigDecimal discPercent, AbsPosSalesScreen view) {
        return this.addSalesFreeLine(register, item, lineNumber, qty, uom, dimensions, masterId, null, null, false, false, notFreeButDiscount, discLocation, discPercent, view);
    }

    public AbsPOSSalesLine addSalesFreeLine(POSRegistery register, POSItem item, int lineNumber, BigDecimal qty, POSUnit uom, POSItemSpecificDimensions dimensions, UUID masterId, POSOfferOnItemsCountLine offerOnItemsCountLine, POSFreeItemGroup freeItemGroup, Boolean freeItemsOnInvoiceOffer, Boolean freeFromItemCountOffer, AbsPosSalesScreen view) {
        return this.addSalesFreeLine(register, item, lineNumber, qty, uom, dimensions, masterId, offerOnItemsCountLine, freeItemGroup, freeItemsOnInvoiceOffer, freeFromItemCountOffer, false, null, null, view);
    }

    public AbsPOSSalesLine addSalesFreeLine(POSRegistery register, POSItem item, int lineNumber, BigDecimal qty, POSUnit uom, POSItemSpecificDimensions dimensions, UUID masterId, POSOfferOnItemsCountLine offerOnItemsCountLine, POSFreeItemGroup freeItemGroup, Boolean freeItemsOnInvoiceOffer, Boolean freeFromItemCountOffer, Boolean notFreeButDiscount, String discLocation, BigDecimal discPercent, AbsPosSalesScreen view) {
        if (ObjectChecker.isNotEmptyOrNull((Object)item)) {
            AbsPOSSalesLine defaultLine = this.setLineValues(register, lineNumber, qty, item, BigDecimal.ZERO, null, true, view);
            defaultLine.setItemDimensions(dimensions);
            defaultLine.setFromFreeItemsOnInvoiceOffer(freeItemsOnInvoiceOffer);
            defaultLine.setFreeFromItemsCountOffer(freeFromItemCountOffer);
            defaultLine.getQty().setUom(uom);
            defaultLine.setUnitPrice(ObjectChecker.toZeroIfNull((BigDecimal)defaultLine.getUnitPrice()));
            this.updateLineValues(defaultLine);
            defaultLine.setFreeLine(true);
            this.notFreeButDiscountEffect(register, notFreeButDiscount, discLocation, discPercent, defaultLine, view);
            defaultLine.setMasterRowId(masterId);
            defaultLine.setFreeItemGroup(freeItemGroup);
            if (ObjectChecker.isNotEmptyOrNull((Object)offerOnItemsCountLine)) {
                defaultLine.setInvoiceOfferId(offerOnItemsCountLine.getId());
            }
            if (view != null) {
                this.refreshViewAfterAddLine(item.getId().toString(), view, null);
            }
            return defaultLine;
        }
        return null;
    }

    private void notFreeButDiscountEffect(POSRegistery register, Boolean notFreeButDiscount, String discLocation, BigDecimal discountPercent, AbsPOSSalesLine defaultLine, AbsPosSalesScreen view) {
        if (ObjectChecker.isFalse((Boolean)notFreeButDiscount)) {
            return;
        }
        defaultLine.setFreeLine(false);
        this.calcUnitPriceAndFreeLines(register, defaultLine, true, view);
        defaultLine.updateDiscountByLocation(DiscountLocation.valueOf((String)discLocation), discountPercent);
    }

    public void removeRelatedFreeLines(POSRegistery register, AbsPOSSalesLine selectedLine, AbsPosSalesScreen view) {
        UUID selectedLineId = selectedLine.getId();
        for (int i = this.fetchDetails().size() - 1; i >= 0; --i) {
            AbsPOSSalesLine line = this.fetchDetails().get(i);
            if (!ObjectChecker.areEqual((Object)line.getMasterRowId(), (Object)selectedLineId)) continue;
            AbsPOSSalesLine removed = this.fetchDetails().remove(i);
            this.addToRemovedLinesIfNeeded(register, removed);
            if (view == null) continue;
            view.getSalesTable().getItems().remove(i);
        }
    }

    public void addOfferLineToInvoice(POSRegistery register, List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> toGetFree, AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        for (Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine> pair : toGetFree) {
            if (ObjectChecker.isNotEmptyOrNull((Object)((AbsPOSSalesLine)pair.getY()).getFreeItemGroup())) {
                this.openGroupToSelectItem(register, ((AbsPOSSalesLine)pair.getY()).getFreeItemGroup(), ((AbsPOSSalesLine)pair.getY()).getQty().getValue(), (POSOfferOnItemsCountLine)pair.getX(), false, true, view);
                continue;
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)((AbsPOSSalesLine)pair.getY()).fetchItemsCountOfferSrcIds())) {
                List<String> srcIDs = Arrays.asList(((AbsPOSSalesLine)pair.getY()).fetchItemsCountOfferSrcIds().split("_#_"));
                srcIDs.forEach(id -> this.updateSrcLineQtyIfFound(register, pair, ServerStringUtils.strToUUID((String)id), salesDoc, view));
                continue;
            }
            this.updateSrcLineQtyIfFound(register, pair, ((AbsPOSSalesLine)pair.getY()).getMasterRowId(), salesDoc, view);
        }
    }

    private void updateSrcLineQtyIfFound(POSRegistery register, Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine> pair, UUID masterId, AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        AbsPOSSalesLine salesLine = this.fetchSourceLine(masterId);
        if (salesLine == null) {
            return;
        }
        boolean diffBetweenSourceAndFreeQty = ObjectChecker.areNotEqual((Object)((AbsPOSSalesLine)pair.getY()).getQty().getValue().intValue(), (Object)salesLine.getQty().getValue().intValue());
        if (diffBetweenSourceAndFreeQty) {
            BigDecimal newQty = this.subtractSourceLineQty(pair, salesLine, salesDoc, view);
            if (ObjectChecker.isNotEmptyOrZero((BigDecimal)newQty)) {
                this.addSalesFreeLine(register, salesLine.getItem(), view.getCurrentLine(), newQty, salesLine.getQty().getUom(), salesLine.getItemDimensions(), salesLine.getId(), (POSOfferOnItemsCountLine)pair.getX(), null, false, true, view);
                ((AbsPOSSalesLine)pair.getY()).getQty().setValue(((AbsPOSSalesLine)pair.getY()).getQty().getValue().subtract(salesLine.getQty().getValue()));
            } else {
                this.addSalesFreeLine(register, salesLine.getItem(), view.getCurrentLine(), ((AbsPOSSalesLine)pair.getY()).getQty().getValue(), salesLine.getQty().getUom(), salesLine.getItemDimensions(), salesLine.getId(), (POSOfferOnItemsCountLine)pair.getX(), null, false, true, view);
            }
        } else {
            this.markLineAsFree(register, pair, salesLine, view);
        }
    }

    private void openGroupToSelectItem(POSRegistery register, POSFreeItemGroup freeItemGroup, BigDecimal totalQty, POSOfferOnItemsCountLine offerLine, boolean freeItemsOnInvoiceOffer, boolean freeItemsOnItemCount, AbsPosSalesScreen view) {
        this.openGroupToSelectItem(freeItemGroup, totalQty, view, (item, lineQty) -> this.addSalesFreeLine(register, (POSItem)item, view.getSalesTable().getItems().size(), (BigDecimal)lineQty, item.getDefaultSalesUnit(), new POSItemSpecificDimensions(), null, offerLine, freeItemGroup, freeItemsOnInvoiceOffer, freeItemsOnItemCount, view));
    }

    private void openGroupToSelectItem(POSFreeItemGroup freeItemGroup, BigDecimal totalQty, AbsPosSalesScreen view, BiConsumer<POSItem, BigDecimal> afterSelectAction) {
        POSFreeItemsGroupDialog freeItemsGroupDialog = new POSFreeItemsGroupDialog(view, POSPersister.findByID(POSFreeItemGroup.class, freeItemGroup.getId()), totalQty, afterSelectAction);
        freeItemsGroupDialog.showDialog();
    }

    private AbsPOSSalesLine fetchSourceLine(UUID masterRowId) {
        return this.fetchDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getId(), (Object)masterRowId)).findFirst().orElse(null);
    }

    private void markLineAsFree(POSRegistery register, Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine> pair, AbsPOSSalesLine salesLine, AbsPosSalesScreen view) {
        salesLine.setUnitPrice(BigDecimal.ZERO);
        salesLine.setFreeLine(true);
        POSOfferOnItemsCountLine offerOnItemsCountLine = (POSOfferOnItemsCountLine)pair.getX();
        this.notFreeButDiscountEffect(register, offerOnItemsCountLine.getNotFreeButDiscount(), offerOnItemsCountLine.getDiscLocation(), offerOnItemsCountLine.getDiscountPercentage(), salesLine, view);
        salesLine.setInvoiceOfferId(offerOnItemsCountLine.getId());
        salesLine.setFreeFromItemsCountOffer(true);
        this.updateLineValues(salesLine);
        view.getSalesTable().getItems().set(view.getSalesTable().getItems().indexOf((Object)salesLine), (Object)salesLine);
        view.updateFieldsEvent(Arrays.asList("details"), this);
    }

    private BigDecimal subtractSourceLineQty(Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine> pair, AbsPOSSalesLine salesLine, AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        BigDecimal diffOfQty = salesLine.getQty().getValue().subtract(((AbsPOSSalesLine)pair.getY()).getQty().getValue());
        if (diffOfQty.compareTo(BigDecimal.ZERO) <= 0) {
            salesDoc.fetchDetails().remove(salesLine);
            return salesLine.getQty().getValue();
        }
        salesLine.getQty().setValue(diffOfQty);
        this.updateLineValues(salesLine);
        view.getSalesTable().getItems().set(this.fetchIndexOfLine((ObservableList<AbsPOSSalesLine>)view.getSalesTable().getItems(), salesLine), (Object)salesLine);
        view.updateFieldsEvent(Arrays.asList("details"), this);
        return null;
    }

    private int fetchIndexOfLine(ObservableList<AbsPOSSalesLine> items, AbsPOSSalesLine salesLine) {
        for (int i = 0; i < items.size(); ++i) {
            AbsPOSSalesLine absPOSSalesLine = (AbsPOSSalesLine)items.get(i);
            if (!ObjectChecker.areEqual((Object)absPOSSalesLine.getItemCode(), (Object)salesLine.getItemCode()) || !ObjectChecker.areEqual((Object)absPOSSalesLine.getQty().getUom(), (Object)salesLine.getQty().getUom())) continue;
            return i;
        }
        return -1;
    }

    private AbsPOSSalesLine setLineValues(POSRegistery register, int lineNumber, BigDecimal qty, POSItem item, BigDecimal currentPrice, POSItemCode posItemCode, boolean isFree, AbsPosSalesScreen view) {
        POSItemSpecificDimensions itemSpecificDimensions;
        String linesCollectionMethod = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{register.getLinesCollectionMethod(), POSResourcesUtil.fetchPOSConfig().getLinesCollectionMethod()});
        AbsPOSSalesLine line = ObjectChecker.isEmptyOrNull((Object)linesCollectionMethod) || ObjectChecker.areEqual((Object)linesCollectionMethod, (Object)POSLineCollectionMethod.WithoutCollection.name()) || isFree ? this.addNewLineToSalesDoc(lineNumber, qty, item, currentPrice, posItemCode, view) : this.collectLineForItem(lineNumber, qty, item, currentPrice, posItemCode, view);
        if (this instanceof IPOSDocFromInvoice && (itemSpecificDimensions = (POSItemSpecificDimensions)this.fetchInvLines().stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)item)).map(AbsPOSSalesLine::getItemDimensions).findFirst().orElse(null)) != null) {
            line.setItemDimensions(itemSpecificDimensions.fetchCopy());
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fillSalesManInDetails())) {
            line.setSalesman(this.salesMan);
        }
        return line;
    }

    private AbsPOSSalesLine addNewLineToSalesDoc(int lineNumber, BigDecimal qty, POSItem item, BigDecimal currentPrice, POSItemCode posItemCode, AbsPosSalesScreen view) {
        AbsPOSSalesLine line = this.initializeDefaultLine(item, qty, currentPrice, posItemCode);
        this.fetchDetails().add(lineNumber, line);
        if (view != null) {
            view.getSalesTable().getItems().add(lineNumber, (Object)line);
            view.getSalesTable().scrollTo((Object)line);
        }
        return line;
    }

    private boolean areEqualOrNull(Object obj1, Object obj2) {
        return ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{obj1, obj2}) || ObjectChecker.areEqual((Object)obj1, (Object)obj2);
    }

    private AbsPOSSalesLine collectLineForItem(int lineNumber, BigDecimal qty, POSItem item, BigDecimal currentPrice, POSItemCode posItemCode, AbsPosSalesScreen view) {
        AbsPOSSalesLine line = this.fetchDetails().stream().filter(l -> {
            boolean sameUnitOrNoUnit = ObjectChecker.isEmptyOrNull((Object)posItemCode.getUnit()) || ObjectChecker.areEqual((Object)l.getQty().getUom(), (Object)posItemCode.getUnit());
            return ObjectChecker.isFalseOrNull((Boolean)l.getFreeLine()) && sameUnitOrNoUnit && this.areEqualOrNull(l.getItem().getId(), item.getId()) && this.areEqualOrNull(l.getItemDimensions().getColor(), posItemCode.getColor()) && this.areEqualOrNull(l.getItemDimensions().getSize(), posItemCode.getSize()) && this.areEqualOrNull(l.getItemDimensions().getRevisionId(), posItemCode.getRevision());
        }).findFirst().orElse(null);
        if (ObjectChecker.isNotEmptyOrNull((Object)line)) {
            line.getQty().setValue(line.getQty().getValue().add(ObjectChecker.toOneIfNull((BigDecimal)qty)));
            return line;
        }
        return this.addNewLineToSalesDoc(lineNumber, qty, item, currentPrice, posItemCode, view);
    }

    public void updateRegion(String id) {
        if (ObjectChecker.isNotEmptyOrNull((Object)id)) {
            this.setAddressRegion(POSPersister.findByID(PosAddressRegion.class, id));
        } else {
            this.setAddressRegion(null);
        }
    }

    public void updateDriver(String id) {
        if (ObjectChecker.isNotEmptyOrNull((Object)id)) {
            this.setDriver(POSPersister.findByID(POSEmployee.class, id));
        } else {
            this.setDriver(null);
        }
    }

    public void updateReservation(String id, boolean saveOperation) {
        if (ObjectChecker.isNotEmptyOrNull((Object)id)) {
            this.setReservation(POSPersister.findByID(POSOrderReservation.class, id));
        } else {
            this.setReservation(null);
        }
        if (saveOperation && this.getReservation() != null) {
            this.getReservation().setDelivered(true);
            POSPersister.saveOrUpdate(this.getReservation());
        }
    }

    public void updateCustomer(String customerID, AbsPosSalesScreen view) {
        this.updateCustomer(POSPersister.findByID(POSCustomer.class, customerID));
    }

    public void updateCustomer(POSCustomer customer) {
        if (ObjectChecker.isNotEmptyOrNull((Object)customer)) {
            this.setCustomer(customer);
            this.setCustomerCode(customer.getCode());
            this.setCustomerName(customer.getName1());
            this.setAddressRegion(customer.getAddressRegion());
        } else {
            this.setCustomer(null);
            this.setCustomerCode(null);
            this.setCustomerName(null);
            this.setAddressRegion(null);
        }
    }

    public void updateDocCategory(String docCategoryID) {
        if (ObjectChecker.isNotEmptyOrNull((Object)docCategoryID)) {
            this.setDocCategory(POSPersister.findByID(PosDocCategory.class, docCategoryID));
        } else {
            this.setDocCategory(null);
        }
    }

    public void updateCurrency(String currencyID, boolean saveOperation, AbsPosSalesScreen view) {
        if (ObjectChecker.isNotEmptyOrNull((Object)currencyID) && (ObjectChecker.isEmptyOrNull((Object)this.getCurrency()) || ObjectChecker.areNotEqual((Object)currencyID, (Object)ServerStringUtils.toUUIDStr((Object)this.getCurrency().getId())))) {
            POSCurrency currency = POSPersister.findByID(POSCurrency.class, currencyID);
            this.setCurrency(currency);
            for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
                absPOSSalesLine.setCurrency(currency);
            }
            if (!saveOperation) {
                this.setCurrencyRate(NaMaMath.round((BigDecimal)POSResourcesUtil.getCurrencyRate(currency, this.getValueDate()), (Integer)POSMoneyUtils.displayDecimalPlaces));
                if (view != null) {
                    view.updateFieldsEvent(Arrays.asList("currencyRate"), this);
                }
            }
        }
    }

    public abstract List<? extends AbsPOSSalesLine> fetchDetails();

    public List<? extends AbsPOSSalesLine> fetchRemovedLines() {
        return new ArrayList();
    }

    public List<? extends AbsPOSSalesLine> fetchInvLines() {
        return new ArrayList();
    }

    public abstract List<? extends AbsPOSPaymentLine> fetchPayments();

    public abstract String fromInvoiceCode();

    public abstract void updateDetails(List<? extends AbsPOSSalesLine> var1);

    public abstract <T extends AbsPOSPaymentLine> T createPaymentLine(String var1, UUID var2, BigDecimal var3, String var4, Boolean var5);

    public abstract <T extends AbsPOSSalesLine> T createBasicLine();

    @Override
    public void initializeLists() {
        this.fetchDetails().size();
        this.fetchPayments().size();
        this.fetchDetails().stream().filter(Objects::nonNull).forEach(l -> {
            if (l.getLocation() != null) {
                l.getLocation().getCode();
            }
            if (l.getWarehouse() != null) {
                l.getWarehouse().getCode();
            }
            if (l.getSalesman() != null) {
                l.getSalesman().getCode();
            }
        });
    }

    @Override
    public void initializeSearchLevelLists() {
        if (ObjectChecker.isNotEmptyOrNull(this.fetchPayments())) {
            this.fetchPayments().size();
        }
    }

    public <T extends AbsPOSPaymentLine> void addPaymentLine(POSPaymentMethod method, PaymentInfo info, int methodIndex, POSRegistery register) {
        boolean allowNonCashOverpay;
        BigDecimal value = info.getValue();
        String processNum = info.getProcessNumber();
        if (ObjectChecker.areEqual((Object)method.getId(), (Object)MultiplePaymentDialog.cashMethodID()) && methodIndex == 0 && !(this instanceof POSOrderReservation)) {
            value = value.subtract(this.getRemainingChange());
        }
        boolean bl = allowNonCashOverpay = ObjectChecker.isTrue((Boolean)method.getCashMethod()) && POSConfigurationUtil.shouldAllowCustomerToOverpayByNonCash(register) != false;
        if (value.compareTo(BigDecimal.ZERO) > 0 || allowNonCashOverpay && value.compareTo(BigDecimal.ZERO) < 0) {
            this.fetchPayments().add((AbsPOSPaymentLine)this.createPaymentLine(method.nameByLanguage(), method.getId(), value, processNum, ObjectChecker.areEqual((Object)MultiplePaymentDialog.cashMethodID(), (Object)method.getId())));
            this.fetchPayments().get(this.fetchPayments().size() - 1).setPaidFromTerminal(info.isPaidFromTerminal());
            if (ObjectChecker.isNotEmptyOrNull((Object)info.getPgwProperties())) {
                this.fetchPayments().get(this.fetchPayments().size() - 1).setPanNum(info.getPgwProperties().getPanNum());
                this.fetchPayments().get(this.fetchPayments().size() - 1).setMerchantId(info.getPgwProperties().getMerchantId());
                this.fetchPayments().get(this.fetchPayments().size() - 1).setSchemeId(info.getPgwProperties().getSchemeId());
                this.fetchPayments().get(this.fetchPayments().size() - 1).setEcrRefNum(info.getPgwProperties().getEcrRefNum());
                this.fetchPayments().get(this.fetchPayments().size() - 1).setStanNum(info.getPgwProperties().getStanNum());
                this.fetchPayments().get(this.fetchPayments().size() - 1).setTerminalId(info.getPgwProperties().getTerminalId());
            }
        }
    }

    public void addPaymentLines(Map.Entry<POSPaymentMethod, List<PaymentInfo>> posPaymentMethod, POSRegistery register) {
        for (int i = 0; i < posPaymentMethod.getValue().size(); ++i) {
            PaymentInfo info = posPaymentMethod.getValue().get(i);
            this.addPaymentLine(posPaymentMethod.getKey(), info, i, register);
        }
    }

    public void addPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean cash) {
        this.fetchPayments().add((AbsPOSPaymentLine)this.createPaymentLine(methodName, methodId, value, authorizationNumber, cash));
    }

    public AbsPOSSalesLine initializeDefaultLine(POSItem item, BigDecimal qty, BigDecimal currentPrice, POSItemCode posItemCode) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)qty)) {
            qty = BigDecimal.ONE;
        }
        Object line = this.createBasicLine();
        ((AbsPOSSalesLine)line).setQty(new POSQuantity());
        ((AbsPOSSalesLine)line).getQty().setValue(qty);
        if (ObjectChecker.isNotEmptyOrNull((Object)posItemCode) && ObjectChecker.isAnyEqualToFirst((Object)((Object)posItemCode.getCodeType()), (Object[])new POSItemCodeType[]{POSItemCodeType.UOM, POSItemCodeType.Revision}) && ObjectChecker.isNotEmptyOrNull((Object)posItemCode.getUnit())) {
            ((AbsPOSSalesLine)line).getQty().setUom(posItemCode.getUnit());
        } else if (ObjectChecker.isNotEmptyOrNull((Object)item.getDefaultSalesUnit())) {
            ((AbsPOSSalesLine)line).getQty().setUom(item.getDefaultSalesUnit());
        }
        ((AbsPOSSalesLine)line).setItemName(item.nameByLanguage());
        ((AbsPOSSalesLine)line).setItem(item);
        ((AbsPOSSalesLine)line).setUnitPrice(currentPrice);
        String itemCode = posItemCode != null ? posItemCode.getCode() : item.getCode();
        ((AbsPOSSalesLine)line).setItemCode(itemCode);
        ((AbsPOSSalesLine)line).setItemActualCode(item.getCode());
        ((AbsPOSSalesLine)line).setWarehouseIssueMethod("Normal");
        ((AbsPOSSalesLine)line).setDiscount1(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setDiscount2(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setDiscount3(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setDiscount4(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setDiscount5(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setDiscount6(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setDiscount7(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setDiscount8(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setTax1(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setTax2(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        ((AbsPOSSalesLine)line).setHeaderDicount(new POSDiscountTax(BigDecimal.ZERO, BigDecimal.ZERO));
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getDiscountPercent())) {
            ((AbsPOSSalesLine)line).getHeaderDicount().setPercentage(this.getDiscountPercent());
        }
        this.updateTaxesFromTaxPlan((AbsPOSSalesLine)line, item);
        ((AbsPOSSalesLine)line).setCurrency(this.getCurrency());
        if (ObjectChecker.isNotEmptyOrNull((Object)posItemCode)) {
            if (ObjectChecker.areEqual((Object)((Object)posItemCode.getCodeType()), (Object)((Object)POSItemCodeType.SizeAndColor))) {
                ((AbsPOSSalesLine)line).getItemDimensions().setSize(posItemCode.getSize());
                ((AbsPOSSalesLine)line).getItemDimensions().setColor(posItemCode.getColor());
                ((AbsPOSSalesLine)line).getItemDimensions().setColorName(posItemCode.getColorName());
                ((AbsPOSSalesLine)line).getItemDimensions().setSizeName(posItemCode.getSizeName());
            }
            if (ObjectChecker.areEqual((Object)((Object)posItemCode.getCodeType()), (Object)((Object)POSItemCodeType.Revision))) {
                ((AbsPOSSalesLine)line).getItemDimensions().setRevisionId(posItemCode.getRevision());
            }
        }
        ((AbsPOSSalesLine)line).setWarehouse(POSResourcesUtil.fetchMainRegister() == null ? null : POSResourcesUtil.fetchMainRegister().getWarehouse());
        ((AbsPOSSalesLine)line).setLocation(((AbsPOSSalesLine)line).calcLocation(this.getLocation()));
        this.updateLineValues((AbsPOSSalesLine)line);
        return line;
    }

    private void updateTaxesFromTaxPlan(AbsPOSSalesLine line, POSItem item) {
        boolean notNullCustomerTax;
        boolean bl = notNullCustomerTax = ObjectChecker.isNotEmptyOrNull((Object)this.customer) && ObjectChecker.isNotEmptyOrNull((Object)this.customer.getTaxPlan());
        if (ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{item.fetchTaxPlanId(), POSResourcesUtil.fetchPOSConfig().getTaxPlan()}) || notNullCustomerTax) {
            POSTaxPlan posTax = null;
            if (notNullCustomerTax) {
                posTax = POSPersister.findByID(POSTaxPlan.class, this.customer.getTaxPlan().getId());
            } else if (ObjectChecker.isNotEmptyOrNull((Object)item.fetchTaxPlanId())) {
                posTax = POSPersister.findByID(POSTaxPlan.class, item.fetchTaxPlanId());
            } else if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchPOSConfig().getTaxPlan())) {
                posTax = POSPersister.findByID(POSTaxPlan.class, POSResourcesUtil.fetchPOSConfig().getTaxPlan().getId());
            }
            if (ObjectChecker.isEmptyOrNull((Object)posTax)) {
                return;
            }
            POSLegalEntityTax itemTax = this.findLegalEntityTax(posTax.getTaxes());
            if (ObjectChecker.isNotEmptyOrNull((Object)itemTax)) {
                line.getTax1().setPercentage(itemTax.getTax1());
                line.getTax2().setPercentage(itemTax.getTax2());
            }
        }
    }

    private boolean entityTypeMatched(String entityType, POSLegalEntityTax tax) {
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{tax.getEntityTypeList(), tax.getEntityType()})) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)tax.getEntityType(), (Object)entityType)) {
            return true;
        }
        if (tax.getEntityTypeList() == null) {
            return false;
        }
        return ObjectChecker.toStringOrEmpty((Object)tax.getEntityTypeList()).contains("," + entityType + ",");
    }

    private POSLegalEntityTax findLegalEntityTax(List<POSLegalEntityTax> taxes) {
        LocalDate currentDate = LocalDate.now();
        for (POSLegalEntityTax posItemTaxes : taxes) {
            boolean equalOrBeforeEndDate;
            LocalDate effectiveTo;
            boolean entityMatched;
            boolean currentLegalEntity = ObjectChecker.isNotEmptyOrNull((Object)posItemTaxes.getLegalEntity()) && ObjectChecker.areEqual((Object)posItemTaxes.getLegalEntity().getId(), (Object)POSResourcesUtil.fetchMainRegister().getGenericDims().getLegalEntity().getId());
            if (!currentLegalEntity || !(entityMatched = this.entityTypeMatched(this.calcNamaEntityType(), posItemTaxes))) continue;
            LocalDate effectiveFrom = POSResourcesUtil.toLocalDate(posItemTaxes.getEffectiveFrom());
            if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{effectiveFrom, effectiveTo = POSResourcesUtil.toLocalDate(posItemTaxes.getEffectiveTo())})) {
                return posItemTaxes;
            }
            boolean equalOrAfterStartDate = effectiveFrom == null || currentDate.equals(effectiveFrom) || currentDate.isAfter(effectiveFrom);
            boolean bl = equalOrBeforeEndDate = effectiveTo == null || currentDate.equals(effectiveTo) || currentDate.isBefore(effectiveTo);
            if (!equalOrAfterStartDate || !equalOrBeforeEndDate) continue;
            return posItemTaxes;
        }
        return null;
    }

    public BigDecimal getDiscountValue() {
        return this.discountValue;
    }

    public void setDiscountValue(BigDecimal discountValue) {
        this.discountValue = discountValue;
    }

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        if (ObjectChecker.isFalseOrNull((Boolean)this.sent) && ObjectChecker.isTrue((Boolean)sent) && ObjectChecker.isTrue((String)POSGeneralSettings.getProperty((String)"log-sent-assignment"))) {
            NaMaLogger.error((Throwable)new RuntimeException("***********Marking as sent for ****" + String.valueOf(this.id)));
        }
        this.sent = sent;
    }

    public void updateWarehouse(String wareID) {
        if (ObjectChecker.isNotEmptyOrNull((Object)wareID)) {
            this.setWarehouse(POSPersister.findByID(POSWarehouse.class, wareID));
        } else {
            this.setWarehouse(null);
        }
    }

    public void updateLocator(String locatorID, AbsPosSalesScreen view) {
        if (ObjectChecker.isNotEmptyOrNull((Object)locatorID)) {
            this.setLocation(POSPersister.findByID(POSLocation.class, locatorID));
        } else {
            this.setLocation(null);
        }
        if (this instanceof POSStockTransferReq) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getLocation())) {
            for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
                absPOSSalesLine.setLocation(this.getLocation());
                view.getSalesTable().getItems().set(view.getSalesTable().getItems().indexOf((Object)absPOSSalesLine), (Object)absPOSSalesLine);
            }
        }
    }

    public void updateToLocator(String toLocatorId, AbsPosSalesScreen posSalesScreen) {
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public void updateWarehouseFromRegister(POSWarehouse warehouse) {
        this.setWarehouse(warehouse);
    }

    public void updateRegisterFields(POSRegistery currentRegister, AbsPosSalesScreen view) {
        if (ObjectChecker.isEmptyOrNull((Object)currentRegister)) {
            return;
        }
        this.setRegisterId(currentRegister.getId());
        if (ObjectChecker.isNotEmptyOrNull((Object)currentRegister.getWarehouse()) && ObjectChecker.isEmptyOrNull((Object)this.getWarehouse())) {
            this.updateWarehouseFromRegister(currentRegister.getWarehouse());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)currentRegister.getCurrencyId()) && ObjectChecker.isEmptyOrNull((Object)this.getCurrency())) {
            this.updateCurrency(ServerStringUtils.toUUIDStr((Object)currentRegister.fetchCurrency().getId()), false, view);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)currentRegister.getLocation()) && ObjectChecker.isEmptyOrNull((Object)this.getLocation())) {
            this.setLocation(currentRegister.getLocation());
        }
        POSInvoiceClassification posInvoiceClassification = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchPOSConfig().getInvoiceClassification())) {
            posInvoiceClassification = POSPersister.findByID(POSInvoiceClassification.class, POSResourcesUtil.fetchPOSConfig().getInvoiceClassification().getId());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)currentRegister.getInvoiceClassification())) {
            posInvoiceClassification = currentRegister.getInvoiceClassification();
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.getPosInvoiceClassification())) {
            this.setPosInvoiceClassification(posInvoiceClassification);
        }
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{posInvoiceClassification, view})) {
            view.getInvoiceClassification().updateFromRecord(posInvoiceClassification);
        }
        this.updateDocumentCategory(currentRegister, view);
    }

    public void updateDocumentCategory(POSRegistery currentRegister, AbsPosSalesScreen view) {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getDocCategory())) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)currentRegister.getDocCategory())) {
            this.setDocCategory(currentRegister.getDocCategory());
        } else if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchPOSConfig().getDefaultDocCategory())) {
            this.setDocCategory(POSPersister.findByID(PosDocCategory.class, POSResourcesUtil.fetchPOSConfig().getDefaultDocCategory().getId()));
        }
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{this.getDocCategory(), view})) {
            view.getDocCategory().getIdBox().setText(this.getDocCategory().getId().toString());
            view.getDocCategory().getCodeBox().setText(this.getDocCategory().getCode());
            view.getDocCategory().getNameBox().setText(this.getDocCategory().nameByLanguage());
        }
    }

    public String calcDistinctItemsCount(AbsPosSalesScreen<?> view) {
        if (ObjectChecker.isEmptyOrNull(view)) {
            return "0";
        }
        ObservableList lines = view.getSalesTable().getItems();
        return ObjectChecker.toStringOrEmpty((Object)lines.stream().map(AbsPOSSalesLine::getItem).distinct().count());
    }

    public void updateSalesMan(String id) {
        POSEmployee salesman = null;
        salesman = ObjectChecker.isNotEmptyOrNull((Object)id) ? POSPersister.findByID(POSEmployee.class, id) : null;
        this.setSalesMan(salesman);
        if (salesman == null || ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fillSalesManInDetails())) {
            return;
        }
        for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
            if (!ObjectChecker.isEmptyOrNull((Object)absPOSSalesLine.getSalesman())) continue;
            absPOSSalesLine.setSalesman(salesman);
        }
    }

    public <T extends AbsPOSSalesLine> void calcUnitPriceAndFreeLines(POSRegistery register, AbsPOSSalesLine posSalesLine, boolean unitPriceEditedByUser, AbsPosSalesScreen view) {
        this.calcUnitPriceAndFreeLines(register, posSalesLine, unitPriceEditedByUser, view, false);
    }

    public <T extends AbsPOSSalesLine> void calcUnitPriceAndFreeLines(POSRegistery register, AbsPOSSalesLine posSalesLine, boolean unitPriceEditedByUser, AbsPosSalesScreen view, boolean recalculate) {
        this.setLastModifiedLine(posSalesLine);
        if (ObjectChecker.areEqual((Object)posSalesLine.getWarehouseIssueMethod(), (Object)WarehouseIssueMethod.ToBeIssued.name())) {
            posSalesLine.setUnitPrice(BigDecimal.ZERO);
            return;
        }
        if (!posSalesLine.getFreeLine().booleanValue()) {
            for (int i = this.fetchDetails().size() - 1; i >= 0; --i) {
                AbsPOSSalesLine line = this.fetchDetails().get(i);
                if (ObjectChecker.areNotEqual((Object)line.getMasterRowId(), (Object)posSalesLine.getId())) continue;
                this.fetchDetails().remove(i);
                if (view == null) continue;
                view.getSalesTable().getItems().remove(i);
            }
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)posSalesLine) && ObjectChecker.isNotEmptyOrNull((Object)posSalesLine.getItemCode())) {
            POSItemSalesPriceReq requestHeader = this.createItemSalesPriceReq(register, posSalesLine);
            POSItemSalesPriceResDetail cachedPriceResDetail = POSPricesCachingUtil.searchForPrice(posSalesLine, this);
            BigDecimal oldUnitPrice = posSalesLine.getUnitPrice();
            if (ObjectChecker.isNotEmptyOrNull((Object)cachedPriceResDetail)) {
                this.calcLinePriceAndDiscountsFromCachedResult(register, posSalesLine, unitPriceEditedByUser, view, recalculate, cachedPriceResDetail, oldUnitPrice, requestHeader);
            } else {
                this.calcLinePriceAndDiscounts(register, posSalesLine, view, recalculate, requestHeader, oldUnitPrice);
            }
        }
        if (!recalculate) {
            this.calcDiscountsFromOffersConditionally(register, view);
        }
    }

    private POSItemSalesPriceReq createItemSalesPriceReq(POSRegistery register, AbsPOSSalesLine posSalesLine) {
        posSalesLine.roundQty();
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSInvoiceClassification invClassifition = (POSInvoiceClassification)ObjectChecker.getFirstNotNullObj((Object[])new POSInvoiceClassification[]{this.getPosInvoiceClassification(), POSResourcesUtil.calcInvoiceClassification(register)});
        POSItemSalesPriceReq requestHeader = POSSalesPriceUtil.createSalesPriceRequestHeader(Arrays.asList(NaMaMath.absValue((BigDecimal)posSalesLine.getQty().getValue())), new Date(), invClassifition, POSSalesPriceReqType.SingleLine, currentUser, Arrays.asList(posSalesLine), ObjectChecker.toZeroIfNull((BigDecimal)this.getDiscountPercent()).toString(), this.getTotalPrice(), ObjectChecker.toZeroIfNull((BigDecimal)this.getNetPrice()).toString(), this);
        return requestHeader;
    }

    private void calcLinePriceAndDiscountsFromCachedResult(POSRegistery register, AbsPOSSalesLine posSalesLine, boolean unitPriceEditedByUser, AbsPosSalesScreen view, boolean recalculate, POSItemSalesPriceResDetail cachedPriceResDetail, BigDecimal oldUnitPrice, POSItemSalesPriceReq requestHeader) {
        if (cachedPriceResDetail.getPrice() != null && (ObjectChecker.isEmptyOrZero((BigDecimal)posSalesLine.getUnitPrice()) || ObjectChecker.areNotEqual((Object)cachedPriceResDetail.getPrice(), (Object)posSalesLine.getUnitPrice()) && !unitPriceEditedByUser)) {
            posSalesLine.setUnitPrice(ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{cachedPriceResDetail.getPrice(), oldUnitPrice}));
        }
        if (ObjectChecker.isNotEmptyOrNull(cachedPriceResDetail.getDiscounts())) {
            this.updateLinesDiscountsFromCache(register, posSalesLine, cachedPriceResDetail.getDiscounts(), view, recalculate);
        }
        this.addFreeItemsFromResponse(register, posSalesLine, cachedPriceResDetail, view);
        this.updateLines(posSalesLine, view);
        POSSalesHeaderDiscountResp discountPercent = POSSalesPriceUtil.calculateHeaderDicount(requestHeader, this.getTotalPrice(), this.getTotalPrice());
        BigDecimal headerDiscount = POSSalesPriceUtil.determineAppropiatDiscount(discountPercent.getMinDiscountPercent(), requestHeader.getHeaderPercent(), discountPercent.getMinDiscountPercent(), discountPercent.getMaxDiscountPercent());
        this.setDiscountPercent(NaMaMath.round((BigDecimal)headerDiscount, (Integer)POSMoneyUtils.getPercentageScale()));
        this.updateLineAndTotalMoney(view, true);
        posSalesLine.setPriceListLineId(cachedPriceResDetail.getPriceListLineID());
        DisplayPoleConnectorUtil.writeAddingLineMsg(this);
    }

    private void updateLinesDiscountsFromCache(POSRegistery register, AbsPOSSalesLine posSalesLine, List<POSSalesDiscountResultUnit> discounts, AbsPosSalesScreen view, boolean fromRecursion) {
        List discountLinesFromOffer = discounts.stream().flatMap(l -> l.getApplyOnlyIfItemInInvoiceLines().stream()).toList();
        if (fromRecursion || ObjectChecker.isEmptyOrNull(discountLinesFromOffer)) {
            this.applyDiscountsOnLine(posSalesLine, discounts);
            return;
        }
        ArrayList<POSItemDiscountLine> applicableDiscountLines = new ArrayList<POSItemDiscountLine>();
        Set invoiceItems = this.fetchDetails().stream().map(AbsPOSSalesLine::getItem).collect(Collectors.toSet());
        block0: for (POSItemDiscountLine posItemDiscountLine : discountLinesFromOffer) {
            for (POSFreeGroupLine detail : posItemDiscountLine.getApplyOnlyIfItemInInvoice().getDetails()) {
                if (!invoiceItems.stream().noneMatch(i -> ObjectChecker.areEqual((Object)i, (Object)detail.getItem()))) continue;
                continue block0;
            }
            applicableDiscountLines.add(posItemDiscountLine);
        }
        if (ObjectChecker.isEmptyOrNull(applicableDiscountLines)) {
            this.applyDiscountsOnLine(posSalesLine, discounts.stream().filter(l -> ObjectChecker.isEmptyOrNull(l.getApplyOnlyIfItemInInvoiceLines())).toList());
            return;
        }
        List<AbsPOSSalesLine> linesToRecalculate = this.fetchDetails().stream().filter(l -> POSSalesPriceUtil.isAnyDiscountApplicableOnLine(applicableDiscountLines, l)).toList();
        for (AbsPOSSalesLine line : linesToRecalculate) {
            POSItemSalesPriceReq requestHeader = this.createItemSalesPriceReq(register, line);
            POSItemSalesPriceResDetail cachedPriceResDetail = POSPricesCachingUtil.searchForPrice(posSalesLine, this);
            this.calcLinePriceAndDiscountsFromCachedResult(register, line, false, view, true, cachedPriceResDetail, line.getUnitPrice(), requestHeader);
        }
    }

    private void calcLinePriceAndDiscounts(POSRegistery register, AbsPOSSalesLine posSalesLine, AbsPosSalesScreen view, boolean recalculate, POSItemSalesPriceReq requestHeader, BigDecimal oldUnitPrice) {
        boolean notServiceNorMinChangeNorDelivery;
        POSItemSalesPriceRes response = POSSalesPriceUtil.updateLinePriceAndDiscounts(requestHeader);
        if (ObjectChecker.isEmptyOrNull((Object)response)) {
            return;
        }
        boolean serviceItem = ObjectChecker.areEqual((Object)AbsPOSSales.fetchServiceItem(), (Object)posSalesLine.getItem());
        boolean deliveryItem = ObjectChecker.areEqual((Object)AbsPOSSales.fetchDeliveryItem(), (Object)posSalesLine.getItem());
        boolean minChargeItem = ObjectChecker.areEqual((Object)AbsPOSSales.fetchMinChargeItem(), (Object)posSalesLine.getItem());
        boolean bl = notServiceNorMinChangeNorDelivery = !serviceItem && !deliveryItem && !minChargeItem;
        if (notServiceNorMinChangeNorDelivery && ObjectChecker.isEmptyOrNull(response.getFreeItems())) {
            POSItemSalesPriceResDetail posItemSalesPriceResDetail = response.getDetails().get(0);
            POSPricesCachingUtil.addEntryToCache(posSalesLine, this, posItemSalesPriceResDetail);
        }
        if (serviceItem) {
            posSalesLine.setUnitPrice(this.calculateServiceChargeValue());
        } else if (deliveryItem) {
            posSalesLine.setUnitPrice(this.calculateDeliveryCost());
        } else if (minChargeItem) {
            posSalesLine.setUnitPrice(this.calculateMinChargeVal());
        } else {
            List<POSItemSalesPriceResDetail> details = response.getDetails();
            if (ObjectChecker.isNotEmptyOrNull(details) && ObjectChecker.isNotEmptyOrNull((Object)details.getFirst())) {
                POSItemSalesPriceResDetail responseLine = details.getFirst();
                if (responseLine.getPrice() != null) {
                    posSalesLine.setUnitPrice(ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{responseLine.getPrice(), oldUnitPrice}));
                    posSalesLine.setPriceListLineId(responseLine.getPriceListLineID());
                }
                this.addFreeItemsFromResponse(register, posSalesLine, responseLine, view);
                List<POSSalesDiscountResultUnit> discounts = responseLine.getDiscounts();
                if (AbsPOSSales.shouldUpdateLineDiscounts(discounts, posSalesLine)) {
                    this.updateLinesDiscounts(register, posSalesLine, discounts, view, recalculate);
                }
            }
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)response.getHeaderDiscount())) {
            this.setDiscountPercent(response.getHeaderDiscount());
        }
    }

    private static boolean shouldUpdateLineDiscounts(List<POSSalesDiscountResultUnit> discounts, AbsPOSSalesLine line) {
        if (ObjectChecker.isEmptyOrNull(discounts)) {
            return false;
        }
        boolean applyDiscounts = discounts.stream().anyMatch(l -> ObjectChecker.isNotEmptyOrZero((BigDecimal)l.getDiscountValue()));
        if (applyDiscounts) {
            return true;
        }
        return !AbsPOSSales.isEmptyDiscount(line.getDiscount1()) || !AbsPOSSales.isEmptyDiscount(line.getDiscount2()) || !AbsPOSSales.isEmptyDiscount(line.getDiscount3()) || !AbsPOSSales.isEmptyDiscount(line.getDiscount4()) || !AbsPOSSales.isEmptyDiscount(line.getDiscount5()) || !AbsPOSSales.isEmptyDiscount(line.getDiscount6()) || !AbsPOSSales.isEmptyDiscount(line.getDiscount7()) || !AbsPOSSales.isEmptyDiscount(line.getDiscount8());
    }

    private static boolean isEmptyDiscount(POSDiscountTax discount) {
        return ObjectChecker.isEmptyOrNull((Object)discount) || discount.isEmptyOrZero();
    }

    private void updateLinesDiscounts(POSRegistery register, AbsPOSSalesLine posSalesLine, List<POSSalesDiscountResultUnit> discounts, AbsPosSalesScreen view, boolean fromRecursion) {
        List discountLinesFromOffer = discounts.stream().flatMap(l -> l.getApplyOnlyIfItemInInvoiceLines().stream()).toList();
        if (fromRecursion || ObjectChecker.isEmptyOrNull(discountLinesFromOffer)) {
            this.applyDiscountsOnLine(posSalesLine, discounts);
        } else {
            List<AbsPOSSalesLine> linesToRecalculate = this.fetchDetails().stream().filter(l -> POSSalesPriceUtil.isAnyDiscountApplicableOnLine(discountLinesFromOffer, l)).toList();
            for (AbsPOSSalesLine line : linesToRecalculate) {
                POSItemSalesPriceReq requestHeader = this.createItemSalesPriceReq(register, line);
                this.calcLinePriceAndDiscounts(register, line, view, true, requestHeader, line.getUnitPrice());
            }
        }
    }

    private Function<AbsPOSSalesLine, BigDecimal> serviceChargeCalcFrom(String location) {
        if (ObjectChecker.isNotEmptyOrNull(serviceChargeCalcFrom)) {
            return serviceChargeCalcFrom.get(location);
        }
        serviceChargeCalcFrom.put(PosServiceItemCalcType.BasePrice.name(), AbsPOSSalesLine::getTotalPrice);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount1.name(), AbsPOSSalesLine::getAfterDisc1);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount2.name(), AbsPOSSalesLine::getAfterDisc2);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount3.name(), AbsPOSSalesLine::getAfterDisc3);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount4.name(), AbsPOSSalesLine::getAfterDisc4);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount5.name(), AbsPOSSalesLine::getAfterDisc5);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount6.name(), AbsPOSSalesLine::getAfterDisc6);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount7.name(), AbsPOSSalesLine::getAfterDisc7);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterDiscount8.name(), AbsPOSSalesLine::getAfterDisc8);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterTax1.name(), AbsPOSSalesLine::getAfterTax1);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.AfterTax2.name(), AbsPOSSalesLine::getAfterTax2);
        serviceChargeCalcFrom.put(PosServiceItemCalcType.NetValue.name(), AbsPOSSalesLine::getNetPrice);
        return serviceChargeCalcFrom.get(location);
    }

    public void setCustomDeliveryCost(BigDecimal customDeliveryCost) {
        this.customDeliveryCost = customDeliveryCost;
    }

    public BigDecimal calculateDeliveryCost() {
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.customDeliveryCost)) {
            return this.customDeliveryCost;
        }
        PosDeliveryCost deliveryCost = PosSalesUtil.fetchDeliveryCostSettings();
        if (deliveryCost == null) {
            return BigDecimal.ZERO;
        }
        List<PosDeliveryCostLine> details = deliveryCost.getDetails();
        PosDeliveryCostLine line = details.stream().filter(this::posDeliveryCostLineMatched).findFirst().orElse(null);
        if (line == null) {
            return BigDecimal.ZERO;
        }
        return line.getDeliveryCost();
    }

    public boolean posDeliveryCostLineMatched(PosDeliveryCostLine l) {
        if (ObjectChecker.isNotEmptyOrNull((Object)l.getAddressRegion()) && ObjectChecker.areNotEqual((Object)l.getAddressRegion(), (Object)this.getAddressRegion())) {
            return false;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)l.getCustomer()) && ObjectChecker.areNotEqual((Object)l.getCustomer(), (Object)this.getCustomer())) {
            return false;
        }
        if (this.deliveryCostLineCustomerNotMatched(l)) {
            return false;
        }
        return this.specialItemLineMatched(l);
    }

    private boolean deliveryCostLineCustomerNotMatched(PosDeliveryCostLine l) {
        POSEntityRefData customerRef = l.getCustomerRef();
        if (customerRef == null) {
            return false;
        }
        if (this.getCustomer() == null) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)customerRef.getNamaGenRefId(), (Object)this.getCustomer().getId())) {
            return false;
        }
        return this.getCustomer().getCustomerClass() == null || ObjectChecker.areNotEqual((Object)customerRef.getNamaGenRefId(), (Object)this.getCustomer().getCustomerClass().getId());
    }

    public BigDecimal calculateMinChargeVal() {
        PosMinCharge minCharge = PosSalesUtil.fetchMinChargeSettings();
        if (minCharge == null) {
            return BigDecimal.ZERO;
        }
        List<PosMinChargeLine> details = minCharge.getDetails();
        PosMinChargeLine line = details.stream().filter(this::posMinChargeLineMatched).findFirst().orElse(null);
        if (line == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal minChargeValue = line.getMinChargeValue();
        String calcLocation = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{POSResourcesUtil.fetchMainRegister().getMinChargeCalcType(), POSResourcesUtil.fetchPOSConfig().getMinChargeCalcType(), "AfterDiscount8"});
        BigDecimal calcFromValue = this.fetchDetails().stream().filter(l -> ObjectChecker.areNotEqual((Object)l.getItem(), (Object)AbsPOSSales.fetchMinChargeItem())).map(this.serviceChargeCalcFrom(calcLocation)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return minChargeValue.subtract(calcFromValue);
    }

    public boolean posMinChargeLineMatched(PosMinChargeLine line) {
        return this.specialItemLineMatched(line);
    }

    private <T extends POSSpecialItemLine> boolean specialItemLineMatched(T line) {
        Date valueDate = (Date)ObjectChecker.getFirstNotEmptyObj((Object[])new Date[]{this.getValueDate(), new Date()});
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getFromDate()) && line.getFromDate().after(valueDate)) {
            return false;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getToDate()) && line.getToDate().before(valueDate)) {
            return false;
        }
        return !ObjectChecker.isNotEmptyOrNull((Object)line.getInvoiceClassification()) || !ObjectChecker.areNotEqual((Object)line.getInvoiceClassification(), (Object)this.getPosInvoiceClassification());
    }

    public boolean posServiceChargeLineMatched(POSServiceChargeLine line) {
        return this.specialItemLineMatched(line);
    }

    public BigDecimal calculateServiceChargeValue() {
        DTOPosServiceCharge configServiceCharge = POSResourcesUtil.fetchPOSConfig().getServiceCharge();
        String serviceCalcLocation = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{POSResourcesUtil.fetchMainRegister().getServiceItemCalcType(), configServiceCharge == null ? null : configServiceCharge.getServiceItemCalcType(), "AfterDiscount8"});
        BigDecimal servicePercentage = (BigDecimal)ObjectChecker.getFirstNotNullObj((Object[])new BigDecimal[]{POSResourcesUtil.fetchMainRegister().getServiceChargePercent(), configServiceCharge == null ? null : configServiceCharge.getPercentage()});
        if (ObjectChecker.isEmptyOrZero((BigDecimal)servicePercentage)) {
            return BigDecimal.ZERO;
        }
        POSItem minChargeItem = AbsPOSSales.fetchMinChargeItem();
        POSItem serviceItem = AbsPOSSales.fetchServiceItem();
        BigDecimal serviceCalcFrom = this.fetchDetails().stream().filter(l -> ObjectChecker.NOTisAnyEqualToFirst((Object)l.getItem(), (Object[])new POSItem[]{serviceItem, minChargeItem})).map(this.serviceChargeCalcFrom(serviceCalcLocation)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return NaMaMath.calcPercentageValue((BigDecimal)serviceCalcFrom, (BigDecimal)servicePercentage, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
    }

    public void updateLines(AbsPOSSalesLine posSalesLine, AbsPosSalesScreen view) {
        this.updateLineValues(posSalesLine);
        if (view != null) {
            view.updateFieldsEvent(Arrays.asList("details"), this);
        }
        NaMaProfiler.get().end("restofwork", new Object[0]);
    }

    public void addFreeItemsFromResponse(POSRegistery register, AbsPOSSalesLine posSalesLine, POSItemSalesPriceResDetail responseLine, AbsPosSalesScreen view) {
        HashSet<UUID> groupIds = new HashSet<UUID>();
        List<POSItemSalesFreeItem> freeItems = responseLine.getFreeItems();
        if (ObjectChecker.isEmptyOrNull(freeItems)) {
            return;
        }
        for (POSItemSalesFreeItem posItemSalesFreeItem : freeItems) {
            if (this.groupAdded(posItemSalesFreeItem, groupIds)) continue;
            POSItem item = POSPersister.findByID(POSItem.class, posItemSalesFreeItem.getItem().getId());
            BigDecimal totalQty = NaMaMath.round((BigDecimal)posItemSalesFreeItem.getQty().getValue(), (Integer)this.getCurrency().getFractionDecimalPlaces());
            UUID groupId = posItemSalesFreeItem.getGroupId();
            POSFreeItemGroup freeItemGroup = groupId == null ? null : POSPersister.findByID(POSFreeItemGroup.class, groupId);
            String groupPolicy = null;
            if (freeItemGroup != null) {
                groupPolicy = freeItemGroup.getGroupPolicy();
            }
            if (view != null && ObjectChecker.areEqual((Object)FreeGroupPolicy.One.name(), (Object)groupPolicy)) {
                this.openGroupToSelectItem(freeItemGroup, totalQty, view, (i, lineQty) -> {
                    AbsPOSSalesLine line = this.addSalesFreeLine(register, (POSItem)i, view.getCurrentLine(), (BigDecimal)lineQty, posItemSalesFreeItem.getQty().getUom(), posItemSalesFreeItem.getSpecificDimensions(), posSalesLine.getId(), posItemSalesFreeItem.getNotFreeButDiscount(), posItemSalesFreeItem.getDiscLocation(), posItemSalesFreeItem.getDiscountPercentage(), view);
                    this.updateLineDataFromFreeLine(posItemSalesFreeItem, line);
                });
                continue;
            }
            int currentLine = this.fetchDetails().size();
            if (view != null) {
                currentLine = view.getCurrentLine();
            }
            AbsPOSSalesLine line = this.addSalesFreeLine(register, item, currentLine, totalQty, posItemSalesFreeItem.getQty().getUom(), posItemSalesFreeItem.getSpecificDimensions(), posSalesLine.getId(), posItemSalesFreeItem.getNotFreeButDiscount(), posItemSalesFreeItem.getDiscLocation(), posItemSalesFreeItem.getDiscountPercentage(), view);
            this.updateLineDataFromFreeLine(posItemSalesFreeItem, line);
        }
    }

    private void updateLineDataFromFreeLine(POSItemSalesFreeItem posItemSalesFreeItem, AbsPOSSalesLine line) {
        if (line == null || posItemSalesFreeItem == null) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)posItemSalesFreeItem.getItemCode())) {
            line.setItemCode(posItemSalesFreeItem.getItemCode());
        }
        if (ObjectChecker.isTrue((Boolean)posItemSalesFreeItem.getEditableFreeLine())) {
            line.setEditableFreeLine(true);
        }
    }

    private boolean groupAdded(POSItemSalesFreeItem posItemSalesFreeItem, Set<UUID> groupIds) {
        if (ObjectChecker.areEqual((Object)posItemSalesFreeItem.getGroupId(), (Object)posItemSalesFreeItem.getItem().getId())) {
            return false;
        }
        if (ObjectChecker.isFalse((Boolean)posItemSalesFreeItem.getGroupExeclusive())) {
            return false;
        }
        if (groupIds.contains(posItemSalesFreeItem.getGroupId())) {
            return true;
        }
        groupIds.add(posItemSalesFreeItem.getGroupId());
        return false;
    }

    public void applyDiscountsOnLine(AbsPOSSalesLine posSalesLine, List<POSSalesDiscountResultUnit> discounts) {
        DTOTaxConfiguration taxConfiguration = DTOTaxPlan.fetchTaxConfiguration((DTOTaxPlan)POSResourcesUtil.fetchPosConfigDtoTaxPlan(), (DTOTaxPlan)POSResourcesUtil.fetchItemDtoTaxPlanFrom(posSalesLine == null ? null : posSalesLine.getItem()), (EntityReferenceData)POSResourcesUtil.fetchMainRegister().fetchLegalEntityRef(), (Date)this.valueDate, (DTOGlobalConfigInfo)POSResourcesUtil.fetchGlobalConfig().getInfo(), (String)this.calcNamaEntityType());
        posSalesLine.updateTotal();
        posSalesLine.getPrice();
        posSalesLine.getDiscount1().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 0));
        posSalesLine.getDiscount1().setValue(BigDecimal.ZERO);
        posSalesLine.getDiscount2().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 1));
        posSalesLine.getDiscount2().setValue(BigDecimal.ZERO);
        posSalesLine.getDiscount3().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 2));
        posSalesLine.getDiscount3().setValue(BigDecimal.ZERO);
        posSalesLine.getDiscount4().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 3));
        posSalesLine.getDiscount4().setValue(BigDecimal.ZERO);
        posSalesLine.getDiscount5().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 4));
        posSalesLine.getDiscount5().setValue(BigDecimal.ZERO);
        posSalesLine.getDiscount6().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 5));
        posSalesLine.getDiscount6().setValue(BigDecimal.ZERO);
        posSalesLine.getDiscount7().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 6));
        posSalesLine.getDiscount7().setValue(BigDecimal.ZERO);
        posSalesLine.getDiscount8().setPercentage(AbsPOSSales.calcDiscountPercentage(discounts, 8));
        posSalesLine.getDiscount8().setValue(BigDecimal.ZERO);
        posSalesLine.setDeactivateEmpDiscountsValidations(discounts.stream().anyMatch(l -> ObjectChecker.isTrue((Boolean)l.getDeactivateEmpValidations())));
        posSalesLine.setDiscountConsidersOtherItemsInInvoice(discounts.stream().anyMatch(POSSalesDiscountResultUnit::fetchDiscountConsidersOtherItemsInInvoice));
        this.updateLineValues(posSalesLine);
    }

    private static BigDecimal calcDiscountPercentage(List<POSSalesDiscountResultUnit> discounts, int discountIndex) {
        if (discounts.size() <= discountIndex) {
            return BigDecimal.ZERO;
        }
        return discounts.get(discountIndex).getDiscountValue();
    }

    public String fetchTotal() {
        BigDecimal total = BigDecimal.ZERO;
        for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
            total = total.add(absPOSSalesLine.getTotalPrice());
        }
        this.setLineTotalsBeforeDiscs(total);
        return total.toString();
    }

    public String fetchDiscTotal() {
        BigDecimal discs = BigDecimal.ZERO;
        for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
            discs = discs.add(absPOSSalesLine.getDiscount1().getValue()).add(absPOSSalesLine.getDiscount2().getValue()).add(absPOSSalesLine.getDiscount3().getValue()).add(absPOSSalesLine.getDiscount4().getValue()).add(absPOSSalesLine.getDiscount5().getValue()).add(absPOSSalesLine.getDiscount6().getValue()).add(absPOSSalesLine.getDiscount7().getValue()).add(absPOSSalesLine.getDiscount8().getValue());
        }
        return discs.toString();
    }

    public String fetchTaxesTotal() {
        BigDecimal taxes = BigDecimal.ZERO;
        EntityReferenceData legalEntity = POSResourcesUtil.fetchMainRegister().fetchLegalEntityRef();
        for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
            DTOTaxConfiguration taxConfiguration = DTOTaxPlan.fetchTaxConfiguration((DTOTaxPlan)POSResourcesUtil.fetchPosConfigDtoTaxPlan(), (DTOTaxPlan)POSResourcesUtil.fetchItemDtoTaxPlanFrom(absPOSSalesLine == null ? null : absPOSSalesLine.getItem()), (EntityReferenceData)legalEntity, (Date)this.valueDate, (DTOGlobalConfigInfo)POSResourcesUtil.fetchGlobalConfig().getInfo(), (String)this.calcNamaEntityType());
            taxes = taxes.add(absPOSSalesLine.getTax1().getValue());
            Boolean tax2IsDisc = false;
            if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.currentSetting)) {
                tax2IsDisc = taxConfiguration.getTax2IsDiscount();
            }
            if (tax2IsDisc.booleanValue()) {
                taxes = taxes.subtract(absPOSSalesLine.getTax2().getValue());
                continue;
            }
            taxes = taxes.add(absPOSSalesLine.getTax2().getValue());
        }
        return taxes.toString();
    }

    public Date getHoldTime() {
        return this.holdTime;
    }

    public void setHoldTime(Date holdTime) {
        this.holdTime = holdTime;
    }

    @Override
    public POSInvoiceClassification getPosInvoiceClassification() {
        this.posInvoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.posInvoiceClassification);
        return this.posInvoiceClassification;
    }

    public void setPosInvoiceClassification(POSInvoiceClassification posInvoiceClassification) {
        this.posInvoiceClassification = posInvoiceClassification;
    }

    public void updateInvoiceClassification(String id, AbsPosSalesScreen view) {
        if (ObjectChecker.isNotEmptyOrNull((Object)id)) {
            this.setPosInvoiceClassification(POSPersister.findByID(POSInvoiceClassification.class, id));
        } else {
            this.setPosInvoiceClassification(null);
        }
    }

    public void updateReturnReason(String id) {
        if (!(this instanceof IPOSDocFromInvoice)) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)id)) {
            POSReturnReason returnReason = POSPersister.findByID(POSReturnReason.class, id);
            ((IPOSDocFromInvoice)((Object)this)).setReturnReason(returnReason);
        } else {
            ((IPOSDocFromInvoice)((Object)this)).setReturnReason(null);
        }
    }

    public void updateSalesPrices(POSRegistery register, AbsPosSalesScreen view) {
        if (ObjectChecker.isEmptyOrNull(this.fetchDetails())) {
            return;
        }
        for (int i = 0; i < this.fetchDetails().size(); ++i) {
            AbsPOSSalesLine posSalesLine = this.fetchDetails().get(i);
            if (posSalesLine.isFreeLine().booleanValue()) continue;
            this.calcUnitPriceAndFreeLines(register, posSalesLine, false, view);
        }
    }

    public BigDecimal getLineTotalsBeforeDiscs() {
        return this.lineTotalsBeforeDiscs;
    }

    public void setLineTotalsBeforeDiscs(BigDecimal lineTotalsBeforeDiscs) {
        this.lineTotalsBeforeDiscs = lineTotalsBeforeDiscs;
    }

    public BigDecimal totalOtherPayments() {
        BigDecimal totalPays = BigDecimal.ZERO;
        for (AbsPOSPaymentLine absPOSPaymentLine : this.fetchPayments()) {
            totalPays = totalPays.add(absPOSPaymentLine.getValue());
        }
        return totalPays;
    }

    public void updateRemarksIfNotEmpty(String text) {
        if (ObjectChecker.isNotEmptyOrNull((Object)text)) {
            this.setRemarks(text);
        }
    }

    @Override
    public boolean searchOnAllFields() {
        return true;
    }

    public String getPaymentMethods() {
        Object methods = "";
        for (AbsPOSPaymentLine absPOSPaymentLine : this.fetchPayments()) {
            methods = (String)methods + absPOSPaymentLine.getMethodName() + " - ";
        }
        return methods;
    }

    public void setPaymentMethods(String methods) {
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "customer", "salesMan", "netPrice", "valueDate", "holdTime", "paymentMethods", "replacementCode", "shiftCode", "tablesCodes");
        return creatorUtil.createColumns(fields);
    }

    public BigDecimal getChange() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.change);
    }

    @Override
    public void postCommitAction(Session session) {
        if (this.getHold() || this.postCommitActionsApplied.booleanValue()) {
            return;
        }
        this.assignIds();
        if (this.isFromServer()) {
            if (this.shouldApplyFinancialEffects()) {
                POSFinancialUtil.applyEffects(this, session);
            }
            this.updateFromInvoice(session);
        } else {
            POSFinancialUtil.applyEffects(this, session);
        }
        this.postCommitActionsApplied = true;
    }

    private boolean isFromServer() {
        if (this instanceof IPOSDocFromInvoice) {
            return ObjectChecker.isTrue((Boolean)((IPOSDocFromInvoice)((Object)this)).getSrcInvoiceFromRemoteRegister());
        }
        return false;
    }

    private boolean shouldApplyFinancialEffects() {
        return ObjectChecker.areEqual((Object)this.getRegisterId(), (Object)POSResourcesUtil.fetchMainRegister().getId());
    }

    protected POSRegistery fetchOriginRegister() {
        return null;
    }

    @Override
    public Date fetchValueDate() {
        return this.getValueDate();
    }

    @Override
    public Date fetchValueTime() {
        return this.getValueTime();
    }

    @Override
    public List<? extends IPOSFinancialEffect> effects() {
        return null;
    }

    public void addPaymentDetails(Map<POSPaymentMethod, List<PaymentInfo>> payments, POSRegistery register) {
        this.fetchPayments().clear();
        for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> posPaymentMethod : payments.entrySet()) {
            this.addPaymentLines(posPaymentMethod, register);
        }
    }

    public void updateFromInvoice(Session session) {
    }

    public POSResult processCreditNotesAndCoupons(POSRegistery register, List<PaymentInfo> creditNoteInfos, List<PaymentInfo> couponsInfoInPayments) {
        return new POSResult();
    }

    public POSResult writeDocToServer(POSRegistery register, List<PaymentInfo> couponsInfoInPayments, List<PaymentInfo> creditNoteInfos, Callback callback, boolean preventDraft) {
        return new POSResult();
    }

    public POSResult writeDocToServerFirst(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        return new POSResult();
    }

    public POSResult writeDocToServerFirstThenPOS(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        POSResult result = this.writeDocToServerFirst(register, creditNoteInfos);
        if (result.isSucceeded().booleanValue() && this.getSent().booleanValue()) {
            POSPersister.saveOrUpdateWithActionHistory(this).addToAccumulateResult(result);
        }
        return result;
    }

    public List<POSTable> calcTables() {
        List<POSTable> tables = this.fetchTables().stream().map(AbsPOSSalesTableLine::getPosTable).filter(ObjectChecker::isNotEmptyOrNull).collect(Collectors.toList());
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getTable()) && tables.stream().noneMatch(t -> ObjectChecker.areEqual((Object)t, (Object)this.getTable()))) {
            tables.add(this.getTable());
        }
        return tables;
    }

    public List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> fetchOfferOnItemsCount() {
        ArrayList<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> linesOfItemToGetFree = new ArrayList<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>>();
        if (ObjectChecker.areNotEqual((Object)this.calcNamaEntityType(), (Object)"NamaPOSSalesInvoice")) {
            return linesOfItemToGetFree;
        }
        return POSSalesPriceUtil.findLinesOfItemToGetFree(this);
    }

    public DTOInvoiceMoney getInvoiceMoney() {
        return this.invoiceMoney;
    }

    public void setInvoiceMoney(DTOInvoiceMoney invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }

    public DTOInvoiceMoney updateMoney() {
        this.invoiceMoney = new DTOInvoiceMoney();
        this.invoiceMoney.updateNulls();
        EntityReferenceData currency = POSMasterFile.toRef(this.getCurrency());
        if (currency != null) {
            currency.put("fractionDecimalPlaces", (Object)this.getCurrency().getFractionDecimalPlaces());
        }
        this.invoiceMoney.setCurrencyRate(BigDecimal.ONE);
        return this.invoiceMoney;
    }

    public BigDecimal getDiscount2Value() {
        return this.discount2Value;
    }

    public void setDiscount2Value(BigDecimal discount2Value) {
        this.discount2Value = discount2Value;
    }

    public abstract BigDecimal calcCashValue();

    public abstract BigDecimal calcDebitValue();

    public POSUser getCurrentUser() {
        this.currentUser = POSPersister.materialize(POSUser.class, this.currentUser);
        return this.currentUser;
    }

    public void setCurrentUser(POSUser currentUser) {
        this.currentUser = currentUser;
    }

    @Override
    public String orderByCol() {
        return "valueDate";
    }

    public HashMap<MultiKeyHash, POSItemSalesFreeItem> constructItemsMapFromExistAndNew(List<POSItemSalesFreeItem> freeItems, AbsPosSalesScreen view) {
        HashMap<MultiKeyHash, POSItemSalesFreeItem> toAdd = new HashMap<MultiKeyHash, POSItemSalesFreeItem>();
        freeItems.forEach(freeItem -> {
            POSFreeItemGroup group = null;
            if (ObjectChecker.isNotEmptyOrNull((Object)freeItem.getGroupId())) {
                group = POSPersister.findByID(POSFreeItemGroup.class, freeItem.getGroupId());
            }
            this.addOrSubtractFromMap(toAdd, group, freeItem.getQty(), freeItem.getItem(), freeItem.getSpecificDimensions(), true);
        });
        List existLinesFromOffer = this.fetchDetails().stream().filter(l -> ObjectChecker.isTrue((Boolean)l.getFreeLine()) && ObjectChecker.isTrue((Boolean)l.getFromFreeItemsOnInvoiceOffer())).collect(Collectors.toList());
        for (int i = existLinesFromOffer.size() - 1; i >= 0; --i) {
            boolean mustBeRemovedLine;
            AbsPOSSalesLine fromOfferLine = (AbsPOSSalesLine)existLinesFromOffer.get(i);
            boolean bl = mustBeRemovedLine = !toAdd.containsKey(this.makeKey(fromOfferLine.getFreeItemGroup(), fromOfferLine.getItem()));
            if (mustBeRemovedLine) {
                this.removeLineAndShowMsg(fromOfferLine, view);
                continue;
            }
            this.addOrSubtractFromMap(toAdd, fromOfferLine.getFreeItemGroup(), fromOfferLine.getQty(), fromOfferLine.getItem(), fromOfferLine.getItemDimensions(), false);
        }
        return toAdd;
    }

    public void removeLineAndShowMsg(AbsPOSSalesLine fromOfferLine, AbsPosSalesScreen view) {
        this.fetchDetails().remove(fromOfferLine);
        if (view != null) {
            view.updateFieldsEvent(Arrays.asList("details"), this);
        }
        POSDataWriterUtil.showNotificationWithFailure(null, POSResourcesUtil.id("item {0} - {1} has been removed as offer changed", fromOfferLine.getItem().getCode(), fromOfferLine.getItem().nameByLanguage()));
    }

    public void addInvoiceFreeItems(POSRegistery register, HashMap<MultiKeyHash, POSItemSalesFreeItem> toAdd, AbsPosSalesScreen view) {
        toAdd.forEach((k, v) -> {
            POSFreeItemGroup group = POSPersister.findByID(POSFreeItemGroup.class, v.getGroupId());
            if (group == null) {
                this.addSalesFreeLine(register, v.getItem(), this.fetchDetails().size(), v.getQty().getValue(), v.getQty().getUom(), v.getSpecificDimensions(), null, null, group, true, false, view);
            } else if (view != null) {
                this.openGroupToSelectItem(register, group, v.getQty().getValue(), null, true, false, view);
            }
        });
    }

    public void addOrSubtractFromMap(HashMap<MultiKeyHash, POSItemSalesFreeItem> toAdd, POSFreeItemGroup group, POSQuantity qty, POSItem item, POSItemSpecificDimensions itemDims, boolean addition) {
        MultiKeyHash key;
        POSItemSalesFreeItem mapValue;
        BigDecimal value = qty.getValue();
        if (!addition) {
            value = value.negate();
        }
        if ((mapValue = toAdd.get(key = this.makeKey(group, item))) == null) {
            mapValue = new POSItemSalesFreeItem();
            if (ObjectChecker.isNotEmptyOrNull((Object)group)) {
                mapValue.setGroupId(group.getId());
            }
            mapValue.setItem(item);
            mapValue.setQty(new POSQuantity(value, qty.getUom()));
            mapValue.setSpecificDimensions(itemDims);
            toAdd.put(key, mapValue);
            return;
        }
        if (group == null || !addition) {
            mapValue.getQty().setValue(mapValue.getQty().getValue().add(value));
        }
        if (ObjectChecker.isZero((BigDecimal)mapValue.getQty().getValue())) {
            toAdd.remove(key);
        }
    }

    public MultiKeyHash makeKey(POSFreeItemGroup group, POSItem item) {
        return MultiKeyHash.of((Object[])new Object[]{group, group == null ? item : null});
    }

    public abstract POSDocumentType docType();

    public abstract List<String> screenFieldsToUpdate();

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("valueDate");
        list.add("customer");
        list.add("shiftCode");
        list.add("salesMan");
        list.add("netPrice");
        return list;
    }

    public void updateToWarehouse(String toWarehouseId) {
    }

    public void updateCurrencyRate(String rate) {
        if (ObjectChecker.isEmptyOrNull((Object)rate)) {
            this.setCurrencyRate(BigDecimal.ONE);
            return;
        }
        this.setCurrencyRate(new BigDecimal(rate));
    }

    @Override
    public BigDecimal fetchNetPrice() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.getNetPrice());
    }

    @Override
    public BigDecimal fetchQuantity(AbsPosSalesScreen view) {
        if (ObjectChecker.isEmptyOrNull((Object)view)) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalQty = BigDecimal.ZERO;
        ObservableList lines = view.getSalesTable().getItems();
        for (AbsPOSSalesLine absPOSSalesLine : lines) {
            totalQty = totalQty.add(absPOSSalesLine.getQty().getValue());
        }
        return NaMaMath.round((BigDecimal)totalQty, (Integer)POSMoneyUtils.displayDecimalPlaces);
    }

    public void updateSubsidiary(POSMasterFile subsidiary, String subsidiaryType) {
        if (ObjectChecker.isEmptyOrNull((Object)subsidiary)) {
            return;
        }
        this.setSubsidiaryID(ServerStringUtils.strToUUID((String)ObjectChecker.toStringOrEmpty((Object)subsidiary.getId())));
        this.setSubsidiaryCode(ObjectChecker.toStringOrEmpty((Object)subsidiary.getCode()));
        this.setSubsidiaryType(ObjectChecker.toStringOrEmpty((Object)subsidiaryType));
        this.setSubsidiaryNamaType(subsidiary.calcNamaEntityType());
    }

    public AbsPOSSalesLine getLastLine() {
        return (AbsPOSSalesLine)CollectionsUtility.getLast(this.fetchDetails());
    }

    public AbsPOSSalesLine getLastModifiedLine() {
        return this.lastModifiedLine;
    }

    public void setLastModifiedLine(AbsPOSSalesLine lastModifiedLine) {
        this.lastModifiedLine = lastModifiedLine;
    }

    public AbsPOSSalesLine getLastDeletedLine() {
        return this.lastDeletedLine;
    }

    public void setLastDeletedLine(AbsPOSSalesLine lastDeletedLine) {
        this.lastDeletedLine = lastDeletedLine;
    }

    @Override
    public Date fetchDate() {
        return this.getValueDate();
    }

    @Override
    public Date fetchTime() {
        return this.getValueTime();
    }

    @Override
    public void updateDate(Date date) {
        this.setValueDate(date);
    }

    @Override
    public void updateTime(Date time) {
        this.setValueTime(time);
    }

    public boolean canSaveInAnotherUserShift() {
        return POSSecurityUtil.userCan(POSSecurityCapability.CanUseAnotherUserShift).isSucceeded();
    }

    public BigDecimal calcInvNet() {
        return BigDecimal.ZERO;
    }

    public BigDecimal calcReturnNet() {
        return BigDecimal.ZERO;
    }

    @Override
    public boolean userEnteredData() {
        return ObjectChecker.isNotEmptyOrNull(this.fetchDetails());
    }

    public POSResult itemCodeEvent(POSRegistery register, String itemCode, int currentLine, AbsPosSalesScreen screen, AbsPOSSalesLine posSalesLine, BigDecimal qty, String unitId) {
        POSResult result = new POSResult();
        if (itemCode.length() != 0) {
            this.deleteSalesLineAction(register, currentLine, screen);
            result.accumulate(this.addItemToTableSpeceificIndex(register, itemCode, currentLine, screen, qty, unitId));
        }
        return result;
    }

    public POSResult addItemToTableSpeceificIndex(POSRegistery register, String itemCode, int newLineNum, AbsPosSalesScreen screen, BigDecimal qty, String unitId) {
        POSResult result = new POSResult();
        if (ObjectChecker.isEmptyOrNull((Object)(itemCode = itemCode.trim()))) {
            return result;
        }
        if (itemCode.contains("*")) {
            String[] split = itemCode.split("\\*");
            qty = new BigDecimal(split[0]);
            itemCode = split[1];
        }
        ArrayList<GenericValue> retValues = new ArrayList<GenericValue>();
        String originalItemCode = itemCode;
        itemCode = AbsPOSSales.parseBarcode(itemCode, retValues);
        if (ObjectChecker.isNotEmptyOrNull(retValues)) {
            qty = (BigDecimal)retValues.stream().filter(v -> ObjectChecker.areEqual((Object)v.getFieldId(), (Object)"details.quantity.quantity.primeQty.value")).map(GenericValue::fieldValue).findFirst().orElse(qty);
        }
        if (ObjectChecker.isEmptyOrZero((BigDecimal)qty)) {
            qty = BigDecimal.ONE;
        }
        AbsPOSSalesLine newLine = this.addSalesLine(register, itemCode, newLineNum, qty, true, screen, false, POSPersister.findByID(POSUnit.class, unitId), result);
        if (result.isFailed().booleanValue()) {
            if (screen != null) {
                POSErrorAndInfoMessagesUtil.showError(result, screen.fetchStage());
            }
            return result;
        }
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{retValues, newLine})) {
            return result;
        }
        newLine.setItemCode(originalItemCode);
        Boolean containsUnitPrice = false;
        for (GenericValue genericValue : retValues) {
            if (ObjectChecker.areEqual((Object)genericValue.getFieldId(), (Object)"details.quantity.quantity.primeQty.value")) continue;
            AbsPosSalesScreen.namaWithPOSFields().get(genericValue.getFieldId()).set(newLine, genericValue);
            if (!genericValue.getFieldId().contains("unitPrice")) continue;
            containsUnitPrice = true;
        }
        if (containsUnitPrice.booleanValue() && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotCalcPriceIfExistsInBarcode())) {
            this.updateLineValues(newLine);
            if (screen != null) {
                this.updateLineAndTotalMoney(screen, false);
            }
        } else {
            this.calcUnitPriceAndFreeLines(register, newLine, false, screen);
        }
        return result;
    }

    public static String parseBarcode(String itemCode, List<GenericValue> retValues) {
        EntityReferenceData posItemBarcodeParser = POSResourcesUtil.fetchPOSConfig().getPosItemBarcodeParser();
        UUID parserId = (UUID)ObjectChecker.getFirstNotNullObj((Object[])new UUID[]{POSResourcesUtil.fetchMainRegister().getItemBarcodeParserId(), ObjectChecker.isEmptyOrNull((Object)posItemBarcodeParser) ? null : ServerStringUtils.strToUUID((String)posItemBarcodeParser.getId())});
        if (ObjectChecker.isEmptyOrNull((Object)parserId)) {
            return itemCode;
        }
        POSItemBarcodeParser parser = POSPersister.findByID(POSItemBarcodeParser.class, parserId);
        if (ObjectChecker.isEmptyOrNull((Object)parser)) {
            return itemCode;
        }
        CommonItemBarcodeParser commonItemBarcodeParser = new CommonItemBarcodeParser(new CommonReferencePropertyValueParser(){

            public CommonReferencePropertyValueParser instance(String entityType, String propertyId) {
                this.propertyId = propertyId;
                this.entityType = entityType;
                return this;
            }

            public Object parse(String s, DTOCommonItemBarcodePart part) {
                Class<POSUnit> refernceType = null;
                switch (this.entityType) {
                    case "UOM": {
                        refernceType = POSUnit.class;
                    }
                }
                return POSMasterFile.toRef(POSPersister.findByCode(refernceType, s));
            }
        });
        List<POSItemBarcodeSpecs> specsList = Arrays.asList(parser.getSpecs1(), parser.getSpecs2(), parser.getSpecs3(), parser.getSpecs4(), parser.getSpecs5());
        HashMap<POSItemBarcodeSpecs, List<AbsPOSItemBarcodePart>> specsWithParts = new HashMap<POSItemBarcodeSpecs, List<AbsPOSItemBarcodePart>>();
        specsWithParts.put(parser.getSpecs1(), parser.getParts1());
        specsWithParts.put(parser.getSpecs2(), parser.getParts2());
        specsWithParts.put(parser.getSpecs3(), parser.getParts3());
        specsWithParts.put(parser.getSpecs4(), parser.getParts4());
        specsWithParts.put(parser.getSpecs5(), parser.getParts5());
        List specs = CollectionsUtility.convert(specsList, object -> {
            DTOCommonItemBarcodeSpecs barcodeSpecs = new DTOCommonItemBarcodeSpecs();
            barcodeSpecs.setSeparator(object.getSeparator());
            barcodeSpecs.setTreatPrefixAsPartOfFirstProperty(object.getTreatPrefixAsPartOfFirstProperty());
            barcodeSpecs.setPrefix(object.getPrefix());
            barcodeSpecs.setMinCodeLength(object.getMinCodeLength());
            barcodeSpecs.setMaxCodeLength(object.getMaxCodeLength());
            barcodeSpecs.setParts(CollectionsUtility.convert((Collection)((Collection)specsWithParts.get(object)), partLine -> {
                DTOCommonItemBarcodePart part = new DTOCommonItemBarcodePart();
                part.setProperty(partLine.getProperty());
                part.setSeparator(partLine.getSeparator());
                part.setMultiplyBy(partLine.getMultiplyBy());
                part.setLength(Integer.valueOf(partLine.getLength()));
                part.setDivideOn(partLine.getDivideOn());
                part.setFormat(partLine.getFormat());
                return part;
            }));
            return barcodeSpecs;
        });
        return commonItemBarcodeParser.parseBarcode(itemCode, retValues, specs);
    }

    public void updateTotals(AbsPosSalesScreen screen) {
        this.updateLineAndTotalMoney(screen, true);
        PaymentDialogHelper.serviceItemMustBeReCalculated(this, screen, false);
        POSResult result = new POSResult();
        PaymentDialogHelper.minChargeItemMustBeReCalculated(this, screen, result);
        if (screen != null && result.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(result, screen.getStage());
        }
    }

    @Override
    public boolean relationWithCustomerApplied(String relation, POSCustomer customer) {
        return AbsPOSSales.relationWithObjApplied(relation, customer, this.getCustomer());
    }

    @Override
    public boolean relationWithClassificationApplied(String relation, POSInvoiceClassification classification) {
        return AbsPOSSales.relationWithObjApplied(relation, classification, this.getPosInvoiceClassification());
    }

    @Override
    public boolean relationWithDocCategoryApplied(String relation, PosDocCategory category) {
        return AbsPOSSales.relationWithObjApplied(relation, category, this.getDocCategory());
    }

    @Override
    public boolean relationWithSalesManApplied(String relation, POSEmployee salesMan) {
        return AbsPOSSales.relationWithObjApplied(relation, salesMan, this.getSalesMan());
    }

    @Override
    public boolean relationWithWarehouseApplied(String relation, POSWarehouse warehouse) {
        return AbsPOSSales.relationWithObjApplied(relation, warehouse, this.getWarehouse());
    }

    @Override
    public boolean relationWithLocatorApplied(String relation, POSLocation location) {
        return AbsPOSSales.relationWithObjApplied(relation, location, this.getLocation());
    }

    public static boolean relationWithObjApplied(String relation, Object lineObj, Object currVal) {
        if (ObjectChecker.isEmptyOrNull((Object)relation)) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)relation, (Object)PosReqFieldRelationWithRef.WithoutRelation)) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)relation, (Object)PosReqFieldRelationWithRef.Empty) && ObjectChecker.isEmptyOrNull((Object)currVal)) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)relation, (Object)PosReqFieldRelationWithRef.Equal) && ObjectChecker.areEqual((Object)currVal, (Object)lineObj)) {
            return true;
        }
        return ObjectChecker.areEqual((Object)relation, (Object)PosReqFieldRelationWithRef.NotEqual) && ObjectChecker.areNotEqual((Object)currVal, (Object)lineObj);
    }

    @Override
    public Map<String, Supplier<Object>> namaFieldsWithPosValues() {
        if (ObjectChecker.isNotEmptyOrNull(this.fieldsValues)) {
            return this.fieldsValues;
        }
        this.fieldsValues.put("customer", this::getCustomer);
        this.fieldsValues.put("warehouse", this::getWarehouse);
        this.fieldsValues.put("salesMan", this::getSalesMan);
        this.fieldsValues.put("locator", this::getLocation);
        this.fieldsValues.put("driver", this::getDriver);
        this.fieldsValues.put("docCategory", this::getDocCategory);
        this.fieldsValues.put("money.total", this::getTotalPrice);
        this.fieldsValues.put("money.netValue", this::getNetPrice);
        this.fieldsValues.put("invoiceClassification", this::getPosInvoiceClassification);
        this.fieldsValues.put("money.currency", this::getCurrency);
        this.fieldsValues.put("subsidiary", this::getSubsidiaryID);
        this.fieldsValues.put("priceClassifier1", this::getPriceClassifier1);
        this.fieldsValues.put("priceClassifier2", this::getPriceClassifier2);
        this.fieldsValues.put("priceClassifier3", this::getPriceClassifier3);
        this.fieldsValues.put("priceClassifier4", this::getPriceClassifier4);
        this.fieldsValues.put("priceClassifier5", this::getPriceClassifier5);
        this.fieldsValues.put("billingAddress.address1", this::getAddress);
        this.fieldsValues.put("shippingAddress.address1", this::getAddress);
        this.fieldsValues.put("billingAddress.region", this::getAddressRegion);
        this.fieldsValues.put("shippingAddress.region", this::getAddressRegion);
        this.fieldsValues.put("details.price.discount1.value", this::fetchDisc1Values);
        this.fieldsValues.put("details.price.discount2.value", this::fetchDisc2Values);
        this.fieldsValues.put("details.price.discount3.value", this::fetchDisc3Values);
        this.fieldsValues.put("details.price.discount4.value", this::fetchDisc4Values);
        this.fieldsValues.put("details.price.discount1.percentage", this::fetchDisc1Percent);
        this.fieldsValues.put("details.price.discount2.percentage", this::fetchDisc2Percent);
        this.fieldsValues.put("details.price.discount3.percentage", this::fetchDisc3Percent);
        this.fieldsValues.put("details.price.discount4.percentage", this::fetchDisc4Percent);
        this.fieldsValues.put("details.price.tax1.value", this::fetchTax1Value);
        this.fieldsValues.put("details.price.tax2.value", this::fetchTax2Value);
        this.fieldsValues.put("details.price.tax1.percentage", this::fetchTax1Percent);
        this.fieldsValues.put("details.price.tax2.percentage", this::fetchTax2Percent);
        this.fieldsValues.put("remarks", this::getRemarks);
        this.fieldsValues.put("description1", this::getDescription1);
        this.fieldsValues.put("description2", this::getDescription2);
        this.fieldsValues.put("description3", this::getDescription3);
        this.fieldsValues.put("description4", this::getDescription4);
        this.fieldsValues.put("description5", this::getDescription5);
        this.fieldsValues.put("customer.description1", () -> this.customerField(WritalblePOSFile::getDescription1));
        this.fieldsValues.put("customer.description2", () -> this.customerField(WritalblePOSFile::getDescription2));
        this.fieldsValues.put("customer.description3", () -> this.customerField(WritalblePOSFile::getDescription3));
        return this.fieldsValues;
    }

    private String customerField(Function<POSCustomer, String> getter) {
        if (this.getCustomer() == null) {
            return null;
        }
        return getter.apply(this.getCustomer());
    }

    private List<BigDecimal> fetchDisc1Values() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount1).map(POSDiscountTax::getValue).collect(Collectors.toList());
    }

    private Stream<? extends AbsPOSSalesLine> normalItems() {
        return this.fetchDetails().stream().filter(line -> ObjectChecker.NOTisAnyEqualToFirst((Object)line.getItem(), (Object[])new POSItem[]{AbsPOSSales.fetchDeliveryItem(), AbsPOSSales.fetchMinChargeItem(), AbsPOSSales.fetchServiceItem()}));
    }

    private List<BigDecimal> fetchDisc2Values() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount2).map(POSDiscountTax::getValue).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchDisc3Values() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount3).map(POSDiscountTax::getValue).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchDisc4Values() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount4).map(POSDiscountTax::getValue).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchDisc1Percent() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount1).map(POSDiscountTax::getPercentage).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchDisc2Percent() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount2).map(POSDiscountTax::getPercentage).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchDisc3Percent() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount3).map(POSDiscountTax::getPercentage).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchDisc4Percent() {
        return this.normalItems().map(AbsPOSSalesLine::getDiscount4).map(POSDiscountTax::getPercentage).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchTax1Percent() {
        return this.normalItems().map(AbsPOSSalesLine::getTax1).map(POSDiscountTax::getPercentage).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchTax2Percent() {
        return this.normalItems().map(AbsPOSSalesLine::getTax2).map(POSDiscountTax::getPercentage).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchTax1Value() {
        return this.normalItems().map(AbsPOSSalesLine::getTax1).map(POSDiscountTax::getValue).collect(Collectors.toList());
    }

    private List<BigDecimal> fetchTax2Value() {
        return this.normalItems().map(AbsPOSSalesLine::getTax2).map(POSDiscountTax::getValue).collect(Collectors.toList());
    }

    @Override
    public List<String> fetchReferenceFieldsIDs() {
        return Arrays.asList("money.currency", "warehouse", "toWarehouse", "locator", "toLocator", "details.item.item", "InvoiceClassification", "ReturnReason", "customer", "salesMan", "addressRegion", "driver", "reservation", "docCategory", "priceClassifier1", "priceClassifier2", "priceClassifier3", "priceClassifier4", "priceClassifier5", "table", "fromInvoiceCode", "subsidiary", "register");
    }

    public void selectSalesDoc(AbsPOSSales docToOpen, AbsPosSalesScreen posSalesScreen) {
        if (docToOpen == null || docToOpen.getId() == null) {
            return;
        }
        UUID invId = docToOpen.getId();
        AbsPOSSales invoice = (AbsPOSSales)ObjectChecker.getFirstNotNullObj((Object[])new POSSavable[]{POSPersister.findByID(posSalesScreen.fetchScreenKlass(), invId), docToOpen});
        if (ObjectChecker.isNotEmptyOrNull((Object)invoice)) {
            posSalesScreen.setSalesDoc(invoice);
            posSalesScreen.getSalesTable().getItems().clear();
            posSalesScreen.setCurrentLine(-2);
            for (AbsPOSSalesLine absPOSSalesLine : invoice.fetchDetails()) {
                posSalesScreen.getSalesTable().getItems().add((Object)absPOSSalesLine);
            }
            invoice.setOldDoc(docToOpen.isOldDoc());
            posSalesScreen.onDocumentFetched(invoice);
        } else {
            this.setCode(docToOpen.getCode());
        }
    }

    public void docSelectionMoreAction(AbsPOSSales doc, AbsPosSalesScreen posSalesScreen) {
    }

    public boolean isOldPaidInvoice() {
        if (this.isOldDoc()) {
            return true;
        }
        return POSEntityUtil.isPersistedDoc(this.docType(), this) && !this.getHold() && this.getPaymentDelayed() == false;
    }

    public BigDecimal calcDocumentNet() {
        BigDecimal net = this.getNetPrice();
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getReservation())) {
            net = net.subtract(ObjectChecker.toZeroIfNull((BigDecimal)this.getReservation().getReservationAmount()));
        }
        if (POSEntityUtil.isOrderReservation(this.docType()) && ObjectChecker.isNotEmptyOrZero((BigDecimal)((POSOrderReservation)this).getReservationAmount())) {
            net = ObjectChecker.toZeroIfNull((BigDecimal)((POSOrderReservation)this).getReservationAmount());
        }
        if (POSEntityUtil.isCancelReservation(this.docType()) && ObjectChecker.isAnyNotEmptyOrZero((BigDecimal[])new BigDecimal[]{((PosCancelReservation)this).getNetValue(), ((PosCancelReservation)this).getReservationAmount()})) {
            net = ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{((PosCancelReservation)this).getNetValue(), ((PosCancelReservation)this).getReservationAmount()});
        }
        if (POSEntityUtil.isReplacement(this.docType())) {
            BigDecimal returnNet = this.calcReturnNet().abs();
            BigDecimal invoiceNet = this.calcInvNet();
            net = invoiceNet.subtract(returnNet).abs();
        }
        return net;
    }

    @Override
    public POSRegistery register() {
        return POSResourcesUtil.fetchRegisterIgnoringInActiveAndPreventUsage(this.registerId);
    }

    private static /* synthetic */ Integer lambda$removeItem$10(List items, AbsPOSSalesLine l) {
        return items.indexOf(l);
    }
}

