/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IPOSHasDims;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.POSSalesPriceUtil;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AssociationOverrides;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

@MappedSuperclass
public abstract class AbsSCPriceListSysLine
implements POSSavable,
IPOSHasDims {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @AttributeOverrides(value={@AttributeOverride(name="color", column=@Column(name="itemColor")), @AttributeOverride(name="colorName", column=@Column(name="colorName")), @AttributeOverride(name="lotId", column=@Column(name="itemLotId")), @AttributeOverride(name="revisionId", column=@Column(name="itemRevisionId")), @AttributeOverride(name="serialNumber", column=@Column(name="itemSerialNumber")), @AttributeOverride(name="size", column=@Column(name="itemSize")), @AttributeOverride(name="sizeName", column=@Column(name="sizeName")), @AttributeOverride(name="secondSerial", column=@Column(name="itemSecondSerial")), @AttributeOverride(name="box", column=@Column(name="itemBox"))})
    private POSItemSpecificDimensions itemDimensions;
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="qValue", precision=20, scale=10))})
    @AssociationOverrides(value={@AssociationOverride(name="uom", joinColumns={@JoinColumn(name="qUom_id")})})
    private POSQuantity qty;
    private Date fromDate;
    private Date toDate;
    private Integer lineNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification invoiceClassification;
    @Column(name="itemID", length=16)
    private UUID itemID;
    @Column(length=16)
    private UUID empTargetId;
    private String empTargetType;
    @Column(length=16)
    private UUID refId;
    @Column(length=16)
    private UUID targetId;
    private String targetType;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="legalEntityId", length=16)), @AttributeOverride(name="code", column=@Column(name="legalEntityCode"))})
    private POSDimInfo legalEntity;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="sectorId", length=16)), @AttributeOverride(name="code", column=@Column(name="sectorCode"))})
    private POSDimInfo sector;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="branchId", length=16)), @AttributeOverride(name="code", column=@Column(name="branchCode"))})
    private POSDimInfo branch;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="departmentId", length=16)), @AttributeOverride(name="code", column=@Column(name="departmentCode"))})
    private POSDimInfo department;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="analysisSetId", length=16)), @AttributeOverride(name="code", column=@Column(name="analysisSetCode"))})
    private POSDimInfo analysisSet;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier1 priceClassifier1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier2 priceClassifier2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier3 priceClassifier3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier4 priceClassifier4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier5 priceClassifier5;
    @Column(precision=20, scale=10)
    private BigDecimal negateQtyInBaseUOM;
    @Column(length=16)
    private UUID subsidiaryId;
    private String subsidiaryType;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSFreeItemGroup applyOnlyIfItemInInvoice;
    @Embedded
    private POSEntityRefData applyOnItems;

    public POSEntityRefData getApplyOnItems() {
        return this.applyOnItems;
    }

    public void setApplyOnItems(POSEntityRefData applyOnItems) {
        this.applyOnItems = applyOnItems;
    }

    public POSFreeItemGroup getApplyOnlyIfItemInInvoice() {
        this.applyOnlyIfItemInInvoice = POSPersister.materialize(POSFreeItemGroup.class, this.applyOnlyIfItemInInvoice);
        return this.applyOnlyIfItemInInvoice;
    }

    public void setApplyOnlyIfItemInInvoice(POSFreeItemGroup applyOnlyIfItemInInvoice) {
        this.applyOnlyIfItemInInvoice = applyOnlyIfItemInInvoice;
    }

    public UUID getSubsidiaryId() {
        return this.subsidiaryId;
    }

    public void setSubsidiaryId(UUID subsidiaryId) {
        this.subsidiaryId = subsidiaryId;
    }

    @Override
    public String getSubsidiaryType() {
        return this.subsidiaryType;
    }

    public void setSubsidiaryType(String subsidiaryType) {
        this.subsidiaryType = subsidiaryType;
    }

    public BigDecimal getNegateQtyInBaseUOM() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.negateQtyInBaseUOM);
    }

    public void setNegateQtyInBaseUOM(BigDecimal negateQtyInBaseUOM) {
        this.negateQtyInBaseUOM = negateQtyInBaseUOM;
    }

    public POSSalesPriceClassifier1 getPriceClassifier1() {
        this.priceClassifier1 = POSPersister.materialize(POSSalesPriceClassifier1.class, this.priceClassifier1);
        return this.priceClassifier1;
    }

    public void setPriceClassifier1(POSSalesPriceClassifier1 priceClassifier1) {
        this.priceClassifier1 = priceClassifier1;
    }

    public POSSalesPriceClassifier2 getPriceClassifier2() {
        this.priceClassifier2 = POSPersister.materialize(POSSalesPriceClassifier2.class, this.priceClassifier2);
        return this.priceClassifier2;
    }

    public void setPriceClassifier2(POSSalesPriceClassifier2 priceClassifier2) {
        this.priceClassifier2 = priceClassifier2;
    }

    public POSSalesPriceClassifier3 getPriceClassifier3() {
        this.priceClassifier3 = POSPersister.materialize(POSSalesPriceClassifier3.class, this.priceClassifier3);
        return this.priceClassifier3;
    }

    public void setPriceClassifier3(POSSalesPriceClassifier3 priceClassifier3) {
        this.priceClassifier3 = priceClassifier3;
    }

    public POSSalesPriceClassifier4 getPriceClassifier4() {
        this.priceClassifier4 = POSPersister.materialize(POSSalesPriceClassifier4.class, this.priceClassifier4);
        return this.priceClassifier4;
    }

    public void setPriceClassifier4(POSSalesPriceClassifier4 priceClassifier4) {
        this.priceClassifier4 = priceClassifier4;
    }

    public POSSalesPriceClassifier5 getPriceClassifier5() {
        this.priceClassifier5 = POSPersister.materialize(POSSalesPriceClassifier5.class, this.priceClassifier5);
        return this.priceClassifier5;
    }

    public void setPriceClassifier5(POSSalesPriceClassifier5 priceClassifier5) {
        this.priceClassifier5 = priceClassifier5;
    }

    @Override
    public POSDimInfo getLegalEntity() {
        return this.legalEntity;
    }

    @Override
    public void setLegalEntity(POSDimInfo legalEntity) {
        this.legalEntity = legalEntity;
    }

    @Override
    public POSDimInfo getSector() {
        return this.sector;
    }

    @Override
    public void setSector(POSDimInfo sector) {
        this.sector = sector;
    }

    @Override
    public POSDimInfo getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(POSDimInfo branch) {
        this.branch = branch;
    }

    @Override
    public POSDimInfo getDepartment() {
        return this.department;
    }

    @Override
    public void setDepartment(POSDimInfo department) {
        this.department = department;
    }

    @Override
    public POSDimInfo getAnalysisSet() {
        return this.analysisSet;
    }

    @Override
    public void setAnalysisSet(POSDimInfo analysisSet) {
        this.analysisSet = analysisSet;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSItemSpecificDimensions getItemDimensions() {
        if (this.itemDimensions == null) {
            return new POSItemSpecificDimensions();
        }
        return this.itemDimensions;
    }

    public void setItemDimensions(POSItemSpecificDimensions itemDimensions) {
        this.itemDimensions = itemDimensions;
    }

    public POSQuantity getQty() {
        if (this.qty == null) {
            this.setQty(new POSQuantity());
        }
        return this.qty;
    }

    public void setQty(POSQuantity qty) {
        this.qty = qty;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public UUID getEmpTargetId() {
        return this.empTargetId;
    }

    public void setEmpTargetId(UUID empTargetId) {
        this.empTargetId = empTargetId;
    }

    public String getEmpTargetType() {
        return this.empTargetType;
    }

    public void setEmpTargetType(String empTargetType) {
        this.empTargetType = empTargetType;
    }

    public UUID getRefId() {
        return this.refId;
    }

    public void setRefId(UUID refId) {
        this.refId = refId;
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public void setTargetId(UUID targetId) {
        this.targetId = targetId;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public POSInvoiceClassification getInvoiceClassification() {
        this.invoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.invoiceClassification);
        return this.invoiceClassification;
    }

    public void setInvoiceClassification(POSInvoiceClassification invoiceClassification) {
        this.invoiceClassification = invoiceClassification;
    }

    @Override
    public void markAsCommit() {
    }

    public UUID getItemID() {
        return this.itemID;
    }

    public void setItemID(UUID itemID) {
        this.itemID = itemID;
    }

    public boolean matches(HashMap<String, Object> params) {
        return true;
    }

    @Override
    public POSGenericDims fetchGenericDims() {
        POSGenericDims genericDims = new POSGenericDims();
        genericDims.setLegalEntity(this.getLegalEntity());
        genericDims.setSector(this.getSector());
        genericDims.setBranch(this.getBranch());
        genericDims.setAnalysisSet(this.getAnalysisSet());
        genericDims.setDepartment(this.getDepartment());
        return genericDims;
    }

    public abstract Long fetchPriority();

    public BigDecimal fetchNegatedQtyInBaseUOM() {
        if (this.getItemID() == null || this.getQty() == null || this.getQty().getUom() == null || ObjectChecker.isEmptyOrZero((BigDecimal)this.getQty().getValue())) {
            return BigDecimal.ZERO;
        }
        POSItem item = POSPersister.findByID(POSItem.class, this.getItemID().toString());
        BigDecimal lineUniRateToBaseUOM = POSSalesPriceUtil.calcRateToBase(item.getUnits(), this.getQty().getUom());
        if (ObjectChecker.isEmptyOrZero((BigDecimal)lineUniRateToBaseUOM)) {
            return BigDecimal.ZERO;
        }
        return this.getQty().getValue().multiply(lineUniRateToBaseUOM).negate();
    }
}

