/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.basic.dtos.DTOAnalysisSet;
import com.namasoft.contracts.basic.dtos.DTOBranch;
import com.namasoft.contracts.basic.dtos.DTODepartment;
import com.namasoft.contracts.basic.dtos.DTOLegalEntity;
import com.namasoft.contracts.basic.dtos.DTOSector;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.details.HasCheckBox;
import com.namasoft.pos.domain.entities.IHasTableColumns;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.annotations.Index;

@MappedSuperclass
public abstract class POSMasterFile<DTOType extends MasterFileDTO>
implements POSSavable,
HasCheckBox,
IHasTableColumns {
    @Index(name="index_Code")
    private String code;
    @Index(name="index_name1")
    private String name1;
    @Index(name="index_name2")
    private String name2;
    @XmlTransient
    @Id
    @Column(name="id", length=16)
    public UUID id;
    @Embedded
    private POSGenericDims genericDims;
    private String imgDownloadLink;
    private Boolean comitBefore;
    private Boolean selected;
    private Integer writeFailures;
    private Boolean preventUsage;
    private Date creationDate;
    private Date lastUpdateDate;
    private String colorCode;
    private Integer printCount;
    @Transient
    private boolean isOldDoc = false;

    public POSMasterFile() {
        this(null);
    }

    public POSMasterFile(String code) {
        this(code, null, null);
    }

    public POSMasterFile(String code, String name1, String name2) {
        this.setCode(code);
        this.setName1(name1);
        this.setName2(name2);
        this.setComitBefore(false);
        this.setCreationDate(new Date());
    }

    public Integer getPrintCount() {
        return ObjectChecker.toZeroIfNull((Integer)this.printCount);
    }

    public void setPrintCount(Integer printCount) {
        this.printCount = printCount;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public String nameByLanguage() {
        if (POSResourcesUtil.getCurrentLang().equals((Object)Language.Arabic)) {
            return this.getName1();
        }
        return this.getName2();
    }

    public void updateData(DTOType object) {
        this.setId(ServerStringUtils.strToUUID((String)object.getId()));
        this.setName1(object.getName1());
        this.setName2(object.getName2());
        this.setCode(object.getCode());
        this.setCreationDate(object.getCreationDate());
        this.setLastUpdateDate(object.getLastUpdateDate());
        if (!(object instanceof DTOLegalEntity || object instanceof DTOBranch || object instanceof DTOSector || object instanceof DTOAnalysisSet || object instanceof DTODepartment)) {
            this.setGenericDims(POSGenericDims.calcDims(object));
        }
        this.setPreventUsage(object.getPreventUsage());
        this.setColorCode(object.getColorCode());
    }

    public POSGenericDims getGenericDims() {
        if (this.genericDims == null) {
            this.genericDims = new POSGenericDims();
            return this.genericDims;
        }
        return this.genericDims;
    }

    public void setGenericDims(POSGenericDims genericDims) {
        this.genericDims = genericDims;
    }

    public String getImgDownloadLink() {
        return this.imgDownloadLink;
    }

    public void setImgDownloadLink(String imgDownloadLink) {
        this.imgDownloadLink = imgDownloadLink;
    }

    public Boolean getComitBefore() {
        return this.comitBefore;
    }

    public void setComitBefore(Boolean comitBefore) {
        this.comitBefore = comitBefore;
    }

    @Override
    public void markAsCommit() {
        this.setComitBefore(true);
    }

    public Boolean getSelected() {
        if (this.selected == null) {
            return false;
        }
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    @Override
    public void updateSelectionProperty(Boolean selected) {
        this.setSelected(selected);
    }

    @Override
    public Boolean fetchSelectionProperty() {
        return this.getSelected();
    }

    @Override
    public Boolean fetchFreeLineProperty() {
        return false;
    }

    @Override
    public void updateFreeLineProperty(Boolean selected) {
    }

    public static EntityReferenceData toRef(POSMasterFile f) {
        if (ObjectChecker.isEmptyOrNull((Object)f)) {
            return null;
        }
        return f.toRef();
    }

    private EntityReferenceData toRef() {
        return new EntityReferenceData(this.calcNamaEntityType(), ServerStringUtils.toUUIDStr((Object)this.getId()), this.getCode(), "", "", this.getName1(), this.getName2());
    }

    public static EntityReferenceData toRef(String entityType, UUID id) {
        return new EntityReferenceData(entityType, ServerStringUtils.toUUIDStr((Object)id), "", "", "", "", "");
    }

    public void incrementFailures() {
        if (this.getWriteFailures() == null) {
            this.setWriteFailures(0);
        }
        this.setWriteFailures(this.getWriteFailures() + 1);
    }

    public Integer getWriteFailures() {
        return this.writeFailures;
    }

    public void setWriteFailures(Integer writeFailures) {
        this.writeFailures = writeFailures;
    }

    public void setSent(Boolean sent) {
    }

    public void materialize(POSMasterFile ... files) {
        for (POSMasterFile file : files) {
            if (!ObjectChecker.isNotEmptyOrNull((Object)file)) continue;
            file.getCode();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof POSMasterFile) {
            return ObjectChecker.areEqual((Object)this.getId(), (Object)((POSMasterFile)obj).getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Boolean getPreventUsage() {
        return this.preventUsage;
    }

    public void setPreventUsage(Boolean preventUsage) {
        this.preventUsage = preventUsage;
    }

    public void preventItFromUsage() {
        this.setPreventUsage(true);
        POSPersister.saveOrUpdate(this);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public void allowUsage() {
        this.setPreventUsage(false);
        POSPersister.saveOrUpdate(this);
    }

    public boolean canSearchOn() {
        return true;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "name1", "name2");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public List<POSTableColumn> createCalculatedColumnList(TableCellCreatorUtil creatorUtil) {
        return new ArrayList<POSTableColumn>();
    }

    @Override
    public List<String> filterByFields() {
        ArrayList<String> fieldsList = new ArrayList<String>();
        fieldsList.addAll(Arrays.asList("code", "name1", "name2"));
        return fieldsList;
    }

    public boolean searchOnAllFields() {
        return false;
    }

    public boolean notAllowedToBeSelected(NamaSearchBox searchBox) {
        return false;
    }

    public static <T extends POSMasterFile> T findPOSRef(Class<T> klass, EntityReferenceData referenceData) {
        if (ObjectChecker.isEmptyOrNull((Object)referenceData)) {
            return null;
        }
        return (T)((POSMasterFile)POSPersister.findByID(klass, referenceData.getId()));
    }

    public String orderByCol() {
        return "code";
    }

    public String getTranslatedName() {
        return this.nameByLanguage();
    }

    public boolean userEnteredData() {
        return true;
    }

    public String filteringCondition(String fieldId, String operator) {
        return " ( " + fieldId + ".code" + operator + " :" + fieldId + " or " + fieldId + ".name1" + operator + " :" + fieldId + " or " + fieldId + ".name2" + operator + " :" + fieldId + " )";
    }

    public EntityReferenceData toEntityReferenceData() {
        return new EntityReferenceData(this.calcNamaEntityType(), this.getId().toString(), this.getCode(), this.getCode(), this.getCode(), this.getName1(), this.getName2());
    }

    public PosDocCategory fetchDocCategory() {
        return null;
    }

    public List<String> fetchReferenceFieldsIDs() {
        return new ArrayList<String>();
    }

    public boolean sendAllInfoToMobile() {
        return false;
    }

    public static boolean fieldIsFromType(String fieldId, Class fieldKlass, Class typeKlass) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{fieldId, fieldKlass})) {
            return false;
        }
        try {
            String getMethod = "get" + fieldId.substring(0, 1).toUpperCase() + fieldId.substring(1);
            Method method = fieldKlass.getMethod(getMethod, new Class[0]);
            if (method.getReturnType().isAssignableFrom(typeKlass)) {
                return true;
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return false;
        }
        return false;
    }

    public POSRegistery register() {
        return POSResourcesUtil.fetchMainRegister();
    }

    public void setOldDoc(boolean oldDoc) {
        this.isOldDoc = oldDoc;
    }

    public boolean isOldDoc() {
        return this.isOldDoc;
    }
}

