/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.commonbasic.contracts.entities.DTOPaymentMethod;
import com.namasoft.modules.namapos.contracts.common.ILineHasPaymentMethod;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSPaymentMethodLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSRegister;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSPaymentMethodsSettingsLine;
import com.namasoft.pos.domain.details.POSRegisteryMethodLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSPaymentMethodsSettings;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSSecurityUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;

@Entity
public class POSPaymentMethod
extends POSMasterFile<DTOPaymentMethod> {
    private Integer orderInPOS;
    private Boolean cashMethod = false;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    private Boolean authorizationNumberRequire;
    private Boolean mustBeWithFeesPercentInReturn;
    private Boolean defaultMethod = false;
    @Column(length=16)
    private UUID masterGroupId;
    private String masterGroupName1;
    private String masterGroupName2;
    private Boolean doNotUseInPosPayments;
    private Boolean doNotUseInPosReceipts;
    private Boolean criticalPosPaymentMethod;
    private Boolean hideInShifts;
    private Boolean hideInPaymentDialog;
    private Boolean disableActualBalance;
    @Transient
    private boolean doNotCallCacheMethodsOfRegister;

    public Boolean getHideInShifts() {
        if (ObjectChecker.isEmptyOrNull((Object)this.hideInShifts)) {
            return false;
        }
        return this.hideInShifts;
    }

    public Boolean getHideInPaymentDialog() {
        if (this.hideInPaymentDialog == null) {
            this.hideInPaymentDialog = false;
            return this.hideInPaymentDialog;
        }
        return this.hideInPaymentDialog;
    }

    public void setHideInPaymentDialog(Boolean hideWhenPayment) {
        this.hideInPaymentDialog = hideWhenPayment;
    }

    public void setHideInShifts(Boolean hideInShifts) {
        this.hideInShifts = hideInShifts;
    }

    public Boolean getDisableActualBalance() {
        return this.disableActualBalance;
    }

    public void setDisableActualBalance(Boolean disableActualBalance) {
        this.disableActualBalance = disableActualBalance;
    }

    public Boolean getCriticalPosPaymentMethod() {
        if (ObjectChecker.isEmptyOrNull((Object)this.criticalPosPaymentMethod)) {
            return false;
        }
        return this.criticalPosPaymentMethod;
    }

    public void setCriticalPosPaymentMethod(Boolean criticalPosPaymentMethod) {
        this.criticalPosPaymentMethod = criticalPosPaymentMethod;
    }

    public UUID getMasterGroupId() {
        return this.masterGroupId;
    }

    public void setMasterGroupId(UUID masterGroupId) {
        this.masterGroupId = masterGroupId;
    }

    public String getMasterGroupName1() {
        return this.masterGroupName1;
    }

    public void setMasterGroupName1(String masterGroupName1) {
        this.masterGroupName1 = masterGroupName1;
    }

    public String getMasterGroupName2() {
        return this.masterGroupName2;
    }

    public void setMasterGroupName2(String masterGroupName2) {
        this.masterGroupName2 = masterGroupName2;
    }

    public POSPaymentMethod() {
    }

    public POSPaymentMethod(String code, String name1, String name2) {
        super(code, name1, name2);
    }

    public Integer getOrderInPOS() {
        if (this.orderInPOS == null) {
            this.orderInPOS = 0;
        }
        return this.orderInPOS;
    }

    public Boolean getDefaultMethod() {
        return this.defaultMethod;
    }

    public void setDefaultMethod(Boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    public static POSPaymentMethod fromReference(DTOAbsPOSPaymentMethodLine dtoLine, DTONamaPOSRegister register) {
        return POSPaymentMethod.fromReference(dtoLine, register, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static POSPaymentMethod fromReference(DTOAbsPOSPaymentMethodLine dtoLine, DTONamaPOSRegister register, boolean withoutRegisterCheck) {
        POSPaymentMethod method = null;
        EntityReferenceData ref = dtoLine.getPaymentMethod();
        if (ObjectChecker.isNotEmptyOrNull((Object)ref)) {
            method = POSPersister.findByID(POSPaymentMethod.class, ref.getId());
            if (method == null) {
                method = new POSPaymentMethod();
            }
            if (!withoutRegisterCheck) {
                DTOPaymentMethod dto = (DTOPaymentMethod)POSPersister.getReference(ref);
                method.updateData(dto);
                method.setAuthorizationNumberRequire(dto.getAuthorizationNumberRequire());
                method.setMustBeWithFeesPercentInReturn(dto.getMustBeWithFeesPercentInReturn());
            }
            if (withoutRegisterCheck || POSPaymentMethod.sameRegisterAsCurrent(register)) {
                method.setCashMethod(dtoLine.getCashMethod());
                method.setOrderInPOS(dtoLine.getOrderInPOS());
                if (ObjectChecker.isTrue((Boolean)dtoLine.getDefaultMethod())) {
                    POSPersister.execute("update " + POSPaymentMethod.class.getSimpleName() + " set defaultMethod = 0");
                }
                method.setDefaultMethod(dtoLine.getDefaultMethod());
            }
            boolean oldValue = method.doNotCallCacheMethodsOfRegister;
            method.doNotCallCacheMethodsOfRegister = true;
            try {
                POSPersister.saveOrUpdate(method);
            }
            finally {
                method.doNotCallCacheMethodsOfRegister = oldValue;
            }
        }
        return method;
    }

    private void markDoNotCallCacheMethodsOfRegister() {
    }

    private static boolean sameRegisterAsCurrent(DTONamaPOSRegister register) {
        return register.getCode().trim().equalsIgnoreCase(POSGeneralSettings.getRegisterCode().trim());
    }

    public void setOrderInPOS(Integer orderInPOS) {
        this.orderInPOS = orderInPOS;
    }

    public Boolean getCashMethod() {
        return this.cashMethod;
    }

    public void setCashMethod(Boolean cashMethod) {
        this.cashMethod = cashMethod;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    @Override
    public String calcNamaEntityType() {
        return "PaymentMethod";
    }

    public Boolean getDoNotUseInPosPayments() {
        if (this.doNotUseInPosPayments == null) {
            this.doNotUseInPosPayments = false;
        }
        return this.doNotUseInPosPayments;
    }

    public void setDoNotUseInPosPayments(Boolean doNotUseInPosPayments) {
        this.doNotUseInPosPayments = doNotUseInPosPayments;
    }

    public Boolean getDoNotUseInPosReceipts() {
        if (this.doNotUseInPosReceipts == null) {
            this.doNotUseInPosReceipts = false;
        }
        return this.doNotUseInPosReceipts;
    }

    public void setDoNotUseInPosReceipts(Boolean doNotUseInPosReceipts) {
        this.doNotUseInPosReceipts = doNotUseInPosReceipts;
    }

    @Override
    public void updateData(DTOPaymentMethod object) {
        super.updateData(object);
        this.setAuthorizationNumberRequire(object.getAuthorizationNumberRequire());
        this.setHideInShifts(object.getHideInShifts());
        this.setHideInPaymentDialog(object.getHideInPOSPayment());
        this.setMustBeWithFeesPercentInReturn(object.getMustBeWithFeesPercentInReturn());
        this.setDoNotUseInPosPayments(object.getDoNotUseInPosPayments());
        this.setDoNotUseInPosReceipts(object.getDoNotUseInPosReceipts());
        this.setCriticalPosPaymentMethod(object.getCriticalPosPaymentMethod());
        if (POSResourcesUtil.fetchMainRegister() != null && !POSResourcesUtil.methods.contains(this)) {
            this.setPreventUsage(true);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)object.getGroup())) {
            this.setMasterGroupId(ServerStringUtils.strToUUID((String)object.getGroup().getId()));
            this.setMasterGroupName1(object.getGroup().getName1());
            this.setMasterGroupName2(object.getGroup().getName2());
        } else {
            this.setMasterGroupId(null);
            this.setMasterGroupName1("");
            this.setMasterGroupName2("");
        }
        this.setDisableActualBalance(object.getDisableActualBalanceInPOS());
    }

    @Override
    public void afterCommitSuccessfully() {
        if (POSResourcesUtil.fetchMainRegister() != null && !this.doNotCallCacheMethodsOfRegister) {
            POSResourcesUtil.fetchMainRegister().cacheRegisteryFields();
        }
    }

    public Boolean getAuthorizationNumberRequire() {
        return this.authorizationNumberRequire;
    }

    public void setAuthorizationNumberRequire(Boolean authorizationNumberRequire) {
        this.authorizationNumberRequire = authorizationNumberRequire;
    }

    public Boolean getMustBeWithFeesPercentInReturn() {
        if (ObjectChecker.isEmptyOrNull((Object)this.mustBeWithFeesPercentInReturn)) {
            return false;
        }
        return this.mustBeWithFeesPercentInReturn;
    }

    public void setMustBeWithFeesPercentInReturn(Boolean mustBeWithFeesPercentInReturn) {
        this.mustBeWithFeesPercentInReturn = mustBeWithFeesPercentInReturn;
    }

    @Override
    public boolean notAllowedToBeSelected(NamaSearchBox searchBox) {
        return this.getCriticalPosPaymentMethod() != false && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseCriticalMethods).isFailed() != false;
    }

    public boolean showInAdditionalMethods() {
        List<POSRegisteryMethodLine> registerMethods = POSResourcesUtil.fetchMainRegister().getPaymentMethods();
        List configMethods = POSResourcesUtil.fetchPOSConfig().getPaymentMethods();
        Predicate<ILineHasPaymentMethod> methodLinePredicate = m -> ObjectChecker.areEqual((Object)m.methodId(), (Object)ServerStringUtils.toUUIDStr((Object)this.getId())) && ObjectChecker.isTrue((Boolean)m.getShowInAdditionalMethods());
        if (ObjectChecker.isNotEmptyOrNull(registerMethods)) {
            return registerMethods.stream().anyMatch(methodLinePredicate);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)configMethods)) {
            return configMethods.stream().anyMatch(methodLinePredicate);
        }
        return false;
    }

    private boolean shouldHidePaymentMethod(UUID docCategoryId, UUID invoiceClassificationId) {
        POSPaymentMethodsSettings methodsSettings = POSResourcesUtil.fetchPaymentMethodsSettings();
        if (methodsSettings == null) {
            return false;
        }
        for (POSPaymentMethodsSettingsLine detail : methodsSettings.getDetails()) {
            if (ObjectChecker.areNotEqual((Object)detail.getPaymentMethodId(), (Object)this.getId()) || ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{detail.getDocCategoryId(), detail.getInvoiceClassificationId()}) || ObjectChecker.isNotEmptyOrNull((Object)detail.getDocCategoryId()) && ObjectChecker.areNotEqual((Object)detail.getDocCategoryId(), (Object)docCategoryId) || ObjectChecker.isNotEmptyOrNull((Object)detail.getInvoiceClassificationId()) && ObjectChecker.areNotEqual((Object)detail.getInvoiceClassificationId(), (Object)invoiceClassificationId)) continue;
            return true;
        }
        return false;
    }

    public boolean mustNotBeAddedToPayDialog(UUID docCategoryId, UUID invoiceClassificationId) {
        return !POSResourcesUtil.pgwMethods.contains(this) && (this.showInAdditionalMethods() || this.getHideInPaymentDialog() != false || this.shouldHidePaymentMethod(docCategoryId, invoiceClassificationId));
    }
}

