/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSPaymentRecipt;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSReceiptFromRegister;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSPayReceipt;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import jakarta.persistence.Entity;
import java.math.BigDecimal;
import java.util.Arrays;

@Entity
public class POSReceiptFromRegistery
extends AbsPOSPayReceipt {
    public POSReceiptFromRegistery() {
    }

    public POSReceiptFromRegistery(POSPaymentReciptScreen view) {
        this.setCode(POSCodeGenerator.generateInvoiceCode(POSDocumentType.Receipt));
        this.setView(view);
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    @Override
    public String calcNamaEntityType() {
        return "POSReceiptFromRegister";
    }

    @Override
    public POSMasterFile origin() {
        return this;
    }

    @Override
    public BigDecimal getAmount() {
        return this.getValue();
    }

    @Override
    public void writeToServer(POSRegistery register, boolean forceSend, Callback callback) {
        boolean generateCoupons;
        boolean mustTransferReceipt = POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType());
        boolean bl = generateCoupons = ObjectChecker.areEqual((Object)this.getSubsidiaryType(), (Object)POSCustomer.class.getSimpleName()) && POSResourcesUtil.fetchPOSConfig().getUseCoupons() != false;
        if (forceSend || mustTransferReceipt || generateCoupons) {
            POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeReceipts(register, Arrays.asList(this), callback)));
        }
    }

    @Override
    public NaMaDTO toDTO() {
        return POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSPaymentRecipt)new DTOPOSReceiptFromRegister());
    }
}

