/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTOPOSMobileGridFieldLine;
import com.namasoft.modules.namapos.contracts.details.DTOPOSMobileHeaderFieldLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPosMobileUISettings;
import com.namasoft.pos.controllers.MobileInvoicesController;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPosMobileFieldLine;
import com.namasoft.pos.domain.details.POSMobileUIGridLine;
import com.namasoft.pos.domain.details.POSMobileUIMainLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.Session;

@Entity
public class PosMobileUISettings
extends POSMasterFile<DTONamaPosMobileUISettings> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    private List<POSMobileUIMainLine> mobileMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    private List<POSMobileUIGridLine> mobileGridFields;
    private Boolean doNotAddPayButton;
    private Boolean doNotAddSaveButton;
    private Boolean doNotAddSendButton;
    private Boolean doNotAddAddItemButton;
    private Boolean doNotAddEditItemButton;
    private Boolean doNotAddDeleteItemButton;
    private Boolean doNotAddFavouriteItemsButton;

    public Boolean getDoNotAddPayButton() {
        return this.doNotAddPayButton;
    }

    public void setDoNotAddPayButton(Boolean doNotAddPayButton) {
        this.doNotAddPayButton = doNotAddPayButton;
    }

    public Boolean getDoNotAddSaveButton() {
        return this.doNotAddSaveButton;
    }

    public void setDoNotAddSaveButton(Boolean doNotAddSaveButton) {
        this.doNotAddSaveButton = doNotAddSaveButton;
    }

    public Boolean getDoNotAddSendButton() {
        return this.doNotAddSendButton;
    }

    public void setDoNotAddSendButton(Boolean doNotAddSendButton) {
        this.doNotAddSendButton = doNotAddSendButton;
    }

    public Boolean getDoNotAddAddItemButton() {
        return this.doNotAddAddItemButton;
    }

    public void setDoNotAddAddItemButton(Boolean doNotAddAddItemButton) {
        this.doNotAddAddItemButton = doNotAddAddItemButton;
    }

    public Boolean getDoNotAddEditItemButton() {
        return this.doNotAddEditItemButton;
    }

    public void setDoNotAddEditItemButton(Boolean doNotAddEditItemButton) {
        this.doNotAddEditItemButton = doNotAddEditItemButton;
    }

    public Boolean getDoNotAddDeleteItemButton() {
        return this.doNotAddDeleteItemButton;
    }

    public void setDoNotAddDeleteItemButton(Boolean doNotAddDeleteItemButton) {
        this.doNotAddDeleteItemButton = doNotAddDeleteItemButton;
    }

    public Boolean getDoNotAddFavouriteItemsButton() {
        return this.doNotAddFavouriteItemsButton;
    }

    public void setDoNotAddFavouriteItemsButton(Boolean doNotAddFavouriteItemsButton) {
        this.doNotAddFavouriteItemsButton = doNotAddFavouriteItemsButton;
    }

    @Override
    public void updateData(DTONamaPosMobileUISettings object) {
        AbsPosMobileFieldLine line;
        DTOPOSMobileHeaderFieldLine dtoLine;
        int i;
        super.updateData(object);
        CollectionsUtility.makeSecondSameSize((List)object.getHeaderFields(), this.getMobileMainFields(), POSMobileUIMainLine::new);
        for (i = 0; i < object.getHeaderFields().size(); ++i) {
            dtoLine = (DTOPOSMobileHeaderFieldLine)object.getHeaderFields().get(i);
            line = this.getMobileMainFields().get(i);
            line.setPosSettings(this);
            line.setField(dtoLine.getField());
            ((POSMobileUIMainLine)line).setDisplayMethod(dtoLine.getDisplayMethod());
            ((POSMobileUIMainLine)line).setFieldSize(dtoLine.getFieldSize());
        }
        CollectionsUtility.makeSecondSameSize((List)object.getLineFields(), this.getMobileGridFields(), POSMobileUIGridLine::new);
        for (i = 0; i < object.getLineFields().size(); ++i) {
            dtoLine = (DTOPOSMobileGridFieldLine)object.getLineFields().get(i);
            line = this.getMobileGridFields().get(i);
            line.setPosSettings(this);
            line.setField(dtoLine.getField());
        }
        this.setDoNotAddPayButton(object.getDoNotAddPayButton());
        this.setDoNotAddSaveButton(object.getDoNotAddSaveButton());
        this.setDoNotAddSendButton(object.getDoNotAddSendButton());
        this.setDoNotAddAddItemButton(object.getDoNotAddAddItemButton());
        this.setDoNotAddEditItemButton(object.getDoNotAddEditItemButton());
        this.setDoNotAddDeleteItemButton(object.getDoNotAddDeleteItemButton());
        this.setDoNotAddFavouriteItemsButton(object.getDoNotAddFavouriteItemsButton());
    }

    public List<POSMobileUIMainLine> getMobileMainFields() {
        if (this.mobileMainFields == null) {
            this.mobileMainFields = new ArrayList<POSMobileUIMainLine>();
            return this.mobileMainFields;
        }
        return this.mobileMainFields;
    }

    public void setMobileMainFields(List<POSMobileUIMainLine> mobileMainFields) {
        this.mobileMainFields = mobileMainFields;
    }

    public List<POSMobileUIGridLine> getMobileGridFields() {
        if (this.mobileGridFields == null) {
            this.mobileGridFields = new ArrayList<POSMobileUIGridLine>();
            return this.mobileGridFields;
        }
        return this.mobileGridFields;
    }

    public void setMobileGridFields(List<POSMobileUIGridLine> mobileGridFields) {
        this.mobileGridFields = mobileGridFields;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPosMobileUISettings";
    }

    @Override
    public void initializeLists() {
        this.getMobileGridFields().size();
        this.getMobileMainFields().size();
    }

    @Override
    public void assignIds() {
        super.assignIds();
        Consumer<AbsPosMobileFieldLine> lineConsumer = l -> {
            l.getId();
            l.setPosSettings(this);
        };
        this.getMobileGridFields().forEach(lineConsumer);
        this.getMobileMainFields().forEach(lineConsumer);
    }

    @Override
    public void postCommitAction(Session session) {
        super.postCommitAction(session);
        MobileInvoicesController.resetMobileUIConfiguration();
    }
}

