/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;

@MappedSuperclass
@XmlRootElement
public abstract class AbsPOSSalesInvoiceLine
extends AbsPOSSalesLine {
    @JoinColumn(name="invoice_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesInvoice invoice;
    @Column(precision=20, scale=10)
    private BigDecimal returnedQty;

    @XmlTransient
    public POSSalesInvoice getInvoice() {
        this.invoice = POSPersister.materialize(POSSalesInvoice.class, this.invoice);
        return this.invoice;
    }

    public void setInvoice(POSSalesInvoice invoice) {
        this.invoice = invoice;
    }

    public BigDecimal getReturnedQty() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.returnedQty)) {
            return BigDecimal.ZERO;
        }
        return this.returnedQty;
    }

    public void setReturnedQty(BigDecimal returnedQty) {
        this.returnedQty = returnedQty;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setInvoice((POSSalesInvoice)invoice);
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getInvoice();
    }
}

