/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.details.DTOAbsNamaAdditionalItems;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.util.UUID;

@MappedSuperclass
public abstract class AbsPosAdditionalItems
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="addItems_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private PosItemAdditionalItems addItems;
    private UUID itemID;
    private String itemType;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUnit defaultUnit;
    private String itemCode;
    private Boolean defaultItem;

    public void updateCommonData(DTOAbsNamaAdditionalItems line) {
        this.assignIds();
        this.setDefaultItem(ObjectChecker.isTrue((Boolean)line.getDefaultItem()));
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getDefaultUnit())) {
            this.setDefaultUnit((POSUnit)this.fromReference(line.getDefaultUnit()));
        } else {
            this.setDefaultUnit(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getItem())) {
            this.setItemCode(line.getItem().getCode());
            this.setItemID(UUID.fromString(line.getItem().getId()));
            this.setItemType(line.getItem().getEntityType());
        } else {
            this.setItemCode(null);
            this.setItemID(null);
            this.setItemType(null);
        }
    }

    public POSUnit getDefaultUnit() {
        this.defaultUnit = POSPersister.materialize(POSUnit.class, this.defaultUnit);
        return this.defaultUnit;
    }

    public void setDefaultUnit(POSUnit defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    public PosItemAdditionalItems getAddItems() {
        this.addItems = POSPersister.materialize(PosItemAdditionalItems.class, this.addItems);
        return this.addItems;
    }

    public void setAddItems(PosItemAdditionalItems addItems) {
        this.addItems = addItems;
    }

    public UUID getItemID() {
        return this.itemID;
    }

    public void setItemID(UUID itemID) {
        this.itemID = itemID;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Boolean getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(Boolean defaultItem) {
        this.defaultItem = defaultItem;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }
}

