/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.enums.ExchangeRateType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSExchangeRate;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSExchangeRateLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    @Column(precision=20, scale=10)
    private BigDecimal sell;
    @Column(precision=20, scale=10)
    private BigDecimal buy;
    private String remarks;
    private String type;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency mainCurrency;
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @JoinColumn(name="exchangeRate_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSExchangeRate exchangeRate;
    @Column(length=16)
    private UUID ledgerId;
    @Temporal(value=TemporalType.DATE)
    private Date startDate;
    @Temporal(value=TemporalType.DATE)
    private Date endDate;

    public UUID getLedgerId() {
        return this.ledgerId;
    }

    public void setLedgerId(UUID ledgerId) {
        this.ledgerId = ledgerId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public POSExchangeRate getExchangeRate() {
        this.exchangeRate = POSPersister.materialize(POSExchangeRate.class, this.exchangeRate);
        return this.exchangeRate;
    }

    public void setExchangeRate(POSExchangeRate exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public BigDecimal getSell() {
        return this.sell;
    }

    public void setSell(BigDecimal sell) {
        this.sell = sell;
    }

    public BigDecimal getBuy() {
        return this.buy;
    }

    public void setBuy(BigDecimal buy) {
        this.buy = buy;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public POSCurrency getMainCurrency() {
        this.mainCurrency = POSPersister.materialize(POSCurrency.class, this.mainCurrency);
        return this.mainCurrency;
    }

    public void setMainCurrency(POSCurrency mainCurrency) {
        this.mainCurrency = mainCurrency;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public int typePriority() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getType())) {
            return 10;
        }
        ExchangeRateType type = ExchangeRateType.valueOf((String)this.getType());
        switch (type) {
            case Daily: {
                return 1;
            }
            case Period: {
                return 2;
            }
            case Annual: {
                return 3;
            }
        }
        return 10;
    }
}

