/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.supplychain.contracts.details.DTOFreeItemLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesOffers;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsSCPriceListSysLine;
import com.namasoft.pos.domain.details.IPOSFreeItemOfferLine;
import com.namasoft.pos.domain.entities.IHasPOSItemClasses;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSSalesOffers;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSFreeItemData;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.IHasMaxQty;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSFreeItemLine
extends AbsSCPriceListSysLine
implements IHasPOSItemClasses,
IPOSFreeItemOfferLine,
IHasMaxQty {
    @Embedded
    private POSFreeItemData freeItemData;
    @JoinColumn(name="salesOffer_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesOffers salesOffer;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemBrand brand;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass1 itemClass1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass2 itemClass2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass3 itemClass3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass4 itemClass4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass5 itemClass5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass6 itemClass6;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass7 itemClass7;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass8 itemClass8;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass9 itemClass9;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass10 itemClass10;
    private Boolean notFreeButDiscount;
    private String discLocation;
    @Column(precision=20, scale=10)
    private BigDecimal discountPercentage;
    private Boolean stopOtherDiscounts;
    @Column(precision=20, scale=10)
    private BigDecimal itemMaxQty;
    private Boolean doNotCopyMasterItemData;
    private Boolean freeItemIsSameAsInvItem;

    @Override
    public Boolean getFreeItemIsSameAsInvItem() {
        return this.freeItemIsSameAsInvItem;
    }

    public void setFreeItemIsSameAsInvItem(Boolean freeItemIsSameAsInvItem) {
        this.freeItemIsSameAsInvItem = freeItemIsSameAsInvItem;
    }

    public Boolean getNotFreeButDiscount() {
        return this.notFreeButDiscount;
    }

    public void setNotFreeButDiscount(Boolean notFreeButDiscount) {
        this.notFreeButDiscount = notFreeButDiscount;
    }

    public String getDiscLocation() {
        return this.discLocation;
    }

    public void setDiscLocation(String discLocation) {
        this.discLocation = discLocation;
    }

    public BigDecimal getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(BigDecimal discountPercentage) {
        this.discountPercentage = discountPercentage;
    }

    @Override
    public POSItemClass1 getItemClass1() {
        this.itemClass1 = POSPersister.materialize(POSItemClass1.class, this.itemClass1);
        return this.itemClass1;
    }

    public void setItemClass1(POSItemClass1 itemClass1) {
        this.itemClass1 = itemClass1;
    }

    @Override
    public POSItemClass2 getItemClass2() {
        this.itemClass2 = POSPersister.materialize(POSItemClass2.class, this.itemClass2);
        return this.itemClass2;
    }

    public void setItemClass2(POSItemClass2 itemClass2) {
        this.itemClass2 = itemClass2;
    }

    @Override
    public POSItemClass3 getItemClass3() {
        this.itemClass3 = POSPersister.materialize(POSItemClass3.class, this.itemClass3);
        return this.itemClass3;
    }

    public void setItemClass3(POSItemClass3 itemClass3) {
        this.itemClass3 = itemClass3;
    }

    @Override
    public POSItemClass4 getItemClass4() {
        this.itemClass4 = POSPersister.materialize(POSItemClass4.class, this.itemClass4);
        return this.itemClass4;
    }

    public void setItemClass4(POSItemClass4 itemClass4) {
        this.itemClass4 = itemClass4;
    }

    @Override
    public POSItemClass5 getItemClass5() {
        this.itemClass5 = POSPersister.materialize(POSItemClass5.class, this.itemClass5);
        return this.itemClass5;
    }

    public void setItemClass5(POSItemClass5 itemClass5) {
        this.itemClass5 = itemClass5;
    }

    @Override
    public POSItemClass6 getItemClass6() {
        this.itemClass6 = POSPersister.materialize(POSItemClass6.class, this.itemClass6);
        return this.itemClass6;
    }

    public void setItemClass6(POSItemClass6 itemClass6) {
        this.itemClass6 = itemClass6;
    }

    @Override
    public POSItemClass7 getItemClass7() {
        this.itemClass7 = POSPersister.materialize(POSItemClass7.class, this.itemClass7);
        return this.itemClass7;
    }

    public void setItemClass7(POSItemClass7 itemClass7) {
        this.itemClass7 = itemClass7;
    }

    @Override
    public POSItemClass8 getItemClass8() {
        this.itemClass8 = POSPersister.materialize(POSItemClass8.class, this.itemClass8);
        return this.itemClass8;
    }

    public void setItemClass8(POSItemClass8 itemClass8) {
        this.itemClass8 = itemClass8;
    }

    @Override
    public POSItemClass9 getItemClass9() {
        this.itemClass9 = POSPersister.materialize(POSItemClass9.class, this.itemClass9);
        return this.itemClass9;
    }

    public void setItemClass9(POSItemClass9 itemClass9) {
        this.itemClass9 = itemClass9;
    }

    @Override
    public POSItemClass10 getItemClass10() {
        this.itemClass10 = POSPersister.materialize(POSItemClass10.class, this.itemClass10);
        return this.itemClass10;
    }

    public void setItemClass10(POSItemClass10 itemClass10) {
        this.itemClass10 = itemClass10;
    }

    public POSSalesOffers getSalesOffer() {
        this.salesOffer = POSPersister.materialize(POSSalesOffers.class, this.salesOffer);
        return this.salesOffer;
    }

    public void setSalesOffer(POSSalesOffers salesOffer) {
        this.salesOffer = salesOffer;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public POSFreeItemData getFreeItemData() {
        return this.freeItemData;
    }

    public void setFreeItemData(POSFreeItemData freeItemData) {
        this.freeItemData = freeItemData;
    }

    @Override
    public Boolean getStopOtherDiscounts() {
        return this.stopOtherDiscounts;
    }

    public void setStopOtherDiscounts(Boolean stopOtherDiscounts) {
        this.stopOtherDiscounts = stopOtherDiscounts;
    }

    public void updateData(DTOFreeItemLine dtoFreeItemLine, DTOSalesOffers offer, int i) {
        this.setId(UUID.fromString(dtoFreeItemLine.getId()));
        this.setFreeItemData(POSFreeItemData.fromDTO(dtoFreeItemLine.getFreeItemData(), this));
        this.setCategory1((POSItemCategory)this.fromReference(dtoFreeItemLine.getCategory1()));
        this.setCategory2((POSItemCategory)this.fromReference(dtoFreeItemLine.getCategory2()));
        this.setCategory3((POSItemCategory)this.fromReference(dtoFreeItemLine.getCategory3()));
        this.setCategory4((POSItemCategory)this.fromReference(dtoFreeItemLine.getCategory4()));
        this.setCategory5((POSItemCategory)this.fromReference(dtoFreeItemLine.getCategory5()));
        this.setFreeItemData(POSFreeItemData.fromDTO(dtoFreeItemLine.getFreeItemData(), this));
        this.setBrand((POSItemBrand)this.fromReference(dtoFreeItemLine.getBrand()));
        this.setFromDate(dtoFreeItemLine.getFromDate());
        this.setToDate(dtoFreeItemLine.getToDate());
        this.setItemDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(dtoFreeItemLine.getItemDimensions()));
        this.setQty(POSQuantity.fromDTORawQuantity(dtoFreeItemLine.getQty(), this));
        this.setItemMaxQty(dtoFreeItemLine.getItemMaxQty());
        this.setDoNotCopyMasterItemData(dtoFreeItemLine.getDoNotCopyMasterItemData());
        this.setItemID(ObjectChecker.isEmptyOrNull((Object)dtoFreeItemLine.getItem()) ? null : ServerStringUtils.strToUUID((String)dtoFreeItemLine.getItem().getId()));
        this.setLineNumber(i);
        this.setRefId(ServerStringUtils.strToUUID((String)offer.getId()));
        this.setInvoiceClassification((POSInvoiceClassification)this.fromReference(dtoFreeItemLine.getInvoiceClassification()));
        this.setCurrency((POSCurrency)this.fromReference(offer.getCurrency()));
        if (ObjectChecker.isNotEmptyOrNull((Object)offer.getCustomer())) {
            this.setTargetId(UUID.fromString(offer.getCustomer().getId()));
            this.setTargetType(offer.getCustomer().getEntityType());
        } else {
            this.setTargetId(null);
            this.setTargetType(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)offer.getEmployee())) {
            this.setEmpTargetId(UUID.fromString(offer.getEmployee().getId()));
            this.setEmpTargetType(offer.getEmployee().getEntityType());
        } else {
            this.setEmpTargetId(null);
            this.setEmpTargetType(null);
        }
        this.setLegalEntity(new POSDimInfo());
        this.getLegalEntity().setId(ServerStringUtils.strToUUID((String)dtoFreeItemLine.getDimensions().getLegalEntity().getId()));
        this.getLegalEntity().setCode(dtoFreeItemLine.getDimensions().getLegalEntity().getCode());
        this.setSector(new POSDimInfo());
        this.getSector().setCode(dtoFreeItemLine.getDimensions().getSector().getCode());
        this.getSector().setId(ServerStringUtils.strToUUID((String)dtoFreeItemLine.getDimensions().getSector().getId()));
        this.setBranch(new POSDimInfo());
        this.getBranch().setCode(dtoFreeItemLine.getDimensions().getBranch().getCode());
        this.getBranch().setId(ServerStringUtils.strToUUID((String)dtoFreeItemLine.getDimensions().getBranch().getId()));
        this.setDepartment(new POSDimInfo());
        this.getDepartment().setCode(dtoFreeItemLine.getDimensions().getDepartment().getCode());
        this.getDepartment().setId(ServerStringUtils.strToUUID((String)dtoFreeItemLine.getDimensions().getDepartment().getId()));
        this.setAnalysisSet(new POSDimInfo());
        this.getAnalysisSet().setCode(dtoFreeItemLine.getDimensions().getAnalysisSet().getCode());
        this.getAnalysisSet().setId(ServerStringUtils.strToUUID((String)dtoFreeItemLine.getDimensions().getAnalysisSet().getId()));
        this.setPriceClassifier1((POSSalesPriceClassifier1)this.fromReference(dtoFreeItemLine.getPriceClassifier1()));
        this.setPriceClassifier2((POSSalesPriceClassifier2)this.fromReference(dtoFreeItemLine.getPriceClassifier2()));
        this.setPriceClassifier3((POSSalesPriceClassifier3)this.fromReference(dtoFreeItemLine.getPriceClassifier3()));
        this.setPriceClassifier4((POSSalesPriceClassifier4)this.fromReference(dtoFreeItemLine.getPriceClassifier4()));
        this.setPriceClassifier5((POSSalesPriceClassifier5)this.fromReference(dtoFreeItemLine.getPriceClassifier5()));
        this.setItemClass1((POSItemClass1)this.fromReference(dtoFreeItemLine.getItemClass1()));
        this.setItemClass2((POSItemClass2)this.fromReference(dtoFreeItemLine.getItemClass2()));
        this.setItemClass3((POSItemClass3)this.fromReference(dtoFreeItemLine.getItemClass3()));
        this.setItemClass4((POSItemClass4)this.fromReference(dtoFreeItemLine.getItemClass4()));
        this.setItemClass5((POSItemClass5)this.fromReference(dtoFreeItemLine.getItemClass5()));
        this.setItemClass6((POSItemClass6)this.fromReference(dtoFreeItemLine.getItemClass6()));
        this.setItemClass7((POSItemClass7)this.fromReference(dtoFreeItemLine.getItemClass7()));
        this.setItemClass8((POSItemClass8)this.fromReference(dtoFreeItemLine.getItemClass8()));
        this.setItemClass9((POSItemClass9)this.fromReference(dtoFreeItemLine.getItemClass9()));
        this.setItemClass10((POSItemClass10)this.fromReference(dtoFreeItemLine.getItemClass10()));
        this.setNotFreeButDiscount(dtoFreeItemLine.getNotFreeButDiscount());
        this.setDiscLocation(dtoFreeItemLine.getDiscLocation());
        this.setDiscountPercentage(dtoFreeItemLine.getDiscountPercentage());
        this.setNegateQtyInBaseUOM(ObjectChecker.toZeroIfNull((BigDecimal)dtoFreeItemLine.getQtyInBaseUOM()).negate());
        this.setStopOtherDiscounts(offer.getStopOtherDiscounts());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoFreeItemLine.getSubsidiary())) {
            this.setSubsidiaryType(dtoFreeItemLine.getSubsidiary().getEntityType());
            this.setSubsidiaryId(ServerStringUtils.strToUUID((String)dtoFreeItemLine.getSubsidiary().getId()));
        } else {
            this.setSubsidiaryType(null);
            this.setSubsidiaryId(null);
        }
        this.setFreeItemIsSameAsInvItem(dtoFreeItemLine.getFreeItemIsSameAsInvItem());
    }

    public POSItemBrand getBrand() {
        this.brand = POSPersister.materialize(POSItemBrand.class, this.brand);
        return this.brand;
    }

    public void setBrand(POSItemBrand brand) {
        this.brand = brand;
    }

    public POSItemCategory getCategory1() {
        this.category1 = POSPersister.materialize(POSItemCategory.class, this.category1);
        return this.category1;
    }

    public void setCategory1(POSItemCategory category1) {
        this.category1 = category1;
    }

    public POSItemCategory getCategory2() {
        this.category2 = POSPersister.materialize(POSItemCategory.class, this.category2);
        return this.category2;
    }

    public void setCategory2(POSItemCategory category2) {
        this.category2 = category2;
    }

    public POSItemCategory getCategory3() {
        this.category3 = POSPersister.materialize(POSItemCategory.class, this.category3);
        return this.category3;
    }

    public void setCategory3(POSItemCategory category3) {
        this.category3 = category3;
    }

    public POSItemCategory getCategory4() {
        this.category4 = POSPersister.materialize(POSItemCategory.class, this.category4);
        return this.category4;
    }

    public void setCategory4(POSItemCategory category4) {
        this.category4 = category4;
    }

    public POSItemCategory getCategory5() {
        this.category5 = POSPersister.materialize(POSItemCategory.class, this.category5);
        return this.category5;
    }

    public void setCategory5(POSItemCategory category5) {
        this.category5 = category5;
    }

    @Override
    public BigDecimal fetchPerValue() {
        return this.getQty().getValue();
    }

    @Override
    public String discLocation() {
        return this.getDiscLocation();
    }

    @Override
    public boolean notFreeButDiscount() {
        return this.getNotFreeButDiscount();
    }

    @Override
    public BigDecimal discPercent() {
        return this.getDiscountPercentage();
    }

    @Override
    public Long fetchPriority() {
        return 0L;
    }

    public BigDecimal getItemMaxQty() {
        return this.itemMaxQty;
    }

    public void setItemMaxQty(BigDecimal maxQty) {
        this.itemMaxQty = maxQty;
    }

    @Override
    public BigDecimal fetchMaxQty() {
        return this.getItemMaxQty();
    }

    @Override
    public Boolean getDoNotCopyMasterItemData() {
        return this.doNotCopyMasterItemData;
    }

    public void setDoNotCopyMasterItemData(Boolean doNotCopyMasterItemData) {
        this.doNotCopyMasterItemData = doNotCopyMasterItemData;
    }
}

