/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.constants.TimePeriodType;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.details.DTOOfferCouponLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesOffers;
import com.namasoft.pos.application.IPOSHasDims;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSSalesOffers;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSOfferCouponLine
implements POSSavable,
IPOSHasDims {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="salesOffer_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesOffers salesOffer;
    @Column(precision=20, scale=10)
    private BigDecimal invoiceValueFrom;
    @Column(precision=20, scale=10)
    private BigDecimal invoiceValueTo;
    private String couponValueType;
    @Column(precision=20, scale=10)
    private BigDecimal couponValue;
    private TimePeriodType couponPeriodType;
    @Column(precision=20, scale=10)
    private BigDecimal couponPeriodVal;
    private Boolean couponUsedOnce;
    private Date fromDate;
    private Date toDate;
    private Boolean deactivated;
    private Long priority;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="legalEntityId", length=16)), @AttributeOverride(name="code", column=@Column(name="legalEntityCode"))})
    private POSDimInfo legalEntity;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="sectorId", length=16)), @AttributeOverride(name="code", column=@Column(name="sectorCode"))})
    private POSDimInfo sector;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="branchId", length=16)), @AttributeOverride(name="code", column=@Column(name="branchCode"))})
    private POSDimInfo branch;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="departmentId", length=16)), @AttributeOverride(name="code", column=@Column(name="departmentCode"))})
    private POSDimInfo department;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="analysisSetId", length=16)), @AttributeOverride(name="code", column=@Column(name="analysisSetCode"))})
    private POSDimInfo analysisSet;
    private String dimensionsCopyMethod;
    private Boolean considerStopOtherDiscounts;

    public String getDimensionsCopyMethod() {
        return this.dimensionsCopyMethod;
    }

    public void setDimensionsCopyMethod(String dimensionsCopyMethod) {
        this.dimensionsCopyMethod = dimensionsCopyMethod;
    }

    @Override
    public POSDimInfo getLegalEntity() {
        return this.legalEntity;
    }

    @Override
    public POSGenericDims fetchGenericDims() {
        return new POSGenericDims(this.getLegalEntity(), this.getSector(), this.getBranch(), this.getDepartment(), this.getAnalysisSet());
    }

    @Override
    public void setLegalEntity(POSDimInfo legalEntity) {
        this.legalEntity = legalEntity;
    }

    @Override
    public POSDimInfo getSector() {
        return this.sector;
    }

    @Override
    public void setSector(POSDimInfo sector) {
        this.sector = sector;
    }

    @Override
    public POSDimInfo getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(POSDimInfo branch) {
        this.branch = branch;
    }

    @Override
    public POSDimInfo getDepartment() {
        return this.department;
    }

    @Override
    public void setDepartment(POSDimInfo department) {
        this.department = department;
    }

    @Override
    public POSDimInfo getAnalysisSet() {
        return this.analysisSet;
    }

    @Override
    public void setAnalysisSet(POSDimInfo analysisSet) {
        this.analysisSet = analysisSet;
    }

    public BigDecimal getInvoiceValueFrom() {
        return this.invoiceValueFrom;
    }

    public void setInvoiceValueFrom(BigDecimal invoiceValueFrom) {
        this.invoiceValueFrom = invoiceValueFrom;
    }

    public BigDecimal getInvoiceValueTo() {
        return this.invoiceValueTo;
    }

    public void setInvoiceValueTo(BigDecimal invoiceValueTo) {
        this.invoiceValueTo = invoiceValueTo;
    }

    public String getCouponValueType() {
        return this.couponValueType;
    }

    public void setCouponValueType(String couponValueType) {
        this.couponValueType = couponValueType;
    }

    public BigDecimal getCouponValue() {
        return this.couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public TimePeriodType getCouponPeriodType() {
        return this.couponPeriodType;
    }

    public void setCouponPeriodType(TimePeriodType couponPeriodType) {
        this.couponPeriodType = couponPeriodType;
    }

    public BigDecimal getCouponPeriodVal() {
        return this.couponPeriodVal;
    }

    public void setCouponPeriodVal(BigDecimal couponPeriodVal) {
        this.couponPeriodVal = couponPeriodVal;
    }

    public Boolean getCouponUsedOnce() {
        return this.couponUsedOnce;
    }

    public void setCouponUsedOnce(Boolean couponUsedOnce) {
        this.couponUsedOnce = couponUsedOnce;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Boolean getDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(Boolean deactivated) {
        this.deactivated = deactivated;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSSalesOffers getSalesOffer() {
        this.salesOffer = POSPersister.materialize(POSSalesOffers.class, this.salesOffer);
        return this.salesOffer;
    }

    public void setSalesOffer(POSSalesOffers salesOffer) {
        this.salesOffer = salesOffer;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public Boolean getConsiderStopOtherDiscounts() {
        return this.considerStopOtherDiscounts;
    }

    public void setConsiderStopOtherDiscounts(Boolean considerStopOtherDiscounts) {
        this.considerStopOtherDiscounts = considerStopOtherDiscounts;
    }

    public void updateDate(DTOSalesOffers offer, DTOOfferCouponLine dtoOfferCouponLine) {
        this.setFromDate(offer.getFromDate());
        this.setToDate(offer.getToDate());
        this.setDeactivated(offer.getDeactivatePriceList());
        this.setPriority(offer.getPriority());
        this.setCouponUsedOnce(dtoOfferCouponLine.getCouponUsedOnce());
        this.setCouponValue(dtoOfferCouponLine.getCouponValue());
        this.setCouponValueType(dtoOfferCouponLine.getCouponValueType());
        this.setInvoiceValueFrom(dtoOfferCouponLine.getInvoiceValueFrom());
        this.setInvoiceValueTo(dtoOfferCouponLine.getInvoiceValueTo());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoOfferCouponLine.getCouponPeriod())) {
            this.setCouponPeriodType(TimePeriodType.valueOf((String)dtoOfferCouponLine.getCouponPeriod().getUom()));
            this.setCouponPeriodVal(dtoOfferCouponLine.getCouponPeriod().getValue());
        }
        this.setDimensionsCopyMethod(dtoOfferCouponLine.getDimensionsCopyMethod());
        this.setLegalEntity(new POSDimInfo(dtoOfferCouponLine.getDimensions().getLegalEntity()));
        this.setSector(new POSDimInfo(dtoOfferCouponLine.getDimensions().getSector()));
        this.setBranch(new POSDimInfo(dtoOfferCouponLine.getDimensions().getBranch()));
        this.setAnalysisSet(new POSDimInfo(dtoOfferCouponLine.getDimensions().getAnalysisSet()));
        this.setDepartment(new POSDimInfo(dtoOfferCouponLine.getDimensions().getDepartment()));
        this.setConsiderStopOtherDiscounts(dtoOfferCouponLine.getConsiderStopOtherDiscounts());
    }
}

