/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.modules.namapos.contracts.details.DTOPOSRegisterDocsCodingParam;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSRegistery;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSRegisteryCodingParam
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="register_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSRegistery register;
    private String type;
    private Integer startFrom;
    private String perfix;
    private String codeDatePartFormat;
    private Boolean doNotUseDefaultPrefix;
    private Boolean doNotUseRegisterCode;

    public POSRegisteryCodingParam() {
    }

    public POSRegisteryCodingParam(DTOPOSRegisterDocsCodingParam line) {
        this.setType(line.getEntityType());
        this.setStartFrom(line.getStartFrom());
        this.setPerfix(line.getPrefix());
        this.setCodeDatePartFormat(line.getPosCodeDatePartFormat());
        this.setDoNotUseDefaultPrefix(line.getDoNotUseDefaultPrefix());
        this.setDoNotUseRegisterCode(line.getDoNotUseRegisterCode());
    }

    public String getPerfix() {
        if (this.perfix == null) {
            this.perfix = "";
        }
        return this.perfix;
    }

    public void setPerfix(String perfix) {
        this.perfix = perfix;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public POSRegistery getRegister() {
        this.register = POSPersister.materialize(POSRegistery.class, this.register);
        return this.register;
    }

    public void setRegister(POSRegistery register) {
        this.register = register;
    }

    public Integer getStartFrom() {
        return this.startFrom;
    }

    public void setStartFrom(Integer startFrom) {
        this.startFrom = startFrom;
    }

    public String getCodeDatePartFormat() {
        return this.codeDatePartFormat;
    }

    public void setCodeDatePartFormat(String codeDatePartFormat) {
        this.codeDatePartFormat = codeDatePartFormat;
    }

    public Boolean getDoNotUseRegisterCode() {
        return this.doNotUseRegisterCode;
    }

    public void setDoNotUseRegisterCode(Boolean doNotUseRegisterCode) {
        this.doNotUseRegisterCode = doNotUseRegisterCode;
    }

    public Boolean getDoNotUseDefaultPrefix() {
        return this.doNotUseDefaultPrefix;
    }

    public void setDoNotUseDefaultPrefix(Boolean doNotUseDefaultPrefix) {
        this.doNotUseDefaultPrefix = doNotUseDefaultPrefix;
    }
}

