/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.common.ILineHasPaymentMethod;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSPaymentMethodLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSRegister;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.entities.POSRegistery;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSRegisteryMethodLine
implements POSSavable,
ILineHasPaymentMethod {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSPaymentMethod paymentMethod;
    @JoinColumn(name="register_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSRegistery register;
    private Boolean showInAdditionalMethods;

    public POSRegisteryMethodLine() {
    }

    public POSRegisteryMethodLine(DTOAbsPOSPaymentMethodLine object, DTONamaPOSRegister register, boolean withoutRegisterCheck) {
        this.setPaymentMethod(POSPaymentMethod.fromReference(object, register, withoutRegisterCheck));
        this.setShowInAdditionalMethods(object.getShowInAdditionalMethods());
    }

    public POSRegisteryMethodLine(DTOAbsPOSPaymentMethodLine object, DTONamaPOSRegister register) {
        this.setPaymentMethod(POSPaymentMethod.fromReference(object, register));
        this.setShowInAdditionalMethods(object.getShowInAdditionalMethods());
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSPaymentMethod getPaymentMethod() {
        this.paymentMethod = POSPersister.materialize(POSPaymentMethod.class, this.paymentMethod);
        return this.paymentMethod;
    }

    public void setPaymentMethod(POSPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public POSRegistery getRegister() {
        this.register = POSPersister.materialize(POSRegistery.class, this.register);
        return this.register;
    }

    public void setRegister(POSRegistery register) {
        this.register = register;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public Boolean getShowInAdditionalMethods() {
        return this.showInAdditionalMethods;
    }

    public void setShowInAdditionalMethods(Boolean showInAdditionalMethods) {
        this.showInAdditionalMethods = showInAdditionalMethods;
    }

    public String methodId() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getPaymentMethod())) {
            return ServerStringUtils.toUUIDStr((Object)this.getPaymentMethod().getId());
        }
        return null;
    }
}

