/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
@XmlRootElement
public class POSReservationPaymentLine
extends AbsPOSPaymentLine {
    @JoinColumn(name="reservation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSOrderReservation reservation;

    public POSReservationPaymentLine() {
    }

    public POSReservationPaymentLine(String methodName, UUID method_id, BigDecimal value, String authorizationNumber, Boolean cash) {
        super(methodName, value);
        this.setAuthorizationNumber(authorizationNumber);
        this.setMethod_id(method_id);
        this.setCash(cash);
    }

    public POSOrderReservation getReservation() {
        this.reservation = POSPersister.materialize(POSOrderReservation.class, this.reservation);
        return this.reservation;
    }

    public void setReservation(POSOrderReservation reservation) {
        this.reservation = reservation;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setReservation((POSOrderReservation)invoice);
    }

    @Override
    public POSMasterFile origin() {
        return this.reservation;
    }

    @Override
    public BigDecimal getAmount() {
        return this.getValue();
    }

    @Override
    public Date fetchValueDate() {
        return this.reservation.getValueDate();
    }
}

