/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSReturnPaymentLine
extends AbsPOSPaymentLine {
    @JoinColumn(name="invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesReturn invoice;

    public POSReturnPaymentLine(String methodName, UUID method_id, BigDecimal value, String authorizationNumber, Boolean cash) {
        super(methodName, value);
        this.setAuthorizationNumber(authorizationNumber);
        this.setMethod_id(method_id);
        this.setCash(cash);
    }

    public POSReturnPaymentLine() {
    }

    @XmlTransient
    public POSSalesReturn getInvoice() {
        this.invoice = POSPersister.materialize(POSSalesReturn.class, this.invoice);
        return this.invoice;
    }

    public void setInvoice(POSSalesReturn invoice) {
        this.invoice = invoice;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setInvoice((POSSalesReturn)invoice);
    }

    @Override
    public POSMasterFile origin() {
        return this.invoice;
    }

    @Override
    public BigDecimal getAmount() {
        return this.getValue().negate();
    }

    @Override
    public Date fetchValueDate() {
        return this.invoice.getValueDate();
    }
}

