/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSSalesInvoiceCouponLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesInvoice invoice;
    private String couponCode;
    @Column(precision=20, scale=10)
    private BigDecimal couponValue;

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSSalesInvoice getInvoice() {
        this.invoice = POSPersister.materialize(POSSalesInvoice.class, this.invoice);
        return this.invoice;
    }

    public void setInvoice(POSSalesInvoice invoice) {
        this.invoice = invoice;
    }

    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public BigDecimal getCouponValue() {
        return this.couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    @Override
    public void assignIds() {
        this.getId();
    }
}

