/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSSalesInvoiceCreditNoteLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesInvoice invoice;
    private String creditNoteCode;
    @Column(precision=20, scale=10)
    private BigDecimal creditNoteValue;

    public String getCreditNoteCode() {
        return this.creditNoteCode;
    }

    public void setCreditNoteCode(String creditNoteCode) {
        this.creditNoteCode = creditNoteCode;
    }

    public BigDecimal getCreditNoteValue() {
        return this.creditNoteValue;
    }

    public void setCreditNoteValue(BigDecimal creditNoteValue) {
        this.creditNoteValue = creditNoteValue;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public POSSalesInvoice getInvoice() {
        this.invoice = POSPersister.materialize(POSSalesInvoice.class, this.invoice);
        return this.invoice;
    }

    public void setInvoice(POSSalesInvoice invoice) {
        this.invoice = invoice;
    }
}

