/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import com.namasoft.modules.supplychain.contracts.details.DTOSalesPriceListLine;
import com.namasoft.modules.supplychain.contracts.entities.DTOSalesPriceList;
import com.namasoft.pos.application.IPOSHasDims;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsSCPriceListSysLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.entities.POSSalesPriceList;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.IHasMaxQty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSSalesPriceListLine
extends AbsSCPriceListSysLine
implements IHasMaxQty {
    @JoinColumn(name="priceList_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceList priceList;
    @Column(precision=20, scale=10)
    private BigDecimal minPrice;
    @Column(precision=20, scale=10)
    private BigDecimal maxPrice;
    @Column(precision=20, scale=10)
    private BigDecimal defaultPrice;
    @Column(precision=20, scale=10)
    private BigDecimal customPrice;
    @Column(precision=20, scale=10)
    private BigDecimal n1;
    @Column(precision=20, scale=10)
    private BigDecimal n2;
    @Column(precision=20, scale=10)
    private BigDecimal n3;
    @Column(precision=20, scale=10)
    private BigDecimal n4;
    @Column(precision=20, scale=10)
    private BigDecimal n5;
    private Boolean stopDiscounts;
    private Boolean selectedforPriceChange;
    private Long priority;
    private Long netDays;
    @Column(precision=20, scale=10)
    private BigDecimal maxQty;

    public BigDecimal getCustomPrice() {
        return this.customPrice;
    }

    public void setCustomPrice(BigDecimal customPrice) {
        this.customPrice = customPrice;
    }

    public BigDecimal getN1() {
        return this.n1;
    }

    public void setN1(BigDecimal n1) {
        this.n1 = n1;
    }

    public BigDecimal getN2() {
        return this.n2;
    }

    public void setN2(BigDecimal n2) {
        this.n2 = n2;
    }

    public BigDecimal getN3() {
        return this.n3;
    }

    public void setN3(BigDecimal n3) {
        this.n3 = n3;
    }

    public BigDecimal getN4() {
        return this.n4;
    }

    public void setN4(BigDecimal n4) {
        this.n4 = n4;
    }

    public BigDecimal getN5() {
        return this.n5;
    }

    public void setN5(BigDecimal n5) {
        this.n5 = n5;
    }

    public BigDecimal getMinPrice() {
        return this.minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return this.maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public BigDecimal getDefaultPrice() {
        return this.defaultPrice;
    }

    public void setDefaultPrice(BigDecimal defaultPrice) {
        this.defaultPrice = defaultPrice;
    }

    public Boolean getStopDiscounts() {
        return this.stopDiscounts;
    }

    public void setStopDiscounts(Boolean stopDiscounts) {
        this.stopDiscounts = stopDiscounts;
    }

    public POSSalesPriceList getPriceList() {
        this.priceList = POSPersister.materialize(POSSalesPriceList.class, this.priceList);
        return this.priceList;
    }

    public void setPriceList(POSSalesPriceList priceList) {
        this.priceList = priceList;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public void updateData(DTOSalesPriceListLine dtoSalesPriceListLine, DTOSalesPriceList priceList, int i) {
        this.setId(UUID.fromString(dtoSalesPriceListLine.getId()));
        this.setFromDate(dtoSalesPriceListLine.getFromDate());
        this.setToDate(dtoSalesPriceListLine.getToDate());
        this.setMaxPrice(dtoSalesPriceListLine.getMaxPrice());
        this.setMinPrice(dtoSalesPriceListLine.getMinPrice());
        this.setDefaultPrice(dtoSalesPriceListLine.getDefaultPrice());
        this.setCustomPrice(dtoSalesPriceListLine.getCustomPrice());
        this.setN1(dtoSalesPriceListLine.getN1());
        this.setN2(dtoSalesPriceListLine.getN2());
        this.setN3(dtoSalesPriceListLine.getN3());
        this.setN4(dtoSalesPriceListLine.getN4());
        this.setN5(dtoSalesPriceListLine.getN5());
        this.setStopDiscounts(dtoSalesPriceListLine.getStopDiscounts());
        this.setSelectedforPriceChange(dtoSalesPriceListLine.getSelectedforPriceChange());
        this.setItemDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(dtoSalesPriceListLine.getItemDimensions()));
        this.setQty(POSQuantity.fromDTORawQuantity(dtoSalesPriceListLine.getQty(), this));
        this.setItemID(ObjectChecker.isEmptyOrNull((Object)dtoSalesPriceListLine.getItem()) ? null : ServerStringUtils.strToUUID((String)dtoSalesPriceListLine.getItem().getId()));
        this.setLineNumber(i);
        this.setRefId(ServerStringUtils.strToUUID((String)priceList.getId()));
        this.setPriority(priceList.getPriority());
        this.setNetDays(priceList.getNetDays());
        this.setInvoiceClassification((POSInvoiceClassification)this.fromReference(dtoSalesPriceListLine.getInvoiceClassification()));
        this.setCurrency((POSCurrency)this.fromReference(priceList.getCurrency()));
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoSalesPriceListLine.getCustomer())) {
            this.setTargetId(UUID.fromString(dtoSalesPriceListLine.getCustomer().getId()));
            this.setTargetType(dtoSalesPriceListLine.getCustomer().getEntityType());
        } else {
            this.setTargetId(null);
            this.setTargetType(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)priceList.getEmployee())) {
            this.setEmpTargetId(UUID.fromString(priceList.getEmployee().getId()));
            this.setEmpTargetType(priceList.getEmployee().getEntityType());
        } else {
            this.setEmpTargetId(null);
            this.setEmpTargetType(null);
        }
        POSSalesPriceListLine.updatePOSLineDimensions(this, dtoSalesPriceListLine.getDimensions());
        this.setPriceClassifier1((POSSalesPriceClassifier1)this.fromReference(dtoSalesPriceListLine.getPriceClassifier1()));
        this.setPriceClassifier2((POSSalesPriceClassifier2)this.fromReference(dtoSalesPriceListLine.getPriceClassifier2()));
        this.setPriceClassifier3((POSSalesPriceClassifier3)this.fromReference(dtoSalesPriceListLine.getPriceClassifier3()));
        this.setPriceClassifier4((POSSalesPriceClassifier4)this.fromReference(dtoSalesPriceListLine.getPriceClassifier4()));
        this.setPriceClassifier5((POSSalesPriceClassifier5)this.fromReference(dtoSalesPriceListLine.getPriceClassifier5()));
        this.setNegateQtyInBaseUOM(ObjectChecker.toZeroIfNull((BigDecimal)dtoSalesPriceListLine.getQtyInBaseUOM()).negate());
        if (ObjectChecker.isNotEmptyOrNull((Object)priceList.getSubsidiary())) {
            this.setSubsidiaryType(priceList.getSubsidiary().getEntityType());
            this.setSubsidiaryId(ServerStringUtils.strToUUID((String)priceList.getSubsidiary().getId()));
        } else {
            this.setSubsidiaryType(null);
            this.setSubsidiaryId(null);
        }
        this.setMaxQty(dtoSalesPriceListLine.getMaxQty());
    }

    public static void updatePOSLineDimensions(IPOSHasDims hasDims, DTOGenericDimensions srcDims) {
        hasDims.setLegalEntity(new POSDimInfo(srcDims.getLegalEntity()));
        hasDims.setSector(new POSDimInfo(srcDims.getSector()));
        hasDims.setBranch(new POSDimInfo(srcDims.getBranch()));
        hasDims.setDepartment(new POSDimInfo(srcDims.getDepartment()));
        hasDims.setAnalysisSet(new POSDimInfo(srcDims.getAnalysisSet()));
    }

    public Boolean getSelectedforPriceChange() {
        return this.selectedforPriceChange;
    }

    public void setSelectedforPriceChange(Boolean selectedforPriceChange) {
        this.selectedforPriceChange = selectedforPriceChange;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public BigDecimal getMaxQty() {
        return this.maxQty;
    }

    public void setMaxQty(BigDecimal maxQty) {
        this.maxQty = maxQty;
    }

    public Long getNetDays() {
        return this.netDays;
    }

    public void setNetDays(Long netDays) {
        this.netDays = netDays;
    }

    @Override
    public Long fetchPriority() {
        return ObjectChecker.toZeroIfNull((Long)this.getPriority());
    }

    @Override
    public BigDecimal fetchMaxQty() {
        return this.getMaxQty();
    }
}

