/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
@XmlRootElement
public class POSScrapDocLine
extends AbsPOSSalesLine {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="scrap_id")
    @JsonIgnore
    private POSScrapDoc scrap;
    @Column(precision=20, scale=10)
    private BigDecimal returnedQty;
    @Column(length=16)
    private UUID sourceLineId;

    public POSScrapDocLine() {
        this.setItemDimensions(new POSItemSpecificDimensions());
    }

    public POSScrapDocLine(POSQuantity qty, POSItem item, String itemCode) {
        this.setCommonValues(qty, BigDecimal.ZERO, BigDecimal.ZERO, item, itemCode, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    public void updateInvoice(AbsPOSSales scrap) {
        this.setScrap((POSScrapDoc)scrap);
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getScrap();
    }

    public BigDecimal getReturnedQty() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.returnedQty)) {
            return BigDecimal.ZERO;
        }
        return this.returnedQty;
    }

    public void setReturnedQty(BigDecimal returnedQty) {
        this.returnedQty = returnedQty;
    }

    public POSScrapDoc getScrap() {
        this.scrap = POSPersister.materialize(POSScrapDoc.class, this.scrap);
        return this.scrap;
    }

    public void setScrap(POSScrapDoc scrap) {
        this.scrap = scrap;
    }

    public UUID getSourceLineId() {
        return this.sourceLineId;
    }

    public void setSourceLineId(UUID sourceLineId) {
        this.sourceLineId = sourceLineId;
    }

    @Override
    public void updateSourceLineId(UUID sourceLineId) {
        this.setSourceLineId(sourceLineId);
    }
}

