/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
@XmlRootElement
public class POSShortfallsDocLine
extends AbsPOSSalesLine {
    @JoinColumn(name="shortfalls_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private POSShortfallsDoc shortfalls;
    @Column(precision=20, scale=10)
    private BigDecimal returnedQty;
    @Column(length=16)
    private UUID sourceLineId;

    public POSShortfallsDocLine() {
        this.setItemDimensions(new POSItemSpecificDimensions());
    }

    public POSShortfallsDocLine(POSQuantity qty, POSItem item, String itemCode) {
        this.setCommonValues(qty, BigDecimal.ZERO, BigDecimal.ZERO, item, itemCode, null, null, null, null, null, null, null, null, null, null, null);
    }

    public POSShortfallsDoc getShortfalls() {
        this.shortfalls = POSPersister.materialize(POSShortfallsDoc.class, this.shortfalls);
        return this.shortfalls;
    }

    public void setShortfalls(POSShortfallsDoc shortfalls) {
        this.shortfalls = shortfalls;
    }

    @Override
    public void updateInvoice(AbsPOSSales shortfalls) {
        this.setShortfalls((POSShortfallsDoc)shortfalls);
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getShortfalls();
    }

    public BigDecimal getReturnedQty() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.returnedQty)) {
            return BigDecimal.ZERO;
        }
        return this.returnedQty;
    }

    public void setReturnedQty(BigDecimal returnedQty) {
        this.returnedQty = returnedQty;
    }

    public UUID getSourceLineId() {
        return this.sourceLineId;
    }

    public void setSourceLineId(UUID sourceLineId) {
        this.sourceLineId = sourceLineId;
    }

    @Override
    public void updateSourceLineId(UUID sourceLineId) {
        this.setSourceLineId(sourceLineId);
    }
}

