/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSStockTransferReqLine;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOInvItemRef;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOItemSpecificDimensions;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOUserQuantity;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;

@Entity
public class POSStockTransferReqLine
extends AbsPOSSalesLine {
    @JoinColumn(name="request_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private POSStockTransferReq request;

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setRequest((POSStockTransferReq)invoice);
    }

    public POSStockTransferReq getRequest() {
        this.request = POSPersister.materialize(POSStockTransferReq.class, this.request);
        return this.request;
    }

    public void setRequest(POSStockTransferReq request) {
        this.request = request;
    }

    public DTONamaPOSStockTransferReqLine convertToDTO() {
        DTONamaPOSStockTransferReqLine line = new DTONamaPOSStockTransferReqLine();
        DTOInvItemRef item = new DTOInvItemRef();
        POSItem theItem = this.getItem();
        if (theItem == null) {
            theItem = (POSItem)POSPersister.findByCode(POSItem.class, this.getItemCode());
        }
        POSItem frontEndItem = POSPersister.findByID(POSItem.class, theItem.getId().toString());
        item.setItem(POSMasterFile.toRef(frontEndItem));
        item.setItemCode(frontEndItem.getCode());
        item.setItemName1(frontEndItem.getName1());
        item.setItemName2(frontEndItem.getName2());
        line.setItem(item);
        DTOUserQuantity userQuantity = new DTOUserQuantity();
        DTOQuantity quantity = new DTOQuantity();
        DTORawQuantity primeQty = new DTORawQuantity();
        primeQty.setUom(POSMasterFile.toRef(this.getQty().getUom()));
        primeQty.setValue(this.getQty().getValue().abs());
        quantity.setPrimeQty(primeQty);
        userQuantity.setQuantity(quantity);
        line.setQuantity(userQuantity);
        line.setSpecificDimensions(new DTOItemSpecificDimensions());
        line.getSpecificDimensions().setColor(this.getItemDimensions().getColor());
        line.getSpecificDimensions().setSize(this.getItemDimensions().getSize());
        line.getSpecificDimensions().setLotId(this.getItemDimensions().getLotId());
        line.getSpecificDimensions().setSerialNumber(this.getItemDimensions().getSerialNumber());
        line.getSpecificDimensions().setRevisionId(this.getItemDimensions().getRevisionId());
        line.getSpecificDimensions().setLocator(POSMasterFile.toRef(this.getLocation()));
        line.setRemarks(this.getRemarks());
        return line;
    }

    @Override
    public AbsPOSSales fetchSalesDoc() {
        return this.getRequest();
    }
}

